/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.util.fast;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class Enum2ObjectMap<K extends Enum<K>, V>
implements Map<K, V> {
    private final V[] values;
    private final BitSet setFlags;
    private final Class<K> keyType;
    private final V defaultValue;

    public Enum2ObjectMap(Class<K> keyType) {
        this(keyType, null);
    }

    public Enum2ObjectMap(Class<K> keyType, V defaultValue) {
        this.keyType = keyType;
        this.defaultValue = defaultValue;
        Enum[] constants = (Enum[])keyType.getEnumConstants();
        this.values = new Object[constants.length];
        Arrays.fill(this.values, defaultValue);
        this.setFlags = new BitSet(constants.length);
    }

    public Enum2ObjectMap(EnumMap<K, V> m, Class<K> keyType) {
        this(keyType, null);
        this.putAll(m);
    }

    public Enum2ObjectMap(Enum2ObjectMap<K, V> m) {
        this(m.getKeyType());
        this.putAll(m);
    }

    public Enum2ObjectMap(Map<K, V> m) {
        Class<Object> clazz;
        if (m instanceof Enum2ObjectMap) {
            Enum2ObjectMap em = (Enum2ObjectMap)m;
            clazz = em.getKeyType();
        } else {
            clazz = ((Enum)m.keySet().iterator().next()).getDeclaringClass();
        }
        this(clazz);
        this.putAll(m);
    }

    @Override
    public V put(K key, V value) {
        this.values[((Enum)key).ordinal()] = value;
        this.setFlags.set(((Enum)key).ordinal());
        return value;
    }

    @Override
    public V get(Object key) {
        return this.get((K)((Enum)key));
    }

    @Override
    public V get(K key) {
        return this.values[((Enum)key).ordinal()];
    }

    @Override
    public boolean containsKey(Object key) {
        return this.values[((Enum)key).ordinal()] != this.defaultValue;
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!Objects.equals(this.values[i], value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V remove(Object key) {
        return this.remove((K)((Enum)key));
    }

    @Override
    public V remove(K key) {
        int ordinal = ((Enum)key).ordinal();
        V oldValue = this.values[ordinal];
        this.values[ordinal] = null;
        this.setFlags.clear(ordinal);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put((K)((Enum)entry.getKey()), entry.getValue());
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, this.defaultValue);
        this.setFlags.clear();
    }

    @Override
    public int size() {
        return this.setFlags.cardinality();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        EnumSet<K> keys = EnumSet.noneOf(this.keyType);
        for (Enum key : (Enum[])this.keyType.getEnumConstants()) {
            if (this.values[key.ordinal()] == this.defaultValue) continue;
            keys.add(key);
        }
        return keys;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList<V> vals = new ArrayList<V>();
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == this.defaultValue) continue;
            vals.add(this.values[i]);
        }
        return vals;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet<Map.Entry<K, V>> entries = new LinkedHashSet<Map.Entry<K, V>>();
        for (Enum key : (Enum[])this.keyType.getEnumConstants()) {
            if (this.values[key.ordinal()] == this.defaultValue) continue;
            entries.add(new AbstractMap.SimpleEntry<Enum, V>(key, this.get((K)key)));
        }
        return entries;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Enum2ObjectMap that = (Enum2ObjectMap)o;
        return Objects.deepEquals(this.values, that.values) && Objects.equals(this.setFlags, that.setFlags) && Objects.equals(this.keyType, that.keyType) && Objects.equals(this.defaultValue, that.defaultValue);
    }

    public Class<K> getKeyType() {
        return this.keyType;
    }
}

