/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.color.season;

import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.constant.solar.color.base.SolarTermColor;
import com.teamtea.eclipticseasons.api.constant.solar.color.leaves.BirchLeavesColor;
import com.teamtea.eclipticseasons.api.constant.solar.color.leaves.LeaveColor;
import com.teamtea.eclipticseasons.api.constant.solar.color.leaves.MangroveLeavesColor;
import com.teamtea.eclipticseasons.api.constant.solar.color.leaves.SpruceLeavesColor;
import com.teamtea.eclipticseasons.api.constant.tag.ClimateTypeBiomeTags;
import com.teamtea.eclipticseasons.api.data.client.BiomeColor;
import com.teamtea.eclipticseasons.api.data.client.ColorMode;
import com.teamtea.eclipticseasons.api.misc.IBiomeTagHolder;
import com.teamtea.eclipticseasons.api.util.fast.Enum2ObjectMap;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.client.util.ClientRef;
import com.teamtea.eclipticseasons.client.util.ColorHelper;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.config.ClientConfig;
import java.awt.Color;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;

public class BiomeColorsHandler {
    public static Map<TagKey<Biome>, int[]> newFoliageBufferMap = new IdentityHashMap<TagKey<Biome>, int[]>();
    public static Map<TagKey<Biome>, int[]> newGrassBufferMap = new IdentityHashMap<TagKey<Biome>, int[]>();
    public static boolean needRefresh = false;
    public static final ColorResolver GRASS_COLOR = (biome, posX, posZ) -> {
        int originColor = biome.m_47464_(posX, posZ);
        if (((Boolean)ClientConfig.Renderer.seasonalGrassColorChange.get()).booleanValue()) {
            ColorMode.Instance instance;
            BiomeColor.Instance biomeColor = BiomeColorsHandler.getBiomeColor(biome, originColor);
            if (biomeColor != null && (instance = biomeColor.grassColor().get(ClientCon.nowSolarTerm)) != null) {
                ColorMode.Instance instance2;
                int color = ColorHelper.simplyMixColor(instance.value(), instance.mix(), originColor, Math.abs(1.0f - instance.mix()));
                if (((Boolean)ClientConfig.Renderer.smootherSeasonalGrassColorChange.get()).booleanValue() && (instance2 = biomeColor.grassColor().get(ClientCon.nowSolarTerm.getLastSolarTerm())) != null && !instance.equals(instance2)) {
                    int color2 = ColorHelper.simplyMixColor(instance2.value(), instance2.mix(), originColor, Math.abs(1.0f - instance2.mix()));
                    float progressFloat = (float)ClientCon.progress / 100.0f;
                    return ColorHelper.simplyMixColor(color, progressFloat, color2, 1.0f - progressFloat);
                }
                return color;
            }
            TagKey<Biome> biomeTagKey = ((IBiomeTagHolder)biome).eclipticseasons$getBindColorTag();
            if (((Boolean)ClientConfig.Renderer.smootherSeasonalGrassColorChange.get()).booleanValue()) {
                SolarTermColor colorInfo = ClientCon.nowSolarTerm.getSolarTermColor(biomeTagKey);
                SolarTermColor colorInfo2 = ClientCon.nowSolarTerm.getLastSolarTerm().getSolarTermColor(biomeTagKey);
                int color = ColorHelper.simplyMixColor(colorInfo.getGrassColor(), colorInfo.getMix(), originColor, 1.0f - colorInfo.getMix());
                int color2 = ColorHelper.simplyMixColor(colorInfo2.getGrassColor(), colorInfo2.getMix(), originColor, 1.0f - colorInfo2.getMix());
                float progressFloat = (float)ClientCon.progress / 100.0f;
                return ColorHelper.simplyMixColor(color, progressFloat, color2, 1.0f - progressFloat);
            }
            if (needRefresh) {
                BiomeColorsHandler.reloadColors();
            }
            double temperature = Mth.m_14036_((float)biome.getModifiedClimateSettings().f_47681_(), (float)0.0f, (float)1.0f);
            double humidity = Mth.m_14036_((float)biome.getModifiedClimateSettings().f_47683_(), (float)0.0f, (float)1.0f);
            int j = (int)((1.0 - (humidity *= temperature)) * 255.0);
            int i = (int)((1.0 - temperature) * 255.0);
            int k = j << 8 | i;
            int[] newGrassBuffer = newGrassBufferMap.getOrDefault(biomeTagKey, GrassColor.f_46413_);
            int color = k > newGrassBuffer.length ? originColor : newGrassBuffer[k];
            return color;
        }
        return originColor;
    };
    public static final ColorResolver FOLIAGE_COLOR = (biome, posX, posZ) -> {
        int originColor = biome.m_47542_();
        if (((Boolean)ClientConfig.Renderer.seasonalGrassColorChange.get()).booleanValue()) {
            ColorMode.Instance instance;
            BiomeColor.Instance biomeColor = BiomeColorsHandler.getBiomeColor(biome, originColor);
            if (biomeColor != null && (instance = biomeColor.foliageColor().get(ClientCon.nowSolarTerm)) != null) {
                ColorMode.Instance instance2;
                int color = ColorHelper.simplyMixColor(instance.value(), instance.mix(), originColor, Math.abs(1.0f - instance.mix()));
                if (((Boolean)ClientConfig.Renderer.smootherSeasonalGrassColorChange.get()).booleanValue() && (instance2 = biomeColor.foliageColor().get(ClientCon.nowSolarTerm.getLastSolarTerm())) != null && !instance.equals(instance2)) {
                    int color2 = ColorHelper.simplyMixColor(instance2.value(), instance2.mix(), originColor, Math.abs(1.0f - instance2.mix()));
                    float progressFloat = (float)ClientCon.progress / 100.0f;
                    return ColorHelper.simplyMixColor(color, progressFloat, color2, 1.0f - progressFloat);
                }
                return color;
            }
            TagKey<Biome> biomeTagKey = ((IBiomeTagHolder)biome).eclipticseasons$getBindColorTag();
            if (((Boolean)ClientConfig.Renderer.smootherSeasonalGrassColorChange.get()).booleanValue()) {
                SolarTermColor colorInfo = ClientCon.nowSolarTerm.getSolarTermColor(biomeTagKey);
                SolarTermColor colorInfo2 = ClientCon.nowSolarTerm.getLastSolarTerm().getSolarTermColor(biomeTagKey);
                int color = ColorHelper.simplyMixColor(colorInfo.getLeaveColor(), colorInfo.getMix(), originColor, 1.0f - colorInfo.getMix());
                int color2 = ColorHelper.simplyMixColor(colorInfo2.getLeaveColor(), colorInfo2.getMix(), originColor, 1.0f - colorInfo2.getMix());
                float progressFloat = (float)ClientCon.progress / 100.0f;
                return ColorHelper.simplyMixColor(color, progressFloat, color2, 1.0f - progressFloat);
            }
            if (needRefresh) {
                BiomeColorsHandler.reloadColors();
            }
            double temperature = Mth.m_14036_((float)biome.getModifiedClimateSettings().f_47681_(), (float)0.0f, (float)1.0f);
            double humidity = Mth.m_14036_((float)biome.getModifiedClimateSettings().f_47683_(), (float)0.0f, (float)1.0f);
            int j = (int)((1.0 - (humidity *= temperature)) * 255.0);
            int i = (int)((1.0 - temperature) * 255.0);
            int k = j << 8 | i;
            int[] newFoliageBuffer = newFoliageBufferMap.getOrDefault(biomeTagKey, FoliageColor.f_46104_);
            int color = k > newFoliageBuffer.length ? originColor : newFoliageBuffer[k];
            return color;
        }
        return originColor;
    };

    private static BiomeColor.Instance getBiomeColor(Biome biome, int originColor) {
        return ClientRef.biomeColors.getOrDefault(biome, null);
    }

    public static void reloadColors() {
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        if (clientLevel != null && MapChecker.isValidDimension((Level)clientLevel)) {
            SolarHolders.getSaveDataLazy((Level)clientLevel).ifPresent(data -> {
                for (TagKey<Biome> biomeTagKey : ClimateTypeBiomeTags.BIOME_COLOR_TYPES) {
                    int originColor;
                    int i;
                    int[] newFoliageBuffer = new int[65536];
                    int[] newGrassBuffer = new int[65536];
                    int[] foliageBuffer = FoliageColor.f_46104_;
                    int[] grassBuffer = GrassColor.f_46413_;
                    SolarTerm solar = data.getSolarTerm();
                    SolarTermColor colorInfo = solar.getSolarTermColor(biomeTagKey);
                    for (i = 0; i < foliageBuffer.length; ++i) {
                        originColor = foliageBuffer[i];
                        newFoliageBuffer[i] = colorInfo.getMix() == 0.0f ? originColor : ColorHelper.simplyMixColor(colorInfo.getLeaveColor(), colorInfo.getMix(), originColor, 1.0f - colorInfo.getMix());
                    }
                    for (i = 0; i < grassBuffer.length; ++i) {
                        originColor = grassBuffer[i];
                        newGrassBuffer[i] = colorInfo.getMix() == 0.0f ? originColor : ColorHelper.simplyMixColor(colorInfo.getGrassColor(), colorInfo.getMix(), originColor, 1.0f - colorInfo.getMix());
                    }
                    newFoliageBufferMap.put(biomeTagKey, newFoliageBuffer);
                    newGrassBufferMap.put(biomeTagKey, newGrassBuffer);
                }
                needRefresh = false;
            });
        }
    }

    public static int getSpruceColor(BlockState state, BlockAndTintGetter blockAndTintGetter, BlockPos pos, int tintIndex) {
        return BiomeColorsHandler.getLeavesColor(FoliageColor.m_46106_(), SpruceLeavesColor.collectValues(), pos);
    }

    public static int getBirchColor(BlockState state, BlockAndTintGetter blockAndTintGetter, BlockPos pos, int tintIndex) {
        return BiomeColorsHandler.getLeavesColor(FoliageColor.m_46112_(), BirchLeavesColor.collectValues(), pos);
    }

    public static int getMangroveColor(BlockState state, BlockAndTintGetter blockAndTintGetter, BlockPos pos, int tintIndex) {
        return BiomeColorsHandler.getLeavesColor(FoliageColor.m_220346_(), MangroveLeavesColor.collectValues(), pos);
    }

    public static int getLeavesColor(int base, LeaveColor[] values, BlockPos pos) {
        if (((Boolean)ClientConfig.Renderer.seasonalGrassColorChange.get()).booleanValue() && ((Boolean)ClientConfig.Renderer.seasonalColorChangeExtend.get()).booleanValue() && pos != null && MapChecker.isValidDimension(ClientCon.getUseLevel())) {
            SolarTerm solarTerm = ClientCon.nowSolarTerm;
            LeaveColor leaveColor = values[solarTerm.ordinal()];
            int color = ColorHelper.simplyMixColor(BiomeColorsHandler.fixColor(values, pos, solarTerm, leaveColor.getColor()), leaveColor.getMix(), base, 1.0f - leaveColor.getMix());
            if (((Boolean)ClientConfig.Renderer.smootherSeasonalGrassColorChange.get()).booleanValue()) {
                SolarTerm solarTerm2 = solarTerm.getLastSolarTerm();
                LeaveColor leaveColor2 = values[solarTerm2.ordinal()];
                int color2 = ColorHelper.simplyMixColor(BiomeColorsHandler.fixColor(values, pos, solarTerm2, leaveColor2.getColor()), leaveColor2.getMix(), base, 1.0f - leaveColor2.getMix());
                float progressFloat = (float)ClientCon.progress / 100.0f;
                return ColorHelper.simplyMixColor(color, progressFloat, color2, 1.0f - progressFloat);
            }
            return color;
        }
        return base;
    }

    private static int fixColor(LeaveColor[] values, BlockPos pos, SolarTerm solarTerm, int color) {
        if (values instanceof BirchLeavesColor[] && solarTerm.isInTerms(SolarTerm.END_OF_HEAT, SolarTerm.LIGHT_SNOW)) {
            float saturation = 1.0f;
            float brightness = 1.0f;
            float xChange = (float)((Math.sin((float)pos.m_123341_() / 16.0f) + 1.0) / 2.0);
            float yChange = (float)((Math.sin((float)pos.m_123342_() / 128.0f) + 1.0) / 2.0);
            float zChange = (float)((Math.sin((float)pos.m_123343_() / 32.0f) + 1.0) / 2.0);
            float change = (xChange + yChange + zChange) / 3.0f;
            float hue = 0.025f + change * 0.14f;
            Color foliage = Color.getHSBColor(hue, saturation, brightness);
            color = foliage.getRGB();
        }
        return color;
    }

    public static int getSkyColor(Biome biome, int originColor) {
        return BiomeColorsHandler.getBiomeColorInternal(biome, originColor, BiomeColorsHandler::getSkyColorMap);
    }

    public static int getWaterColor(Biome biome, int originColor) {
        return BiomeColorsHandler.getBiomeColorInternal(biome, originColor, BiomeColorsHandler::getWaterColorMap);
    }

    public static int getWaterFogColor(Biome biome, int originColor) {
        return BiomeColorsHandler.getBiomeColorInternal(biome, originColor, BiomeColorsHandler::getWaterFogColorMap);
    }

    public static int getFogColor(Biome biome, int originColor) {
        return BiomeColorsHandler.getBiomeColorInternal(biome, originColor, BiomeColorsHandler::getFogColorMap);
    }

    public static Enum2ObjectMap<SolarTerm, ColorMode.Instance> getSkyColorMap(BiomeColor.Instance instance) {
        return instance.skyColor();
    }

    public static Enum2ObjectMap<SolarTerm, ColorMode.Instance> getWaterColorMap(BiomeColor.Instance instance) {
        return instance.waterColor();
    }

    public static Enum2ObjectMap<SolarTerm, ColorMode.Instance> getWaterFogColorMap(BiomeColor.Instance instance) {
        return instance.waterFogColor();
    }

    public static Enum2ObjectMap<SolarTerm, ColorMode.Instance> getFogColorMap(BiomeColor.Instance instance) {
        return instance.fogColor();
    }

    public static int getBiomeColorInternal(Biome biome, int originColor, Function<BiomeColor.Instance, Enum2ObjectMap<SolarTerm, ColorMode.Instance>> function) {
        ColorMode.Instance instance;
        BiomeColor.Instance biomeColor;
        if (((Boolean)ClientConfig.Renderer.seasonalGrassColorChange.get()).booleanValue() && (biomeColor = BiomeColorsHandler.getBiomeColor(biome, originColor)) != null && (instance = function.apply(biomeColor).get(ClientCon.nowSolarTerm)) != null) {
            ColorMode.Instance instance2;
            int color = ColorHelper.simplyMixColor(instance.value(), instance.mix(), originColor, Math.abs(1.0f - instance.mix()));
            if (((Boolean)ClientConfig.Renderer.smootherSeasonalGrassColorChange.get()).booleanValue() && (instance2 = function.apply(biomeColor).get(ClientCon.nowSolarTerm.getLastSolarTerm())) != null && !instance.equals(instance2)) {
                int color2 = ColorHelper.simplyMixColor(instance2.value(), instance2.mix(), originColor, Math.abs(1.0f - instance2.mix()));
                float progressFloat = (float)ClientCon.progress / 100.0f;
                return ColorHelper.simplyMixColor(color, progressFloat, color2, 1.0f - progressFloat);
            }
            return color;
        }
        return originColor;
    }
}

