/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.core;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.data.client.model.ESModelLoadedJson;
import com.teamtea.eclipticseasons.api.data.client.model.ModelResolver;
import com.teamtea.eclipticseasons.api.data.client.model.ModelTester;
import com.teamtea.eclipticseasons.api.data.client.model.seasonal.SeasonBlockDefinition;
import com.teamtea.eclipticseasons.api.data.client.model.seasonal.SeasonalTexture;
import com.teamtea.eclipticseasons.api.data.season.SnowDefinition;
import com.teamtea.eclipticseasons.api.misc.client.IExtraRendererContextOwner;
import com.teamtea.eclipticseasons.api.misc.client.IMapSlice;
import com.teamtea.eclipticseasons.api.misc.client.IMapSliceProvider;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.client.core.ExtraRendererContext;
import com.teamtea.eclipticseasons.client.model.IESReplaceModel;
import com.teamtea.eclipticseasons.client.model.ISnowyReplaceModel;
import com.teamtea.eclipticseasons.client.model.SnowyBakedModelWrapper;
import com.teamtea.eclipticseasons.client.model.SnowySeasonBakeModel;
import com.teamtea.eclipticseasons.client.model.TempReplaceModelWrapper;
import com.teamtea.eclipticseasons.client.model.bakequad.BakedQuadRetexturedAndReUV;
import com.teamtea.eclipticseasons.client.model.bakequad.DirectionMask;
import com.teamtea.eclipticseasons.client.model.bakequad.QuadFixer;
import com.teamtea.eclipticseasons.client.model.unbake.SolarBlockModel;
import com.teamtea.eclipticseasons.client.reload.ClientJsonCacheListener;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.client.util.ClientRef;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.core.snow.SnowChecker;
import com.teamtea.eclipticseasons.common.registry.BlockRegistry;
import com.teamtea.eclipticseasons.compat.Platform;
import com.teamtea.eclipticseasons.config.ClientConfig;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirtPathBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;

public class ExtraModelManager {
    public static final RenderType CUTOUT_MIPPED = null;
    public static Map<ResourceLocation, BakedModel> models;
    public static ModelResourceLocation snowOverlayLeaves;
    public static ModelResourceLocation snowySlabBottom;
    public static ModelResourceLocation snowOverlayBlock;
    public static ResourceLocation ice;
    public static ResourceLocation snowy_leaves_attach;
    public static ResourceLocation snowy_leaves_top;
    public static ResourceLocation snowy_custom;
    public static ResourceLocation snowy_custom_ao;
    public static ResourceLocation stairs_top;
    public static ResourceLocation snowy_fern;
    public static ResourceLocation snowy_grass;
    public static ResourceLocation snowy_large_fern_bottom;
    public static ResourceLocation snowy_large_fern_top;
    public static ResourceLocation snowy_tall_grass_bottom;
    public static ResourceLocation snowy_tall_grass_top;
    public static ResourceLocation overlay_2;
    public static ResourceLocation snow_height2;
    public static ResourceLocation snow_height2_top;
    public static ResourceLocation grass_flower;
    public static ResourceLocation snow;
    public static ResourceLocation snow_overlay_half_left;
    public static ResourceLocation snow_overlay_half_right;
    public static ResourceLocation snow_overlay;
    public static ResourceLocation snow_overlay_leaves;
    public static ResourceLocation snow_overlay_tiny;
    public static ResourceLocation extra_slope_overlay;
    public static ResourceLocation extra_slope_overlay_2;
    public static List<ResourceLocation> flower_on_grass;
    public static List<ResourceLocation> snow_edge_overlays;
    public static List<ResourceLocation> fourleaf_clovers;
    public static HashMap<ResourceLocation, SpriteContents> blocksCache;
    public static Map<BlockState, BakedModel> snowyModelsCache;
    public static Map<BlockState, BakedModel> snowyModelsCache2;
    private static final List<BakedQuad> EMPTY;
    public static final Map<ResourceLocation, ESModelLoadedJson> extraSnowModels;
    public static final Map<ResourceLocation, ModelResolver> extraSnowModelBuilds;
    public static final Map<ResourceLocation, List<SeasonalTexture>> SEASONAL_TEXTURE_HASH_MAP;

    public static ResourceLocation textureRL(String s) {
        return EclipticSeasons.rl("block/" + s);
    }

    public static ResourceLocation mrl(String s, String s2) {
        return new ModelResourceLocation(EclipticSeasons.rl(s), s2);
    }

    public static ResourceLocation extra_mrl(ResourceLocation resourceLocation, String v) {
        return resourceLocation.m_246208_("extra/" + (String)(v.isEmpty() ? "" : v + "/"));
    }

    public static boolean shouldCutoutMipped(BlockState state) {
        Block onBlock;
        return CommonConfig.isSnowyWinter() && Minecraft.m_91087_().f_91073_ != null && !((onBlock = state.m_60734_()) instanceof FenceBlock) && (onBlock instanceof SlabBlock || onBlock instanceof FarmBlock || onBlock instanceof DirtPathBlock || onBlock instanceof StairBlock || state.m_60804_((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_));
    }

    public static BakedModel getSnowyModel(BlockState state, BlockState snowState, int flag, int offset) {
        BakedModel snowModel;
        boolean notSpecialLeaves = !MapChecker.leaveLike(flag) || snowState != null;
        BakedModel bakedModel = snowModel = notSpecialLeaves ? snowyModelsCache.get(state) : snowyModelsCache2.get(state);
        if (snowModel == null) {
            Block onBlock = state.m_60734_();
            boolean forceReplace = false;
            List<SnowDefinition> snowDefinitions = ClientRef.snowClientDef.get(onBlock);
            if (snowDefinitions != null && !snowDefinitions.isEmpty()) {
                for (SnowDefinition snowDefinition : snowDefinitions) {
                    ModelTester mmrl;
                    ResourceLocation cinfo = notSpecialLeaves ? snowDefinition.getInfo().getMid() : snowDefinition.getInfo().getMid2();
                    ModelResolver smr = extraSnowModelBuilds.get(cinfo);
                    if (smr == null || (mmrl = smr.tryFind(state)) == null) continue;
                    snowModel = models.get(mmrl.modelResourceLocation());
                    forceReplace = mmrl.replace();
                    flag = snowDefinition.getInfo().getFlag();
                    break;
                }
            }
            if (snowModel == null) {
                if (flag == 1) {
                    snowModel = models.get(snowOverlayBlock);
                } else if (flag == 4) {
                    snowModel = (Boolean)CommonConfig.Snow.snowyTree.get() == false ? models.get(snowOverlayLeaves) : (notSpecialLeaves ? models.get(snowy_leaves_top) : models.get(snowy_leaves_attach));
                } else if (flag == 2) {
                    snowModel = models.get(snowySlabBottom);
                } else if (flag == 301) {
                    snowModel = models.get(stairs_top);
                } else if (models != null && flag == 3) {
                    if (snowState != null) {
                        snowModel = Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(snowState);
                    }
                } else if (flag == 5) {
                    snowModel = onBlock == Blocks.f_50034_ ? models.get(snowy_grass) : (onBlock == Blocks.f_50035_ ? models.get(snowy_fern) : models.get(snowy_grass));
                } else if (flag == 501) {
                    snowModel = onBlock == Blocks.f_50359_ ? models.get(offset == 1 ? snowy_tall_grass_bottom : snowy_tall_grass_top) : (onBlock == Blocks.f_50360_ ? models.get(offset == 1 ? snowy_large_fern_bottom : snowy_large_fern_top) : models.get(offset == 1 ? snowy_tall_grass_bottom : snowy_tall_grass_top));
                } else if (flag == 7) {
                    if (snowState != null) {
                        snowModel = Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(snowState);
                    }
                } else if (flag == 6) {
                    snowModel = models.get(snow_height2_top);
                } else if (flag == 999) {
                    snowModel = models.get(snowy_custom);
                } else if (flag == 998) {
                    snowModel = models.get(snowy_custom_ao);
                } else if (flag == 1000 | flag == 1001 || flag == 1200 || flag == 1100 || flag == 1101) {
                    ModelTester mmrl;
                    SnowDefinition.Info uncacheSnow = SnowChecker.getUncacheSnow(state);
                    ResourceLocation cinfo = notSpecialLeaves ? uncacheSnow.getMid() : uncacheSnow.getMid2();
                    ModelResolver smr = extraSnowModelBuilds.get(cinfo);
                    if (smr != null && (mmrl = smr.tryFind(state)) != null) {
                        snowModel = models.get(mmrl.modelResourceLocation());
                        forceReplace = mmrl.replace();
                    }
                }
            }
            if (snowModel != null) {
                SnowyBakedModelWrapper<Object> bakedModel2 = snowModel instanceof SnowyBakedModelWrapper ? (SnowyBakedModelWrapper<Object>)snowModel : new SnowyBakedModelWrapper<BakedModel>(snowModel);
                bakedModel2.setReplace(forceReplace);
                if (ISnowyReplaceModel.isInvalid((BakedModel)bakedModel2)) {
                    bakedModel2.updateBlockType(flag);
                    bakedModel2.setLowLayer(!notSpecialLeaves);
                }
                if (notSpecialLeaves) {
                    snowyModelsCache.put(state, (BakedModel)bakedModel2);
                } else {
                    snowyModelsCache2.put(state, (BakedModel)bakedModel2);
                }
            }
        }
        return snowModel;
    }

    public static TextureAtlasSprite getSprite(ResourceLocation resourceLocation) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(resourceLocation);
    }

    public static List<BakedQuad> cancelTop(BakedModel bakedModel, BlockAndTintGetter blockAndTintGetter, BlockState state, BlockPos pos, Direction direction, RandomSource random, long seed, List<BakedQuad> original) {
        int blockType;
        ExtraRendererContext rendererHolder = IExtraRendererContextOwner.of(blockAndTintGetter);
        if (rendererHolder.getExtraModel() == null) {
            return original;
        }
        if (bakedModel != null && ClientConfig.isTopFaceCulling() && !original.isEmpty() && (direction == Direction.UP || direction == null) && !IESReplaceModel.isInvalid(bakedModel) && blockAndTintGetter instanceof IMapSlice) {
            random.m_188584_(seed);
            BakedModel snowModel = rendererHolder.getExtraModel();
            if (snowModel instanceof SnowyBakedModelWrapper) {
                blockType = MapChecker.getDefaultBlockTypeFlag(state);
                if (MapChecker.customBuiltin(blockType)) {
                    return original;
                }
                if (direction == Direction.UP && blockType == 1) {
                    return EMPTY;
                }
                if (original.size() == 1) {
                    if (original.get(0).m_111306_() == Direction.UP) {
                        return EMPTY;
                    }
                } else {
                    original = new ArrayList<BakedQuad>(original);
                    for (int i = 0; i < original.size(); ++i) {
                        BakedQuad bakedQuad = original.get(i);
                        if (bakedQuad.m_111306_() != Direction.UP) continue;
                        original.remove(i);
                        --i;
                    }
                }
            }
        }
        if (bakedModel instanceof SnowyBakedModelWrapper) {
            SnowyBakedModelWrapper snowyBakedModelWrapper = (SnowyBakedModelWrapper)bakedModel;
            int n = blockType = snowyBakedModelWrapper.getBindBlockType() > -1 ? snowyBakedModelWrapper.getBindBlockType() : MapChecker.getDefaultBlockTypeFlag(state);
            if (MapChecker.customBuiltin(blockType)) {
                original = new ArrayList<BakedQuad>();
            }
            if (MapChecker.customBuiltin(blockType) && ExtraModelManager.shouldMakeSnowyBakedQuads(blockType, direction)) {
                ArrayList quadsCTM = null;
                BakedModel bakedModelCTM = rendererHolder.getOriginalModel();
                if (bakedModelCTM != null) {
                    ModelData modelDataCTM = rendererHolder.getModelData();
                    random.m_188584_(seed);
                    ChunkRenderTypeSet renderTypes = bakedModelCTM.getRenderTypes(state, random, modelDataCTM);
                    quadsCTM = new ArrayList();
                    for (RenderType renderType : renderTypes.asList()) {
                        random.m_188584_(seed);
                        quadsCTM.addAll(bakedModelCTM.getQuads(state, direction, random, modelDataCTM, renderType));
                    }
                }
                original = ExtraModelManager.makeSnowyBakedQuads(state, original, quadsCTM);
            }
        }
        return original;
    }

    public static boolean shouldMakeSnowyBakedQuads(int blockType, Direction direction) {
        return MapChecker.customBuiltin(blockType) || direction != null && direction.ordinal() > 1;
    }

    public static List<BakedQuad> makeSnowyBakedQuads(BlockState state, List<BakedQuad> original, ArrayList<BakedQuad> quadsCTM) {
        if (quadsCTM != null) {
            boolean tooTiny = false;
            tooTiny |= state.m_60734_() instanceof FenceBlock;
            tooTiny |= state.m_60734_() instanceof FenceGateBlock;
            tooTiny |= state.m_60734_() instanceof IronBarsBlock;
            if (!(tooTiny |= state.m_60734_() instanceof StairBlock)) {
                quadsCTM = QuadFixer.fixQuadCTM(quadsCTM);
            }
            TextureAtlasSprite snow_overlay_sprite = ExtraModelManager.getSprite(snow_overlay);
            TextureAtlasSprite snow_overlay_tiny_sprite = ExtraModelManager.getSprite(snow_overlay_tiny);
            TextureAtlasSprite snow_sprite = ExtraModelManager.getSprite(snow);
            float offset = 0.5f;
            boolean isSlabDown = false;
            original = new ArrayList<BakedQuad>(quadsCTM.size());
            for (BakedQuad bakedQuad : quadsCTM) {
                Direction bakedQuadDirection = bakedQuad.m_111306_();
                if (bakedQuadDirection == Direction.DOWN) continue;
                TextureAtlasSprite spriteUse = snow_overlay_sprite;
                if (bakedQuadDirection != Direction.UP) {
                    isSlabDown = true;
                    float maxY = QuadFixer.getMaxY(bakedQuad);
                    offset = 1.0f - maxY;
                    if (offset < 1.0E-5f) {
                        offset = 0.0f;
                        isSlabDown = false;
                    }
                }
                spriteUse = bakedQuadDirection == Direction.UP ? snow_sprite : (tooTiny ? snow_overlay_tiny_sprite : (QuadFixer.getMaxY(bakedQuad) - QuadFixer.getMinY(bakedQuad) > 0.4002f ? snow_overlay_sprite : snow_overlay_tiny_sprite));
                BakedQuadRetexturedAndReUV retexturedBakedQuad = new BakedQuadRetexturedAndReUV(bakedQuad, spriteUse, isSlabDown, offset);
                original.add(retexturedBakedQuad);
            }
        }
        return original;
    }

    public static BlockPos.MutableBlockPos posToMutable(BlockPos pos) {
        return new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static boolean canSnowy(BlockAndTintGetter blockAndTintGetter, BlockPos pos, BlockState state, long seed, @Nullable BlockPos.MutableBlockPos checkPos) {
        IMapSliceProvider ip;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return false;
        }
        int flag = MapChecker.getDefaultBlockTypeFlag(state);
        Block onBlock = state.m_60734_();
        List<SnowDefinition> snowDefClientOverlay = ClientRef.snowClientDef.get(onBlock);
        if (flag == 0 && (snowDefClientOverlay == null || snowDefClientOverlay.isEmpty() || snowDefClientOverlay.get(0).getInfo().getFlag() == 0)) {
            return false;
        }
        boolean leaveLike = MapChecker.leaveLike(flag);
        boolean leavesOrVine = leaveLike || MapChecker.vineLike(flag);
        IMapSlice mapSlice = null;
        if (blockAndTintGetter instanceof IMapSlice) {
            int cut;
            IMapSlice cmapSlice;
            mapSlice = cmapSlice = (IMapSlice)blockAndTintGetter;
            if (!leavesOrVine && (cut = mapSlice.getBlockHeight(pos) - pos.m_123342_()) > 1 && !((Boolean)ClientConfig.Renderer.snowUnderFence.get()).booleanValue()) {
                return false;
            }
        }
        int offset = snowDefClientOverlay == null ? MapChecker.getSnowOffset(state, flag) : snowDefClientOverlay.get(0).getInfo().getOffset();
        boolean isLight = false;
        if (checkPos == null) {
            checkPos = ExtraModelManager.posToMutable(pos);
        } else {
            checkPos.m_122178_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
        if (((Boolean)ClientConfig.Renderer.useVanillaCheck.get()).booleanValue()) {
            checkPos.m_142448_(pos.m_123342_() + 1);
            isLight = blockAndTintGetter.m_45517_(LightLayer.BLOCK, (BlockPos)checkPos) >= 15;
        } else {
            int cacheHeight = mapSlice != null ? mapSlice.getBlockHeight((BlockPos)checkPos) : MapChecker.getHeightOrUpdate((Level)level, (BlockPos)checkPos, false);
            isLight = cacheHeight <= pos.m_123342_() - offset;
        }
        boolean specialLeaves = false;
        if (!isLight && ((Boolean)ClientConfig.Renderer.snowUnderFence.get()).booleanValue()) {
            checkPos.m_122178_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
            if (blockAndTintGetter.m_45517_(LightLayer.SKY, (BlockPos)checkPos) >= 9) {
                int n;
                if (blockAndTintGetter instanceof IMapSliceProvider) {
                    ip = (IMapSliceProvider)blockAndTintGetter;
                    n = ip.getSolidBlockHeight((BlockPos)checkPos);
                } else {
                    n = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_()) - 1;
                }
                int y_real = n;
                checkPos.m_142448_(y_real);
                BlockState getterBlockState = blockAndTintGetter.m_8055_((BlockPos)checkPos);
                if (getterBlockState.m_60795_()) {
                    try {
                        getterBlockState = level.m_8055_((BlockPos)checkPos);
                    }
                    catch (Exception e) {
                        EclipticSeasons.logger(e);
                    }
                }
                if (getterBlockState.m_60792_((BlockGetter)blockAndTintGetter, (BlockPos)checkPos) < 0.5f) {
                    isLight = true;
                    if (leaveLike) {
                        if (((Boolean)CommonConfig.Snow.snowyTree.get()).booleanValue()) {
                            specialLeaves = true;
                        } else {
                            isLight = false;
                        }
                    }
                }
            }
        }
        if (isLight) {
            checkPos.m_122178_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
            if (MapChecker.leaveLike(flag)) {
                if (!specialLeaves) {
                    BlockState aboveState = blockAndTintGetter.m_8055_((BlockPos)checkPos);
                    if (isLight) {
                        specialLeaves = blockAndTintGetter instanceof IMapSliceProvider ? (ip = (IMapSliceProvider)blockAndTintGetter).getSolidBlockHeight((BlockPos)checkPos) > pos.m_123342_() : aboveState.m_60713_(state.m_60734_());
                    }
                }
            } else if (MapChecker.extraSnowPassable(state)) {
                isLight = !MapChecker.extraSnowPassable(blockAndTintGetter.m_8055_((BlockPos)checkPos));
            } else if (!((Boolean)ClientConfig.Renderer.snowUnderFence.get()).booleanValue()) {
                boolean bl = isLight = !MapChecker.solidTest(blockAndTintGetter.m_8055_((BlockPos)checkPos));
            }
        }
        if (isLight && specialLeaves && !(isLight = ((Boolean)CommonConfig.Snow.snowyTree.get()).booleanValue())) {
            specialLeaves = false;
        }
        boolean isSnowy = false;
        if (isLight) {
            checkPos.m_142448_(pos.m_123342_());
            if (CommonConfig.isSnowyWinter() && onBlock != Blocks.f_50127_ && ExtraModelManager.maySnowyAt((Level)level, mapSlice, state, (BlockPos)checkPos, null, seed)) {
                isSnowy = true;
                checkPos.m_122178_(pos.m_123341_(), pos.m_123342_() + 1 - offset, pos.m_123343_());
                isSnowy = ExtraModelManager.notTooBright(blockAndTintGetter, mapSlice, (BlockPos)checkPos);
            }
        }
        return isSnowy;
    }

    public static boolean maySnowyAt(Level level, IMapSlice mapSlice, BlockState state, BlockPos checkPos, RandomSource random, long seed) {
        if (mapSlice != null) {
            if (EclipticUtil.canSnowyBlockInteract() && MapChecker.notWater(state)) {
                return mapSlice.isSnowyBlock(checkPos);
            }
            return MapChecker.shouldSnowAt(level, checkPos, mapSlice.getSurfaceFaceBiomeId(checkPos), state, random, seed);
        }
        return MapChecker.shouldSnowAt(level, checkPos, state, random, seed);
    }

    public static boolean notTooBright(BlockAndTintGetter blockAndTintGetter, IMapSlice mapSlice, BlockPos checkPos) {
        boolean isSnowy = true;
        if (((Boolean)CommonConfig.Snow.notSnowyNearGlowingBlock.get()).booleanValue() && !EclipticUtil.canSnowyBlockInteract()) {
            if (mapSlice != null && blockAndTintGetter.m_45517_(LightLayer.BLOCK, checkPos) >= (Integer)CommonConfig.Snow.notSnowyNearGlowingBlockLevel.get()) {
                isSnowy = false;
            }
            if (mapSlice == null && blockAndTintGetter.m_45517_(LightLayer.BLOCK, checkPos) >= (Integer)CommonConfig.Snow.notSnowyNearGlowingBlockLevel.get()) {
                isSnowy = false;
            }
        }
        return isSnowy;
    }

    public static BakedModel findModel(BlockAndTintGetter blockAndTintGetter, BlockPos pos, BlockState state, RandomSource random, long seed, @Nullable BlockPos.MutableBlockPos checkPos) {
        IESReplaceModel iesReplaceModel;
        IMapSliceProvider ip;
        boolean leaveLike;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return null;
        }
        int flag = MapChecker.getDefaultBlockTypeFlag(state);
        List<SeasonBlockDefinition> seasonDefCache = null;
        List<SnowDefinition> snowDefClientOverlay = null;
        Block onBlock = state.m_60734_();
        if (flag == 0) {
            seasonDefCache = ClientRef.seasonDef.get(onBlock);
            snowDefClientOverlay = ClientRef.snowClientDef.get(onBlock);
            if (snowDefClientOverlay != null && snowDefClientOverlay.isEmpty()) {
                snowDefClientOverlay = null;
            }
            if (seasonDefCache == null && snowDefClientOverlay == null) {
                return null;
            }
        }
        boolean extendCheck = false;
        if (checkPos == null) {
            checkPos = ExtraModelManager.posToMutable(pos);
        } else {
            checkPos.m_122178_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
        checkPos.m_122178_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
        if (((Boolean)ClientConfig.Debug.smoothSnowyEdges.get()).booleanValue() && blockAndTintGetter.m_45517_(LightLayer.SKY, (BlockPos)checkPos) > 0) {
            extendCheck = true;
        }
        boolean leavesOrVine = (leaveLike = MapChecker.leaveLike(flag)) || MapChecker.vineLike(flag);
        Object replace = null;
        IMapSlice mapSlice = null;
        if (blockAndTintGetter instanceof IMapSlice) {
            int cut;
            IMapSlice cmapSlice;
            mapSlice = cmapSlice = (IMapSlice)blockAndTintGetter;
            if (!(leavesOrVine || (cut = mapSlice.getBlockHeight(pos) - pos.m_123342_()) <= 1 || ((Boolean)ClientConfig.Renderer.snowUnderFence.get()).booleanValue() || extendCheck)) {
                return null;
            }
        }
        int offset = snowDefClientOverlay == null ? MapChecker.getSnowOffset(state, flag) : snowDefClientOverlay.get(0).getInfo().getOffset();
        boolean isLight = false;
        if (checkPos == null) {
            checkPos = ExtraModelManager.posToMutable(pos);
        } else {
            checkPos.m_122178_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
        if (((Boolean)ClientConfig.Renderer.useVanillaCheck.get()).booleanValue()) {
            checkPos.m_142448_(pos.m_123342_() + 1);
            isLight = blockAndTintGetter.m_45517_(LightLayer.BLOCK, (BlockPos)checkPos) >= 15;
        } else {
            int cacheHeight = mapSlice != null ? mapSlice.getBlockHeight((BlockPos)checkPos) : MapChecker.getHeightOrUpdate((Level)level, (BlockPos)checkPos, false);
            isLight = cacheHeight <= pos.m_123342_() - offset;
        }
        boolean specialLeaves = false;
        if (!isLight && ((Boolean)ClientConfig.Renderer.snowUnderFence.get()).booleanValue()) {
            checkPos.m_122178_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
            if (blockAndTintGetter.m_45517_(LightLayer.SKY, (BlockPos)checkPos) >= 9) {
                int n;
                if (blockAndTintGetter instanceof IMapSliceProvider) {
                    ip = (IMapSliceProvider)blockAndTintGetter;
                    n = ip.getSolidBlockHeight((BlockPos)checkPos);
                } else {
                    n = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_()) - 1;
                }
                int y_real = n;
                checkPos.m_142448_(y_real);
                BlockState getterBlockState = blockAndTintGetter.m_8055_((BlockPos)checkPos);
                if (getterBlockState.m_60795_()) {
                    try {
                        getterBlockState = level.m_8055_((BlockPos)checkPos);
                    }
                    catch (Exception e) {
                        EclipticSeasons.logger(e);
                    }
                }
                if (getterBlockState.m_60792_((BlockGetter)blockAndTintGetter, (BlockPos)checkPos) < 0.5f) {
                    isLight = true;
                    if (leaveLike) {
                        if (((Boolean)CommonConfig.Snow.snowyTree.get()).booleanValue()) {
                            specialLeaves = true;
                        } else {
                            isLight = false;
                        }
                    }
                }
            }
        }
        if (isLight) {
            checkPos.m_122178_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
            if (MapChecker.leaveLike(flag)) {
                if (!specialLeaves) {
                    BlockState aboveState = blockAndTintGetter.m_8055_((BlockPos)checkPos);
                    if (isLight) {
                        specialLeaves = blockAndTintGetter instanceof IMapSliceProvider ? (ip = (IMapSliceProvider)blockAndTintGetter).getSolidBlockHeight((BlockPos)checkPos) > pos.m_123342_() : aboveState.m_60713_(state.m_60734_());
                    }
                }
            } else if (MapChecker.extraSnowPassable(state)) {
                isLight = !MapChecker.extraSnowPassable(blockAndTintGetter.m_8055_((BlockPos)checkPos));
            } else if (!((Boolean)ClientConfig.Renderer.snowUnderFence.get()).booleanValue()) {
                boolean bl = isLight = !MapChecker.solidTest(blockAndTintGetter.m_8055_((BlockPos)checkPos));
            }
        }
        if (isLight && specialLeaves && !(isLight = ((Boolean)CommonConfig.Snow.snowyTree.get()).booleanValue())) {
            specialLeaves = false;
        }
        if (isLight || extendCheck) {
            boolean isSnowy = false;
            checkPos.m_142448_(pos.m_123342_());
            if (CommonConfig.isSnowyWinter() && isLight && onBlock != Blocks.f_50127_ && ExtraModelManager.maySnowyAt((Level)level, mapSlice, state, (BlockPos)checkPos, random, seed)) {
                isSnowy = true;
                checkPos.m_122178_(pos.m_123341_(), pos.m_123342_() + 1 - offset, pos.m_123343_());
                isSnowy = ExtraModelManager.notTooBright(blockAndTintGetter, mapSlice, (BlockPos)checkPos);
                if (isSnowy) {
                    BlockState snowState = null;
                    if (flag == 3) {
                        snowState = (BlockState)((BlockState)((BlockState)((Block)BlockRegistry.snowyStairs.get()).m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)((Direction)state.m_61143_((Property)StairBlock.f_56841_)))).m_61124_((Property)StairBlock.f_56842_, (Comparable)((Half)state.m_61143_((Property)StairBlock.f_56842_)))).m_61124_((Property)StairBlock.f_56843_, (Comparable)((StairsShape)state.m_61143_((Property)StairBlock.f_56843_)));
                    } else if (flag == 7) {
                        snowState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((VineBlock)BlockRegistry.snowyVine.get()).m_49966_().m_61124_((Property)VineBlock.f_57835_, (Comparable)((Boolean)state.m_61143_((Property)VineBlock.f_57835_)))).m_61124_((Property)VineBlock.f_57837_, (Comparable)((Boolean)state.m_61143_((Property)VineBlock.f_57837_)))).m_61124_((Property)VineBlock.f_57836_, (Comparable)((Boolean)state.m_61143_((Property)VineBlock.f_57836_)))).m_61124_((Property)VineBlock.f_57834_, (Comparable)((Boolean)state.m_61143_((Property)VineBlock.f_57834_)))).m_61124_((Property)VineBlock.f_57833_, (Comparable)((Boolean)state.m_61143_((Property)VineBlock.f_57833_)));
                    } else if (leaveLike && !specialLeaves) {
                        snowState = ((Block)BlockRegistry.snowyLeaves.get()).m_49966_();
                    }
                    BakedModel snowModel = ExtraModelManager.getSnowyModel(state, snowState, flag, offset);
                    if (snowModel != null) {
                        replace = snowModel;
                    }
                }
            }
            if (!isSnowy && (flag == 1 || onBlock == Blocks.f_50440_) && ((Boolean)ClientConfig.Debug.smoothSnowyEdges.get()).booleanValue()) {
                int index = -1;
                int ddLength = 0;
                int[][][] directions = DirectionMask.DIRECTIONS;
                int[] indexs = DirectionMask.INDICES;
                BlockPos.MutableBlockPos originalCache = null;
                int directionsLength = directions.length;
                block2: for (int i = 0; i < directionsLength; ++i) {
                    int[][] directionRequireGroup;
                    for (int[] direction : directionRequireGroup = directions[i]) {
                        checkPos.m_122178_(pos.m_123341_() + direction[0], pos.m_123342_() + 1, pos.m_123343_() + direction[1]);
                        if ((mapSlice != null ? mapSlice.getBlockHeight((BlockPos)checkPos) : MapChecker.getHeightOrUpdate((Level)level, (BlockPos)checkPos, false)) != pos.m_123342_()) continue block2;
                        checkPos.m_122178_(pos.m_123341_() + direction[0], pos.m_123342_(), pos.m_123343_() + direction[1]);
                        BlockState neighSate = blockAndTintGetter.m_8055_((BlockPos)checkPos);
                        long neighSateSeed = neighSate.m_60726_((BlockPos)checkPos);
                        if (!neighSate.m_60713_(Blocks.f_50440_) && MapChecker.getDefaultBlockTypeFlag(neighSate) != 1) continue block2;
                        if (originalCache == null) {
                            originalCache = new BlockPos.MutableBlockPos(checkPos.m_123341_(), checkPos.m_123342_(), checkPos.m_123343_());
                        } else {
                            originalCache.m_122178_(checkPos.m_123341_(), checkPos.m_123342_(), checkPos.m_123343_());
                        }
                        if (!ExtraModelManager.canSnowy(blockAndTintGetter, (BlockPos)originalCache, neighSate, neighSateSeed, checkPos)) continue block2;
                    }
                    if (directionRequireGroup.length <= ddLength) continue;
                    index = i;
                    ddLength = directionRequireGroup.length;
                }
                if (index > -1) {
                    index = indexs[index];
                    replace = models.get(snow_edge_overlays.get(index));
                    isSnowy = true;
                }
            }
        }
        if (replace == null || !(replace instanceof IESReplaceModel) || !(iesReplaceModel = (IESReplaceModel)replace).isReplace()) {
            if (seasonDefCache == null) {
                seasonDefCache = ClientRef.seasonDef.get(onBlock);
            }
            if (seasonDefCache != null) {
                for (SeasonBlockDefinition localSeasonStatus : seasonDefCache) {
                    List<SeasonBlockDefinition.FlatSliceHolder> flatSliceHolders = localSeasonStatus.getFlatSliceEnumMap().get(ClientCon.nowSolarTerm);
                    if (flatSliceHolders == null || flatSliceHolders.isEmpty()) continue;
                    checkPos.m_122178_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
                    for (SeasonBlockDefinition.FlatSliceHolder flatSliceHolder : flatSliceHolders) {
                        BakedModel to_replace;
                        ModelTester mmrl;
                        ResourceLocation cinfo;
                        ModelResolver smr;
                        SeasonBlockDefinition.FlatSlice flatSlice = flatSliceHolder.flatSlice();
                        if (flatSlice.emptyAbove() && !blockAndTintGetter.m_8055_((BlockPos)checkPos).m_60795_() || (mapSlice != null || !localSeasonStatus.getBiomes().m_203333_(MapChecker.getSurfaceBiome((Level)level, (BlockPos)checkPos))) && (mapSlice == null || !localSeasonStatus.getBiomes().m_203333_(MapChecker.idToBiome((Level)level, mapSlice.getSurfaceFaceBiomeId((BlockPos)checkPos)))) || (smr = extraSnowModelBuilds.get(cinfo = flatSlice.transitionModels() == null ? flatSlice.mid() : (Mth.m_14040_((int)((int)(seed + (long)pos.m_123341_()))) % 100 > ClientCon.progress ? (ResourceLocation)flatSlice.transitionModels().getFirst() : (ResourceLocation)flatSlice.transitionModels().getSecond()))) == null || (mmrl = smr.tryFind(state)) == null || (to_replace = models.get(mmrl.modelResourceLocation())) == null) continue;
                        if (replace != null) {
                            replace = new SnowySeasonBakeModel<BakedModel>(to_replace, (BakedModel)replace, ExtraModelManager.getRenderType(state));
                            if (!mmrl.replace() || !(replace instanceof SnowySeasonBakeModel)) continue;
                            SnowySeasonBakeModel snowyBakedModelWrapper = (SnowySeasonBakeModel)replace;
                            snowyBakedModelWrapper.setReplace(true);
                            continue;
                        }
                        replace = mmrl.replace() ? new TempReplaceModelWrapper<BakedModel>(to_replace) : to_replace;
                    }
                }
            }
        }
        return replace;
    }

    public static RenderType getRenderType(BlockState state) {
        ChunkRenderTypeSet chunkRenderTypeSet = ItemBlockRenderTypes.getRenderLayers((BlockState)state);
        if (chunkRenderTypeSet.contains(RenderType.m_110466_())) {
            return RenderType.m_110466_();
        }
        if (chunkRenderTypeSet.contains(RenderType.m_110463_())) {
            return RenderType.m_110463_();
        }
        return RenderType.m_110457_();
    }

    @Deprecated(forRemoval=true)
    public static boolean isModelReplaced(BlockState state) {
        return ExtraModelManager.isModelReplaceable(state, (BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_, null);
    }

    public static boolean isModelReplaceable(BlockState state, BlockGetter blockAndTintGetter, BlockPos pos, BakedModel bakedModel) {
        IESReplaceModel model;
        return bakedModel instanceof IESReplaceModel && (model = (IESReplaceModel)bakedModel).isReplace() || ExtraModelManager.isModelReplaceable(MapChecker.getDefaultBlockTypeFlag(state));
    }

    public static boolean isModelReplaceable(BakedModel bakedModel, int flag) {
        IESReplaceModel model;
        return bakedModel instanceof IESReplaceModel && (model = (IESReplaceModel)bakedModel).isReplace() || ExtraModelManager.isModelReplaceable(flag);
    }

    private static boolean isModelReplaceable(int flag) {
        return flag == 5 || flag == 501;
    }

    public static boolean renderAsSnowInShader(BlockState state, BlockGetter blockAndTintGetter, BlockPos pos) {
        int blockType = MapChecker.getDefaultBlockTypeFlag(state);
        return switch (blockType) {
            case 1, 2, 3, 6, 301, 998, 999, 1000, 1100 -> true;
            default -> false;
        };
    }

    public static void clearForRebaked(Map<ResourceLocation, BakedModel> modelRegistry) {
        models = modelRegistry;
        snowyModelsCache.clear();
        snowyModelsCache2.clear();
        if (ClientCon.getUseLevel() != null) {
            ClientRef.updateClientSide(ClientCon.getUseLevel().m_9598_());
        }
    }

    public static void registerExtraSnowyModels(BiConsumer<ResourceLocation, UnbakedModel> registerModelAndDependenceMethod) {
        extraSnowModelBuilds.clear();
        Map<ResourceLocation, ESModelLoadedJson> snowModelLoadedJsonMap = ClientJsonCacheListener.modelDefCache.build(ESModelLoadedJson.CODEC);
        EclipticSeasons.logger("Try to register extra model definitions with size %s.".formatted(snowModelLoadedJsonMap.size()));
        snowModelLoadedJsonMap.forEach((resourceLocation, loadedJson) -> {
            if (!loadedJson.getRequire().isEmpty()) {
                for (String modid : loadedJson.getRequire()) {
                    if (Platform.isModLoaded(modid)) continue;
                    return;
                }
            }
            if (loadedJson.getMultiPartLike().isValid()) {
                ResourceLocation mrl = ExtraModelManager.extra_mrl(resourceLocation, "0");
                registerModelAndDependenceMethod.accept(mrl, (UnbakedModel)loadedJson.getMultiPartLike());
                extraSnowModelBuilds.put((ResourceLocation)resourceLocation, new ModelResolver(List.of(new ModelTester(mrl, loadedJson.isReplace(), List.of()))));
            } else {
                loadedJson.getVariants().forEach((va, multiVariant) -> {
                    ResourceLocation mrl = ExtraModelManager.extra_mrl(resourceLocation, va.replaceAll("=", "_").replace(",", "_"));
                    registerModelAndDependenceMethod.accept(mrl, (UnbakedModel)multiVariant);
                    extraSnowModelBuilds.compute((ResourceLocation)resourceLocation, (sss, solver) -> {
                        if (solver == null) {
                            solver = new ModelResolver(new ArrayList<ModelTester>());
                        }
                        ArrayList<SnowDefinition.PropertyTester> test = new ArrayList<SnowDefinition.PropertyTester>();
                        for (String s : va.split(",")) {
                            String[] split = s.split("=");
                            if (split.length != 2) continue;
                            test.add(SnowDefinition.PropertyTester.builder().name(split[0]).matcher(SnowDefinition.ExactMatcher.builder().value(split[1]).build()).build());
                        }
                        solver.modelTesters().add(new ModelTester(mrl, loadedJson.isReplace(), test));
                        return solver;
                    });
                });
            }
        });
    }

    public static BlockModel remappingSeasonTextures(ResourceLocation resourceLocation, BlockModel returnValue) {
        if (SEASONAL_TEXTURE_HASH_MAP.containsKey(resourceLocation)) {
            List<SeasonalTexture> seasonalTexture = SEASONAL_TEXTURE_HASH_MAP.get(resourceLocation);
            return SolarBlockModel.of(returnValue).setSeasonalTexture(seasonalTexture);
        }
        return null;
    }

    static {
        snowOverlayLeaves = new ModelResourceLocation(BlockRegistry.snowyLeaves.getId(), "");
        snowySlabBottom = new ModelResourceLocation(BlockRegistry.snowySlab.getId(), "type=bottom,waterlogged=false");
        snowOverlayBlock = new ModelResourceLocation(BlockRegistry.snowyBlock.getId(), "");
        ice = EclipticSeasons.rl("block/ice");
        snowy_leaves_attach = EclipticSeasons.rl("block/snowy_leaves_attach");
        snowy_leaves_top = EclipticSeasons.rl("block/snowy_leaves_top");
        snowy_custom = EclipticSeasons.rl("block/snowy_custom");
        snowy_custom_ao = EclipticSeasons.rl("block/snowy_custom_ao");
        stairs_top = EclipticSeasons.rl("block/stairs_top");
        snowy_fern = EclipticSeasons.rl("block/snowy_fern");
        snowy_grass = EclipticSeasons.rl("block/snowy_grass");
        snowy_large_fern_bottom = EclipticSeasons.rl("block/snowy_large_fern_bottom");
        snowy_large_fern_top = EclipticSeasons.rl("block/snowy_large_fern_top");
        snowy_tall_grass_bottom = EclipticSeasons.rl("block/snowy_tall_grass_bottom");
        snowy_tall_grass_top = EclipticSeasons.rl("block/snowy_tall_grass_top");
        overlay_2 = EclipticSeasons.rl("block/overlay_2");
        snow_height2 = EclipticSeasons.rl("block/snow_height2");
        snow_height2_top = EclipticSeasons.rl("block/snow_height2_top");
        grass_flower = EclipticSeasons.rl("block/grass_flower");
        snow = new ResourceLocation("block/snow");
        snow_overlay_half_left = ExtraModelManager.textureRL("snow_overlay_half_left");
        snow_overlay_half_right = ExtraModelManager.textureRL("snow_overlay_half_right");
        snow_overlay = ExtraModelManager.textureRL("snow_overlay");
        snow_overlay_leaves = ExtraModelManager.textureRL("snow_overlay_leaves");
        snow_overlay_tiny = ExtraModelManager.textureRL("snow_overlay_tiny");
        extra_slope_overlay = ExtraModelManager.textureRL("extra/slope_overlay");
        extra_slope_overlay_2 = ExtraModelManager.textureRL("extra/slope_overlay_2");
        flower_on_grass = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6)).stream().map(i -> EclipticSeasons.rl("block/flower_%s".formatted(i))).toList();
        snow_edge_overlays = IntStream.rangeClosed(0, 18).mapToObj(i -> EclipticSeasons.rl("block/snow_edge/snow_edge_overlay_%s".formatted(i))).collect(Collectors.toCollection(ArrayList::new));
        fourleaf_clovers = IntStream.rangeClosed(0, 6).mapToObj(i -> EclipticSeasons.rl("block/fourleaf_clover/fourleaf_clover_%s".formatted(i))).collect(Collectors.toCollection(ArrayList::new));
        blocksCache = new HashMap();
        snowyModelsCache = new IdentityHashMap<BlockState, BakedModel>();
        snowyModelsCache2 = new IdentityHashMap<BlockState, BakedModel>();
        EMPTY = List.of();
        extraSnowModels = new HashMap<ResourceLocation, ESModelLoadedJson>(1024);
        extraSnowModelBuilds = new HashMap<ResourceLocation, ModelResolver>(1024);
        SEASONAL_TEXTURE_HASH_MAP = new HashMap<ResourceLocation, List<SeasonalTexture>>();
    }
}

