/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.debug;

import com.teamtea.eclipticseasons.api.constant.biome.Humidity;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.client.debug.DebugInfoRenderer;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.solar.SolarAngelHelper;
import com.teamtea.eclipticseasons.common.core.solar.SolarDataManager;
import com.teamtea.eclipticseasons.config.ClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelTimeAccess;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="eclipticseasons")
public final class OverlayEventHandler {
    public static final ResourceLocation DEFAULT = new ResourceLocation("minecraft", "textures/gui/icons.png");
    private static final DebugInfoRenderer BAR_4 = new DebugInfoRenderer(Minecraft.m_91087_());

    @SubscribeEvent(receiveCanceled=true)
    public static void onEvent(RenderGuiOverlayEvent.Pre event) {
        LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
        if (clientPlayer != null && ((Boolean)ClientConfig.Debug.debugInfo.get()).booleanValue() && !Minecraft.m_91087_().f_91066_.f_92062_) {
            Level level = clientPlayer.m_9236_();
            BlockPos blockPos = clientPlayer.m_20183_();
            Holder biome = level.m_204166_(clientPlayer.m_20097_());
            SolarTerm solar = ((SolarDataManager)((Object)SolarHolders.getSaveDataLazy(level).resolve().get())).getSolarTerm();
            long dayTime = level.m_46468_();
            float downfall = EclipticUtil.getDownfallFloat(level, (Biome)biome.m_203334_(), blockPos);
            Humidity h = EclipticUtil.getHumidityAt(level, blockPos);
            double env = EclipticUtil.getTemperatureFloat(level, (Biome)biome.m_203334_(), blockPos);
            int solarTime = SolarAngelHelper.getSolarAngelTime((LevelTimeAccess)level, level.m_46468_());
            BAR_4.renderStatusBar(event.getGuiGraphics(), event.getWindow().m_85445_(), event.getWindow().m_85446_(), clientPlayer, (Holder<Biome>)biome, solar, dayTime, env, downfall, h, solarTime);
        }
    }
}

