/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.model;

import com.teamtea.eclipticseasons.client.core.ExtraModelManager;
import com.teamtea.eclipticseasons.client.model.ISnowyReplaceModel;
import com.teamtea.eclipticseasons.client.model.SnowyBakedModelWrapper;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MulBakeModel<T extends BakedModel>
extends BakedModelWrapper<T>
implements ISnowyReplaceModel {
    public static final ModelData ES_DATA = ModelData.builder().with(new ModelProperty(), null).build();
    public static final List<BakedQuad> EMPTY_LIST = new ArrayList<BakedQuad>();
    private final T esModel;
    private final boolean customRuntime;
    private final boolean replace;
    private final boolean valid;
    private final RenderType snowChunkRenderType;
    private final ChunkRenderTypeSet snowRenderTypes;
    private final int flag;
    private final boolean snowy;

    public MulBakeModel(T originalModel, T esModel, boolean replace, RenderType snowChunkRenderType) {
        super(originalModel);
        int n;
        SnowyBakedModelWrapper snowyBakedModelWrapper;
        if (esModel instanceof SnowyBakedModelWrapper) {
            snowyBakedModelWrapper = (SnowyBakedModelWrapper)esModel;
            n = snowyBakedModelWrapper.getBindBlockType();
        } else {
            n = 0;
        }
        this.flag = n;
        this.customRuntime = MapChecker.customBuiltin(this.flag);
        this.esModel = esModel;
        this.valid = esModel != null;
        this.replace = replace;
        this.snowChunkRenderType = snowChunkRenderType;
        this.snowRenderTypes = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{this.snowChunkRenderType});
        this.snowy = esModel instanceof SnowyBakedModelWrapper && !ISnowyReplaceModel.isInvalid((BakedModel)(snowyBakedModelWrapper = (SnowyBakedModelWrapper)esModel));
    }

    protected List<BakedQuad> getCustomBakedQuads(@Nullable BlockState state, List<BakedQuad> quads, @Nullable Direction side) {
        if (ExtraModelManager.shouldMakeSnowyBakedQuads(this.flag, side)) {
            ArrayList<BakedQuad> snowModelQuads = new ArrayList<BakedQuad>(quads.size());
            snowModelQuads.addAll(ExtraModelManager.makeSnowyBakedQuads(state, quads, new ArrayList<BakedQuad>(quads)));
            return snowModelQuads;
        }
        return EMPTY_LIST;
    }

    protected List<BakedQuad> cancelTop(List<BakedQuad> quads) {
        if (this.snowy) {
            ArrayList<BakedQuad> subQuads = new ArrayList<BakedQuad>(quads.size());
            for (BakedQuad quad : quads) {
                if (quad.m_111306_() == Direction.UP) continue;
                subQuads.add(quad);
            }
            return subQuads.size() == quads.size() ? quads : subQuads;
        }
        return quads;
    }

    @NotNull
    protected List<BakedQuad> combineBakedQuads(List<BakedQuad> quads, List<BakedQuad> snowModelQuads_Ori) {
        if (snowModelQuads_Ori.isEmpty()) {
            return quads;
        }
        if (quads.isEmpty()) {
            return snowModelQuads_Ori;
        }
        ArrayList<BakedQuad> snowModelQuads = new ArrayList<BakedQuad>(quads.size() + snowModelQuads_Ori.size());
        snowModelQuads.addAll(quads);
        snowModelQuads.addAll(snowModelQuads_Ori);
        return snowModelQuads;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        List quads;
        if (this.replace) {
            return this.esModel.getQuads(state, side, rand, extraData, renderType);
        }
        boolean buildExtraQuad = this.shouldBuildExtraQuad(extraData);
        List list = quads = !buildExtraQuad ? this.originalModel.getQuads(state, side, rand, extraData, renderType) : EMPTY_LIST;
        if (this.valid) {
            quads = this.cancelTop(quads);
            if (this.isRenderTypeUse(renderType) && buildExtraQuad) {
                if (this.customRuntime) {
                    if (state != null) {
                        quads = new ArrayList<BakedQuad>();
                        for (RenderType runGet : this.getRenderTypes(state, rand, extraData)) {
                            quads.addAll(this.originalModel.getQuads(state, side, rand, extraData, runGet));
                        }
                    }
                    quads = this.getCustomBakedQuads(state, quads, side);
                } else {
                    quads = this.esModel.getQuads(state, side, rand, extraData, renderType);
                }
            }
        }
        return quads;
    }

    public boolean isRenderTypeUse(@Nullable RenderType renderType) {
        return this.snowRenderTypes.contains(renderType);
    }

    public boolean isSnowy() {
        return this.snowy;
    }

    protected boolean shouldBuildExtraQuad(ModelData modelData) {
        return modelData == ES_DATA;
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        if (this.replace) {
            return this.snowRenderTypes;
        }
        ChunkRenderTypeSet renderTypes = this.originalModel.getRenderTypes(state, rand, data);
        if (this.valid && !renderTypes.contains(this.snowChunkRenderType)) {
            renderTypes = ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{renderTypes, this.snowRenderTypes});
        }
        return renderTypes;
    }

    @Override
    public boolean isLowLayer() {
        ISnowyReplaceModel isrm;
        T t = this.esModel;
        return t instanceof ISnowyReplaceModel && (isrm = (ISnowyReplaceModel)t).isLowLayer();
    }

    @Override
    public void setLowLayer(boolean lowLayer) {
        T t = this.esModel;
        if (t instanceof ISnowyReplaceModel) {
            ISnowyReplaceModel isrm = (ISnowyReplaceModel)t;
            isrm.setLowLayer(lowLayer);
        }
    }

    @Override
    public void updateBlockType(int bindBlockType) {
        T t = this.esModel;
        if (t instanceof ISnowyReplaceModel) {
            ISnowyReplaceModel isrm = (ISnowyReplaceModel)t;
            isrm.updateBlockType(bindBlockType);
        }
    }

    @Override
    public int getBindBlockType() {
        int n;
        T t = this.esModel;
        if (t instanceof ISnowyReplaceModel) {
            ISnowyReplaceModel isrm = (ISnowyReplaceModel)t;
            n = isrm.getBindBlockType();
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    public boolean isReplace() {
        ISnowyReplaceModel isrm;
        T t = this.esModel;
        return t instanceof ISnowyReplaceModel && (isrm = (ISnowyReplaceModel)t).isReplace();
    }
}

