/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.model.bakequad;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.util.Arrays;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;

public class BakedQuadRetexturedAndReUV
extends BakedQuad {
    private final TextureAtlasSprite texture;
    public static int uvIndex = 4;
    public static int verticeSpace = DefaultVertexFormat.f_85811_.m_86020_() / 4;
    private final boolean isSlabDown;
    private final float offset;

    public BakedQuadRetexturedAndReUV(BakedQuad quad, TextureAtlasSprite textureIn, boolean isSlabDown) {
        this(quad, textureIn, isSlabDown, 0.5f);
    }

    public BakedQuadRetexturedAndReUV(BakedQuad quad, TextureAtlasSprite textureIn, boolean isSlabDown, float offset) {
        super(Arrays.copyOf(quad.m_111303_(), quad.m_111303_().length), -1, quad.m_111306_(), textureIn, quad.m_111307_(), quad.hasAmbientOcclusion());
        this.texture = textureIn;
        this.isSlabDown = isSlabDown;
        this.offset = offset;
        this.remapQuad();
    }

    private void remapQuad() {
        float x0 = Float.intBitsToFloat(this.f_111292_[0]);
        float y0 = Float.intBitsToFloat(this.f_111292_[1]);
        float z0 = Float.intBitsToFloat(this.f_111292_[2]);
        float x1 = Float.intBitsToFloat(this.f_111292_[verticeSpace]);
        float y1 = Float.intBitsToFloat(this.f_111292_[verticeSpace + 1]);
        float z1 = Float.intBitsToFloat(this.f_111292_[verticeSpace + 2]);
        float x3 = Float.intBitsToFloat(this.f_111292_[3 * verticeSpace]);
        float y3 = Float.intBitsToFloat(this.f_111292_[3 * verticeSpace + 1]);
        float z3 = Float.intBitsToFloat(this.f_111292_[3 * verticeSpace + 2]);
        float edge1X = x1 - x0;
        float edge1Y = y1 - y0;
        float edge1Z = z1 - z0;
        float edge2X = x3 - x0;
        float edge2Y = y3 - y0;
        float edge2Z = z3 - z0;
        float lenU = (float)Math.sqrt(edge2X * edge2X + edge2Y * edge2Y + edge2Z * edge2Z);
        float lenV = (float)Math.sqrt(edge1X * edge1X + edge1Y * edge1Y + edge1Z * edge1Z);
        for (int i = 0; i < 4; ++i) {
            int j = verticeSpace * i;
            float x = Float.intBitsToFloat(this.f_111292_[j]);
            float y = Float.intBitsToFloat(this.f_111292_[j + 1]);
            float z = Float.intBitsToFloat(this.f_111292_[j + 2]);
            float du = ((x - x0) * edge2X + (y - y0) * edge2Y + (z - z0) * edge2Z) / (edge2X * edge2X + edge2Y * edge2Y + edge2Z * edge2Z);
            float dv = ((x - x0) * edge1X + (y - y0) * edge1Y + (z - z0) * edge1Z) / (edge1X * edge1X + edge1Y * edge1Y + edge1Z * edge1Z);
            du *= lenU;
            dv *= lenV;
            du = Mth.m_14036_((float)du, (float)0.0f, (float)1.0f);
            dv = Mth.m_14036_((float)dv, (float)0.0f, (float)1.0f);
            this.f_111292_[j + BakedQuadRetexturedAndReUV.uvIndex] = Float.floatToRawIntBits(this.texture.m_118367_((double)(du * 16.0f)));
            this.f_111292_[j + BakedQuadRetexturedAndReUV.uvIndex + 1] = Float.floatToRawIntBits(this.texture.m_118393_((double)(dv * 16.0f)));
        }
    }

    private static float getUnInterpolatedU(TextureAtlasSprite sprite, float u) {
        float f = sprite.m_118410_() - sprite.m_118409_();
        return (u - sprite.m_118409_()) / f * 16.0f;
    }

    private static float getUnInterpolatedV(TextureAtlasSprite sprite, float v) {
        float f = sprite.m_118412_() - sprite.m_118411_();
        return (v - sprite.m_118411_()) / f * 16.0f;
    }
}

