/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.particle;

import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.api.EclipticSeasonsApi;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.tag.EclipticBlockTags;
import com.teamtea.eclipticseasons.api.data.client.ColorMode;
import com.teamtea.eclipticseasons.api.data.client.LeafColor;
import com.teamtea.eclipticseasons.client.particle.ColorParticleOptions;
import com.teamtea.eclipticseasons.client.particle.FallenLeavesParticle;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.client.util.ClientRef;
import com.teamtea.eclipticseasons.client.util.ColorHelper;
import com.teamtea.eclipticseasons.common.registry.ParticleRegistry;
import com.teamtea.eclipticseasons.config.ClientConfig;
import java.awt.Color;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Vector3f;

public class ParticleUtil {
    private static Holder<Biome> nowBiome = null;
    private static final Map<BlockState, Pair<Color, Integer>> LEAVES_COLOR_MAP = new IdentityHashMap<BlockState, Pair<Color, Integer>>();

    public static void createParticle(ClientLevel clientLevel, int x, int y, int z) {
        if (!((Boolean)ClientConfig.Particle.seasonParticle.get()).booleanValue()) {
            return;
        }
    }

    public static void doAnimateTick(ClientLevel clientLevel, int x, int y, int z, int b, RandomSource random, BlockPos.MutableBlockPos blockpos$mutableblockpos) {
        int i = x + random.m_188503_(b) - random.m_188503_(b);
        int j = y + random.m_188503_(b) - random.m_188503_(b);
        int k = z + random.m_188503_(b) - random.m_188503_(b);
        blockpos$mutableblockpos.m_122178_(i, j, k);
        BlockState blockstate = clientLevel.m_8055_((BlockPos)blockpos$mutableblockpos);
        ParticleUtil.doAnimateTick(clientLevel, x, y, z, b, random, blockpos$mutableblockpos, blockstate);
    }

    public static boolean doAnimateTick(ClientLevel clientLevel, int x, int y, int z, int b, RandomSource random, BlockPos.MutableBlockPos blockpos$mutableblockpos, BlockState blockstate) {
        Season sd;
        List<Pair<LeafColor.InstanceHolder, LeafColor.Instance>> pairs;
        if (!((Boolean)ClientConfig.Particle.seasonParticle.get()).booleanValue()) {
            return false;
        }
        boolean replace = false;
        int i = blockpos$mutableblockpos.m_123341_();
        int j = blockpos$mutableblockpos.m_123342_();
        int k = blockpos$mutableblockpos.m_123343_();
        boolean isLeaf = false;
        Block block = blockstate.m_60734_();
        List<Pair<LeafColor.InstanceHolder, LeafColor.Instance>> list = pairs = !blockstate.m_60795_() ? null : ClientRef.leaveColors.get(block);
        if (pairs != null) {
            for (Pair<LeafColor.InstanceHolder, LeafColor.Instance> pair : pairs) {
                if (!((LeafColor.InstanceHolder)pair.getFirst()).matches((Level)clientLevel, i, j, k, random, blockstate)) continue;
                isLeaf = true;
                LeafColor.Instance second = (LeafColor.Instance)pair.getSecond();
                Integer chanceW = null;
                if (second.weights().contains(ClientCon.nowSolarTerm)) {
                    chanceW = second.weights().get(ClientCon.nowSolarTerm);
                } else {
                    switch (ClientCon.nowSolarTerm.getSeason()) {
                        case SPRING: {
                            chanceW = 17;
                            break;
                        }
                        case SUMMER: {
                            chanceW = 27;
                            break;
                        }
                        case AUTUMN: {
                            chanceW = 9;
                            break;
                        }
                        case WINTER: {
                            chanceW = 15;
                        }
                    }
                }
                if (second.sprites().get(ClientCon.nowSolarTerm) == null) break;
                if (chanceW != null && random.m_188503_((chanceW = Integer.valueOf(chanceW * (int)((float)((Integer)ClientConfig.Particle.fallenLeavesDropWeight.get()).intValue() * 0.4f))).intValue()) == 0) {
                    ParticleUtil.fallenLeaves(clientLevel, (BlockPos)blockpos$mutableblockpos, random, blockstate, second);
                }
                replace = second.replace();
                break;
            }
        }
        if (!isLeaf && ((Boolean)ClientConfig.Particle.fallenLeaves.get()).booleanValue() && block instanceof LeavesBlock && !blockstate.m_204336_(EclipticBlockTags.NONE_FALLEN_LEAVES) && (sd = ClientCon.nowSolarTerm.getSeason()) != Season.NONE) {
            int chanceW = 19;
            switch (sd) {
                case SPRING: {
                    chanceW = 17;
                    break;
                }
                case SUMMER: {
                    chanceW = 27;
                    break;
                }
                case AUTUMN: {
                    chanceW = 9;
                    break;
                }
                case WINTER: {
                    chanceW = 15;
                }
            }
            if (random.m_188503_(chanceW *= (int)((float)((Integer)ClientConfig.Particle.fallenLeavesDropWeight.get()).intValue() * 0.4f)) == 0) {
                ParticleUtil.fallenLeaves(clientLevel, (BlockPos)blockpos$mutableblockpos, random, blockstate, null);
            }
        }
        if (((Boolean)ClientConfig.Particle.butterfly.get()).booleanValue() && ClientCon.nowSolarTerm.getSeason() == Season.SPRING && ClientCon.isDay && !blockstate.m_60795_() && blockstate.m_204336_(EclipticBlockTags.HABITAT_BUTTERFLY) && !EclipticSeasonsApi.getInstance().isRainOrSnowAt((Level)clientLevel, (BlockPos)blockpos$mutableblockpos) && clientLevel.m_45527_((BlockPos)blockpos$mutableblockpos) && random.m_188503_((int)(1024.0f * ((float)((Integer)ClientConfig.Particle.butterflySpawnWeight.get()).intValue() * 0.1f))) == 0) {
            clientLevel.m_6493_((ParticleOptions)ParticleRegistry.BUTTERFLY, false, (double)i + 0.5, (double)j + 0.8, (double)k + 0.5, 0.0, 5.0E-4, 0.0);
        }
        if (((Boolean)ClientConfig.Particle.firefly.get()).booleanValue() && ClientCon.nowSolarTerm.getSeason() == Season.SUMMER && ClientCon.isEvening && !blockstate.m_60795_() && blockstate.m_204336_(EclipticBlockTags.HABITAT_FIREFLY) && !EclipticSeasonsApi.getInstance().isRainOrSnowAt((Level)clientLevel, (BlockPos)blockpos$mutableblockpos) && clientLevel.m_45527_((BlockPos)blockpos$mutableblockpos) && random.m_188503_((int)(160.0f * ((float)((Integer)ClientConfig.Particle.fireflySpawnWeight.get()).intValue() * 0.1f))) == 0) {
            clientLevel.m_6493_((ParticleOptions)ParticleRegistry.FIREFLY, false, (double)i + 0.5, (double)j + 0.8, (double)k + 0.5, 0.0, 5.0E-4, 0.0);
        }
        if (((Boolean)ClientConfig.Particle.wildGoose.get()).booleanValue() && ClientCon.nowSolarTerm.getSeason() == Season.AUTUMN && ClientCon.isNoon && clientLevel.m_45527_((BlockPos)blockpos$mutableblockpos) && clientLevel.m_46859_((BlockPos)blockpos$mutableblockpos) && !EclipticSeasonsApi.getInstance().isRainAt((Level)clientLevel, (BlockPos)blockpos$mutableblockpos) && ((Biome)clientLevel.m_204166_((BlockPos)blockpos$mutableblockpos).m_203334_()).m_47554_() < 0.95f && random.m_188503_((int)(2295.0f * ((float)((Integer)ClientConfig.Particle.wildGooseSpawnWeight.get()).intValue() * 0.1f))) == 0) {
            clientLevel.m_6493_((ParticleOptions)ParticleRegistry.WILD_GOOSE, false, (double)(x + random.m_216339_(16, 32) * (random.m_188499_() ? -1 : 1)), (double)(y + random.m_216339_(15, 32)), (double)(z + random.m_216339_(16, 32) * (random.m_188499_() ? -1 : 1)), 0.0, 5.0E-4, 0.0);
        }
        return replace;
    }

    public static void fallenLeaves(ClientLevel level, BlockPos pos, RandomSource random, BlockState state, LeafColor.Instance leafInfo) {
        if (!state.m_60795_()) {
            int color = -1;
            if (leafInfo == null) {
                int blockColor;
                pair = ParticleUtil.getOrCreateColor(state);
                color = ((Color)pair.getFirst()).getRGB();
                if ((Integer)pair.getSecond() != -1 && (blockColor = Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)level, pos, ((Integer)pair.getSecond()).intValue())) != -1) {
                    int n = color = color == -1 ? blockColor : ColorHelper.simplyMixColor(color, 0.25f, blockColor, 0.75f);
                }
                if (color == -1) {
                    color = state.m_284242_((BlockGetter)level, (BlockPos)pos).f_283871_;
                }
            } else {
                color = switch (leafInfo.colorSource()) {
                    default -> throw new IncompatibleClassChangeError();
                    case LeafColor.ColorSource.MAP -> state.m_284242_((BlockGetter)level, (BlockPos)pos).f_283871_;
                    case LeafColor.ColorSource.BLOCK -> Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)level, pos, 0);
                    case LeafColor.ColorSource.TEXTURE -> {
                        int color2;
                        pair = ParticleUtil.getOrCreateColor(state);
                        int textureColor = ((Color)pair.getFirst()).getRGB();
                        if ((Integer)pair.getSecond() != -1 && (color2 = Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)level, pos, 0)) != -1) {
                            textureColor = textureColor == -1 ? color2 : ColorHelper.simplyMixColor(textureColor, 0.25f, color2, 0.75f);
                        }
                        yield textureColor;
                    }
                    case LeafColor.ColorSource.CUSTOM -> {
                        ColorMode.Instance orDefault1 = leafInfo.colors().getOrDefault(ClientCon.nowSolarTerm, null);
                        if (orDefault1 != null) {
                            yield orDefault1.value();
                        }
                        yield -1;
                    }
                };
            }
            VoxelShape voxelshape = state.m_60808_((BlockGetter)level, pos);
            double d0 = 0.25;
            int finalColor = color;
            int finalColor1 = color;
            voxelshape.m_83286_((x0, y0, z0, x1, y1, z1) -> {
                double x = Math.min(1.0, x1 - x0);
                double y = Math.min(1.0, y1 - y0);
                double z = Math.min(1.0, z1 - z0);
                int aX = Math.min(1, Mth.m_14165_((double)(x / 0.25)));
                int aY = Math.min(1, Mth.m_14165_((double)(y / 0.25)));
                int aZ = Math.min(1, Mth.m_14165_((double)(z / 0.25)));
                for (int pX = 0; pX < aX; ++pX) {
                    for (int pY = -aY; pY < 0; ++pY) {
                        for (int pZ = 0; pZ < aZ; ++pZ) {
                            double d4 = ((double)pX + 0.5) / (double)aX;
                            double d5 = ((double)pY + 0.5) / (double)aY;
                            double d6 = ((double)pZ + 0.5) / (double)aZ;
                            double d7 = d4 * x + x0;
                            double d8 = d5 * y + y0;
                            double d9 = d6 * z + z0;
                            if (d5 > (double)0.49f) {
                                d5 = 0.42f;
                            }
                            Vector3f vector3f = new Vector3f((float)FastColor.ARGB32.m_13665_((int)finalColor) / 255.0f, (float)FastColor.ARGB32.m_13667_((int)finalColor) / 255.0f, (float)FastColor.ARGB32.m_13669_((int)finalColor) / 255.0f);
                            if (leafInfo == null || leafInfo.sprites().getOrDefault(ClientCon.nowSolarTerm, null) == null) {
                                level.m_7106_((ParticleOptions)new ColorParticleOptions(vector3f, 1.0f), (double)pos.m_123341_() + d7, (double)pos.m_123342_() + d8, (double)pos.m_123343_() + d9, Mth.m_14008_((double)(d4 - 0.5), (double)-0.25, (double)0.25), (d5 - 0.5) * 0.75, Mth.m_14008_((double)(d6 - 0.5), (double)-0.25, (double)0.25));
                                continue;
                            }
                            List<ResourceLocation> resourceLocations = leafInfo.sprites().get(ClientCon.nowSolarTerm);
                            if (resourceLocations.isEmpty()) continue;
                            TextureAtlas textureAtlas = (TextureAtlas)Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118260_);
                            ResourceLocation resourceLocation = resourceLocations.get(random.m_188503_(resourceLocations.size()));
                            Minecraft.m_91087_().f_91061_.m_107344_((Particle)new FallenLeavesParticle(level, (double)pos.m_123341_() + d7, (double)pos.m_123342_() + d8, (double)pos.m_123343_() + d9, Mth.m_14008_((double)(d4 - 0.5), (double)-0.25, (double)0.25), (d5 - 0.5) * 0.75, Mth.m_14008_((double)(d6 - 0.5), (double)-0.25, (double)0.25), new ColorParticleOptions(vector3f, 1.0f), textureAtlas.m_118316_(resourceLocation)));
                        }
                    }
                }
            });
        }
    }

    public static void onReloadResource() {
        LEAVES_COLOR_MAP.clear();
    }

    public static Pair<Color, Integer> getOrCreateColor(BlockState state) {
        Minecraft mc = Minecraft.m_91087_();
        Color c = Color.WHITE;
        try {
            Pair orDefault = LEAVES_COLOR_MAP.getOrDefault(state, null);
            if (orDefault != null) {
                return orDefault;
            }
            BakedModel blockModel = mc.m_91289_().m_110910_(state);
            int tintIndex = -1;
            block2: for (Direction direction : new Direction[]{Direction.UP, Direction.DOWN, Direction.SOUTH, Direction.EAST, Direction.NORTH, Direction.WEST, null}) {
                List quads = blockModel.getQuads(state, direction, mc.f_91073_.m_213780_(), ModelData.EMPTY, ItemBlockRenderTypes.m_109282_((BlockState)state));
                for (BakedQuad quad : quads) {
                    if (quad.m_111305_() == -1) continue;
                    tintIndex = quad.m_111305_();
                    continue block2;
                }
            }
            TextureAtlasSprite texture = blockModel.getParticleIcon(ModelData.EMPTY);
            ArrayList<Integer> rlist = new ArrayList<Integer>();
            ArrayList<Integer> glist = new ArrayList<Integer>();
            ArrayList<Integer> blist = new ArrayList<Integer>();
            for (int i = 0; i < texture.m_245424_().m_246492_(); ++i) {
                for (int j = 0; j < texture.m_245424_().m_245330_(); ++j) {
                    int b;
                    int g;
                    int color = 0xFF000000 | texture.getPixelRGBA(0, i, j);
                    int r = color & 0xFF;
                    if (r * (g = color >> 8 & 0xFF) * (b = color >> 16 & 0xFF) <= 0) continue;
                    rlist.add(r);
                    glist.add(g);
                    blist.add(b);
                }
            }
            c = new Color((int)ColorHelper.getAvg(rlist), (int)ColorHelper.getAvg(glist), (int)ColorHelper.getAvg(blist));
            Pair colorIntegerPair = Pair.of((Object)c, (Object)tintIndex);
            LEAVES_COLOR_MAP.put(state, (Pair<Color, Integer>)colorIntegerPair);
            return colorIntegerPair;
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
            return Pair.of((Object)c, (Object)-1);
        }
    }
}

