/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.render;

import com.mojang.blaze3d.shaders.Uniform;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.common.registry.EffectRegistry;
import com.teamtea.eclipticseasons.config.CommonConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.chunk.ChunkStatus;

public class WorldRenderer {
    public static long reMainTick = 0L;
    public static final int NONE_BLUR = 1;
    public static final int ON_BLUR = 2;
    public static final int TO_BLUR = 3;
    public static final int CLEAR_BLUR = 3;
    public static int oldBlurStatus = 1;

    private static float getProgress(boolean fadeIn) {
        return Math.min(fadeIn ? 1.0f - (float)reMainTick / 100.0f : (float)reMainTick / 100.0f, 1.0f);
    }

    public static void applyEffect(GameRenderer gameRenderer, LocalPlayer player) {
        int blurStatus;
        if (player == null) {
            return;
        }
        int n = blurStatus = (Boolean)CommonConfig.Temperature.heatStroke.get() != false && player.m_21023_(EffectRegistry.HEAT_STROKE) ? 2 : 1;
        if (blurStatus != oldBlurStatus) {
            if (blurStatus == 2) {
                gameRenderer.m_109128_(EclipticSeasons.rl("shaders/post/fade_in_blur.json"));
            }
            reMainTick = reMainTick > 0L ? (reMainTick -= 10L) : 100L;
            float progress = WorldRenderer.getProgress(blurStatus == 2) * 0.03f;
            WorldRenderer.updateUniform("Progress", progress);
            if (reMainTick == 0L && (oldBlurStatus = blurStatus) == 1) {
                gameRenderer.m_109086_();
            }
        }
    }

    public static void updateUniform(String name, float value) {
        PostChain postChain = Minecraft.m_91087_().f_91063_.m_109149_();
        if (postChain != null) {
            for (PostPass postPass : postChain.f_110009_) {
                Uniform uniform = postPass.m_110074_().m_108952_(name);
                if (uniform == null) continue;
                uniform.m_5985_(value);
            }
        }
    }

    public static boolean isSectionLoad(SectionPos sectionPos) {
        return WorldRenderer.isSectionLoad(sectionPos, 1);
    }

    public static boolean isSectionLoad(SectionPos pPos, int range) {
        boolean load = true;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            for (int i = -range + 1; i < range; ++i) {
                for (int j = -range + 1; j < range && (load &= level.m_6522_(pPos.m_123341_() + i, pPos.m_123343_() + j, ChunkStatus.f_62326_, false) != null); ++j) {
                }
            }
        }
        return load;
    }

    public static void setSectionDirty(SectionPos sectionPos) {
        if (WorldRenderer.isSectionLoad(sectionPos)) {
            Minecraft.m_91087_().f_91060_.m_109770_(sectionPos.m_123170_(), sectionPos.m_123206_(), sectionPos.m_123222_());
        }
    }

    public static void setSectionDirtyWithNeighbors(SectionPos sectionPos) {
        if (WorldRenderer.isSectionLoad(sectionPos, 2)) {
            Minecraft.m_91087_().f_91060_.m_109490_(sectionPos.m_123170_(), sectionPos.m_123206_(), sectionPos.m_123222_());
        }
    }

    public static void setSectionDirtyRandomly(SectionPos sectionPos) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            RandomSource random = Minecraft.m_91087_().f_91073_.f_46441_;
            int lastViewDistance = (int)(Minecraft.m_91087_().f_91060_.m_173017_() - 1.0);
            for (int i = 0; i < random.m_188503_(8) + 4; ++i) {
                WorldRenderer.setSectionDirtyWithNeighbors(SectionPos.m_123173_((int)(sectionPos.m_123170_() + 2 * random.m_188503_(lastViewDistance) - lastViewDistance), (int)sectionPos.m_123206_(), (int)(sectionPos.m_123222_() + 2 * random.m_188503_(lastViewDistance) - lastViewDistance)));
            }
        }
    }

    public static void setAllDirty(SectionPos centerPos) {
        int pSectionX = centerPos.m_123170_();
        int pSectionY = centerPos.m_123206_();
        int pSectionZ = centerPos.m_123222_();
        int d = (int)Minecraft.m_91087_().f_91060_.m_173017_();
        for (int j = pSectionZ - d; j <= pSectionZ + d; ++j) {
            for (int i = pSectionX - d; i <= pSectionX + d; ++i) {
                for (int k = pSectionY - 3; k <= pSectionY + 1; ++k) {
                    WorldRenderer.setSectionDirty(SectionPos.m_123173_((int)i, (int)k, (int)j));
                }
            }
        }
    }
}

