/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.render.chunk;

import com.teamtea.eclipticseasons.api.misc.client.IMapSlice;
import com.teamtea.eclipticseasons.client.core.ExtraModelManager;
import com.teamtea.eclipticseasons.client.render.WorldRenderer;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.config.ClientConfig;
import com.teamtea.eclipticseasons.config.CommonConfig;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class IceKeeper {
    public static final LongOpenHashSet ICE_SHOULD_BE_IGNORED = new LongOpenHashSet();

    public static void checkIfPlayerStepInFrozenWater(Entity player) {
        BlockPos blockPos;
        if (!CommonConfig.isSnowyWinter()) {
            return;
        }
        if (!((Boolean)ClientConfig.Debug.frozenWater.get()).booleanValue() || !((Boolean)ClientConfig.Debug.frozenWaterBreakable.get()).booleanValue()) {
            return;
        }
        if (!player.m_20069_()) {
            return;
        }
        Level level = player.m_9236_();
        if (MapChecker.getHeight(level, blockPos = player.m_20183_()) != blockPos.m_123342_()) {
            return;
        }
        BlockState water = Blocks.f_49990_.m_49966_();
        if (water.m_60734_() instanceof SimpleWaterloggedBlock) {
            return;
        }
        if (!ExtraModelManager.maySnowyAt(level, null, water, blockPos, level.m_213780_(), water.m_60726_(blockPos))) {
            return;
        }
        if (!ICE_SHOULD_BE_IGNORED.contains(blockPos.m_121878_())) {
            BlockPos above = blockPos.m_7494_();
            if (((Boolean)ClientConfig.Debug.frozenWaterCheckLight.get()).booleanValue() && !ExtraModelManager.notTooBright((BlockAndTintGetter)level, null, blockPos)) {
                return;
            }
            ICE_SHOULD_BE_IGNORED.add(blockPos.m_121878_());
            try {
                WorldRenderer.setSectionDirtyWithNeighbors(SectionPos.m_235861_((EntityAccess)player));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int count = level.m_213780_().m_216339_(7, 12);
            Direction direction = Direction.UP;
            Vec3 vec3 = above.m_252807_().m_82520_(0.0, -0.5, 0.0);
            BlockParticleOption blockParticleOption = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50568_.m_49966_());
            for (int k = 0; k < count * 2; ++k) {
                level.m_7106_((ParticleOptions)blockParticleOption, vec3.f_82479_ - (double)(direction == Direction.WEST ? 1.0E-6f : 0.0f), vec3.f_82480_, vec3.f_82481_ - (double)(direction == Direction.NORTH ? 1.0E-6f : 0.0f), (double)0.15f, (double)0.1f, (double)0.15f);
            }
            level.m_245803_(ClientCon.agent.getCameraEntity(), blockPos, Blocks.f_50126_.m_49966_().m_60827_().m_56775_(), SoundSource.BLOCKS, 0.35f, 0.65f);
        }
    }

    public static void clearAll() {
        ICE_SHOULD_BE_IGNORED.clear();
    }

    public static boolean notFrozen(BlockAndTintGetter worldSlice, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
        if (!CommonConfig.isSnowyWinter()) {
            return true;
        }
        if (!((Boolean)ClientConfig.Debug.frozenWater.get()).booleanValue()) {
            return true;
        }
        if (!fluidState.m_164512_((Fluid)Fluids.f_76193_)) {
            return true;
        }
        if (blockState.m_60734_() instanceof SimpleWaterloggedBlock) {
            return true;
        }
        if (!(worldSlice instanceof IMapSlice)) {
            return true;
        }
        IMapSlice mapSlice = (IMapSlice)worldSlice;
        if (mapSlice.getBlockHeight(blockPos) != blockPos.m_123342_()) {
            return true;
        }
        if (!ExtraModelManager.maySnowyAt(ClientCon.getUseLevel(), mapSlice, blockState, blockPos, null, blockState.m_60726_(blockPos))) {
            return true;
        }
        if (((Boolean)ClientConfig.Debug.frozenWaterCheckLight.get()).booleanValue() && !ExtraModelManager.notTooBright(worldSlice, mapSlice, blockPos)) {
            return true;
        }
        return (Boolean)ClientConfig.Debug.frozenWaterBreakable.get() != false && ICE_SHOULD_BE_IGNORED.contains(blockPos.m_121878_());
    }

    public static BakedModel getIceModel(BlockState state, FluidState fluidState) {
        return ExtraModelManager.models.get(ExtraModelManager.ice);
    }

    public static BlockState getFakeState(BlockState state, FluidState fluidState) {
        return Blocks.f_50126_.m_49966_();
    }
}

