/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamtea.eclipticseasons.client.render.TryKeyframe;
import com.teamtea.eclipticseasons.client.render.TryModel;
import com.teamtea.eclipticseasons.common.block.GreenHouseCoreBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3f;

public class GreenHouseCoreItemRenderer
extends BlockEntityWithoutLevelRenderer {
    protected ModelPart modelPart;
    private final BlockEntityRenderDispatcher blockEntityRenderDispatcher;
    private static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();

    public GreenHouseCoreItemRenderer(BlockEntityRenderDispatcher renderDispatcher, EntityModelSet modelSet) {
        super(renderDispatcher, modelSet);
        this.blockEntityRenderDispatcher = renderDispatcher;
        this.modelPart = TryModel.createBodyLayer().m_171564_().m_171324_("All");
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext transformType, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlay) {
        matrixStackIn.m_85836_();
        matrixStackIn = this.rotateMatrix(matrixStackIn, transformType);
        this.renderModel(stack, matrixStackIn, bufferIn, combinedLightIn, transformType);
        matrixStackIn.m_85849_();
    }

    protected PoseStack rotateMatrix(PoseStack matrixStackIn, ItemDisplayContext transformType) {
        if (transformType == ItemDisplayContext.GUI) {
            matrixStackIn.m_252880_(0.0f, 0.375f, 0.0f);
        } else if (transformType != ItemDisplayContext.GROUND) {
            if (transformType == ItemDisplayContext.FIXED) {
                matrixStackIn.m_252880_(0.0f, 0.5f, -0.25f);
            } else if (transformType != ItemDisplayContext.THIRD_PERSON_RIGHT_HAND && transformType != ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
                if (transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
                    matrixStackIn.m_85837_(0.75, 0.0, 0.0);
                } else if (transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
                    matrixStackIn.m_85837_(0.75, 0.0, 0.0);
                }
            }
        }
        return matrixStackIn;
    }

    protected void renderModel(ItemStack stack, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLight, ItemDisplayContext context) {
        poseStack.m_85836_();
        this.modelPart.m_171331_().forEach(ModelPart::m_233569_);
        long seed = 0L;
        long time = Minecraft.m_91087_().f_91073_.m_46467_() % 50L;
        long renderTicks = (time + 0L) * 40L;
        renderTicks = renderTicks * 3000L / 2000L;
        combinedLight = this.getLightFromItem(stack);
        VertexConsumer vertexconsumer2 = this.getMaterialFromItem(stack).m_119194_(bufferIn, RenderType::m_110467_);
        this.doAnimate(this.modelPart, renderTicks, context);
        this.modelPart.m_104301_(poseStack, vertexconsumer2, combinedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
    }

    protected int getLightFromItem(ItemStack stack) {
        GreenHouseCoreBlock block = (GreenHouseCoreBlock)((BlockItem)stack.m_41720_()).m_40614_();
        return TryModel.getLightFromBlock(block);
    }

    protected Material getMaterialFromItem(ItemStack stack) {
        GreenHouseCoreBlock block = (GreenHouseCoreBlock)((BlockItem)stack.m_41720_()).m_40614_();
        return TryModel.getMaterialFromBlock(block);
    }

    protected void doAnimate(ModelPart modelPart1, long renderTicks, ItemDisplayContext context) {
        TryKeyframe.animate(modelPart1, TryModel.animation, renderTicks, 1.0f, ANIMATION_VECTOR_CACHE);
    }
}

