/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.util;

import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.api.data.client.BiomeColor;
import com.teamtea.eclipticseasons.api.data.client.LeafColor;
import com.teamtea.eclipticseasons.api.data.client.SeasonalBiomeAmbient;
import com.teamtea.eclipticseasons.api.data.client.model.seasonal.SeasonBlockDefinition;
import com.teamtea.eclipticseasons.api.data.season.SnowDefinition;
import com.teamtea.eclipticseasons.api.misc.util.HolderMappable;
import com.teamtea.eclipticseasons.api.misc.util.Mergable;
import com.teamtea.eclipticseasons.api.util.SimpleUtil;
import com.teamtea.eclipticseasons.client.reload.ClientJsonCacheListener;
import com.teamtea.eclipticseasons.config.ClientConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;

public class ClientRef {
    public static final Map<Biome, BiomeColor.Instance> biomeColors = new IdentityHashMap<Biome, BiomeColor.Instance>();
    public static final Map<Block, List<Pair<LeafColor.InstanceHolder, LeafColor.Instance>>> leaveColors = new IdentityHashMap<Block, List<Pair<LeafColor.InstanceHolder, LeafColor.Instance>>>();
    public static final List<SeasonalBiomeAmbient> sounds = new ArrayList<SeasonalBiomeAmbient>();
    public static final Map<Block, List<SeasonBlockDefinition>> seasonDef = new IdentityHashMap<Block, List<SeasonBlockDefinition>>();
    public static final Map<Block, List<SnowDefinition>> snowClientDef = new IdentityHashMap<Block, List<SnowDefinition>>();

    public static void updateClientSide(RegistryAccess registryAccess) {
        biomeColors.clear();
        sounds.clear();
        seasonDef.clear();
        snowClientDef.clear();
        leaveColors.clear();
        ClientRef.buildBiomeColors(registryAccess);
        ClientRef.buildLeafColors(registryAccess);
        ClientRef.buildSeasonalSounds(registryAccess);
        ClientRef.buildSeasonalModels(registryAccess);
        ClientRef.buildOverrideSnowModels(registryAccess);
    }

    private static void buildSeasonalSounds(RegistryAccess registryAccess) {
        sounds.addAll(ClientJsonCacheListener.ambientCache.build(SeasonalBiomeAmbient.CODEC, registryAccess).values());
    }

    private static void buildOverrideSnowModels(RegistryAccess registryAccess) {
        ArrayList collect = ClientJsonCacheListener.snowDefOverrideCache.build(SnowDefinition.CODEC, registryAccess).values().stream().map(HolderMappable::asHolderMapping).collect(Collectors.toCollection(ArrayList::new));
        Map biomeListMap = ClientRef.buildFromHolders(collect, ClientRef.getHolders(registryAccess, Registries.f_256747_));
        snowClientDef.putAll(biomeListMap);
    }

    private static void buildSeasonalModels(RegistryAccess registryAccess) {
        ArrayList collect = ClientJsonCacheListener.seasonDefCache.build(SeasonBlockDefinition.CODEC, registryAccess).entrySet().stream().filter(r -> (Boolean)ClientConfig.Renderer.flowerOnGrass.get() != false || !((ResourceLocation)r.getKey()).equals((Object)SeasonBlockDefinition.GRASS_BLOCK)).map(Map.Entry::getValue).map(HolderMappable::asHolderMapping).collect(Collectors.toCollection(ArrayList::new));
        Map biomeListMap = ClientRef.buildFromHolders(collect, ClientRef.getHolders(registryAccess, Registries.f_256747_));
        seasonDef.putAll(biomeListMap);
    }

    private static void buildLeafColors(RegistryAccess registryAccess) {
        ArrayList collect = ClientJsonCacheListener.leafCache.build(LeafColor.CODEC, registryAccess).values().stream().map(HolderMappable::asHolderMapping).collect(Collectors.toCollection(ArrayList::new));
        Map biomeListMap = ClientRef.buildFromHolders(collect, ClientRef.getHolders(registryAccess, Registries.f_256747_));
        biomeListMap.forEach((pairs, instances) -> {
            List instance = ClientRef.mergePairList(instances);
            leaveColors.put((Block)pairs, instance);
        });
    }

    private static void buildBiomeColors(RegistryAccess registryAccess) {
        ArrayList collect = ClientJsonCacheListener.biomeCache.build(BiomeColor.CODEC, registryAccess).values().stream().map(HolderMappable::asHolderMapping).collect(Collectors.toCollection(ArrayList::new));
        Map biomeListMap = ClientRef.buildFromHolders(collect, ClientRef.getHolders(registryAccess, Registries.f_256952_));
        biomeListMap.forEach((biome, instances) -> {
            BiomeColor.Instance instance = (BiomeColor.Instance)ClientRef.mergeList(instances);
            biomeColors.put((Biome)biome, instance);
        });
    }

    public static <T, V> Map<T, List<V>> buildFromHolders(List<Pair<HolderSet<T>, V>> pairs, List<Holder<T>> holders) {
        HashMap resultMap = new HashMap();
        for (Pair<HolderSet<T>, V> pair : pairs) {
            HolderSet holderSet = (HolderSet)pair.getFirst();
            Object value = pair.getSecond();
            for (Holder th : holderSet) {
                Object t = th.m_203334_();
                resultMap.putIfAbsent(t, new ArrayList());
                if (!holderSet.m_203333_(th)) continue;
                ((List)resultMap.get(t)).add(value);
            }
        }
        return resultMap;
    }

    public static <E> ArrayList<Holder<E>> getHolders(RegistryAccess registryAccess, ResourceKey<? extends Registry<? extends E>> registryKey) {
        Optional registry = registryAccess.m_6632_(registryKey);
        if (registry.isEmpty()) {
            SimpleUtil.warningForModWrongCalling(registryKey);
            return new ArrayList<Holder<E>>();
        }
        return ((Registry)registry.get()).m_203611_().collect(Collectors.toCollection(ArrayList::new));
    }

    private static <S, T extends Mergable<T>> List<Pair<S, T>> mergePairList(List<Pair<S, T>> instances) {
        if (instances == null || instances.size() <= 1) {
            return instances;
        }
        HashMap<Object, Mergable> mergedMap = new HashMap<Object, Mergable>();
        for (Pair<S, T> pair : instances) {
            Object key = pair.getFirst();
            Mergable value = (Mergable)pair.getSecond();
            mergedMap.merge(key, value, Mergable::merge);
        }
        return mergedMap.entrySet().stream().map(entry -> new Pair(entry.getKey(), (Object)((Mergable)entry.getValue()))).collect(Collectors.toList());
    }

    private static <T extends Mergable<T>> T mergeList(List<T> instances) {
        if (instances.isEmpty()) {
            return null;
        }
        if (instances.size() == 1) {
            return (T)((Mergable)instances.get(0));
        }
        return (T)((Mergable)instances.stream().reduce(Mergable::merge).orElse(null));
    }

    public static void onClientPlayerExit() {
        biomeColors.clear();
        leaveColors.clear();
        sounds.clear();
        seasonDef.clear();
        snowClientDef.clear();
    }
}

