/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.advancement;

import com.google.gson.JsonObject;
import com.teamtea.eclipticseasons.common.registry.ModAdvancements;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class ParentNeedCriterion
extends SimpleCriterionTrigger<TriggerInstance> {
    private final ResourceLocation id;

    public ParentNeedCriterion(ResourceLocation id) {
        this.id = id;
    }

    public void trigger(ServerPlayer player) {
        MinecraftServer server = player.m_20194_();
        if (server != null) {
            this.m_66234_(player, t -> t.test(player, server.m_129889_()));
        }
    }

    @NotNull
    public ResourceLocation m_7295_() {
        return this.id;
    }

    protected TriggerInstance createInstance(JsonObject pJson, ContextAwarePredicate pPredicate, DeserializationContext pDeserializationContext) {
        Optional<ResourceLocation> parent = pJson.has("parent") ? Optional.of(new ResourceLocation(pJson.get("parent").getAsString())) : Optional.empty();
        return new TriggerInstance(this.m_7295_(), pPredicate, parent);
    }

    public static final class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final Optional<ResourceLocation> parent;
        private WeakReference<Advancement> advancementHolderWeakReference = new WeakReference<Object>(null);

        public TriggerInstance(ResourceLocation pCriterion, ContextAwarePredicate pPlayer, Optional<ResourceLocation> parent) {
            super(pCriterion, pPlayer);
            this.parent = parent;
        }

        public static TriggerInstance simple(Advancement advancementHolder) {
            return new TriggerInstance(ModAdvancements.parentNeedCriterion.m_7295_(), ContextAwarePredicate.f_285567_, Optional.of(advancementHolder.m_138327_()));
        }

        public boolean test(ServerPlayer player, ServerAdvancementManager advancements) {
            if (this.parent.isEmpty()) {
                return true;
            }
            Advancement advancementHolder = (Advancement)this.advancementHolderWeakReference.get();
            if (advancementHolder == null) {
                advancementHolder = advancements.m_136041_(this.parent.get());
                this.advancementHolderWeakReference = new WeakReference<Advancement>(advancementHolder);
            }
            if (advancementHolder == null) {
                return true;
            }
            return player.m_8960_().m_135996_(advancementHolder).m_8193_();
        }

        public Optional<ResourceLocation> parent() {
            return this.parent;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            TriggerInstance that = (TriggerInstance)((Object)obj);
            return Objects.equals(this.parent, that.parent);
        }

        public int hashCode() {
            return Objects.hash(this.parent);
        }

        public String toString() {
            return "TriggerInstance[parent=" + String.valueOf(this.parent) + "]";
        }

        public JsonObject m_7683_(SerializationContext pConditions) {
            JsonObject jsonObject = super.m_7683_(pConditions);
            this.parent.ifPresent(resourceLocation -> jsonObject.addProperty("parent", resourceLocation.toString()));
            return jsonObject;
        }
    }
}

