/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.block;

import com.teamtea.eclipticseasons.common.block.base.WallPlacedBlock;
import com.teamtea.eclipticseasons.common.block.blockentity.CalendarBlockEntity;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.registry.BlockEntityRegistry;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CalendarBlock
extends WallPlacedBlock {
    protected static final VoxelShape shape_N = Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.75, (double)0.8125, (double)0.875, (double)1.0);
    protected static final VoxelShape shape_S = Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.0, (double)0.8125, (double)0.875, (double)0.25);
    protected static final VoxelShape shape_W = Shapes.m_83048_((double)0.75, (double)0.0, (double)0.1875, (double)1.0, (double)0.875, (double)0.8125);
    protected static final VoxelShape shape_E = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.1875, (double)0.25, (double)0.875, (double)0.8125);
    protected static final VoxelShape[] shapes = new VoxelShape[]{shape_S, shape_W, shape_N, shape_E};
    public static final EnumProperty<DisplayMode> MODE = EnumProperty.m_61587_((String)"display_mode", DisplayMode.class);

    public CalendarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(MODE, (Comparable)((Object)DisplayMode.NORMAL)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{MODE}));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return shapes[((Direction)pState.m_61143_((Property)FACING)).m_122416_()];
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)BlockEntityRegistry.calendar_entity_type.get()).m_155264_(pPos, pState);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity cycle2;
        if (player.m_6144_()) {
            if (level instanceof ServerLevel) {
                BlockState cycle2 = (BlockState)state.m_61122_(MODE);
                level.m_7731_(pos, cycle2, 2);
                player.m_5661_((Component)Component.m_237110_((String)"info.eclipticseasons.calendar.model", (Object[])new Object[]{Component.m_237115_((String)("info.eclipticseasons.calendar.model." + ((DisplayMode)((Object)cycle2.m_61143_(MODE))).m_7912_()))}), true);
            }
            return InteractionResult.SUCCESS;
        }
        if (level.m_5776_() && (cycle2 = level.m_7702_(pos)) instanceof CalendarBlockEntity) {
            CalendarBlockEntity calendarBlockEntity = (CalendarBlockEntity)cycle2;
            Holder<Biome> cropBiome = CropGrowthHandler.getCropBiome((LevelAccessor)level, pos);
            calendarBlockEntity.setBiome(cropBiome);
            if (!calendarBlockEntity.isInit()) {
                calendarBlockEntity.setInit(true);
            }
        }
        return super.m_6227_(state, level, pos, player, pHand, pHit);
    }

    public static enum DisplayMode implements StringRepresentable
    {
        NORMAL,
        YEAR,
        NEXT;


        @NotNull
        public String m_7912_() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

