/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.block;

import com.teamtea.eclipticseasons.common.registry.BlockRegistry;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class IceOrSnowCauldronBlock
extends AbstractCauldronBlock {
    public IceOrSnowCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties, Map.of());
        this.m_49959_(this.m_49966_());
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return Items.f_42544_.m_7968_();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Block block = state.m_60734_();
        ItemStack stack = player.m_21120_(hand);
        if (block == BlockRegistry.snow_cauldron.get() && stack.m_204117_(ItemTags.f_271138_)) {
            return IceOrSnowCauldronBlock.givePlayerResult(stack, new ItemStack((ItemLike)Items.f_42452_, 4), Blocks.f_50125_.m_49966_(), level, pos, player);
        }
        if (block == BlockRegistry.ice_cauldron.get() && stack.m_204117_(ItemTags.f_271360_)) {
            return IceOrSnowCauldronBlock.givePlayerResult(stack, new ItemStack((ItemLike)Items.f_41980_), Blocks.f_50126_.m_49966_(), level, pos, player);
        }
        return InteractionResult.PASS;
    }

    public boolean m_142596_(BlockState pState) {
        return true;
    }

    @NotNull
    protected static InteractionResult givePlayerResult(ItemStack stack, ItemStack result, BlockState state, Level level, BlockPos pos, Player player) {
        if (!level.f_46443_) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)result);
            player.m_36220_(Stats.f_12944_);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            level.m_46597_(pos, Blocks.f_50256_.m_49966_());
            level.m_5594_(null, pos, state.getSoundType((LevelReader)level, pos, (Entity)player).m_56778_(), SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_(null, GameEvent.f_157816_, pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static void handleChange(BlockState state, Level level, BlockPos pos, Biome.Precipitation precipitation) {
        if (((Boolean)CommonConfig.Debug.disableIceOrSnowCauldron.get()).booleanValue()) {
            return;
        }
        if (precipitation == Biome.Precipitation.SNOW) {
            BlockState blockstate = null;
            if (state.m_60734_() == Blocks.f_152478_) {
                blockstate = ((Block)BlockRegistry.snow_cauldron.get()).m_49966_();
            } else if (state.m_60734_() == Blocks.f_152476_) {
                blockstate = ((Block)BlockRegistry.ice_cauldron.get()).m_49966_();
            }
            if (blockstate != null) {
                level.m_46597_(pos, blockstate);
                level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)blockstate));
            }
        }
    }

    public static void init() {
        CauldronInteraction.f_175606_.put(Items.f_41981_, (state, level, pos, player, hand, stack) -> {
            IceOrSnowCauldronBlock.fillEmptyCauldron(level, pos, player, hand, stack, ((Block)BlockRegistry.snow_cauldron.get()).m_49966_(), SoundEvents.f_12482_);
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        });
        CauldronInteraction.f_175606_.put(Items.f_41980_, (state, level, pos, player, hand, stack) -> {
            IceOrSnowCauldronBlock.fillEmptyCauldron(level, pos, player, hand, stack, ((Block)BlockRegistry.ice_cauldron.get()).m_49966_(), SoundEvents.f_11986_);
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        });
    }

    protected static void fillEmptyCauldron(Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack filledStack, BlockState state, SoundEvent soundEvent) {
        if (((Boolean)CommonConfig.Debug.disableIceOrSnowCauldron.get()).booleanValue()) {
            return;
        }
        if (!level.f_46443_) {
            if (!player.m_7500_()) {
                filledStack.m_41774_(1);
            }
            player.m_36220_(Stats.f_12943_);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)filledStack.m_41720_()));
            level.m_46597_(pos, state);
            level.m_5594_(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_(null, GameEvent.f_157797_, pos);
        }
    }

    public Component getTip() {
        if (this == BlockRegistry.snow_cauldron.get()) {
            return Component.m_237115_((String)"info.eclipticseasons.snow_cauldron.extraction");
        }
        if (this == BlockRegistry.ice_cauldron.get()) {
            return Component.m_237115_((String)"info.eclipticseasons.ice_cauldron.extraction");
        }
        return Component.m_237119_();
    }
}

