/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.block;

import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.client.particle.ColorParticleOptions;
import com.teamtea.eclipticseasons.common.block.blockentity.QuestHangingSignBlockEntity;
import com.teamtea.eclipticseasons.common.registry.BlockEntityRegistry;
import com.teamtea.eclipticseasons.common.registry.ItemRegistry;
import com.teamtea.eclipticseasons.common.registry.ParticleRegistry;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class QuestWallHangingSignBlock
extends WallHangingSignBlock {
    protected String descriptionId = null;

    public QuestWallHangingSignBlock(BlockBehaviour.Properties properties) {
        super(properties, WoodType.f_61830_);
    }

    @NotNull
    public String m_7705_() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.m_137492_((String)"block", (ResourceLocation)BuiltInRegistries.f_256975_.m_7981_((Object)this));
        }
        return this.descriptionId;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return ((Item)ItemRegistry.seasonal_prayer_scroll_item.get()).m_7968_();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntityRegistry.season_quest_hanging_sign_entity_type.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return QuestWallHangingSignBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)BlockEntityRegistry.season_quest_hanging_sign_entity_type.get()), QuestHangingSignBlockEntity::tick);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof QuestHangingSignBlockEntity) {
            QuestHangingSignBlockEntity questHangingSignBlockEntity = (QuestHangingSignBlockEntity)blockEntity;
            if (!level.m_5776_() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                questHangingSignBlockEntity.finishSeasonQuest(serverPlayer);
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.m_214162_(state, level, pos, random);
        QuestWallHangingSignBlock.addSeasonalParticle(state, level, pos, random);
    }

    public static void addSeasonalParticle(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Direction direction = Direction.DOWN;
        int color = Season.collectValues()[random.m_188503_(Season.collectValues().length)].getColor().m_126665_();
        float r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        ColorParticleOptions colorParticleOption = new ColorParticleOptions(new Vector3f(r, g, b), 1.0f);
        colorParticleOption.updateType(ParticleRegistry.GREENHOUSE);
        for (int i = 0; i < 2; ++i) {
            double z;
            double y;
            double x;
            double d0 = (double)pos.m_123341_() + (random.m_188500_() - 0.5) + 0.5;
            double d1 = (double)pos.m_123342_() + (random.m_188500_() - 0.5) - 0.125;
            double d2 = (double)pos.m_123343_() + (random.m_188500_() - 0.5) + 0.5;
            double d3 = (random.m_188500_() - 0.5) * 0.4;
            if (random.m_188503_(6) != 0 || !level.m_46859_(new BlockPos((int)(x = d0 + (double)direction.m_122429_() * d3), (int)(y = d1 + (double)direction.m_122430_() * d3), (int)(z = d2 + (double)direction.m_122431_() * d3)))) continue;
            level.m_7106_((ParticleOptions)colorParticleOption, x, y, z, random.m_188583_() * 0.005, 0.001 + random.m_188500_() * 0.02, random.m_188583_() * 0.005);
        }
    }

    protected void m_142387_(Level level, Player player, BlockPos pos, BlockState state) {
        level.m_5898_(player, 2001, pos, QuestWallHangingSignBlock.m_49956_((BlockState)state));
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(level, pos, state, player);
        if (!level.m_5776_() && player.m_7500_()) {
            QuestHangingSignBlockEntity.removeSign(level, pos);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!(movedByPiston || level.m_5776_() || newState.m_60713_((Block)this))) {
            QuestHangingSignBlockEntity.popSign(level, pos);
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }
}

