/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.block;

import com.teamtea.eclipticseasons.api.EclipticSeasonsApi;
import com.teamtea.eclipticseasons.common.block.base.SimpleHorizontalEntityBlock;
import com.teamtea.eclipticseasons.common.block.blockentity.WindChimesBlockEntity;
import com.teamtea.eclipticseasons.common.registry.BlockEntityRegistry;
import com.teamtea.eclipticseasons.common.registry.BlockRegistry;
import com.teamtea.eclipticseasons.common.registry.SoundEventsRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WindChimesBlock
extends SimpleHorizontalEntityBlock {
    public static final VoxelShape BOX_P = Block.m_49796_((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
    public static final VoxelShape BOX_0 = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
    public static final VoxelShape BOX_B = Block.m_49796_((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0);

    public WindChimesBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = Direction.UP;
        return Block.m_49863_((LevelReader)level, (BlockPos)pos.m_121945_(direction), (Direction)direction.m_122424_());
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (pDirection == Direction.UP && pNeighborState.m_60795_()) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)BlockEntityRegistry.wind_chimes_entity_type.get()).m_155264_(pPos, pState);
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Block block = state.m_60734_();
        if (block == BlockRegistry.wind_chimes.get()) {
            return BOX_0;
        }
        if (block == BlockRegistry.bamboo_wind_chimes.get()) {
            return BOX_B;
        }
        return BOX_P;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.m_7892_(state, level, pos, entity);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            Vec3 deltaMovement = livingEntity.m_20184_();
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof WindChimesBlockEntity) {
                WindChimesBlockEntity windChimesBlockEntity = (WindChimesBlockEntity)blockEntity;
                if (level.m_5776_()) {
                    windChimesBlockEntity.setShaking(true);
                }
            }
        }
    }

    public static SoundEvent getSoundEvent(Block block) {
        return block == BlockRegistry.paper_wind_chimes.get() ? SoundEventsRegistry.paper_wind_chimes : (block == BlockRegistry.bamboo_wind_chimes.get() ? SoundEventsRegistry.bamboo_wind_chimes : SoundEventsRegistry.wind_chimes);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity;
        super.m_213898_(state, level, pos, random);
        if (EclipticSeasonsApi.getInstance().isRainingOrSnowing((Level)level, pos) && (blockEntity = level.m_7702_(pos)) instanceof WindChimesBlockEntity) {
            WindChimesBlockEntity windChimesBlockEntity = (WindChimesBlockEntity)blockEntity;
            windChimesBlockEntity.setShaking(true);
        }
    }
}

