/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.block.blockentity;

import com.teamtea.eclipticseasons.api.data.craft.HumidityControl;
import com.teamtea.eclipticseasons.common.block.BlockInGrateBlock;
import com.teamtea.eclipticseasons.common.block.blockentity.HumidityControlBlockEntity;
import com.teamtea.eclipticseasons.common.registry.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockInCopperGrateBlockEntity
extends HumidityControlBlockEntity {
    protected Block innerBlock = null;
    protected final GrateItemStackHandler itemStackHandler = new GrateItemStackHandler();
    protected final LazyOptional<ItemStackHandler> innerItem = LazyOptional.of(() -> this.itemStackHandler);

    public BlockInCopperGrateBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.block_in_copper_grate_block_entity_type.get(), pos, state);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (!this.m_58901_() && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.innerItem.cast();
        }
        return super.getCapability(cap, side);
    }

    public static void popResource(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BlockInCopperGrateBlockEntity) {
            BlockInCopperGrateBlockEntity blockEntity2 = (BlockInCopperGrateBlockEntity)blockEntity;
            blockEntity2.popBlock(level, pos);
        }
    }

    public static void removeBlock(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BlockInCopperGrateBlockEntity) {
            BlockInCopperGrateBlockEntity blockEntity2 = (BlockInCopperGrateBlockEntity)blockEntity;
            blockEntity2.setInnerBlock(null);
        }
    }

    protected void popBlock(Level level, BlockPos pos) {
        if (this.canBlockObtained(level)) {
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)this.getInnerBlock().m_5456_().m_7968_());
        }
    }

    private boolean canBlockObtained(Level level) {
        return level != null && !level.m_5776_() && this.getInnerBlock() != Blocks.f_50016_ && (this.humidityControl == null || (double)this.humidityControl.lasting_time() * 0.6 < (double)this.time || this.humidityControl.noCost());
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("inner_block", BuiltInRegistries.f_256975_.m_7981_((Object)this.getInnerBlock()).toString());
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("inner_block")) {
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(tag.m_128461_("inner_block")));
            if (!block.m_49966_().m_60795_()) {
                this.setBlockAndItemNotSync(block);
            } else {
                this.setBlockAndItemNotSync(null);
            }
        }
    }

    protected void setBlockNotSync(Block block) {
        this.innerBlock = block;
    }

    protected void setBlockAndItemNotSync(Block block) {
        this.setBlockNotSync(block);
        this.itemStackHandler.setStackInSlotNotSync(0, (block == null ? Items.f_41852_ : block.m_5456_()).m_7968_());
    }

    public void setInnerBlock(Block innerBlock) {
        this.popBlock(this.m_58904_(), this.m_58899_());
        this.setBlockAndItemNotSync(innerBlock);
        this.inventoryChanged();
    }

    public Block getInnerBlock() {
        return this.innerBlock == null ? Blocks.f_50016_ : this.innerBlock;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, BlockInCopperGrateBlockEntity blockEntity) {
        HumidityControlBlockEntity.tick(level, blockPos, blockState, blockEntity);
    }

    @Override
    protected boolean isRecipeCacheValid(@NotNull HumidityControl humidityControl) {
        if (this.innerBlock == null || !humidityControl.ingredient().test(this.innerBlock.m_5456_().m_7968_())) {
            return false;
        }
        return super.isRecipeCacheValid(humidityControl);
    }

    @Override
    protected void endRecipe() {
        Item item;
        if (!this.hasNoRecipe() && this.time <= 0 && (item = this.humidityControl.result().m_41720_()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            this.setInnerBlock(blockItem.m_40614_());
        }
        super.endRecipe();
    }

    @Override
    protected void resetRecipe() {
        super.resetRecipe();
        this.setInnerBlock(null);
    }

    public class GrateItemStackHandler
    extends ItemStackHandler {
        public GrateItemStackHandler() {
            super(1);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return BlockInGrateBlock.getItemMatch(BlockInCopperGrateBlockEntity.this.f_58857_, stack) != null;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            BlockInCopperGrateBlockEntity.this.setBlockNotSync(Block.m_49814_((Item)this.getStackInSlot(0).m_41720_()));
            BlockInCopperGrateBlockEntity.this.inventoryChanged();
        }

        public void setStackInSlotNotSync(int slot, @NotNull ItemStack stack) {
            this.validateSlotIndex(slot);
            this.stacks.set(slot, (Object)stack);
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return super.getStackInSlot(slot);
        }
    }
}

