/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.block.blockentity;

import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.data.climate.AgroClimaticZone;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.common.block.GreenHouseCoreBlock;
import com.teamtea.eclipticseasons.common.block.blockentity.base.SyncBlockEntity;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.core.crop.GreenHouseCoreProvider;
import com.teamtea.eclipticseasons.common.core.solar.SolarDataManager;
import com.teamtea.eclipticseasons.common.registry.BlockEntityRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GreenHouseCoreBlockEntity
extends SyncBlockEntity {
    public GreenHouseCoreBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.greenhouse_core_entity_type.get(), pos, state);
    }

    public void m_7651_() {
        SolarDataManager manager = SolarHolders.getSaveData(this.f_58857_);
        if (manager != null) {
            manager.removeGreenHouseProvider(this.m_58899_());
        }
        super.m_7651_();
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, GreenHouseCoreBlockEntity blockEntity) {
        Block block = blockState.m_60734_();
        if (block instanceof GreenHouseCoreBlock) {
            Holder<Biome> cropBiome;
            Holder<AgroClimaticZone> agroClimaticZoneHolder;
            GreenHouseCoreBlock greenHouseCoreBlock = (GreenHouseCoreBlock)block;
            SolarDataManager manager = SolarHolders.getSaveData(level);
            if (manager != null) {
                GreenHouseCoreProvider nearGreenHouseProvider = manager.queryGreenHouseProvider(blockPos);
                if (nearGreenHouseProvider != null) {
                    if (nearGreenHouseProvider.getAvailCost() < 10) {
                        nearGreenHouseProvider.addAvailCost(999);
                    }
                } else {
                    manager.addGreenHouseCoreProvider(blockPos, new GreenHouseCoreProvider(greenHouseCoreBlock.getSeason(), 999));
                }
            }
            if (!level.m_5776_() && level.m_46467_() % 100L == 0L && (agroClimaticZoneHolder = CropGrowthHandler.getclimateTypeHolder(cropBiome = CropGrowthHandler.getCropBiome((LevelAccessor)level, blockPos))) != null) {
                AgroClimaticZone agroClimaticZone = (AgroClimaticZone)agroClimaticZoneHolder.m_203334_();
                List<Pair<Season, Integer>> pairs = agroClimaticZone.seasonalSignalDurations();
                Pair<Season, Integer> currentSeason = GreenHouseCoreBlockEntity.findCurrentSeason(pairs, EclipticUtil.getNowSolarTerm(level).ordinal());
                if (currentSeason.getFirst() == greenHouseCoreBlock.getSeason()) {
                    level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)GreenHouseCoreBlock.POWER, (Comparable)((Integer)currentSeason.getSecond())));
                } else {
                    level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)GreenHouseCoreBlock.POWER, (Comparable)Integer.valueOf(0)));
                }
            }
        }
    }

    public static Pair<Season, Integer> findCurrentSeason(List<Pair<Season, Integer>> localSeason, int index) {
        if (localSeason.isEmpty()) {
            return Pair.of((Object)Season.NONE, (Object)0);
        }
        if (localSeason.size() == 1) {
            return Pair.of((Object)((Season)localSeason.get(0).getFirst()), (Object)15);
        }
        int accumulatedLength = 0;
        for (int i = 0; i < localSeason.size(); ++i) {
            Season season = (Season)localSeason.get(i).getFirst();
            int seasonLength = (Integer)localSeason.get(i).getSecond();
            if (index < accumulatedLength + seasonLength) {
                int power;
                Season lastSeason;
                Season firstSeason = (Season)localSeason.get(0).getFirst();
                if (firstSeason.equals(lastSeason = (Season)localSeason.get(localSeason.size() - 1).getFirst()) && (i == 0 || i == localSeason.size() - 1)) {
                    int localIndex = index - accumulatedLength;
                    int totalMergedLength = (Integer)localSeason.get(0).getSecond() + (Integer)localSeason.get(localSeason.size() - 1).getSecond();
                    power = Math.min(index, totalMergedLength - localIndex) * 30 / totalMergedLength;
                } else {
                    power = Math.min(accumulatedLength + seasonLength - index, index - accumulatedLength) * 30 / seasonLength;
                }
                return Pair.of((Object)season, (Object)Mth.m_14045_((int)power, (int)1, (int)15));
            }
            accumulatedLength += seasonLength;
        }
        return Pair.of((Object)Season.NONE, (Object)0);
    }
}

