/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.biome;

import com.teamtea.eclipticseasons.api.EclipticSeasonsApi;
import com.teamtea.eclipticseasons.api.constant.climate.BiomeRain;
import com.teamtea.eclipticseasons.api.constant.climate.ISnowTerm;
import com.teamtea.eclipticseasons.api.constant.climate.SnowTerm;
import com.teamtea.eclipticseasons.api.constant.climate.WeatherMode;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.constant.tag.ClimateTypeBiomeTags;
import com.teamtea.eclipticseasons.api.constant.tag.ESEnchantmentTags;
import com.teamtea.eclipticseasons.api.constant.tag.ESItemTags;
import com.teamtea.eclipticseasons.api.constant.tag.ESMobEffectTags;
import com.teamtea.eclipticseasons.api.misc.IBiomeTagHolder;
import com.teamtea.eclipticseasons.api.misc.IBiomeWeatherProvider;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.api.util.SimpleUtil;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.common.advancement.SolarTermsRecord;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.biome.BiomeClimateManager;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.core.snow.SnowyMapChecker;
import com.teamtea.eclipticseasons.common.network.SimpleNetworkHandler;
import com.teamtea.eclipticseasons.common.network.message.BiomeWeatherMessage;
import com.teamtea.eclipticseasons.common.network.message.EmptyMessage;
import com.teamtea.eclipticseasons.common.network.message.SolarTermsMessage;
import com.teamtea.eclipticseasons.common.network.message.UpdateTempChangeMessage;
import com.teamtea.eclipticseasons.common.registry.EffectRegistry;
import com.teamtea.eclipticseasons.common.registry.ModAdvancements;
import com.teamtea.eclipticseasons.compat.CompatModule;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

public class WeatherManager {
    public static final Map<Level, ArrayList<BiomeWeather>> BIOME_WEATHER_LIST = new IdentityHashMap<Level, ArrayList<BiomeWeather>>();
    public static final Map<Level, Integer> NEXT_CHECK_BIOME_MAP = new IdentityHashMap<Level, Integer>();
    public static final Map<Level, Map<Biome, BiomeWeather>> BIOME_WEATHER_QUERY_LIST = new IdentityHashMap<Level, Map<Biome, BiomeWeather>>();
    private static final ThreadLocal<Boolean> IS_ON_SERVER_THREAD = ThreadLocal.withInitial(() -> "SERVER".equals(Thread.currentThread().getThreadGroup().getName()));

    public static ArrayList<BiomeWeather> getBiomeList(Level level) {
        if (level == null) {
            Iterator<ArrayList<BiomeWeather>> iterator = BIOME_WEATHER_LIST.values().iterator();
            if (iterator.hasNext()) {
                ArrayList<BiomeWeather> value = iterator.next();
                return value;
            }
            return null;
        }
        if (level instanceof IBiomeWeatherProvider) {
            IBiomeWeatherProvider iBiomeWeatherProvider = (IBiomeWeatherProvider)level;
            return iBiomeWeatherProvider.es$get();
        }
        return BIOME_WEATHER_LIST.getOrDefault(level, null);
    }

    public static int getWeatherTickFactor(Level level) {
        ArrayList<BiomeWeather> biomeList = WeatherManager.getBiomeList(level);
        int size = biomeList == null ? 1 : biomeList.size();
        size = (int)((float)size * Mth.m_14036_((float)(7.0f / (float)EclipticSeasonsApi.getInstance().getLastingDaysOfEachTerm(level)), (float)0.8f, (float)3.0f));
        size = Math.max(1, size);
        return size;
    }

    @Nullable
    public static BiomeWeather getBiomeWeather(Level level, Holder<Biome> biomeHolder) {
        if (biomeHolder == null) {
            return null;
        }
        return WeatherManager.getBiomeWeather(level, (Biome)biomeHolder.m_203334_());
    }

    @Nullable
    public static BiomeWeather getBiomeWeather(Level level, Biome biome) {
        Biome object;
        IBiomeWeatherProvider iBiomeWeatherProvider;
        ArrayList<BiomeWeather> weatherQueryListOrDefault;
        BiomeWeather weather = null;
        if (level instanceof IBiomeWeatherProvider && (weatherQueryListOrDefault = (iBiomeWeatherProvider = (IBiomeWeatherProvider)level).es$get()) != null && (object = biome) instanceof IBiomeTagHolder) {
            IBiomeTagHolder iBiomeTagHolder = (IBiomeTagHolder)object;
            int id = iBiomeTagHolder.eclipticseasons$getBindId();
            if (weatherQueryListOrDefault.size() > id && id > -1) {
                weather = weatherQueryListOrDefault.get(id);
            }
        }
        return weather;
    }

    public static Level fetchLevelIfNull(Level level) {
        if (level != null) {
            return level;
        }
        boolean isClient = ServerLifecycleHooks.getCurrentServer() == null || !ServerLifecycleHooks.getCurrentServer().m_18695_() && IS_ON_SERVER_THREAD.get() == false;
        return isClient ? ClientCon.getUseLevel() : WeatherManager.getMainServerLevel();
    }

    public static void tickAverageWeather(Level level) {
        if (level instanceof IBiomeWeatherProvider) {
            IBiomeWeatherProvider provider = (IBiomeWeatherProvider)level;
            if (EclipticSeasonsApi.getInstance().hasLocalWeather(level)) {
                provider.es$setAverageRainLevel(WeatherManager.calculateAverageRainLevel(level, 1.0f));
                provider.es$setAverageThunderLevel(WeatherManager.calculateAverageThunderLevel(level, 1.0f));
            }
        }
    }

    public static float calculateAverageRainLevel(Level level, float delta) {
        return WeatherManager.getAverageWeatherLevel(level, delta, BiomeWeather::shouldRain);
    }

    public static float calculateAverageThunderLevel(Level level, float delta) {
        return WeatherManager.getAverageWeatherLevel(level, delta, BiomeWeather::shouldThunder);
    }

    public static float getAverageRainLevel(Level level, float delta) {
        return ((IBiomeWeatherProvider)level).es$getAverageRainLevel(delta);
    }

    public static boolean isEffectiveRaining(ServerLevel level) {
        return (double)WeatherManager.getAverageRainLevel((Level)level, 1.0f) > (Double)CompatModule.CommonConfig.weatherVotePercent.get();
    }

    public static float getAverageThunderLevel(Level level, float delta) {
        return ((IBiomeWeatherProvider)level).es$getAverageThunderLevel(delta);
    }

    public static boolean isEffectiveThundering(ServerLevel level) {
        return (double)WeatherManager.getAverageThunderLevel((Level)level, 1.0f) > (Double)CompatModule.CommonConfig.weatherVotePercent.get();
    }

    public static float getAverageWeatherLevel(Level level, float delta, BiomeWeatherPredicate function) {
        List players = level.m_6907_();
        if (!players.isEmpty()) {
            if (players.size() == 1) {
                return function.test(WeatherManager.getBiomeWeather(level, MapChecker.getSurfaceBiome(level, ((Player)players.get(0)).m_20183_()))) ? 1.0f : 0.0f;
            }
            float thunder = 0.0f;
            int playersSize = players.size();
            for (int i = 0; i < playersSize; ++i) {
                Player player = (Player)players.get(i);
                thunder += function.test(WeatherManager.getBiomeWeather(level, MapChecker.getSurfaceBiome(level, player.m_20183_()))) ? 1.0f : 0.0f;
            }
            return thunder / (float)players.size();
        }
        return function.test(WeatherManager.getBiomeWeather(level, MapChecker.getSurfaceBiome(level, level.m_220360_()))) ? 1.0f : 0.0f;
    }

    public static void onSetWeatherParameters(ServerLevel level, int pClearTime, int pWeatherTime, boolean pIsRaining, boolean pIsThundering) {
        block5: {
            int thunderTime;
            int rainTime;
            int clearTime;
            ArrayList<BiomeWeather> biomeList;
            block3: {
                List players;
                block4: {
                    biomeList = WeatherManager.getBiomeList((Level)level);
                    if (biomeList == null) {
                        return;
                    }
                    int size = WeatherManager.getWeatherTickFactor((Level)level);
                    players = level.m_6907_();
                    clearTime = pIsRaining ? 0 : pClearTime / size;
                    rainTime = pIsRaining ? pWeatherTime / size : 0;
                    int n = thunderTime = pIsRaining && pIsThundering ? pWeatherTime / size : 0;
                    if (players.isEmpty()) break block3;
                    if (players.size() != 1) break block4;
                    BiomeWeather biomeWeather = WeatherManager.getBiomeWeather((Level)level, MapChecker.getSurfaceBiome((Level)level, ((Player)players.get(0)).m_20183_()));
                    if (biomeWeather == null) break block5;
                    WeatherManager.setBiomeWeather(level, biomeWeather, clearTime, rainTime, thunderTime);
                    break block5;
                }
                for (Player player : players) {
                    BiomeWeather biomeWeather = WeatherManager.getBiomeWeather((Level)level, MapChecker.getSurfaceBiome((Level)level, player.m_20183_()));
                    if (biomeWeather == null) continue;
                    WeatherManager.setBiomeWeather(level, biomeWeather, clearTime, rainTime, thunderTime);
                }
                break block5;
            }
            for (BiomeWeather biomeWeather : biomeList) {
                Biome biome = (Biome)biomeWeather.biomeHolder.m_203334_();
                if (WeatherManager.hasNonePrecipitation(biome)) continue;
                WeatherManager.setBiomeWeather(level, biomeWeather, clearTime, rainTime, thunderTime);
            }
        }
    }

    public static void setBiomeWeather(ServerLevel level, BiomeWeather biomeWeather, int clearTime, int rainTime, int thunderTime) {
        biomeWeather.clearTime = clearTime;
        biomeWeather.rainTime = rainTime;
        biomeWeather.thunderTime = thunderTime;
        biomeWeather.lastRainTime = rainTime > 0 ? level.m_46467_() : biomeWeather.lastRainTime;
    }

    public static boolean isThunderAtBiome(Level level, BlockPos pos) {
        Holder<Biome> surfaceBiome = MapChecker.getSurfaceBiome(level, pos);
        return WeatherManager.isThunderAtBiome(level, (Biome)surfaceBiome.get());
    }

    public static boolean isThunderAtBiome(Level level, Biome biome) {
        BiomeWeather biomeWeather = WeatherManager.getBiomeWeather(level, biome);
        if (biomeWeather != null) {
            return biomeWeather.shouldThunder();
        }
        return false;
    }

    public static boolean isThunderAt(Level level, BlockPos pos) {
        if (!level.m_45527_(pos)) {
            return false;
        }
        if (level.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_() > pos.m_123342_()) {
            return false;
        }
        Holder<Biome> biome = MapChecker.getSurfaceBiome(level, pos);
        return WeatherManager.isThunderAtBiome(level, (Biome)biome.get());
    }

    public static boolean isRainingUnderSky(Level level, BlockPos pos) {
        Holder<Biome> biome = MapChecker.getSurfaceBiome(level, pos);
        return WeatherManager.getRainOrSnow(level, (Biome)biome.m_203334_(), pos) == Biome.Precipitation.RAIN;
    }

    public static boolean isRainingAt(Level level, BlockPos pos) {
        if (!level.m_45527_(pos)) {
            return false;
        }
        if (level.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_() > pos.m_123342_()) {
            return false;
        }
        Holder<Biome> biome = MapChecker.getSurfaceBiome(level, pos);
        return WeatherManager.getRainOrSnow(level, (Biome)biome.m_203334_(), pos) == Biome.Precipitation.RAIN;
    }

    public static boolean isRainingOrSnowAt(Level level, BlockPos pos) {
        if (!level.m_45527_(pos)) {
            return false;
        }
        if (level.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_() > pos.m_123342_()) {
            return false;
        }
        Holder<Biome> biome = MapChecker.getSurfaceBiome(level, pos);
        return WeatherManager.isRainingOrSnowAtBiome(level, (Biome)biome.m_203334_());
    }

    public static boolean isRainingOrSnowAtBiome(Level level, Biome biome) {
        BiomeWeather biomeWeather = WeatherManager.getBiomeWeather(level, biome);
        if (biomeWeather != null) {
            return biomeWeather.shouldRain();
        }
        return false;
    }

    public static int getSnowDepthAtBiome(Level level, Biome biome) {
        BiomeWeather biomeWeather = WeatherManager.getBiomeWeather(level, biome);
        if (biomeWeather != null) {
            return biomeWeather.snowDepth;
        }
        return 0;
    }

    public static long getLastRainTimeAtBiome(Level level, Biome biome) {
        BiomeWeather biomeWeather = WeatherManager.getBiomeWeather(level, biome);
        if (biomeWeather != null) {
            return biomeWeather.lastRainTime;
        }
        return 0L;
    }

    public static ServerLevel getMainServerLevel() {
        for (Level level : BIOME_WEATHER_LIST.keySet()) {
            if (level.m_46472_() != Level.f_46428_ || !(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel;
        }
        return null;
    }

    public static Biome.Precipitation getRainOrSnow(Level level, Biome biome, BlockPos pos) {
        if (WeatherManager.hasNonePrecipitation(biome)) {
            return Biome.Precipitation.NONE;
        }
        BiomeWeather biomeWeather = WeatherManager.getBiomeWeather(level, biome);
        if (biomeWeather != null) {
            if (biomeWeather.shouldClear()) {
                return Biome.Precipitation.NONE;
            }
            SolarTerm solarTerm = EclipticUtil.getNowSolarTerm(level);
            ISnowTerm snowTerm = SolarTerm.getSnowTerm(biome, level instanceof ServerLevel, EclipticUtil.getSnowTempChange(level));
            boolean flag_cold = snowTerm.maySnow(solarTerm, biome, pos, level instanceof ServerLevel);
            return flag_cold ? Biome.Precipitation.SNOW : Biome.Precipitation.RAIN;
        }
        return Biome.Precipitation.NONE;
    }

    public static Biome.Precipitation getPrecipitationAt(Biome biome, BlockPos pos) {
        Level level = WeatherManager.fetchLevelIfNull(null);
        if (level != null && ((Boolean)CompatModule.CommonConfig.fixBiome.get()).booleanValue() && MapChecker.isSmallBiome(biome)) {
            biome = (Biome)MapChecker.getSurfaceBiome(level, pos).m_203334_();
        }
        return WeatherManager.getPrecipitationAt(level, biome, pos);
    }

    public static Biome.Precipitation getPrecipitationAt(@Nullable Level level, Biome biome, BlockPos pos) {
        if (WeatherManager.hasNonePrecipitation(biome)) {
            return Biome.Precipitation.NONE;
        }
        BiomeWeather biomeWeather = WeatherManager.getBiomeWeather(level, biome);
        if (level != null && biomeWeather != null) {
            SolarTerm solarTerm = EclipticUtil.getNowSolarTerm(level);
            ISnowTerm snowTerm = SolarTerm.getSnowTerm(biome, level instanceof ServerLevel, EclipticUtil.getSnowTempChange(level));
            boolean flag_cold = snowTerm.maySnow(solarTerm, biome, pos, level instanceof ServerLevel);
            return flag_cold ? Biome.Precipitation.SNOW : Biome.Precipitation.RAIN;
        }
        return Biome.Precipitation.NONE;
    }

    public static boolean hasNonePrecipitation(Biome biome) {
        if (!biome.m_264473_()) {
            return true;
        }
        return (Boolean)CommonConfig.Weather.notRainInDesert.get() != false && !biome.getModifiedClimateSettings().f_263819_() && BiomeClimateManager.getTag(biome) == ClimateTypeBiomeTags.MONSOONAL;
    }

    public static void createLevelBiomeWeatherList(Level level) {
        Optional biomes;
        ArrayList<BiomeWeather> biomesWeathers = new ArrayList<BiomeWeather>();
        BIOME_WEATHER_LIST.put(level, biomesWeathers);
        if (level instanceof IBiomeWeatherProvider) {
            IBiomeWeatherProvider iBiomeWeatherProvider = (IBiomeWeatherProvider)level;
            iBiomeWeatherProvider.es$set(biomesWeathers);
        }
        if ((biomes = level.m_9598_().m_6632_(Registries.f_256952_)).isPresent()) {
            for (Biome biome : (Registry)biomes.get()) {
                ResourceLocation loc = ((Registry)biomes.get()).m_7981_((Object)biome);
                int id = ((Registry)biomes.get()).m_7447_((Object)biome);
                Optional biomeHolder = ((Registry)biomes.get()).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)((Registry)biomes.get()).m_7981_((Object)biome)));
                if (!biomeHolder.isPresent()) continue;
                BiomeWeather biomeWeather = new BiomeWeather((Holder<Biome>)((Holder)biomeHolder.get()));
                ((Registry)biomes.get()).m_7447_((Object)biome);
                biomeWeather.location = loc;
                biomeWeather.id = id;
                biomesWeathers.add(biomeWeather);
                ((IBiomeTagHolder)biome).eclipticseasons$setBindId(id);
            }
            IdentityHashMap<Biome, BiomeWeather> biomeBiomeWeatherMap = new IdentityHashMap<Biome, BiomeWeather>();
            for (BiomeWeather biomesWeather : biomesWeathers) {
                biomeBiomeWeatherMap.put((Biome)biomesWeather.biomeHolder.m_203334_(), biomesWeather);
            }
            BIOME_WEATHER_QUERY_LIST.put(level, biomeBiomeWeatherMap);
        }
    }

    public static void informUpdateBiomes(RegistryAccess registryAccess, boolean isServer) {
        BIOME_WEATHER_LIST.forEach((key, biomeWeathers) -> {
            if (key instanceof ServerLevel == isServer) {
                registryAccess.m_6632_(Registries.f_256952_).ifPresent(biomeRegistry -> biomeRegistry.m_203611_().forEach(biomeHolder -> {
                    ResourceLocation loc = biomeHolder.m_205785_().m_135782_();
                    int id = biomeRegistry.m_7447_((Object)((Biome)biomeHolder.m_203334_()));
                    boolean inList = false;
                    for (BiomeWeather biomeWeather : biomeWeathers) {
                        if (!biomeWeather.biomeHolder.m_203373_(loc)) continue;
                        biomeWeather.id = id;
                        biomeWeather.biomeHolder = biomeHolder;
                        inList = true;
                        break;
                    }
                    if (!inList) {
                        BiomeWeather biomeWeather = new BiomeWeather((Holder<Biome>)biomeHolder);
                        biomeWeather.location = loc;
                        biomeWeather.id = id;
                        biomeWeathers.add(biomeWeather);
                    }
                }));
            }
        });
        BIOME_WEATHER_LIST.forEach((key, value) -> value.sort(Comparator.comparing(c -> c.id)));
    }

    public static void tickPlayerSeasonEffect(ServerPlayer player) {
        if (player.m_7500_() || player.m_5833_() || !((Boolean)CommonConfig.Temperature.heatStroke.get()).booleanValue()) {
            return;
        }
        Level level = player.m_9236_();
        if (level.m_213780_().m_188503_(150) == 0) {
            SolarHolders.getSaveDataLazy(level).ifPresent(solarDataManager -> {
                Biome b;
                if (EclipticUtil.getNowSolarTerm(level).isInTerms(SolarTerm.BEGINNING_OF_SUMMER, SolarTerm.BEGINNING_OF_AUTUMN) && EclipticUtil.getTemperatureFloat(level, b = (Biome)level.m_204166_(player.m_20183_()).m_203334_(), player.m_20183_()) > 0.85f && !player.m_20070_() && EclipticUtil.isNoon(level) && level.m_45527_(player.m_20183_())) {
                    boolean isColdHe = false;
                    block0: for (ItemStack itemstack : player.m_6168_()) {
                        Equipable equipable;
                        Item item = itemstack.m_41720_();
                        if (!(item instanceof Equipable) || (equipable = (Equipable)item).m_40402_() != EquipmentSlot.HEAD) continue;
                        if (itemstack.m_204117_(ESItemTags.HEAT_PROTECTIVE_HELMETS)) {
                            isColdHe = true;
                            break;
                        }
                        Map allEnchantments = itemstack.getAllEnchantments();
                        if (allEnchantments.isEmpty()) continue;
                        for (Enchantment enchantment : allEnchantments.keySet()) {
                            Optional holder = ForgeRegistries.ENCHANTMENTS.getHolder((Object)enchantment);
                            if (!holder.isPresent() || !((Holder)holder.get()).m_203656_(ESEnchantmentTags.HEATSTROKE_RESISTANT)) continue;
                            isColdHe = true;
                            break block0;
                        }
                    }
                    if (!isColdHe) {
                        NonNullList items = player.m_150109_().f_35974_;
                        int selectionSize = Inventory.m_36059_();
                        int itemsSize = items.size();
                        for (int i = 0; i < itemsSize && i < selectionSize; ++i) {
                            ItemStack itemstack = (ItemStack)items.get(i);
                            if (!itemstack.m_204117_(ESItemTags.COOLING_ITEMS)) continue;
                            isColdHe = true;
                            break;
                        }
                    }
                    if (!isColdHe) {
                        isColdHe = player.m_21023_(MobEffects.f_19607_);
                        for (MobEffectInstance activeEffect : player.m_21220_()) {
                            Optional holder = ForgeRegistries.MOB_EFFECTS.getHolder((Object)activeEffect.m_19544_());
                            if (!holder.isPresent() || !((Holder)holder.get()).m_203656_(ESMobEffectTags.HEATSTROKE_RESISTANT)) continue;
                            isColdHe = true;
                            break;
                        }
                    }
                    if (!player.m_21023_(EffectRegistry.HEAT_STROKE) && !isColdHe) {
                        player.m_7292_(new MobEffectInstance(EffectRegistry.HEAT_STROKE, 600));
                        ModAdvancements.heatStrokeCriterion.trigger(player);
                    }
                }
            });
        }
    }

    public static void runWeather(ServerLevel level, BiomeWeather biomeWeather, RandomSource random, int size) {
        Holder<Biome> onwer;
        WeatherMode weatherMode = EclipticUtil.getWeatherMode((Level)level);
        if (weatherMode == WeatherMode.REGION && (onwer = BiomeClimateManager.getWeatherRegionOnwer((Biome)biomeWeather.biomeHolder.m_203334_())) != null) {
            BiomeWeather ownerBiomeWeather = WeatherManager.getBiomeWeather((Level)level, onwer);
            if (onwer != null && !onwer.equals(biomeWeather.biomeHolder)) {
                biomeWeather.rainTime = ownerBiomeWeather.rainTime;
                biomeWeather.thunderTime = ownerBiomeWeather.thunderTime;
                biomeWeather.clearTime = ownerBiomeWeather.clearTime;
                WeatherManager.updateSnowOrMelt(level, biomeWeather, random, size, biomeWeather.shouldRain());
                return;
            }
        }
        if (!((Biome)biomeWeather.biomeHolder.m_203334_()).m_264473_()) {
            return;
        }
        boolean isEcliptic = EclipticUtil.hasLocalWeather((Level)level);
        if (isEcliptic) {
            if (biomeWeather.shouldClear()) {
                --biomeWeather.clearTime;
            } else if (biomeWeather.shouldRain()) {
                --biomeWeather.rainTime;
                if (!biomeWeather.shouldThunder()) {
                    solarTerm = EclipticUtil.getNowSolarTerm((Level)level);
                    BiomeRain biomeRain = WeatherManager.getBiomeRain(level, solarTerm, biomeWeather.biomeHolder);
                    float weight = biomeRain.getThunderChance() * ((float)((Integer)CommonConfig.Weather.thunderChanceMultiplier.get()).intValue() * 1.0f / 100.0f) * (float)size / 3000.0f;
                    if ((float)level.m_213780_().m_188503_(1000) / 1000.0f < weight) {
                        biomeWeather.thunderTime = biomeRain.getThunderDuration(random) / size;
                    }
                }
            } else {
                solarTerm = EclipticUtil.getNowSolarTerm((Level)level);
                BiomeRain biomeRain = WeatherManager.getBiomeRain(level, solarTerm, biomeWeather.biomeHolder);
                float downfall = EclipticUtil.getDownfallFloatConstant(solarTerm, (Biome)biomeWeather.biomeHolder.m_203334_(), !level.m_5776_());
                if (biomeWeather.biomeHolder.m_203656_(BiomeTags.f_215816_)) {
                    downfall += 0.2f;
                }
                float weight = biomeRain.getRainChance() * Math.max(0.01f, downfall) * ((float)((Integer)CommonConfig.Weather.rainChanceMultiplier.get()).intValue() * 1.0f / 100.0f);
                if ((float)level.m_213780_().m_188503_(1000) / 1000.0f < weight) {
                    biomeWeather.rainTime = biomeRain.getRainDuration(random) / size;
                } else {
                    biomeWeather.clearTime = biomeRain.getRainDelay(random) / size;
                }
            }
            if (biomeWeather.shouldThunder()) {
                --biomeWeather.thunderTime;
                if (!biomeWeather.shouldRain()) {
                    biomeWeather.thunderTime = 0;
                }
            }
            WeatherManager.updateSnowOrMelt(level, biomeWeather, random, size, biomeWeather.shouldRain());
        } else {
            WeatherManager.updateSnowOrMelt(level, biomeWeather, random, size, level.m_46471_());
        }
    }

    protected static void updateSnowOrMelt(ServerLevel level, BiomeWeather biomeWeather, RandomSource randomSource, int size, boolean rain) {
        if (rain) {
            biomeWeather.lastRainTime = level.m_46467_();
        }
        if (biomeWeather.shouldRain() || randomSource.m_188503_(5) > 1) {
            SnowRenderStatus snow = WeatherManager.getSnowStatus(level, (Biome)biomeWeather.biomeHolder.m_203334_(), BlockPos.f_121853_, rain);
            if (snow == SnowRenderStatus.SNOW) {
                biomeWeather.snowDepth = (byte)Math.min(100, biomeWeather.snowDepth + 1);
            } else if (snow == SnowRenderStatus.SNOW_MELT) {
                biomeWeather.snowDepth = (byte)Math.max(0, biomeWeather.snowDepth - 1);
            }
        }
    }

    public static BiomeRain getBiomeRain(ServerLevel level, SolarTerm solarTerm, Holder<Biome> biomeWeather) {
        return WeatherManager.getBiomeRain(solarTerm, biomeWeather).resolve((Level)level);
    }

    public static BiomeRain getBiomeRain(SolarTerm solarTerm, Holder<Biome> biomeWeather) {
        return solarTerm.getBiomeRain(biomeWeather);
    }

    public static void initNewWorldWeather(ServerLevel level, RandomSource random, SolarTerm solarTerm) {
        if (!((Boolean)CommonConfig.Weather.shouldInitWeather.get()).booleanValue() || level.m_5776_() || !MapChecker.isValidDimension((Level)level)) {
            return;
        }
        ArrayList<BiomeWeather> biomeList = WeatherManager.getBiomeList((Level)level);
        if (biomeList == null) {
            return;
        }
        int size = WeatherManager.getWeatherTickFactor((Level)level);
        SolarTerm lastSolarTerm = solarTerm == SolarTerm.NONE ? SolarTerm.NONE : SolarTerm.collectValues()[(solarTerm.ordinal() - 1 + 24) % 24];
        boolean weatherLocal = EclipticUtil.hasLocalWeather((Level)level);
        for (BiomeWeather biomeWeather : biomeList) {
            SnowRenderStatus snow;
            if (!((Biome)biomeWeather.biomeHolder.m_203334_()).m_264473_()) continue;
            if (weatherLocal) {
                float weight;
                float ramdomKey = (float)level.m_213780_().m_188503_(1000) / 1000.0f * 3.0f;
                BiomeRain biomeRain = WeatherManager.getBiomeRain(solarTerm, biomeWeather.biomeHolder);
                float downfall = EclipticUtil.getDownfallFloatConstant(solarTerm, (Biome)biomeWeather.biomeHolder.m_203334_(), !level.m_5776_());
                if (biomeWeather.biomeHolder.m_203656_(BiomeTags.f_215816_)) {
                    downfall += 0.2f;
                }
                if (ramdomKey < (weight = biomeRain.getRainChance() * Math.max(0.01f, downfall) * ((float)((Integer)CommonConfig.Weather.rainChanceMultiplier.get()).intValue() * 1.0f / 100.0f))) {
                    biomeWeather.rainTime = biomeRain.getRainDuration(random) / size;
                } else {
                    biomeWeather.clearTime = biomeRain.getRainDelay(random) / size;
                }
                if (biomeWeather.shouldRain() && ramdomKey / 1000.0f < (weight = biomeRain.getThunderChance() * ((float)((Integer)CommonConfig.Weather.thunderChanceMultiplier.get()).intValue() * 1.0f / 100.0f))) {
                    biomeWeather.thunderTime = biomeRain.getThunderDuration(random) / size;
                }
            }
            ISnowTerm snowTerm = SolarTerm.getSnowTerm((Biome)biomeWeather.biomeHolder.m_203334_(), !level.m_5776_(), EclipticUtil.getSnowTempChange((Level)level));
            boolean flag_cold = snowTerm.maySnow(solarTerm);
            boolean flag_little_cold = snowTerm.maySnow(lastSolarTerm);
            SnowRenderStatus snowRenderStatus = flag_cold ? SnowRenderStatus.SNOW : (snow = flag_little_cold ? SnowRenderStatus.SNOW_MELT : SnowRenderStatus.NONE);
            if (snow == SnowRenderStatus.SNOW) {
                biomeWeather.snowDepth = (byte)100;
                continue;
            }
            if (snow == SnowRenderStatus.SNOW_MELT) {
                biomeWeather.snowDepth = (byte)random.m_188503_(50);
                continue;
            }
            biomeWeather.snowDepth = 0;
        }
    }

    public static void updateAfterSleep(ServerLevel level, long newTime, long oldDayTime) {
        ArrayList<BiomeWeather> ws;
        if (newTime > oldDayTime && (ws = WeatherManager.getBiomeList((Level)level)) != null) {
            RandomSource random = level.m_213780_();
            int size = WeatherManager.getWeatherTickFactor((Level)level);
            for (BiomeWeather biomeWeather : ws) {
                int i = 0;
                while ((long)i < (newTime - oldDayTime) / (long)size) {
                    WeatherManager.runWeather(level, biomeWeather, random, size);
                    ++i;
                }
            }
            if (((Boolean)CommonConfig.Weather.clearAfterSleep.get()).booleanValue()) {
                SolarTerm solarTerm = EclipticUtil.getNowSolarTerm((Level)level);
                for (BiomeWeather biomeWeather : ws) {
                    if (!biomeWeather.shouldRain()) continue;
                    biomeWeather.thunderTime = 0;
                    biomeWeather.rainTime = 0;
                    BiomeRain biomeRain = WeatherManager.getBiomeRain(level, solarTerm, biomeWeather.biomeHolder);
                    biomeWeather.clearTime = biomeRain.getRainDelay(random) / size;
                }
            }
            if (!level.m_6907_().isEmpty()) {
                WeatherManager.sendBiomePacket(ws, level.m_6907_());
            }
            SnowyMapChecker.updateAllChunks(level);
        }
        SimpleNetworkHandler.send(new ArrayList<ServerPlayer>(level.m_6907_()), new EmptyMessage());
    }

    public static void onLoggedIn(ServerPlayer serverPlayer, boolean isLogged) {
        if (serverPlayer instanceof FakePlayer) {
            return;
        }
        SolarHolders.getSaveDataLazy(serverPlayer.m_9236_()).ifPresent(t -> {
            SolarTerm solarTerm;
            SimpleNetworkHandler.send(serverPlayer, new SolarTermsMessage(t.getSolarTermsDay()));
            if (isLogged && ((Boolean)CommonConfig.Season.enableInform.get()).booleanValue() && MapChecker.isValidDimension(serverPlayer.m_9236_()) && t.getSolarTermsDay() % (Integer)CommonConfig.Season.lastingDaysOfEachTerm.get() == 0 && (solarTerm = t.getSolarTerm()) != SolarTerm.NONE) {
                SimpleUtil.sendSolarTermMessage(serverPlayer, solarTerm, isLogged);
            }
            SimpleNetworkHandler.send(serverPlayer, new UpdateTempChangeMessage(t.getSolarTempChange()));
        });
        WeatherManager.sendBiomePacket(WeatherManager.getBiomeList(serverPlayer.m_9236_()), List.of(serverPlayer));
    }

    public static void tickPlayerForSeasonCheck(ServerPlayer serverPlayer, SolarTerm st) {
        LazyOptional holder = serverPlayer.getCapability(SolarTermsRecord.SOLAR_TERMS_RECORD_CA_CAPABILITY);
        holder.ifPresent(solarTermsRecordCa -> {
            if (!solarTermsRecordCa.addAndCheck(st)) {
                ModAdvancements.solarTermsCriterion.trigger(serverPlayer);
            }
        });
    }

    public static int getSkyDarken(Level level, BlockPos pos, int amount) {
        BiomeWeather biomeWeather = WeatherManager.getBiomeWeather(level, MapChecker.getSurfaceBiome(level, pos));
        return Mth.m_14045_((int)(amount += biomeWeather == null || biomeWeather.shouldClear() ? 0 : (biomeWeather.shouldThunder() ? 8 : 4)), (int)0, (int)15);
    }

    public static boolean onCheckWarmEnoughToRain(BlockPos p198905) {
        return true;
    }

    public static boolean onShouldSnow(ServerLevel level, Biome biome, BlockPos pos) {
        return true;
    }

    public static boolean agentAdvanceWeatherCycle(ServerLevel level, RandomSource random) {
        int pos = NEXT_CHECK_BIOME_MAP.getOrDefault(level, -1);
        ArrayList<BiomeWeather> levelBiomeWeather = WeatherManager.getBiomeList((Level)level);
        if (pos >= 0 && levelBiomeWeather != null && pos < levelBiomeWeather.size()) {
            int size = WeatherManager.getWeatherTickFactor((Level)level);
            BiomeWeather biomeWeather = WeatherManager.getBiomeList((Level)level).get(pos);
            WeatherManager.runWeather(level, biomeWeather, random, size);
            ++pos;
        } else {
            pos = 0;
        }
        if (levelBiomeWeather != null && level.m_46467_() % 100L == 0L && !level.m_6907_().isEmpty()) {
            WeatherManager.sendBiomePacket(levelBiomeWeather, level.m_6907_());
        }
        NEXT_CHECK_BIOME_MAP.put((Level)level, pos);
        return true;
    }

    public static void sendBiomePacket(ArrayList<BiomeWeather> levelBiomeWeather, List<ServerPlayer> players) {
        if (players.isEmpty()) {
            return;
        }
        byte[] rains = new byte[levelBiomeWeather.size()];
        byte[] thunders = new byte[levelBiomeWeather.size()];
        byte[] clears = new byte[levelBiomeWeather.size()];
        byte[] snows = new byte[levelBiomeWeather.size()];
        for (BiomeWeather biomeWeather : levelBiomeWeather) {
            int index = biomeWeather.id;
            rains[index] = (byte)(biomeWeather.shouldRain() ? 1 : 0);
            thunders[index] = (byte)(biomeWeather.shouldThunder() ? 1 : 0);
            clears[index] = (byte)(biomeWeather.shouldClear() ? 1 : 0);
            snows[index] = biomeWeather.snowDepth;
        }
        BiomeWeatherMessage msg = new BiomeWeatherMessage(rains, thunders, clears, snows);
        SimpleNetworkHandler.send(players, msg);
    }

    @Deprecated(forRemoval=true, since="0.12.0.1")
    public static SnowRenderStatus getSnowStatus(ServerLevel level, Biome biome, BlockPos pos) {
        return WeatherManager.getSnowStatus(level, biome, pos, WeatherManager.isRainingOrSnowAtBiome((Level)level, biome));
    }

    public static SnowRenderStatus getSnowStatus(ServerLevel level, Biome biome, BlockPos pos, boolean rain) {
        SnowRenderStatus status = SnowRenderStatus.NONE;
        if (biome.m_264473_()) {
            Biome.Precipitation precipitation = WeatherManager.getPrecipitationAt((Level)level, biome, pos);
            if (precipitation == Biome.Precipitation.SNOW) {
                if (rain) {
                    status = SnowRenderStatus.SNOW;
                }
            } else {
                status = level.m_213780_().m_188499_() | (rain && precipitation == Biome.Precipitation.RAIN) ? SnowRenderStatus.SNOW_MELT : SnowRenderStatus.NONE;
            }
        }
        return status;
    }

    public static boolean testWeatherCheck(LootContext pContext, WeatherCheck weatherCheck) {
        Vec3 pos;
        boolean needThunder = weatherCheck.isThundering().isPresent();
        boolean needRain = weatherCheck.isRaining().isPresent();
        if (needThunder && (pos = (Vec3)pContext.m_78953_(LootContextParams.f_81460_)) != null) {
            boolean isThunderAt = WeatherManager.isThunderAt((Level)pContext.m_78952_(), new BlockPos((int)pos.f_82479_, (int)pos.f_82480_ + 1, (int)pos.f_82481_));
            if (weatherCheck.isThundering().get() != isThunderAt) {
                return false;
            }
        }
        if (needRain && (pos = (Vec3)pContext.m_78953_(LootContextParams.f_81460_)) != null) {
            boolean isRainingAt = pContext.m_78952_().m_46758_(new BlockPos((int)pos.f_82479_, (int)pos.f_82480_ + 1, (int)pos.f_82481_));
            if (weatherCheck.isRaining().get() != isRainingAt) {
                return false;
            }
        }
        return true;
    }

    public static class BiomeWeather
    implements INBTSerializable<CompoundTag> {
        public Holder<Biome> biomeHolder;
        public int id;
        public SnowTerm snowTerm;
        public ResourceLocation location;
        public int rainTime = 0;
        public long lastRainTime = 0L;
        public int thunderTime = 0;
        public int clearTime = 0;
        public byte snowDepth = 0;

        public BiomeWeather(Holder<Biome> biomeHolder) {
            this.biomeHolder = biomeHolder;
        }

        public boolean shouldRain() {
            return this.rainTime > 0;
        }

        public boolean shouldThunder() {
            return this.thunderTime > 0;
        }

        public boolean shouldClear() {
            return this.clearTime > 0;
        }

        public String toString() {
            return this.serializeNBT().toString();
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("biome", this.location.toString());
            tag.m_128405_("rainTime", this.rainTime);
            tag.m_128356_("lastRainTime", this.lastRainTime);
            tag.m_128405_("thunderTime", this.thunderTime);
            tag.m_128405_("clearTime", this.clearTime);
            tag.m_128344_("snowDepth", this.snowDepth);
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.location = new ResourceLocation(nbt.m_128461_("biome"));
            this.rainTime = nbt.m_128451_("rainTime");
            this.lastRainTime = nbt.m_128454_("lastRainTime");
            this.thunderTime = nbt.m_128451_("thunderTime");
            this.clearTime = nbt.m_128451_("clearTime");
            this.snowDepth = nbt.m_128445_("snowDepth");
        }
    }

    @FunctionalInterface
    public static interface BiomeWeatherPredicate {
        public boolean test(BiomeWeather var1);
    }

    public static enum SnowRenderStatus {
        SNOW,
        SNOW_MELT,
        NONE;

    }

    public record WeatherCheck(Optional<Boolean> isRaining, Optional<Boolean> isThundering) {
    }
}

