/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.crop.internal;

import com.teamtea.eclipticseasons.api.constant.crop.CropHumidityType;
import com.teamtea.eclipticseasons.api.constant.crop.CropSeasonInfo;
import com.teamtea.eclipticseasons.api.constant.crop.CropSeasonType;
import com.teamtea.eclipticseasons.common.core.crop.CropInfoManager;
import com.teamtea.eclipticseasons.compat.CompatModule;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.SaplingBlock;

public class CompatCropHookInternal {
    private static final TagKey<Block> ss1 = CropInfoManager.createBlockTag("sereneseasons", "spring_crops");
    private static final TagKey<Block> ss2 = CropInfoManager.createBlockTag("sereneseasons", "summer_crops");
    private static final TagKey<Block> ss3 = CropInfoManager.createBlockTag("sereneseasons", "autumn_crops");
    private static final TagKey<Block> ss4 = CropInfoManager.createBlockTag("sereneseasons", "winter_crops");
    private static final TagKey<Item> ssi1 = CropInfoManager.createItemTag("sereneseasons", "spring_crops");
    private static final TagKey<Item> ssi2 = CropInfoManager.createItemTag("sereneseasons", "summer_crops");
    private static final TagKey<Item> ssi3 = CropInfoManager.createItemTag("sereneseasons", "autumn_crops");
    private static final TagKey<Item> ssi4 = CropInfoManager.createItemTag("sereneseasons", "winter_crops");
    private static final List<Integer> seasonInfoList = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(8));
    private static final List<TagKey<Block>> ss_blockList = List.of(ss1, ss2, ss3, ss4);
    private static final List<TagKey<Item>> ss_itemList = List.of(ssi1, ssi2, ssi3, ssi4);
    private static final Map<CropSeasonType, CropHumidityType> SEASON_HUMIDITY_MAP = Map.ofEntries(Map.entry(CropSeasonType.SPRING, CropHumidityType.MOIST_HUMID), Map.entry(CropSeasonType.SUMMER, CropHumidityType.DRY_AVERAGE), Map.entry(CropSeasonType.AUTUMN, CropHumidityType.AVERAGE_MOIST), Map.entry(CropSeasonType.WINTER, CropHumidityType.ARID_DRY), Map.entry(CropSeasonType.SP_SU, CropHumidityType.AVERAGE_MOIST), Map.entry(CropSeasonType.SP_AU, CropHumidityType.AVERAGE_MOIST), Map.entry(CropSeasonType.SP_WI, CropHumidityType.DRY_MOIST), Map.entry(CropSeasonType.SU_AU, CropHumidityType.DRY_MOIST), Map.entry(CropSeasonType.SU_WI, CropHumidityType.ARID_DRY), Map.entry(CropSeasonType.AU_WI, CropHumidityType.DRY_AVERAGE), Map.entry(CropSeasonType.SP_SU_AU, CropHumidityType.AVERAGE_MOIST), Map.entry(CropSeasonType.SP_SU_WI, CropHumidityType.AVERAGE_MOIST), Map.entry(CropSeasonType.SP_AU_WI, CropHumidityType.DRY_MOIST), Map.entry(CropSeasonType.SU_AU_WI, CropHumidityType.DRY_MOIST), Map.entry(CropSeasonType.ALL, CropHumidityType.ARID_HUMID));
    public static Map<TagKey<Item>, CropHumidityType> TAG_HUMIDITY_MAP;
    private static final TagKey<Block> SERENE_SEASONS_UNBREAKABLE_FERTILE_CROPS;
    private static final TagKey<Block> SERENE_SEASONS_YEAR_ROUND_CROPS;
    private static final TagKey<Item> ITEM_SERENE_SEASONS_YEAR_ROUND_CROPS;

    public static Map<Item, CropHumidityType> getBultinHumidityTypeMap(Registry<Item> registry) {
        return registry.m_203612_().flatMap(p -> {
            CropHumidityType orDefault = TAG_HUMIDITY_MAP.getOrDefault(p.getFirst(), null);
            if (orDefault == null) {
                return Stream.of(new Map.Entry[0]);
            }
            return ((HolderSet.Named)p.getSecond()).m_203614_().map(h -> Map.entry((Item)h.m_203334_(), orDefault));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, HashMap::new));
    }

    public static CropHumidityType mapSeasonToHumidity(CropSeasonType seasonType) {
        if (SEASON_HUMIDITY_MAP.containsKey((Object)seasonType)) {
            return SEASON_HUMIDITY_MAP.get((Object)seasonType);
        }
        return CropHumidityType.AVERAGE;
    }

    public static <T> void registerForSS(Optional<Registry<T>> tRegistry, ResourceKey<Registry<T>> registryResourceKey) {
        Set blackMods = Set.copyOf((Collection)CompatModule.CommonConfig.modsWithoutSereneSeasonBasedHumidity.get());
        tRegistry.ifPresent(registry -> {
            ArrayList nameBlockList = new ArrayList();
            List<TagKey<Block>> useTag = registryResourceKey.equals((Object)Registries.f_256747_) ? ss_blockList : ss_itemList;
            for (TagKey<Block> blockTagKey : useTag) {
                Optional tag = Optional.empty();
                tag = registry.m_203431_(blockTagKey);
                tag.ifPresent(holders -> nameBlockList.add(holders.m_203614_().map(Holder::m_203334_).toList()));
            }
            ArrayList nameBlockSet = new ArrayList(new HashSet(nameBlockList.stream().flatMap(Collection::stream).toList()));
            Map<Object, Object> bultinHumidityTypeMap = Map.of();
            if (registry.m_123023_().equals((Object)Registries.f_256913_)) {
                bultinHumidityTypeMap = CompatCropHookInternal.getBultinHumidityTypeMap((Registry<Item>)registry);
            }
            for (Object t : nameBlockSet) {
                CropHumidityType humid;
                ResourceLocation key;
                int season = 0;
                for (int i = 0; i < nameBlockList.size(); ++i) {
                    if (!((List)nameBlockList.get(i)).contains(t)) continue;
                    season += seasonInfoList.get(i).intValue();
                }
                CropSeasonType cropSeasonTypeFrom = CropInfoManager.getCropSeasonTypeFrom(new CropSeasonInfo(season));
                boolean isWaterPlant = false;
                if (t instanceof Block) {
                    Block block = (Block)t;
                    if (block instanceof SaplingBlock && ((Boolean)CompatModule.CommonConfig.sereneSeasonsIgnoreSapling.get()).booleanValue()) continue;
                    CropInfoManager.registerCropSeasonInfo(block, cropSeasonTypeFrom, true);
                    isWaterPlant = block instanceof LiquidBlockContainer;
                } else if (t instanceof Item) {
                    BlockItem blockItem;
                    Item item = (Item)t;
                    if (item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof SaplingBlock && ((Boolean)CompatModule.CommonConfig.sereneSeasonsIgnoreSapling.get()).booleanValue()) continue;
                    CropInfoManager.registerCropSeasonInfo(item, cropSeasonTypeFrom);
                    boolean bl = isWaterPlant = item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof LiquidBlockContainer;
                }
                if (!((Boolean)CompatModule.CommonConfig.sereneSeasonBasedHumidity.get()).booleanValue() || (key = registry.m_7981_(t)) == null || blackMods.contains(key.m_135827_())) continue;
                CropHumidityType cropHumidityType = humid = isWaterPlant ? CropHumidityType.MOIST_HUMID : CompatCropHookInternal.mapSeasonToHumidity(cropSeasonTypeFrom);
                if (t instanceof Block) {
                    Block block = (Block)t;
                    CropInfoManager.registerCropHumidityInfo(block, humid, true);
                    continue;
                }
                if (!(t instanceof Item)) continue;
                Item item = (Item)t;
                humid = bultinHumidityTypeMap.getOrDefault(item, (Object)humid);
                CropInfoManager.registerCropHumidityInfo(item, humid);
            }
        });
    }

    public static void registerForSSALL(Optional<Registry<Item>> items, Optional<Registry<Block>> blocks) {
        blocks.flatMap(br -> br.m_203431_(SERENE_SEASONS_YEAR_ROUND_CROPS)).ifPresent(nblocks -> {
            for (Holder nblock : nblocks) {
                CropInfoManager.registerCropSeasonInfo((Block)nblock.m_203334_(), CropSeasonType.ALL, true);
                if (!((Boolean)CommonConfig.Crop.registerCropDefaultValue.get()).booleanValue()) continue;
                CropInfoManager.registerCropHumidityInfo((Block)nblock.m_203334_(), CropHumidityType.AVERAGE_MOIST, true);
            }
        });
        items.flatMap(br -> br.m_203431_(ITEM_SERENE_SEASONS_YEAR_ROUND_CROPS)).ifPresent(itemNamed -> {
            for (Holder itemHolder : itemNamed) {
                CropInfoManager.registerCropSeasonInfo((Item)itemHolder.m_203334_(), CropSeasonType.ALL);
                if (!((Boolean)CommonConfig.Crop.registerCropDefaultValue.get()).booleanValue()) continue;
                CropInfoManager.registerCropHumidityInfo((Item)itemHolder.m_203334_(), CropHumidityType.AVERAGE_MOIST);
            }
        });
    }

    static {
        HashMap<TagKey<Item>, CropHumidityType> builder = new HashMap<TagKey<Item>, CropHumidityType>();
        for (String ns : List.of("forge", "c")) {
            builder.put(CropInfoManager.createItemTag(ns, "seeds/agave"), CropHumidityType.ARID_DRY);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/amaranth"), CropHumidityType.DRY_AVERAGE);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/arrowroot"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/artichoke"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/asparagus"), CropHumidityType.DRY_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/barley"), CropHumidityType.DRY_AVERAGE);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/basil"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/bean"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/beans"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/bellpepper"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/blackbean"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/blackberry"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/blueberry"), CropHumidityType.MOIST_HUMID);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/broccoli"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/brusselsprout"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/cabbage"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/cactusfruit"), CropHumidityType.ARID_DRY);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/candleberry"), CropHumidityType.MOIST_HUMID);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/cantaloupe"), CropHumidityType.DRY_AVERAGE);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/cassava"), CropHumidityType.MOIST_HUMID);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/cauliflower"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/celery"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/chickpea"), CropHumidityType.DRY_AVERAGE);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/chilipepper"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/cinnamon"), CropHumidityType.MOIST_HUMID);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/coffee_beans"), CropHumidityType.MOIST_HUMID);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/coffeebean"), CropHumidityType.MOIST_HUMID);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/corn"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/cotton"), CropHumidityType.DRY_AVERAGE);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/cranberry"), CropHumidityType.MOIST_HUMID);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/cucumber"), CropHumidityType.MOIST_HUMID);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/currant"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/eggplant"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/elderberry"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/flax"), CropHumidityType.DRY_AVERAGE);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/garlic"), CropHumidityType.DRY_AVERAGE);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/ginger"), CropHumidityType.MOIST_HUMID);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/grape"), CropHumidityType.DRY_AVERAGE);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/greengrape"), CropHumidityType.DRY_AVERAGE);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/hops"), CropHumidityType.MOIST_HUMID);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/honeydew"), CropHumidityType.DRY_AVERAGE);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/huckleberry"), CropHumidityType.MOIST_HUMID);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/jicama"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/juniperberry"), CropHumidityType.DRY_AVERAGE);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/jute"), CropHumidityType.MOIST_HUMID);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/kale"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/kenaf"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/kiwi"), CropHumidityType.MOIST_HUMID);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/kohlrabi"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/leek"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/lentil"), CropHumidityType.DRY_AVERAGE);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/lettuce"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/millet"), CropHumidityType.DRY_AVERAGE);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/mustardseeds"), CropHumidityType.DRY_AVERAGE);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/mulberry"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/oat"), CropHumidityType.DRY_AVERAGE);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/okra"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/olive"), CropHumidityType.DRY_AVERAGE);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/onion"), CropHumidityType.DRY_AVERAGE);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/parsnip"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/pea"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/peanut"), CropHumidityType.DRY_AVERAGE);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/pepper"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/pineapple"), CropHumidityType.MOIST_HUMID);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/quinoa"), CropHumidityType.DRY_AVERAGE);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/radish"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/raspberry"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/rhubarb"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/rice"), CropHumidityType.MOIST_HUMID);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/rutabaga"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/rye"), CropHumidityType.DRY_AVERAGE);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/saguaro"), CropHumidityType.ARID_DRY);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/sesameseeds"), CropHumidityType.DRY_AVERAGE);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/sisal"), CropHumidityType.DRY_AVERAGE);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/sorghum"), CropHumidityType.DRY);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/soybean"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/spiceleaf"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/spinach"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/strawberry"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/sweet_potato"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/taro"), CropHumidityType.MOIST_HUMID);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/tea"), CropHumidityType.MOIST_HUMID);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/tea_leaves"), CropHumidityType.MOIST_HUMID);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/tealeaf"), CropHumidityType.MOIST_HUMID);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/tomatillo"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/tomato"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/turmeric"), CropHumidityType.MOIST_HUMID);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/turnip"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/vanilla"), CropHumidityType.MOIST_HUMID);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/waterchestnut"), CropHumidityType.MOIST_HUMID);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/whitemushroom"), CropHumidityType.MOIST_HUMID);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/wintersquash"), CropHumidityType.AVERAGE_MOIST);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/yam"), CropHumidityType.MOIST_HUMID);
            builder.put(CropInfoManager.createItemTag(ns, "seeds/zucchini"), CropHumidityType.AVERAGE_MOIST);
        }
        TAG_HUMIDITY_MAP = builder;
        SERENE_SEASONS_UNBREAKABLE_FERTILE_CROPS = CropInfoManager.createBlockTag("sereneseasons", "unbreakable_infertile_crops");
        SERENE_SEASONS_YEAR_ROUND_CROPS = CropInfoManager.createBlockTag("sereneseasons", "year_round_crops");
        ITEM_SERENE_SEASONS_YEAR_ROUND_CROPS = CropInfoManager.createItemTag("sereneseasons", "year_round_crops");
    }
}

