/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.map;

import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.tag.EclipticBlockTags;
import com.teamtea.eclipticseasons.api.data.season.SnowDefinition;
import com.teamtea.eclipticseasons.api.misc.IBiomeTagHolder;
import com.teamtea.eclipticseasons.api.misc.IBlockStateFlagger;
import com.teamtea.eclipticseasons.api.misc.IChunkBiomeHolder;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.biome.BiomeClimateManager;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.core.map.BiomeHolder;
import com.teamtea.eclipticseasons.common.core.map.ChunkInfoMap;
import com.teamtea.eclipticseasons.common.core.map.SnowyRemover;
import com.teamtea.eclipticseasons.common.core.snow.SnowChecker;
import com.teamtea.eclipticseasons.common.core.snow.SnowyMapChecker;
import com.teamtea.eclipticseasons.common.core.solar.SolarDataManager;
import com.teamtea.eclipticseasons.common.misc.SimplePair;
import com.teamtea.eclipticseasons.common.network.SimpleNetworkHandler;
import com.teamtea.eclipticseasons.common.network.message.ChunkBiomeUpdateMessage;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.AzaleaBlock;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DirtPathBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;

public class MapChecker {
    public static final int ChunkSize = 512;
    public static final int ChunkSizeLoc = 511;
    public static final int ChunkSizeAxis = 9;
    public static final List<Level> validDimension = new ArrayList<Level>();
    public static final Map<Level, List<ChunkInfoMap>> REGION_LIST_COLLECTOR = new IdentityHashMap<Level, List<ChunkInfoMap>>();
    public static List<ChunkInfoMap> CLIENT_REGION_LIST = new ArrayList<ChunkInfoMap>();
    public static final int FLAG_IGNORE = -1;
    public static final int FLAG_NONE = 0;
    public static final int FLAG_BLOCK = 1;
    public static final int FLAG_SLAB = 2;
    public static final int FLAG_STAIRS = 3;
    public static final int FLAG_STAIRS_TOP = 301;
    public static final int FLAG_LEAVES = 4;
    public static final int FLAG_GRASS = 5;
    public static final int FLAG_GRASS_LARGE = 501;
    public static final int FLAG_FARMLAND = 6;
    public static final int FLAG_VINE = 7;
    public static final int FLAG_CUSTOM = 999;
    public static final int FLAG_CUSTOM_AO = 998;
    public static final int FLAG_CUSTOM_JSON = 1000;
    public static final int FLAG_CUSTOM_JSON_PLANTS = 1001;
    public static final int FLAG_CUSTOM_JSON_WITH_TOP = 1100;
    public static final int FLAG_CUSTOM_JSON_WITH_TOP_LEAVES = 1101;
    public static final int FLAG_CUSTOM_JSON_VINE_LIKE = 1200;
    public static final SimplePair<Direction, Direction>[] SMALL_OFFSET_DIRECTIONS = new SimplePair[]{SimplePair.of(Direction.NORTH, null), SimplePair.of(Direction.NORTH, Direction.EAST), SimplePair.of(Direction.EAST, null), SimplePair.of(Direction.EAST, Direction.SOUTH), SimplePair.of(Direction.SOUTH, null), SimplePair.of(Direction.SOUTH, Direction.WEST), SimplePair.of(Direction.WEST, null), SimplePair.of(Direction.WEST, Direction.NORTH)};
    public static final Map<Level, Climate.ParameterList<Holder<Biome>>> LEVEL_PARAMETER_LIST_MAP = new IdentityHashMap<Level, Climate.ParameterList<Holder<Biome>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unloadLevel(Level level) {
        List<ChunkInfoMap> orDefault;
        List<ChunkInfoMap> list = orDefault = MapChecker.getMapsListOrCreate(level);
        synchronized (list) {
            orDefault.clear();
        }
        REGION_LIST_COLLECTOR.remove(level);
        validDimension.removeIf(level1 -> level1 == level);
        LEVEL_PARAMETER_LIST_MAP.remove(level);
    }

    public static boolean unloadChunk(Level level, ChunkPos chunkPos) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tickLevel(Level level) {
        List<ChunkInfoMap> mapsList = MapChecker.getMapsListOrCreate(level);
        if (level.m_5776_()) {
            CLIENT_REGION_LIST = mapsList;
        }
        if (((Boolean)CommonConfig.Debug.disableChunkCacheCleaner.get()).booleanValue()) {
            return;
        }
        List chunkInfoMaps = null;
        if (mapsList != null && level.m_213780_().m_188503_(100) == 0) {
            for (int zz = 0; zz < mapsList.size(); ++zz) {
                boolean shouldRemove = true;
                ChunkInfoMap map = mapsList.get(zz);
                if (map != null) {
                    int x0 = MapChecker.regionCoordToChunkStart(map.getX());
                    int z0 = MapChecker.regionCoordToChunkStart(map.getZ());
                    int mapChunkSize = MapChecker.mapChunkSize();
                    block4: for (int i = 0; i < mapChunkSize; ++i) {
                        for (int j = 0; j < mapChunkSize; ++j) {
                            ServerLevel serverLevel;
                            if ((!(level instanceof ServerLevel) || (serverLevel = (ServerLevel)level).m_7726_().m_5563_(i + x0, j + z0)) && (!level.m_5776_() || !MapChecker.isLoaded(level, i + x0, j + z0))) continue;
                            shouldRemove = false;
                            break block4;
                        }
                    }
                }
                if (!shouldRemove) continue;
                chunkInfoMaps = chunkInfoMaps == null ? new ArrayList() : chunkInfoMaps;
                chunkInfoMaps.add(map);
            }
            if (chunkInfoMaps != null) {
                for (ChunkInfoMap chunkInfoMap : chunkInfoMaps) {
                    EclipticSeasons.extraLogger(true, String.format("Remove the empty Height Map [%s, %s]", chunkInfoMap.getX(), chunkInfoMap.getZ()));
                }
                List<ChunkInfoMap> list = mapsList;
                synchronized (list) {
                    mapsList.removeAll(chunkInfoMaps);
                }
            }
        }
    }

    public static int blockToRegionCoord(int i) {
        return i >> 9;
    }

    public static int chunkToRegionCoord(int chunkI) {
        return chunkI >> 5;
    }

    public static int regionCoordToChunkStart(int i) {
        return SectionPos.m_123171_((int)(i << 9));
    }

    public static int mapChunkSize() {
        return 32;
    }

    public static List<ChunkInfoMap> getMapsListOrCreate(Level level) {
        return REGION_LIST_COLLECTOR.computeIfAbsent(level, level1 -> new ArrayList());
    }

    public static List<ChunkInfoMap> getMapsList(Level level) {
        return level.f_46443_ ? (CLIENT_REGION_LIST == null ? new ArrayList() : CLIENT_REGION_LIST) : MapChecker.getMapsListOrCreate(level);
    }

    public static ChunkInfoMap getChunkMap(Level level, BlockPos pos) {
        int x = MapChecker.blockToRegionCoord(pos.m_123341_());
        int z = MapChecker.blockToRegionCoord(pos.m_123343_());
        return MapChecker.getChunkMap(level, x, z);
    }

    public static ChunkInfoMap getChunkMap(Level level, int regionX, int regionZ) {
        return MapChecker.getChunkMap(MapChecker.getMapsList(level), regionX, regionZ);
    }

    public static ChunkInfoMap getChunkMap(List<ChunkInfoMap> orDefault, int regionX, int regionZ) {
        ChunkInfoMap map = null;
        for (int i = 0; i < orDefault.size(); ++i) {
            ChunkInfoMap chunkHeightMap = orDefault.get(i);
            if (chunkHeightMap == null || chunkHeightMap.x != regionX || chunkHeightMap.z != regionZ) continue;
            map = chunkHeightMap;
            break;
        }
        return map;
    }

    @Nullable
    public static ChunkAccess getChunkView(Level level, BlockPos pos) {
        return level.m_6522_(SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_()), ChunkStatus.f_62319_, false);
    }

    public static int getVanillaSolidHeightOrSelf(Level level, BlockPos pos) {
        ChunkAccess biomeChunk = MapChecker.getChunkView(level, pos);
        return biomeChunk != null ? biomeChunk.m_5885_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_()) + 1 : pos.m_123342_();
    }

    public static int getMCHeightWithCheck(Level level, BlockPos pos) {
        return MapChecker.getMCHeightWithCheck(level, pos, null);
    }

    public static int getMCHeightWithCheck(Level level, BlockPos pos, @Nullable Integer oldY) {
        ChunkAccess chunkAt = MapChecker.getChunkView(level, pos);
        return chunkAt == null ? pos.m_123342_() : MapChecker.getMCHeightWithCheck(level, pos, chunkAt, null, null, oldY);
    }

    public static int getMCHeightWithCheck(Level level, BlockPos pos, @Nonnull ChunkAccess chunkAt, @Nullable SnowyRemover snowyRemover, @Nullable BlockPos.MutableBlockPos checkPos, @Nullable Integer oldHeight) {
        BlockState state;
        if (oldHeight != null && oldHeight <= level.m_151558_() && oldHeight >= level.m_141937_() && pos.m_123342_() <= oldHeight - 2) {
            return oldHeight;
        }
        if (snowyRemover != null && snowyRemover.notSnowyAt(pos)) {
            return level.m_151558_() + 1;
        }
        int posX = pos.m_123341_();
        int posZ = pos.m_123343_();
        Heightmap.Types typesUse = level.f_46443_ || (Boolean)CommonConfig.Snow.snowyTree.get() == false ? Heightmap.Types.MOTION_BLOCKING : Heightmap.Types.MOTION_BLOCKING_NO_LEAVES;
        int height = chunkAt.m_5885_(typesUse, posX, posZ);
        if (checkPos == null) {
            checkPos = new BlockPos.MutableBlockPos(posX, height, posZ);
        } else {
            checkPos.m_142448_(height);
        }
        while (height >= chunkAt.m_141937_() && !MapChecker.solidTest(state = chunkAt.m_8055_((BlockPos)checkPos))) {
            checkPos.m_142448_(--height);
        }
        if (height < chunkAt.m_141937_()) {
            height = chunkAt.m_141937_();
        }
        return height;
    }

    public static boolean solidTest(BlockState state) {
        return Heightmap.Types.MOTION_BLOCKING.m_64299_().test(state) && !MapChecker.extraSnowPassable(state);
    }

    public static boolean extraSnowPassable(BlockState state) {
        SnowDefinition.Info snow = SnowChecker.getUncacheSnow(state);
        if (snow != SnowDefinition.Info.EMPTY) {
            return snow.isSnowPassable() || snow.getFlag() == 1101;
        }
        Block onBlock = state.m_60734_();
        return onBlock instanceof LeavesBlock && (Boolean)CommonConfig.Snow.snowyTree.get() != false || onBlock instanceof TrapDoorBlock || onBlock instanceof DoorBlock || onBlock instanceof FenceBlock || onBlock instanceof FenceGateBlock || onBlock instanceof WallBlock || onBlock instanceof BellBlock || onBlock instanceof ComposterBlock || onBlock instanceof CampfireBlock || onBlock instanceof AnvilBlock || onBlock instanceof BasePressurePlateBlock || onBlock instanceof IronBarsBlock || onBlock instanceof LightningRodBlock || onBlock instanceof LecternBlock || onBlock instanceof BambooStalkBlock;
    }

    public static int getHeightSafe(@NotNull Level level, BlockPos pos) {
        ChunkInfoMap chunkMap = MapChecker.getChunkMap(level, pos);
        if (chunkMap != null) {
            return chunkMap.getHeight(pos);
        }
        return level.m_141937_() - 1;
    }

    public static int getHeight(Level levelNull, BlockPos pos) {
        return MapChecker.getHeightOrUpdate(levelNull, pos, false);
    }

    public static int getHeightOrUpdate(Level levelNull, BlockPos pos, boolean forceUpdate) {
        return MapChecker.getSurfaceOrUpdate(levelNull, pos, forceUpdate, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSurfaceOrUpdate(Level level, BlockPos pos, boolean forceUpdate, int type) {
        if (level == null) {
            return 0;
        }
        int x = MapChecker.blockToRegionCoord(pos.m_123341_());
        int z = MapChecker.blockToRegionCoord(pos.m_123343_());
        List<ChunkInfoMap> mapsList = MapChecker.getMapsList(level);
        ChunkInfoMap map = MapChecker.getChunkMap(mapsList, x, z);
        int value = 0;
        if (map != null) {
            if (type == 0) {
                value = map.getHeight(pos);
                if (value <= map.minY || forceUpdate) {
                    int rh = MapChecker.getMCHeightWithCheck(level, pos, value);
                    map.updateHeight(pos, rh);
                    value = rh;
                }
            } else if (type == 1 && ((value = map.getBiome(pos)) == -1 || forceUpdate)) {
                value = MapChecker.biomeToId(level, (Biome)level.m_204166_(pos).m_203334_());
                if (MapChecker.isLoadNearBy(level, pos)) {
                    map.updateBiome(pos, value);
                }
            }
        } else {
            List<ChunkInfoMap> list = mapsList;
            synchronized (list) {
                boolean hasBuild = false;
                for (ChunkInfoMap chunkHeightMap : mapsList) {
                    if (chunkHeightMap.x != x || chunkHeightMap.z != z) continue;
                    hasBuild = true;
                    map = chunkHeightMap;
                    break;
                }
                if (!hasBuild) {
                    map = new ChunkInfoMap(x, z, level.m_141937_() - 1, level.f_46443_);
                    mapsList.add(map);
                }
            }
            if (type == 0) {
                value = MapChecker.getMCHeightWithCheck(level, pos);
                map.updateHeight(pos, value);
            } else if (type == 1) {
                value = MapChecker.biomeToId(level, (Biome)level.m_204166_(pos).m_203334_());
                if (MapChecker.isLoadNearBy(level, pos)) {
                    map.updateBiome(pos, value);
                }
            }
        }
        return value;
    }

    @Nullable
    public static ChunkInfoMap getChunkInfoMapOrCreate(Level level, BlockPos pos) {
        if (level == null) {
            return null;
        }
        int x = MapChecker.blockToRegionCoord(pos.m_123341_());
        int z = MapChecker.blockToRegionCoord(pos.m_123343_());
        return MapChecker.getChunkInfoMapOrCreate(level, x, z);
    }

    @Nullable
    public static ChunkInfoMap getChunkInfoMapOrCreate(Level level, ChunkPos pos) {
        if (level == null) {
            return null;
        }
        int x = MapChecker.chunkToRegionCoord(pos.f_45578_);
        int z = MapChecker.chunkToRegionCoord(pos.f_45579_);
        return MapChecker.getChunkInfoMapOrCreate(level, x, z);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static ChunkInfoMap getChunkInfoMapOrCreate(@NotNull Level level, int regionX, int regionZ) {
        List<ChunkInfoMap> mapsList = MapChecker.getMapsListOrCreate(level);
        ChunkInfoMap map = MapChecker.getChunkMap(mapsList, regionX, regionZ);
        if (map != null) {
            return map;
        }
        List<ChunkInfoMap> list = mapsList;
        synchronized (list) {
            boolean hasBuild = false;
            for (ChunkInfoMap chunkHeightMap : mapsList) {
                if (chunkHeightMap.x != regionX || chunkHeightMap.z != regionZ) continue;
                hasBuild = true;
                map = chunkHeightMap;
                break;
            }
            if (!hasBuild) {
                map = new ChunkInfoMap(regionX, regionZ, level.m_141937_() - 1, level.f_46443_);
                mapsList.add(map);
            }
        }
        return map;
    }

    public static boolean isLoaded(Level level, BlockPos pos) {
        int chunkX = SectionPos.m_123171_((int)pos.m_123341_());
        int chunkZ = SectionPos.m_123171_((int)pos.m_123343_());
        return !level.m_151570_(pos) && MapChecker.isLoaded(level, chunkX, chunkZ);
    }

    public static boolean isLoaded(Level level, int chunkX, int chunkZ) {
        ChunkSource chunkSource = level.m_7726_();
        if (chunkSource instanceof ServerChunkCache) {
            ServerChunkCache serverChunkCache = (ServerChunkCache)chunkSource;
            ChunkHolder visibleChunkIfPresent = serverChunkCache.m_8364_(ChunkPos.m_45589_((int)chunkX, (int)chunkZ));
            if (visibleChunkIfPresent == null) {
                return false;
            }
            return visibleChunkIfPresent.m_212234_() != null;
        }
        return level.m_7726_().m_5563_(chunkX, chunkZ);
    }

    public static boolean isLoadedOnlyServer(Level level, BlockPos pos) {
        return !(level instanceof ServerLevel) || MapChecker.isLoaded(level, pos);
    }

    public static boolean isLoadNearByOnlyServer(Level level, BlockPos pos) {
        return !(level instanceof ServerLevel) || MapChecker.isLoadNearBy(level, pos);
    }

    public static boolean isLoadNearBy(Level level, BlockPos pos) {
        int chunkX = SectionPos.m_123171_((int)pos.m_123341_());
        int chunkZ = SectionPos.m_123171_((int)pos.m_123343_());
        if (level.m_151570_(pos)) {
            return false;
        }
        int i1 = (pos.m_123341_() & 0xF) - 2;
        int l1 = (pos.m_123343_() & 0xF) - 2;
        int xe = i1 >> 2 > 2 ? 1 : 0;
        int ze = l1 >> 2 > 2 ? 1 : 0;
        int xs = i1 < 2 ? -1 : 0;
        int zs = l1 < 2 ? -1 : 0;
        for (int i = xs; i <= xe; ++i) {
            for (int j = zs; j <= ze; ++j) {
                if (MapChecker.isLoaded(level, chunkX + i, chunkZ + j)) continue;
                return false;
            }
        }
        return true;
    }

    public static void updatePosForce(Level level, BlockPos setPos, int y) {
        ChunkInfoMap map = MapChecker.getChunkMap(level, setPos);
        if (map != null) {
            map.updateHeight(setPos, y);
        }
    }

    public static boolean notLightAbove(Level level, BlockPos pos, int times) {
        if (!((Boolean)CommonConfig.Debug.notLightAbove.get()).booleanValue()) {
            return true;
        }
        BlockPos abovePos = pos.m_7494_();
        if (level.m_46749_(abovePos)) {
            BlockState stateAbove;
            try {
                stateAbove = level.m_8055_(abovePos);
            }
            catch (Exception e) {
                EclipticSeasons.LOGGER.error("Logic thread change the block in render thread with {}", (Object)pos);
                return true;
            }
            if (stateAbove.m_60734_() instanceof LightBlock) {
                if ((Integer)stateAbove.m_61143_((Property)LightBlock.f_153657_) == 0) {
                    return false;
                }
            } else if (!stateAbove.m_60795_() && !MapChecker.solidTest(stateAbove) && times > 0) {
                return MapChecker.notLightAbove(level, abovePos, times - 1);
            }
        }
        return true;
    }

    public static boolean isAboveSnowLine(@NotNull Level level, Biome biome, BlockPos pos) {
        return MapChecker.isAboveSnowLine(biome, pos.m_123342_(), level instanceof ServerLevel);
    }

    public static boolean isAboveSnowLine(Biome biome, int pos, boolean isServer) {
        return pos > BiomeClimateManager.getSnowLine(biome, isServer);
    }

    public static boolean shouldSnowAt(@Nonnull Level level, BlockPos pos, BlockState state, RandomSource random, long seed) {
        boolean isSnowy;
        if (SnowyMapChecker.shouldCheckSnowyStatus(level, pos) && MapChecker.notWater(state)) {
            return SnowyMapChecker.isSnowyBlock(level, pos);
        }
        Holder<Biome> biomeHolder = MapChecker.getSurfaceBiome(level, pos);
        Biome biome = (Biome)biomeHolder.m_203334_();
        boolean bl = isSnowy = (long)WeatherManager.getSnowDepthAtBiome(level, biome) > Math.abs(seed % 100L);
        if (!isSnowy) {
            isSnowy = MapChecker.isAboveSnowLine(level, biome, pos);
        }
        if (isSnowy) {
            isSnowy = MapChecker.notLightAbove(level, pos, 4);
        }
        return isSnowy;
    }

    public static boolean shouldSnowAt(@Nonnull Level level, BlockPos pos, int biomeId, BlockState state, @Nullable RandomSource random, long seed) {
        boolean isSnowy;
        if (SnowyMapChecker.shouldCheckSnowyStatus(level, pos) && MapChecker.notWater(state)) {
            return SnowyMapChecker.isSnowyBlock(level, pos);
        }
        Biome biome = (Biome)MapChecker.idToBiome(level, biomeId).m_203334_();
        ArrayList<WeatherManager.BiomeWeather> biomeList = WeatherManager.getBiomeList(level);
        boolean bl = isSnowy = biomeList != null && (long)WeatherManager.getSnowDepthAtBiome(level, biome) > Math.abs(seed % 100L);
        if (!isSnowy) {
            isSnowy = MapChecker.isAboveSnowLine(level, biome, pos);
        }
        if (isSnowy) {
            isSnowy = MapChecker.notLightAbove(level, pos, 4);
        }
        return isSnowy;
    }

    public static boolean notWater(BlockState state) {
        return state == null || !state.m_60713_(Blocks.f_49990_);
    }

    public static boolean shouldSnowAtBiome(@Nonnull Level level, Biome biome, BlockState state, RandomSource random, long seed, BlockPos mcPos) {
        if (MapChecker.isAboveSnowLine(level, biome, mcPos)) {
            return true;
        }
        return (long)WeatherManager.getSnowDepthAtBiome(level, biome) > Math.abs(seed % 100L);
    }

    public static boolean isSmallBiome(@Nonnull Holder<Biome> biomeHolder) {
        return biomeHolder != null && MapChecker.isSmallBiome((Biome)biomeHolder.m_203334_());
    }

    public static boolean isSmallBiome(@Nonnull Biome biomeHolder) {
        return ((IBiomeTagHolder)biomeHolder).eclipticseasons$isSmallBiome();
    }

    public static Holder<Biome> idToBiome(Level level, int id) {
        Holder<Biome> biomeHolder;
        ArrayList<WeatherManager.BiomeWeather> list = WeatherManager.getBiomeList(level);
        if (list != null && id < list.size() && (biomeHolder = list.get((int)id).biomeHolder) != null) {
            return biomeHolder;
        }
        Optional biomeRegistry = level.m_9598_().m_6632_(Registries.f_256952_);
        if (biomeRegistry.isPresent()) {
            Optional holder = ((Registry)biomeRegistry.get()).m_203300_(id);
            if (holder.isPresent()) {
                return (Holder)holder.get();
            }
            EclipticSeasons.extraLogger(true, "Unknown id with level", level, id);
            return ((Registry)biomeRegistry.get()).m_203636_(Biomes.f_48202_).orElse(null);
        }
        EclipticSeasons.extraLogger(true, "Unknown id with level", level, id);
        return null;
    }

    public static Holder<Biome> idToBiome(Registry<Biome> biomes, int id) {
        Optional holder = biomes.m_203300_(id);
        if (holder.isPresent()) {
            return (Holder)holder.get();
        }
        EclipticSeasons.extraLogger(true, "Unknown id for biome", id);
        return biomes.m_203636_(Biomes.f_48202_).orElse(null);
    }

    public static int biomeToId(Level level, Biome b) {
        IBiomeTagHolder iBiomeTagHolder;
        int id;
        Biome o = b;
        if (o instanceof IBiomeTagHolder && (id = (iBiomeTagHolder = (IBiomeTagHolder)o).eclipticseasons$getBindId()) > -1) {
            return id;
        }
        return MapChecker.biomeToId((Registry<Biome>)level.m_9598_().m_175515_(Registries.f_256952_), b);
    }

    public static int biomeToId(Registry<Biome> biomes, Biome b) {
        int id = biomes.m_7447_((Object)b);
        if (id < 0) {
            Biome plainsBiome = (Biome)biomes.m_6246_(Biomes.f_48202_);
            id = biomes.m_7447_((Object)plainsBiome);
        }
        return id;
    }

    public static Holder<Biome> getSurfaceBiome(Level level, BlockPos pos) {
        IChunkBiomeHolder iChunkBiomeHolder;
        BiomeHolder biomeHolder;
        int z;
        int x = SectionPos.m_123171_((int)pos.m_123341_());
        ChunkAccess chunkAt = level.m_6522_(x, z = SectionPos.m_123171_((int)pos.m_123343_()), ChunkStatus.f_62317_, false);
        if (chunkAt instanceof IChunkBiomeHolder && (biomeHolder = (iChunkBiomeHolder = (IChunkBiomeHolder)chunkAt).eclipticseasons$getBiomeHolder()) != null && biomeHolder.version() == EclipticUtil.getBiomeDataVersion(level)) {
            return MapChecker.getSurfaceBiome(level, pos, biomeHolder);
        }
        return MapChecker.getUnCachedSurfaceBiome(level, pos);
    }

    public static Holder<Biome> getSurfaceBiomeByChunk(Level level, LevelChunk chunkAt, BlockPos pos) {
        IChunkBiomeHolder iChunkBiomeHolder;
        BiomeHolder biomeHolder;
        if (chunkAt instanceof IChunkBiomeHolder && (biomeHolder = (iChunkBiomeHolder = (IChunkBiomeHolder)chunkAt).eclipticseasons$getBiomeHolder()) != null && biomeHolder.version() == EclipticUtil.getBiomeDataVersion(level)) {
            return MapChecker.getSurfaceBiome(level, pos, biomeHolder);
        }
        return MapChecker.getUnCachedSurfaceBiome(level, pos);
    }

    public static Holder<Biome> getSurfaceBiome(Level level, BlockPos pos, @Nonnull BiomeHolder biomeHolder) {
        int biomeId = biomeHolder.getBiomeId(pos);
        return biomeId > -1 ? MapChecker.idToBiome(level, biomeId) : MapChecker.getUnCachedSurfaceBiome(level, pos);
    }

    public static Holder<Biome> getUnCachedSurfaceBiome(Level level, BlockPos pos) {
        int maxBuildHeight = level.m_151558_();
        int minBuildHeight = level.m_141937_();
        ChunkInfoMap chunkMap = MapChecker.getChunkMap(level, pos);
        Holder<Biome> biome = null;
        int bid = 0;
        int y = 0;
        if (chunkMap != null && (bid = chunkMap.getBiome(pos)) > -1 && MapChecker.isSmallBiome(biome = MapChecker.idToBiome(level, bid)) && ((y = chunkMap.getHeight(pos) + 1) > maxBuildHeight || y <= minBuildHeight)) {
            y = MapChecker.getVanillaSolidHeightOrSelf(level, pos);
        }
        if (biome == null) {
            if (chunkMap != null) {
                y = chunkMap.getHeight(pos) + 1;
            }
            if (y > maxBuildHeight || y <= minBuildHeight) {
                y = MapChecker.getVanillaSolidHeightOrSelf(level, pos);
            }
            pos = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
            bid = MapChecker.getSurfaceOrUpdate(level, pos, false, 1);
            biome = MapChecker.idToBiome(level, bid);
        }
        if (biome == null) {
            biome = level.m_9598_().m_175515_(Registries.f_256952_).m_246971_(Biomes.f_48202_);
        }
        BlockPos.MutableBlockPos relative = null;
        int i = 0;
        int last_ii = 0;
        boolean shouldBreak = false;
        while (MapChecker.isSmallBiome(biome)) {
            if (relative == null) {
                relative = new BlockPos.MutableBlockPos(pos.m_123341_(), y, pos.m_123343_());
            }
            i += 4;
            for (SimplePair<Direction, Direction> pair : SMALL_OFFSET_DIRECTIONS) {
                if (pair.getValue() != null) {
                    int ii = i - 1;
                    if (ii == last_ii) continue;
                    relative.m_122175_(pair.getKey(), ii);
                    relative.m_122175_(pair.getValue(), ii);
                    last_ii = ii;
                } else {
                    relative.m_122175_(pair.getKey(), i);
                }
                if (chunkMap != null) {
                    int x = MapChecker.blockToRegionCoord(relative.m_123341_());
                    int z = MapChecker.blockToRegionCoord(relative.m_123343_());
                    if (chunkMap.getX() == x && chunkMap.getZ() == z) {
                        bid = chunkMap.getBiome((BlockPos)relative);
                    }
                }
                if (bid < 0) {
                    y = MapChecker.getHeightSafe(level, (BlockPos)relative) + 1;
                    if (y > maxBuildHeight || y <= minBuildHeight) {
                        y = MapChecker.getVanillaSolidHeightOrSelf(level, (BlockPos)relative);
                    }
                    relative.m_142448_(y);
                    bid = MapChecker.getSurfaceOrUpdate(level, (BlockPos)relative, false, 1);
                }
                if (!MapChecker.isSmallBiome(biome = MapChecker.idToBiome(level, bid))) {
                    shouldBreak = true;
                    break;
                }
                relative.m_142451_(pos.m_123341_());
                relative.m_142443_(pos.m_123343_());
            }
            if (!shouldBreak && i <= 128) continue;
            break;
        }
        return biome;
    }

    @Nullable
    private static Holder<Biome> fixSmallBiome(Level level, BlockPos pos, Holder<Biome> biome, @Nullable BlockPos.MutableBlockPos relative, int y, ChunkInfoMap chunkMap1, int maxBuildHeight, int minBuildHeight) {
        int i = 0;
        int last_ii = 0;
        boolean shouldBreak = false;
        while (MapChecker.isSmallBiome(biome)) {
            if (relative == null) {
                relative = new BlockPos.MutableBlockPos(pos.m_123341_(), y, pos.m_123343_());
            }
            i += 4;
            for (SimplePair<Direction, Direction> pair : SMALL_OFFSET_DIRECTIONS) {
                if (pair.getValue() != null) {
                    int ii = i - 1;
                    if (ii == last_ii) continue;
                    relative.m_122175_(pair.getKey(), ii);
                    relative.m_122175_(pair.getValue(), ii);
                    last_ii = ii;
                } else {
                    relative.m_122175_(pair.getKey(), i);
                }
                if (chunkMap1 != null) {
                    y = chunkMap1.getHeight((BlockPos)relative) + 1;
                }
                if (y > maxBuildHeight || y <= minBuildHeight) {
                    y = pos.m_123342_();
                }
                relative.m_142448_(y);
                biome = CropGrowthHandler.getCropBiome((LevelAccessor)level, (BlockPos)relative);
                if (!MapChecker.isSmallBiome(biome)) {
                    shouldBreak = true;
                    break;
                }
                relative.m_142451_(pos.m_123341_());
                relative.m_142443_(pos.m_123343_());
            }
            if (!shouldBreak && i <= 128) continue;
            break;
        }
        return biome;
    }

    public static Holder<Biome> fixBiomeOnServer(ServerLevel level, BlockPos pos, Holder<Biome> biome, ChunkInfoMap map) {
        BiomeSource biomeSource;
        Climate.ParameterList parameters = LEVEL_PARAMETER_LIST_MAP.get(level);
        if (parameters == null && (biomeSource = level.m_7726_().m_8481_().m_62218_()) instanceof MultiNoiseBiomeSource) {
            MultiNoiseBiomeSource multiNoiseBiomeSource = (MultiNoiseBiomeSource)biomeSource;
            Climate.ParameterList parameters2 = multiNoiseBiomeSource.m_274409_();
            List<Pair> list = parameters2.m_186850_().stream().filter(p -> !MapChecker.isSmallBiome((Holder<Biome>)((Holder)p.getSecond()))).toList();
            parameters = new Climate.ParameterList(list);
            LEVEL_PARAMETER_LIST_MAP.put((Level)level, (Climate.ParameterList<Holder<Biome>>)parameters);
        }
        if (parameters != null) {
            int biomeId;
            int n = biomeId = map == null ? -1 : map.getBiome(QuartPos.m_175402_((int)QuartPos.m_175400_((int)pos.m_123341_())), QuartPos.m_175402_((int)QuartPos.m_175400_((int)pos.m_123343_())));
            if (biomeId > -1) {
                biome = MapChecker.idToBiome((Level)level, biomeId);
            } else {
                Climate.Sampler sampler = level.m_7726_().m_214994_().m_224579_();
                Climate.TargetPoint sample = sampler.m_183445_(QuartPos.m_175400_((int)pos.m_123341_()), QuartPos.m_175400_((int)pos.m_123342_()), QuartPos.m_175400_((int)pos.m_123343_()));
                biome = (Holder)parameters.m_204252_(sample);
            }
        }
        return biome;
    }

    public static int getBlockType(BlockState state, BlockGetter level, BlockPos pos) {
        int flag = 0;
        Block onBlock = state.m_60734_();
        if (!((Boolean)CommonConfig.Debug.snowOverlayGlowingBlock.get()).booleanValue() && state.getLightEmission(level, pos) > 0) {
            flag = 0;
        } else if (!((Boolean)CommonConfig.Debug.disableSnowOverlayControlTag.get()).booleanValue() && state.m_204336_(EclipticBlockTags.SNOW_OVERLAY_CANNOT_SURVIVE_ON)) {
            flag = 0;
        } else {
            if (state.m_60734_().m_204297_().m_205785_().m_135782_().m_135827_().equals("snowrealmagic")) {
                return 0;
            }
            if (onBlock instanceof LeavesBlock) {
                flag = 4;
            } else if (onBlock == Blocks.f_50440_ || onBlock == Blocks.f_50493_ || onBlock == Blocks.f_50069_ || onBlock == Blocks.f_49992_) {
                flag = 1;
            } else if (onBlock == Blocks.f_50034_ || onBlock == Blocks.f_50035_) {
                flag = 5;
            } else if (onBlock == Blocks.f_50359_ || onBlock == Blocks.f_50360_) {
                flag = 501;
            } else if (onBlock instanceof VineBlock) {
                flag = 7;
            } else if (onBlock instanceof FarmBlock || onBlock instanceof DirtPathBlock) {
                flag = 6;
            } else if (onBlock instanceof TrapDoorBlock || onBlock instanceof DoorBlock && state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.UPPER || onBlock instanceof FenceBlock || onBlock instanceof FenceGateBlock || onBlock instanceof WallBlock || onBlock instanceof BellBlock || onBlock instanceof ComposterBlock || onBlock instanceof CampfireBlock && (Boolean)state.m_61143_((Property)CampfireBlock.f_51227_) == false || onBlock instanceof IronBarsBlock || onBlock instanceof LightningRodBlock || onBlock instanceof AzaleaBlock) {
                flag = 999;
            } else {
                ResourceLocation blockName = onBlock.m_204297_().m_205785_().m_135782_();
                if (state.m_60804_(level, pos)) {
                    flag = 1;
                } else if (onBlock instanceof SlabBlock) {
                    SlabType value = (SlabType)state.m_61143_((Property)SlabBlock.f_56353_);
                    flag = value == SlabType.TOP ? 301 : (value == SlabType.BOTTOM ? 2 : 1);
                    if (blockName.toString().equals("xkdeco:dirt_path_slab")) {
                        flag = 999;
                    }
                } else if (onBlock instanceof StairBlock) {
                    flag = state.m_61143_((Property)StairBlock.f_56842_) == Half.TOP ? 301 : 3;
                }
            }
        }
        return flag;
    }

    public static int getSnowOffset(BlockState state, int flag) {
        SnowDefinition.Info uncacheSnow = SnowChecker.getUncacheSnow(state);
        if (uncacheSnow.isValid()) {
            return uncacheSnow.getOffset();
        }
        int offset = 0;
        if (flag == 5 || flag == 501) {
            if (flag == 5) {
                offset = 1;
            } else if (flag == 501) {
                offset = state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.LOWER ? 1 : 2;
            }
        } else if (MapChecker.customBuiltin(flag) && state.m_60734_() instanceof AzaleaBlock) {
            offset = 1;
        }
        return offset;
    }

    public static int getDefaultBlockTypeFlag(BlockState state) {
        IBlockStateFlagger flagger = (IBlockStateFlagger)state;
        int flag = flagger.getBlockTypeFlag();
        if (flag < 0) {
            SnowDefinition.Info uncacheSnow = SnowChecker.getUncacheSnow(state);
            if (CommonConfig.getForceBlocksNotSnowy().contains(state.m_60734_())) {
                flag = 0;
            } else if (uncacheSnow.isValid()) {
                flag = uncacheSnow.getFlag();
            } else {
                try {
                    flag = MapChecker.getBlockType(state, (BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_);
                }
                catch (Exception e) {
                    flag = 0;
                    EclipticSeasons.logger(e);
                }
            }
            flagger.setBlockTypeFlag(flag);
        }
        return flag;
    }

    @Deprecated(forRemoval=true)
    public static int getBlockTypeFlag(BlockGetter blockGetter, BlockPos pos, BlockState state) {
        SnowDefinition.Info uncacheSnow;
        IBlockStateFlagger flagger = (IBlockStateFlagger)state;
        int flag = CommonConfig.getForceBlocksNotSnowy().contains(state.m_60734_()) ? 0 : ((uncacheSnow = SnowChecker.getUncacheSnow(state)).isValid() ? uncacheSnow.getFlag() : MapChecker.getBlockType(state, blockGetter, pos));
        return flag;
    }

    public static List<Holder<Biome>> getBiomes(Level level, BlockPos pos) {
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(pos.m_123341_(), level.m_151558_(), pos.m_123343_());
        ArrayList<Holder<Biome>> list = new ArrayList<Holder<Biome>>();
        while (mPos.m_123342_() >= level.m_141937_()) {
            list.add((Holder<Biome>)level.m_204166_((BlockPos)mPos));
            mPos = mPos.m_122173_(Direction.DOWN);
        }
        return list;
    }

    public static boolean isValidDimension(@Nullable Level level) {
        boolean result;
        boolean bl = result = level != null;
        if (result) {
            for (int i = 0; i < validDimension.size(); ++i) {
                if (validDimension.get(i) != level) continue;
                return true;
            }
        }
        return false;
    }

    public static void sendChunkLoginInfo(ServerLevel serverLevel, LevelChunk chunk, ChunkPos chunkPos, ServerPlayer player) {
        BiomeHolder biomeHolder = MapChecker.getOrUpdateChunkBiomeData(serverLevel, (IChunkBiomeHolder)chunk, chunkPos);
        if (biomeHolder != null && biomeHolder.hasUpdated()) {
            SimpleNetworkHandler.send(player, new ChunkBiomeUpdateMessage(biomeHolder.biomes(), chunkPos, biomeHolder.version()));
        }
    }

    @NotNull
    public static BiomeHolder getOrUpdateChunkBiomeData(ServerLevel serverLevel, IChunkBiomeHolder chunk, ChunkPos chunkPos) {
        int biomeDataVersion = EclipticUtil.getBiomeDataVersion((Level)serverLevel);
        BiomeHolder biomeHolder = chunk.eclipticseasons$getBiomeHolder();
        if (biomeHolder == null) {
            biomeHolder = BiomeHolder.prepareBiomes((Level)serverLevel, chunkPos, biomeDataVersion, false);
            chunk.eclipticseasons$setBiomeHolder(biomeHolder);
        } else if (biomeHolder.hasUpdated() && biomeHolder.version() == -2) {
            biomeHolder = BiomeHolder.fillSmallBiomes((Level)serverLevel, chunkPos, biomeHolder, biomeDataVersion);
            chunk.eclipticseasons$setBiomeHolder(biomeHolder);
        } else if (!biomeHolder.hasUpdated() || biomeHolder.version() != biomeDataVersion) {
            biomeHolder = BiomeHolder.prepareBiomes((Level)serverLevel, chunkPos, biomeDataVersion, biomeHolder.version() != biomeDataVersion);
            chunk.eclipticseasons$setBiomeHolder(biomeHolder);
        }
        return biomeHolder;
    }

    public static ChunkInfoMap forceChunkUpdateHeight(Level level, ChunkAccess chunk) {
        ChunkPos chunkPos = chunk.m_7697_();
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(chunkPos.m_45604_(), 0, chunkPos.m_45605_());
        ChunkInfoMap chunkMap = MapChecker.getChunkInfoMapOrCreate(level, (BlockPos)checkPos);
        if (chunkMap != null) {
            for (int i = chunkPos.m_45604_(); i <= chunkPos.m_45608_(); ++i) {
                for (int j = chunkPos.m_45605_(); j <= chunkPos.m_45609_(); ++j) {
                    checkPos.m_142451_(i);
                    checkPos.m_142443_(j);
                    int k = MapChecker.getMCHeightWithCheck(level, (BlockPos)checkPos, chunk, null, checkPos, null);
                    chunkMap.updateHeight(i, j, k);
                }
            }
        }
        return chunkMap;
    }

    public static void setNewChunk(ServerLevel serverLevel, ChunkAccess chunk) {
        SolarDataManager data;
        IChunkBiomeHolder chunkBiomeHolder;
        BiomeHolder biomeHolder;
        if (chunk instanceof IChunkBiomeHolder && (biomeHolder = (chunkBiomeHolder = (IChunkBiomeHolder)chunk).eclipticseasons$getBiomeHolder()) != null && (data = SolarHolders.getSaveData((Level)serverLevel)) != null && biomeHolder.hasUpdated() && biomeHolder.version() == -1) {
            chunkBiomeHolder.eclipticseasons$setBiomeHolder(new BiomeHolder(biomeHolder.biomes(), true, data.getBiomeDataVersion()));
        }
    }

    public static boolean leaveLike(int flag) {
        return flag == 4 || flag == 1100 || flag == 1101;
    }

    public static boolean vineLike(int flag) {
        return flag == 7 || flag == 1200;
    }

    public static boolean solidBlockLike(int flag) {
        return flag == 1 || flag == 1000;
    }

    public static boolean customBuiltin(int flag) {
        return flag == 998 || flag == 999;
    }
}

