/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.snow;

import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.common.core.snow.SnowyMapChecker;
import com.teamtea.eclipticseasons.common.core.snow.SnowyStatusKeeper;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class SnowyStatusHandler {
    public final boolean initialSync;
    public final SnowyStatusKeeper attachment;
    public final ChunkPos chunkPos;
    public static final Map<ChunkPos, SnowyStatusHandler> SNOWY_STATUS_HANDLER_HASH_MAP = new HashMap<ChunkPos, SnowyStatusHandler>();

    public SnowyStatusHandler(boolean initialSync, SnowyStatusKeeper attachment, ChunkPos chunkPos) {
        this.initialSync = initialSync;
        this.attachment = attachment;
        this.chunkPos = chunkPos;
    }

    public SnowyStatusHandler(FriendlyByteBuf buf) {
        if (!EclipticUtil.canSnowyBlockInteract()) {
            this.initialSync = false;
            this.chunkPos = new ChunkPos(0, 0);
            this.attachment = SnowyStatusKeeper.create();
            return;
        }
        this.initialSync = buf.readBoolean();
        this.chunkPos = buf.m_178383_();
        this.attachment = SnowyStatusKeeper.create();
        int size = 0;
        try {
            size = buf.m_130242_();
            if (!this.initialSync) {
                for (int i = 0; i < size; ++i) {
                    long pos = buf.readLong();
                    int status = buf.m_130242_();
                    this.attachment.getPosListUpdate().add(pos);
                    this.attachment.getStatusListUpdate().add(status);
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    long pos = buf.readLong();
                    int status = buf.m_130242_();
                    this.attachment.set(pos, status);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void write(@NotNull FriendlyByteBuf buf) {
        if (!EclipticUtil.canSnowyBlockInteract()) {
            return;
        }
        buf.writeBoolean(this.initialSync);
        buf.m_178341_(this.chunkPos);
        if (this.initialSync) {
            int size = this.attachment.getPosMap().size();
            buf.m_130130_(size);
            this.attachment.getPosMap().forEach((k, v) -> {
                buf.writeLong(k.longValue());
                buf.m_130130_(v.intValue());
            });
        } else {
            LongArrayList blockPosList = this.attachment.getPosListUpdate();
            IntArrayList integerList = this.attachment.getStatusListUpdate();
            int size = blockPosList.size();
            buf.m_130130_(size);
            for (int i = 0; i < size; ++i) {
                buf.writeLong(blockPosList.getLong(i));
                buf.m_130130_(integerList.getInt(i));
            }
        }
    }

    public static boolean processSnowyStatusMessage(SnowyStatusHandler msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Level useLevel;
            if (((NetworkEvent.Context)context.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT && (useLevel = ClientCon.getUseLevel()) != null) {
                LevelChunk chunkAt = useLevel.m_46745_(msg.chunkPos.m_45615_());
                if (!chunkAt.m_6430_()) {
                    SnowyStatusHandler.setChunkWithUpdate(msg, chunkAt);
                } else {
                    SNOWY_STATUS_HANDLER_HASH_MAP.put(msg.chunkPos, msg);
                }
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setChunkWithUpdate(SnowyStatusHandler msg, LevelChunk chunkAt) {
        SnowyStatusKeeper snowyStatusKeeper = SnowyMapChecker.getSnowyStatusKeeper((ChunkAccess)chunkAt);
        if (msg.initialSync) {
            Long2IntLinkedOpenHashMap long2IntLinkedOpenHashMap = snowyStatusKeeper.getPosMap();
            synchronized (long2IntLinkedOpenHashMap) {
                snowyStatusKeeper.copyFrom(msg.attachment);
            }
        }
        LongArrayList posListUpdate = msg.attachment.getPosListUpdate();
        HashSet<SectionPos> set = new HashSet<SectionPos>();
        Long2IntLinkedOpenHashMap long2IntLinkedOpenHashMap = snowyStatusKeeper.getPosMap();
        synchronized (long2IntLinkedOpenHashMap) {
            int posListUpdateSize = posListUpdate.size();
            for (int i = 0; i < posListUpdateSize; ++i) {
                long pos = posListUpdate.getLong(i);
                snowyStatusKeeper.set(pos, msg.attachment.getStatusListUpdate().getInt(i));
                set.add(SectionPos.m_123199_((BlockPos)BlockPos.m_122022_((long)pos)));
            }
        }
        for (SectionPos sectionPos : set) {
            ClientCon.agent.setChunkDirty(sectionPos);
        }
    }
}

