/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.solar;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.event.SolarTermChangeEvent;
import com.teamtea.eclipticseasons.api.util.SimpleUtil;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.core.crop.GreenHouseCoreProvider;
import com.teamtea.eclipticseasons.common.core.crop.HumidityControlProvider;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.network.SimpleNetworkHandler;
import com.teamtea.eclipticseasons.common.network.message.SolarTermsMessage;
import com.teamtea.eclipticseasons.common.network.message.UpdateTempChangeMessage;
import com.teamtea.eclipticseasons.config.CommonConfig;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class SolarDataManager
extends SavedData {
    public static final String KEY_ATTACH_SOLAR_DATA = EclipticSeasons.rl("attach_solar_data").toString();
    protected final int startSolarTermsDay;
    protected int solarTermsDay;
    protected int solarTermsTicks;
    protected boolean isValidDimension;
    protected float solarTempChange;
    private int biomeDataVersion;
    protected WeakReference<Level> levelWeakReference;
    private final Long2ObjectOpenHashMap<List<Pair<BlockPos, HumidityControlProvider>>> humidityCoreMap;
    private final Long2ObjectOpenHashMap<List<Pair<BlockPos, GreenHouseCoreProvider>>> greenHouseCoreMap;
    private final Long2ObjectOpenHashMap<BlockState> skipNextCheckInTickPosMap;

    public SolarDataManager(Level level) {
        this.solarTermsDay = this.startSolarTermsDay = ((Integer)CommonConfig.Season.initialSolarTermIndex.get() - 1) * (Integer)CommonConfig.Season.lastingDaysOfEachTerm.get();
        this.solarTermsTicks = 0;
        this.isValidDimension = false;
        this.solarTempChange = 0.0f;
        this.biomeDataVersion = 0;
        this.levelWeakReference = new WeakReference<Level>(level);
        this.humidityCoreMap = new Long2ObjectOpenHashMap();
        this.greenHouseCoreMap = new Long2ObjectOpenHashMap();
        this.isValidDimension = MapChecker.isValidDimension(level);
        this.skipNextCheckInTickPosMap = new Long2ObjectOpenHashMap();
        this.solarTempChange = this.createTempChange(level);
    }

    protected float createTempChange(Level level) {
        return this.isValidDimension() ? (float)Mth.m_14008_((double)(level.m_213780_().m_188583_() * 0.125), (double)-0.25, (double)0.25) : 0.0f;
    }

    public SolarDataManager(Level level, CompoundTag nbt) {
        this(level);
        this.setSolarTermsDay(nbt.m_128451_("SolarTermsDay"));
        this.setSolarTermsTicks(nbt.m_128451_("SolarTermsTicks"));
        if (nbt.m_128441_("SolarTempChange")) {
            this.setSolarTempChange(nbt.m_128457_("SolarTempChange"));
        }
        this.biomeDataVersion = nbt.m_128451_("BiomeDataVersion");
        this.setLevelData(nbt);
    }

    protected void setLevelData(CompoundTag nbt) {
        if (this.levelWeakReference.get() != null) {
            ListTag listTag = nbt.m_128437_("biomes", 10);
            ArrayList<WeatherManager.BiomeWeather> biomeWeathers = WeatherManager.getBiomeList((Level)this.levelWeakReference.get());
            int countCheck = 0;
            block0: for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag compound = listTag.m_128728_(i);
                String location = compound.m_128461_("biome");
                if (biomeWeathers == null) continue;
                for (int j = 0; j < biomeWeathers.size(); ++j) {
                    WeatherManager.BiomeWeather biomeWeather = biomeWeathers.get(j);
                    if (!location.equals(biomeWeather.location.toString())) continue;
                    biomeWeather.deserializeNBT(compound);
                    if (i != j) continue block0;
                    ++countCheck;
                    continue block0;
                }
            }
            if (countCheck != listTag.size()) {
                ++this.biomeDataVersion;
                EclipticSeasons.logger("Warning for biome date need to be update with", listTag.size(), biomeWeathers == null ? 0 : biomeWeathers.size(), " new version is", this.biomeDataVersion);
            }
        }
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag compound) {
        ArrayList<WeatherManager.BiomeWeather> list;
        compound.m_128405_("SolarTermsDay", this.getSolarTermsDay());
        compound.m_128405_("SolarTermsTicks", this.getSolarTermsTicks());
        compound.m_128350_("SolarTempChange", this.getSolarTempChange());
        compound.m_128405_("BiomeDataVersion", this.biomeDataVersion);
        ListTag listTag = new ListTag();
        if (this.levelWeakReference.get() != null && (list = WeatherManager.getBiomeList((Level)this.levelWeakReference.get())) != null) {
            for (WeatherManager.BiomeWeather biomeWeather : list) {
                listTag.add((Object)biomeWeather.serializeNBT());
            }
        }
        compound.m_128365_("biomes", (Tag)listTag);
        return compound;
    }

    public static SolarDataManager get(ServerLevel serverLevel) {
        DimensionDataStorage storage = serverLevel.m_8895_();
        return (SolarDataManager)storage.m_164861_(compoundTag -> new SolarDataManager((Level)serverLevel, (CompoundTag)compoundTag), () -> {
            SolarDataManager manager = new SolarDataManager((Level)serverLevel);
            WeatherManager.initNewWorldWeather(serverLevel, serverLevel.f_46441_, manager.getSolarTerm());
            return manager;
        }, "eclipticseasons");
    }

    public void updateTicks(ServerLevel world) {
        ++this.solarTermsTicks;
        int dayTime = Math.toIntExact(world.m_46468_() % 24000L);
        if (this.solarTermsTicks > dayTime + 100) {
            ++this.solarTermsDay;
            this.sendAndUpdate(world);
        }
        this.solarTermsTicks = dayTime;
        this.m_77762_();
    }

    public boolean isValidDimension() {
        return this.isValidDimension;
    }

    public int getSolarTermIndex() {
        if (!this.isValidDimension()) {
            return SolarTerm.NONE.ordinal();
        }
        return (this.getSolarTermsDay() / (Integer)CommonConfig.Season.lastingDaysOfEachTerm.get() % 24 + 24) % 24;
    }

    public SolarTerm getSolarTerm() {
        return SolarTerm.get(this.getSolarTermIndex());
    }

    public SolarTerm getNextSolarTerm() {
        if (!this.isValidDimension()) {
            return SolarTerm.NONE;
        }
        return SolarTerm.get((this.getSolarTermIndex() + 1) % 24);
    }

    public int getSolarTermDaysInPeriod() {
        return Math.abs(this.getSolarTermsDay() % this.getSolarTermLastingDays());
    }

    public int getSolarTermLastingDays() {
        return (Integer)CommonConfig.Season.lastingDaysOfEachTerm.get();
    }

    public boolean isTodayLastDay() {
        int longTime = this.getSolarTermLastingDays();
        return (this.getSolarTermsDay() + 1) % longTime == 0;
    }

    public int getSolarTermsDay() {
        return this.solarTermsDay;
    }

    public int getSolarYear() {
        return !this.isValidDimension() ? 0 : (this.getSolarTermsDay() - 0) / (24 * this.getSolarTermLastingDays()) + 1;
    }

    public int getSolarTermsTicks() {
        return this.solarTermsTicks;
    }

    public int getBiomeDataVersion() {
        return this.biomeDataVersion;
    }

    public float getSolarTempChange() {
        return this.solarTempChange;
    }

    public void setSolarTermsDay(int solarTermsDay) {
        this.solarTermsDay = solarTermsDay;
        this.m_77762_();
    }

    public void setSolarTermsTicks(int solarTermsTicks) {
        this.solarTermsTicks = solarTermsTicks;
        this.m_77762_();
    }

    public void setSolarTempChange(float solarTempChange) {
        this.solarTempChange = solarTempChange;
        this.m_77762_();
    }

    public void addHumidityControlProvider(BlockPos pos, HumidityControlProvider humidityControlProvider) {
        ChunkPos chunkPos = new ChunkPos(pos);
        ArrayList<Pair> blockPosBlockStateMap = (ArrayList<Pair>)this.humidityCoreMap.get(chunkPos.m_45588_());
        if (blockPosBlockStateMap == null) {
            blockPosBlockStateMap = new ArrayList<Pair>();
            this.humidityCoreMap.put(chunkPos.m_45588_(), blockPosBlockStateMap);
        }
        for (int i = 0; i < blockPosBlockStateMap.size(); ++i) {
            Pair p = (Pair)blockPosBlockStateMap.get(i);
            if (!((BlockPos)p.first()).equals((Object)pos)) continue;
            if (p.second() != humidityControlProvider) {
                blockPosBlockStateMap.set(i, Pair.of((Object)pos, (Object)humidityControlProvider));
            }
            return;
        }
        blockPosBlockStateMap.add(Pair.of((Object)pos, (Object)humidityControlProvider));
    }

    public void addGreenHouseCoreProvider(BlockPos pos, GreenHouseCoreProvider provider) {
        ChunkPos chunkPos = new ChunkPos(pos);
        ArrayList<Pair> blockPosBlockStateMap = (ArrayList<Pair>)this.greenHouseCoreMap.get(chunkPos.m_45588_());
        if (blockPosBlockStateMap == null) {
            blockPosBlockStateMap = new ArrayList<Pair>();
            this.greenHouseCoreMap.put(chunkPos.m_45588_(), blockPosBlockStateMap);
        }
        for (int i = 0; i < blockPosBlockStateMap.size(); ++i) {
            Pair p = (Pair)blockPosBlockStateMap.get(i);
            if (!((BlockPos)p.first()).equals((Object)pos)) continue;
            if (((GreenHouseCoreProvider)p.second()).getSeason() == provider.getSeason()) {
                ((GreenHouseCoreProvider)p.second()).addAvailCost(provider.getAvailCost());
            }
            return;
        }
        blockPosBlockStateMap.add(Pair.of((Object)pos, (Object)provider));
    }

    public void unloadChunk(ChunkPos chunkPos) {
        this.humidityCoreMap.remove(chunkPos.m_45588_());
        this.greenHouseCoreMap.remove(chunkPos.m_45588_());
    }

    public HumidityControlProvider queryHumidityControlProvider(BlockPos blockPos) {
        ChunkPos chunkPos = new ChunkPos(blockPos);
        List lis = (List)this.humidityCoreMap.getOrDefault(chunkPos.m_45588_(), null);
        if (lis != null) {
            for (Pair p : lis) {
                if (!((BlockPos)p.first()).equals((Object)blockPos)) continue;
                return (HumidityControlProvider)p.second();
            }
        }
        return null;
    }

    public HumidityControlProvider removeHumidityControlProvider(BlockPos blockPos) {
        ChunkPos chunkPos = new ChunkPos(blockPos);
        List lis = (List)this.humidityCoreMap.getOrDefault(chunkPos.m_45588_(), null);
        if (lis != null) {
            int lisSize = lis.size();
            for (int i = 0; i < lisSize; ++i) {
                Pair p = (Pair)lis.get(i);
                if (!((BlockPos)p.first()).equals((Object)blockPos)) continue;
                lis.remove(i);
                if (lis.isEmpty()) {
                    this.greenHouseCoreMap.remove(chunkPos.m_45588_());
                }
                return (HumidityControlProvider)p.second();
            }
        }
        return null;
    }

    public float calculateHumidityModification(BlockPos blockPos) {
        ChunkPos chunkPos = new ChunkPos(blockPos);
        Vec3 center = blockPos.m_252807_();
        int localX = blockPos.m_123341_() & 0xF;
        int localZ = blockPos.m_123343_() & 0xF;
        boolean isLeftBorder = localX <= 6;
        boolean isRightBorder = localX >= 7;
        boolean isFrontBorder = localZ <= 6;
        boolean isBackBorder = localZ >= 7;
        float result = 0.0f;
        for (int dx = isLeftBorder ? -1 : 0; dx <= (isRightBorder ? 1 : 0); ++dx) {
            for (int dz = isFrontBorder ? -1 : 0; dz <= (isBackBorder ? 1 : 0); ++dz) {
                ChunkPos currentChunkPos = new ChunkPos(chunkPos.f_45578_ + dx, chunkPos.f_45579_ + dz);
                List lis = (List)this.humidityCoreMap.getOrDefault(currentChunkPos.m_45588_(), null);
                if (lis == null) continue;
                for (Pair p : lis) {
                    if (!CropGrowthHandler.isWithinDistanceForGreenHouseWorker(center, ((BlockPos)p.first()).m_252807_(), ((HumidityControlProvider)p.second()).getRange())) continue;
                    result += ((HumidityControlProvider)p.second()).getLevel();
                }
            }
        }
        return result;
    }

    public GreenHouseCoreProvider queryGreenHouseProvider(BlockPos blockPos) {
        ChunkPos chunkPos = new ChunkPos(blockPos);
        List lis = (List)this.greenHouseCoreMap.getOrDefault(chunkPos.m_45588_(), null);
        if (lis != null) {
            for (Pair p : lis) {
                if (!((BlockPos)p.first()).equals((Object)blockPos)) continue;
                return (GreenHouseCoreProvider)p.second();
            }
        }
        return null;
    }

    public GreenHouseCoreProvider removeGreenHouseProvider(BlockPos blockPos) {
        ChunkPos chunkPos = new ChunkPos(blockPos);
        List lis = (List)this.greenHouseCoreMap.getOrDefault(chunkPos.m_45588_(), null);
        if (lis != null) {
            int lisSize = lis.size();
            for (int i = 0; i < lisSize; ++i) {
                Pair p = (Pair)lis.get(i);
                if (!((BlockPos)p.first()).equals((Object)blockPos)) continue;
                lis.remove(i);
                if (lis.isEmpty()) {
                    this.greenHouseCoreMap.remove(chunkPos.m_45588_());
                }
                return (GreenHouseCoreProvider)p.second();
            }
        }
        return null;
    }

    public GreenHouseCoreProvider findNearGreenHouseProvider(BlockPos blockPos, List<Season> seasons) {
        ChunkPos chunkPos = new ChunkPos(blockPos);
        Vec3 center = blockPos.m_252807_();
        int d = (Integer)CommonConfig.Crop.seasonCoreRange.get() / 16 + 1;
        for (int r = 0; r <= d; ++r) {
            for (int dx = -r; dx <= r; ++dx) {
                for (int dz = -r; dz <= r; ++dz) {
                    ChunkPos currentChunkPos;
                    GreenHouseCoreProvider greenHouseCoreProvider;
                    if (dx != -r && dx != r && dz != -r && dz != r || (greenHouseCoreProvider = this.checkSeasonProviderInChunk(seasons, currentChunkPos = new ChunkPos(chunkPos.f_45578_ + dx, chunkPos.f_45579_ + dz), center)) == null) continue;
                    return greenHouseCoreProvider;
                }
            }
        }
        return null;
    }

    protected GreenHouseCoreProvider checkSeasonProviderInChunk(List<Season> seasons, ChunkPos currentChunkPos, Vec3 center) {
        GreenHouseCoreProvider greenHouseCoreProvider = null;
        List lis = (List)this.greenHouseCoreMap.getOrDefault(currentChunkPos.m_45588_(), null);
        if (lis != null) {
            int seasonCoreRange = (Integer)CommonConfig.Crop.seasonCoreRange.get();
            for (Pair p : lis) {
                if (!seasons.contains(((GreenHouseCoreProvider)p.second()).getSeason()) || !CropGrowthHandler.isWithinDistanceForGreenHouseWorker(center, ((BlockPos)p.first()).m_252807_(), seasonCoreRange)) continue;
                greenHouseCoreProvider = (GreenHouseCoreProvider)p.second();
                break;
            }
        }
        return greenHouseCoreProvider;
    }

    public void tickChunk(ChunkPos pos, RandomSource randomSource) {
        if (this.humidityCoreMap.isEmpty()) {
            return;
        }
        List list = (List)this.humidityCoreMap.get(pos.m_45588_());
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Pair pair = (Pair)list.get(i);
                if (((HumidityControlProvider)pair.second()).getRemainTime() <= 0) {
                    list.remove(i);
                    --i;
                    continue;
                }
                ((HumidityControlProvider)pair.second()).addRemainTime(-1);
            }
            if (list.isEmpty()) {
                this.humidityCoreMap.remove(pos.m_45588_());
            }
        }
    }

    public void sendAndUpdate(ServerLevel world) {
        boolean changeSolarTerm = this.getSolarTermsDay() % (Integer)CommonConfig.Season.lastingDaysOfEachTerm.get() == 0;
        boolean updateTempChange = false;
        SolarTerm solarTerm = this.getSolarTerm();
        if (changeSolarTerm) {
            SolarTerm old = SolarTerm.collectValues()[(this.getSolarTermIndex() + 24) % 24];
            MinecraftForge.EVENT_BUS.post((Event)new SolarTermChangeEvent(old, solarTerm, (Level)world, this.solarTermsDay));
            if (solarTerm == SolarTerm.SUMMER_SOLSTICE) {
                this.setSolarTempChange(this.createTempChange((Level)world));
                updateTempChange = true;
            }
        }
        if (solarTerm != SolarTerm.NONE) {
            for (ServerPlayer player : world.m_6907_()) {
                SimpleNetworkHandler.send(player, new SolarTermsMessage(this.getSolarTermsDay()));
                if (changeSolarTerm && ((Boolean)CommonConfig.Season.enableInform.get()).booleanValue()) {
                    SimpleUtil.sendSolarTermMessage(player, solarTerm, false);
                }
                if (updateTempChange) {
                    SimpleNetworkHandler.send(player, new UpdateTempChangeMessage(this.getSolarTempChange()));
                }
                if (!changeSolarTerm) continue;
                WeatherManager.tickPlayerForSeasonCheck(player, solarTerm);
            }
        }
    }

    public void tickLevel(ServerLevel level) {
        this.skipNextCheckInTickPosMap.clear();
        if (MapChecker.isValidDimension((Level)level)) {
            this.updateTicks(level);
        }
    }

    public BlockState addSkipNextCheck(BlockPos blockPos, BlockState blockState) {
        return (BlockState)this.skipNextCheckInTickPosMap.put(blockPos.m_121878_(), (Object)blockState);
    }

    public boolean shouldSkipNextCheck(BlockPos blockPos) {
        return this.skipNextCheckInTickPosMap.containsKey(blockPos.m_121878_());
    }

    public void saveChunk(ChunkPos pos, CompoundTag data) {
        if (!((Boolean)CommonConfig.Crop.saveChunkEnvironmentalHumidity.get()).booleanValue()) {
            return;
        }
        List list = (List)this.humidityCoreMap.getOrDefault(pos.m_45588_(), null);
        if (list != null) {
            ListTag compoundTag = new ListTag();
            for (Pair pair : list) {
                if (!((HumidityControlProvider)pair.right()).shouldSave()) continue;
                CompoundTag ct = new CompoundTag();
                ct.m_128356_("pos", ((BlockPos)pair.left()).m_121878_());
                ct.m_128365_("humidity_modifiers", (Tag)((HumidityControlProvider)pair.right()).serializeNBT());
                compoundTag.add((Object)ct);
            }
            if (!compoundTag.isEmpty()) {
                data.m_128365_(KEY_ATTACH_SOLAR_DATA, (Tag)compoundTag);
            }
        }
    }

    public void loadChunk(ChunkPos pos, CompoundTag data) {
        if (!data.m_128441_(KEY_ATTACH_SOLAR_DATA)) {
            return;
        }
        ListTag attachSolarData = data.m_128437_(KEY_ATTACH_SOLAR_DATA, 10);
        for (Tag attachSolarDatum : attachSolarData) {
            CompoundTag compoundTag = (CompoundTag)attachSolarDatum;
            long aLong = compoundTag.m_128454_("pos");
            BlockPos blockPos = BlockPos.m_122022_((long)aLong);
            CompoundTag humidity_modifier = compoundTag.m_128469_("humidity_modifiers");
            if (humidity_modifier.m_128456_()) continue;
            HumidityControlProvider humidityControlProvider = new HumidityControlProvider(0.0f, 0.0f, 0, true);
            humidityControlProvider.deserializeNBT(humidity_modifier);
            this.addHumidityControlProvider(blockPos, humidityControlProvider);
        }
    }
}

