/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.EclipticSeasonsApi;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.climate.AgroClimaticZone;
import com.teamtea.eclipticseasons.api.util.codec.CodecUtil;
import com.teamtea.eclipticseasons.api.util.codec.ESExtraCodec;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import com.teamtea.eclipticseasons.common.registry.LootItemConditionRegistry;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public record SeasonCondition(Slice require) implements LootItemCondition
{
    public static final MapCodec<SeasonCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Slice.CODEC.fieldOf("require").forGetter(SeasonCondition::require)).apply((Applicative)instance, SeasonCondition::new));
    public static final Codec<SeasonCondition> CONDITION_CODEC = CODEC.codec();

    @NotNull
    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)LootItemConditionRegistry.SEASON.get();
    }

    public boolean test(LootContext context) {
        Season endSeason;
        SolarTerm end;
        SolarTerm start2;
        ServerLevel level = context.m_78952_();
        SolarTerm solarTerm = EclipticSeasonsApi.getInstance().getSolarTerm((Level)level);
        AgroClimaticZone climate = this.require.climate.map(Holder::m_203334_).orElse(null);
        SolarTerm solarTerm2 = this.require.start.isValid() ? this.require.start : (this.require.solarTerm.isValid() ? this.require.solarTerm : (climate != null && this.require.season.isValid() ? this.require.season.getFirstSolarTerm(climate) : (start2 = climate != null && this.require.startSeason.isValid() ? this.require.endSeason.getFirstSolarTerm(climate) : SolarTerm.NONE)));
        SolarTerm solarTerm3 = this.require.end.isValid() ? this.require.end : (this.require.solarTerm.isValid() ? this.require.solarTerm : (climate != null && this.require.season.isValid() ? this.require.season.getEndSolarTerm(climate) : (end = climate != null && this.require.endSeason.isValid() ? this.require.endSeason.getEndSolarTerm(climate) : SolarTerm.NONE)));
        if (start2.isValid() && end.isValid()) {
            return solarTerm.isInTerms(start2, end);
        }
        Season startSeason = this.require.season.isValid() ? this.require.season : this.require.startSeason;
        Season season = endSeason = this.require.season.isValid() ? this.require.season : this.require.endSeason;
        if (startSeason.isValid() && endSeason.isValid()) {
            BlockPos pos;
            Vec3 vec3 = (Vec3)context.m_78953_(LootContextParams.f_81460_);
            BlockPos blockPos = pos = vec3 == null ? null : BlockPos.m_274446_((Position)vec3);
            if (pos != null) {
                Season agroSeason = EclipticSeasonsApi.getInstance().getAgroSeason((Level)level, pos);
                return agroSeason.isInTerms(startSeason, endSeason);
            }
        }
        return solarTerm == SolarTerm.NONE;
    }

    public static Builder builder(Slice require) {
        return new Builder(require);
    }

    public static class Slice {
        public static final Codec<Slice> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)ESExtraCodec.SOLAR_TERM.optionalFieldOf("start", (Object)SolarTerm.NONE).forGetter(o -> o.start), (App)ESExtraCodec.SOLAR_TERM.optionalFieldOf("end", (Object)SolarTerm.NONE).forGetter(o -> o.end), (App)ESExtraCodec.SOLAR_TERM.optionalFieldOf("solar_term", (Object)SolarTerm.NONE).forGetter(o -> o.solarTerm), (App)CodecUtil.holderCodec(ESRegistries.AGRO_CLIMATE).optionalFieldOf("climate").forGetter(o -> o.climate), (App)ESExtraCodec.SEASON.optionalFieldOf("start_season", (Object)Season.NONE).forGetter(o -> o.startSeason), (App)ESExtraCodec.SEASON.optionalFieldOf("end_season", (Object)Season.NONE).forGetter(o -> o.endSeason), (App)ESExtraCodec.SEASON.optionalFieldOf("season", (Object)Season.NONE).forGetter(o -> o.season)).apply((Applicative)ins, Slice::new));
        private final SolarTerm start;
        private final SolarTerm end;
        private final SolarTerm solarTerm;
        private final Optional<Holder<AgroClimaticZone>> climate;
        private final Season startSeason;
        private final Season endSeason;
        private final Season season;

        @Generated
        private static SolarTerm $default$start() {
            return SolarTerm.NONE;
        }

        @Generated
        private static SolarTerm $default$end() {
            return SolarTerm.NONE;
        }

        @Generated
        private static SolarTerm $default$solarTerm() {
            return SolarTerm.NONE;
        }

        @Generated
        private static Optional<Holder<AgroClimaticZone>> $default$climate() {
            return Optional.empty();
        }

        @Generated
        private static Season $default$startSeason() {
            return Season.NONE;
        }

        @Generated
        private static Season $default$endSeason() {
            return Season.NONE;
        }

        @Generated
        private static Season $default$season() {
            return Season.NONE;
        }

        @Generated
        Slice(SolarTerm start2, SolarTerm end, SolarTerm solarTerm, Optional<Holder<AgroClimaticZone>> climate, Season startSeason, Season endSeason, Season season) {
            this.start = start2;
            this.end = end;
            this.solarTerm = solarTerm;
            this.climate = climate;
            this.startSeason = startSeason;
            this.endSeason = endSeason;
            this.season = season;
        }

        @Generated
        public static SliceBuilder builder() {
            return new SliceBuilder();
        }

        @Generated
        public SolarTerm getStart() {
            return this.start;
        }

        @Generated
        public SolarTerm getEnd() {
            return this.end;
        }

        @Generated
        public SolarTerm getSolarTerm() {
            return this.solarTerm;
        }

        @Generated
        public Optional<Holder<AgroClimaticZone>> getClimate() {
            return this.climate;
        }

        @Generated
        public Season getStartSeason() {
            return this.startSeason;
        }

        @Generated
        public Season getEndSeason() {
            return this.endSeason;
        }

        @Generated
        public Season getSeason() {
            return this.season;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Slice)) {
                return false;
            }
            Slice other = (Slice)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SolarTerm this$start = this.getStart();
            SolarTerm other$start = other.getStart();
            if (this$start == null ? other$start != null : !this$start.equals(other$start)) {
                return false;
            }
            SolarTerm this$end = this.getEnd();
            SolarTerm other$end = other.getEnd();
            if (this$end == null ? other$end != null : !this$end.equals(other$end)) {
                return false;
            }
            SolarTerm this$solarTerm = this.getSolarTerm();
            SolarTerm other$solarTerm = other.getSolarTerm();
            if (this$solarTerm == null ? other$solarTerm != null : !this$solarTerm.equals(other$solarTerm)) {
                return false;
            }
            Optional<Holder<AgroClimaticZone>> this$climate = this.getClimate();
            Optional<Holder<AgroClimaticZone>> other$climate = other.getClimate();
            if (this$climate == null ? other$climate != null : !((Object)this$climate).equals(other$climate)) {
                return false;
            }
            Season this$startSeason = this.getStartSeason();
            Season other$startSeason = other.getStartSeason();
            if (this$startSeason == null ? other$startSeason != null : !this$startSeason.equals(other$startSeason)) {
                return false;
            }
            Season this$endSeason = this.getEndSeason();
            Season other$endSeason = other.getEndSeason();
            if (this$endSeason == null ? other$endSeason != null : !this$endSeason.equals(other$endSeason)) {
                return false;
            }
            Season this$season = this.getSeason();
            Season other$season = other.getSeason();
            return !(this$season == null ? other$season != null : !this$season.equals(other$season));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Slice;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SolarTerm $start = this.getStart();
            result = result * 59 + ($start == null ? 43 : $start.hashCode());
            SolarTerm $end = this.getEnd();
            result = result * 59 + ($end == null ? 43 : $end.hashCode());
            SolarTerm $solarTerm = this.getSolarTerm();
            result = result * 59 + ($solarTerm == null ? 43 : $solarTerm.hashCode());
            Optional<Holder<AgroClimaticZone>> $climate = this.getClimate();
            result = result * 59 + ($climate == null ? 43 : ((Object)$climate).hashCode());
            Season $startSeason = this.getStartSeason();
            result = result * 59 + ($startSeason == null ? 43 : $startSeason.hashCode());
            Season $endSeason = this.getEndSeason();
            result = result * 59 + ($endSeason == null ? 43 : $endSeason.hashCode());
            Season $season = this.getSeason();
            result = result * 59 + ($season == null ? 43 : $season.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SeasonCondition.Slice(start=" + String.valueOf(this.getStart()) + ", end=" + String.valueOf(this.getEnd()) + ", solarTerm=" + String.valueOf(this.getSolarTerm()) + ", climate=" + String.valueOf(this.getClimate()) + ", startSeason=" + String.valueOf(this.getStartSeason()) + ", endSeason=" + String.valueOf(this.getEndSeason()) + ", season=" + String.valueOf(this.getSeason()) + ")";
        }

        @Generated
        public static class SliceBuilder {
            @Generated
            private boolean start$set;
            @Generated
            private SolarTerm start$value;
            @Generated
            private boolean end$set;
            @Generated
            private SolarTerm end$value;
            @Generated
            private boolean solarTerm$set;
            @Generated
            private SolarTerm solarTerm$value;
            @Generated
            private boolean climate$set;
            @Generated
            private Optional<Holder<AgroClimaticZone>> climate$value;
            @Generated
            private boolean startSeason$set;
            @Generated
            private Season startSeason$value;
            @Generated
            private boolean endSeason$set;
            @Generated
            private Season endSeason$value;
            @Generated
            private boolean season$set;
            @Generated
            private Season season$value;

            @Generated
            SliceBuilder() {
            }

            @Generated
            public SliceBuilder start(SolarTerm start2) {
                this.start$value = start2;
                this.start$set = true;
                return this;
            }

            @Generated
            public SliceBuilder end(SolarTerm end) {
                this.end$value = end;
                this.end$set = true;
                return this;
            }

            @Generated
            public SliceBuilder solarTerm(SolarTerm solarTerm) {
                this.solarTerm$value = solarTerm;
                this.solarTerm$set = true;
                return this;
            }

            @Generated
            public SliceBuilder climate(Optional<Holder<AgroClimaticZone>> climate) {
                this.climate$value = climate;
                this.climate$set = true;
                return this;
            }

            @Generated
            public SliceBuilder startSeason(Season startSeason) {
                this.startSeason$value = startSeason;
                this.startSeason$set = true;
                return this;
            }

            @Generated
            public SliceBuilder endSeason(Season endSeason) {
                this.endSeason$value = endSeason;
                this.endSeason$set = true;
                return this;
            }

            @Generated
            public SliceBuilder season(Season season) {
                this.season$value = season;
                this.season$set = true;
                return this;
            }

            @Generated
            public Slice build() {
                SolarTerm start$value = this.start$value;
                if (!this.start$set) {
                    start$value = Slice.$default$start();
                }
                SolarTerm end$value = this.end$value;
                if (!this.end$set) {
                    end$value = Slice.$default$end();
                }
                SolarTerm solarTerm$value = this.solarTerm$value;
                if (!this.solarTerm$set) {
                    solarTerm$value = Slice.$default$solarTerm();
                }
                Optional<Holder<AgroClimaticZone>> climate$value = this.climate$value;
                if (!this.climate$set) {
                    climate$value = Slice.$default$climate();
                }
                Season startSeason$value = this.startSeason$value;
                if (!this.startSeason$set) {
                    startSeason$value = Slice.$default$startSeason();
                }
                Season endSeason$value = this.endSeason$value;
                if (!this.endSeason$set) {
                    endSeason$value = Slice.$default$endSeason();
                }
                Season season$value = this.season$value;
                if (!this.season$set) {
                    season$value = Slice.$default$season();
                }
                return new Slice(start$value, end$value, solarTerm$value, climate$value, startSeason$value, endSeason$value, season$value);
            }

            @Generated
            public String toString() {
                return "SeasonCondition.Slice.SliceBuilder(start$value=" + String.valueOf(this.start$value) + ", end$value=" + String.valueOf(this.end$value) + ", solarTerm$value=" + String.valueOf(this.solarTerm$value) + ", climate$value=" + String.valueOf(this.climate$value) + ", startSeason$value=" + String.valueOf(this.startSeason$value) + ", endSeason$value=" + String.valueOf(this.endSeason$value) + ", season$value=" + String.valueOf(this.season$value) + ")";
            }
        }
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private final Slice require;

        public Builder(Slice require) {
            if (require == null) {
                throw new IllegalArgumentException("Require must not be null");
            }
            this.require = require;
        }

        @NotNull
        public LootItemCondition m_6409_() {
            return new SeasonCondition(this.require);
        }
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<SeasonCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void serialize(@NotNull JsonObject jsonObject, @NotNull SeasonCondition value, @NotNull JsonSerializationContext context) {
            JsonElement jsonelement = (JsonElement)CONDITION_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)value).getOrThrow(false, EclipticSeasons::logger);
            if (jsonelement.isJsonObject()) {
                JsonObject obj = jsonelement.getAsJsonObject();
                for (Map.Entry entry : obj.entrySet()) {
                    jsonObject.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
        }

        @NotNull
        public SeasonCondition deserialize(@NotNull JsonObject value, @NotNull JsonDeserializationContext context) {
            return (SeasonCondition)((Pair)CONDITION_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)value).getOrThrow(false, EclipticSeasons::logger)).getFirst();
        }
    }
}

