/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.registry;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Lifecycle;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.constant.tag.ClimateTypeBiomeTags;
import com.teamtea.eclipticseasons.api.data.climate.AgroClimaticZone;
import com.teamtea.eclipticseasons.api.data.crop.GrowParameter;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.holdersets.AndHolderSet;
import net.minecraftforge.registries.holdersets.NotHolderSet;
import net.minecraftforge.registries.holdersets.OrHolderSet;
import org.jetbrains.annotations.NotNull;

public class AgroClimateRegistry {
    public static final ResourceKey<AgroClimaticZone> TEMPERATE = AgroClimateRegistry.createKey("temperate");
    public static final ResourceKey<AgroClimaticZone> COLD = AgroClimateRegistry.createKey("cold");
    public static final ResourceKey<AgroClimaticZone> HOT = AgroClimateRegistry.createKey("hot");
    public static final ResourceKey<AgroClimaticZone> DESERT = AgroClimateRegistry.createKey("desert");
    public static final ResourceKey<AgroClimaticZone> NETHER = AgroClimateRegistry.createKey("nether");
    public static final ResourceKey<AgroClimaticZone> END = AgroClimateRegistry.createKey("end");
    private static HolderLookup.RegistryLookup<Biome> BIOME_REGISTRY_LOOKUP = null;
    private static HolderGetter<Biome> BIOME_HOLDER_GETTER = null;

    private static ResourceKey<AgroClimaticZone> createKey(String name) {
        return ResourceKey.m_135785_(ESRegistries.AGRO_CLIMATE, (ResourceLocation)EclipticSeasons.rl(name));
    }

    @SafeVarargs
    private static <T> HolderSet<T> and(HolderSet<T> ... values) {
        return new AndHolderSet(Arrays.stream(values).toList());
    }

    @SafeVarargs
    private static <T> HolderSet<T> or(HolderSet<T> ... values) {
        return new OrHolderSet(Arrays.stream(values).toList());
    }

    private static HolderSet<Biome> not(HolderSet<Biome> value) {
        return new NotHolderSet(BIOME_REGISTRY_LOOKUP, value);
    }

    private static HolderSet<Biome> get(TagKey<Biome> tagKey) {
        return BIOME_HOLDER_GETTER.m_254956_(tagKey);
    }

    public static void bootstrap(BootstapContext<AgroClimaticZone> context) {
        BIOME_HOLDER_GETTER = context.m_255420_(Registries.f_256952_);
        BIOME_REGISTRY_LOOKUP = new BiomeRegistryLookup(BIOME_HOLDER_GETTER);
        context.m_255272_(TEMPERATE, (Object)AgroClimaticZone.builder(AgroClimateRegistry.get(ClimateTypeBiomeTags.WARM_REGION)).add(Season.SPRING, 6).add(Season.SUMMER, 6).add(Season.AUTUMN, 6).add(Season.WINTER, 6).end());
        Map<Either<Season, SolarTerm>, List<Pair<Either<Season, SolarTerm>, Float>>> mapCold = AgroClimateRegistry.of(Either.right((Object)SolarTerm.BEGINNING_OF_SPRING), List.of(Pair.of((Object)Either.right((Object)SolarTerm.GREATER_COLD), (Object)Float.valueOf(0.8f))), Either.right((Object)SolarTerm.RAIN_WATER), List.of(Pair.of((Object)Either.right((Object)SolarTerm.WINTER_SOLSTICE), (Object)Float.valueOf(0.95f))), Either.right((Object)SolarTerm.INSECTS_AWAKENING), List.of(Pair.of((Object)Either.right((Object)SolarTerm.WINTER_SOLSTICE), (Object)Float.valueOf(1.0f))), Either.right((Object)SolarTerm.SPRING_EQUINOX), List.of(Pair.of((Object)Either.right((Object)SolarTerm.WINTER_SOLSTICE), (Object)Float.valueOf(0.8f)), Pair.of((Object)Either.right((Object)SolarTerm.BEGINNING_OF_SPRING), (Object)Float.valueOf(0.2f))), Either.right((Object)SolarTerm.FRESH_GREEN), List.of(Pair.of((Object)Either.right((Object)SolarTerm.BEGINNING_OF_SPRING), (Object)Float.valueOf(0.7f)), Pair.of((Object)Either.right((Object)SolarTerm.SPRING_EQUINOX), (Object)Float.valueOf(0.3f))), Either.right((Object)SolarTerm.GRAIN_RAIN), List.of(Pair.of((Object)Either.right((Object)SolarTerm.BEGINNING_OF_SPRING), (Object)Float.valueOf(0.5f)), Pair.of((Object)Either.right((Object)SolarTerm.SPRING_EQUINOX), (Object)Float.valueOf(0.5f))), Either.right((Object)SolarTerm.BEGINNING_OF_SUMMER), List.of(Pair.of((Object)Either.right((Object)SolarTerm.SPRING_EQUINOX), (Object)Float.valueOf(1.0f))), Either.right((Object)SolarTerm.LESSER_FULLNESS), List.of(Pair.of((Object)Either.right((Object)SolarTerm.SPRING_EQUINOX), (Object)Float.valueOf(0.8f)), Pair.of((Object)Either.right((Object)SolarTerm.BEGINNING_OF_SUMMER), (Object)Float.valueOf(0.2f))), Either.right((Object)SolarTerm.GRAIN_IN_EAR), List.of(Pair.of((Object)Either.right((Object)SolarTerm.SPRING_EQUINOX), (Object)Float.valueOf(0.6f)), Pair.of((Object)Either.right((Object)SolarTerm.BEGINNING_OF_SUMMER), (Object)Float.valueOf(0.4f))), Either.right((Object)SolarTerm.SUMMER_SOLSTICE), List.of(Pair.of((Object)Either.right((Object)SolarTerm.SPRING_EQUINOX), (Object)Float.valueOf(0.4f)), Pair.of((Object)Either.right((Object)SolarTerm.BEGINNING_OF_SUMMER), (Object)Float.valueOf(0.4f)), Pair.of((Object)Either.right((Object)SolarTerm.SUMMER_SOLSTICE), (Object)Float.valueOf(0.2f))), Either.right((Object)SolarTerm.LESSER_HEAT), List.of(Pair.of((Object)Either.right((Object)SolarTerm.SUMMER_SOLSTICE), (Object)Float.valueOf(0.4f)), Pair.of((Object)Either.right((Object)SolarTerm.BEGINNING_OF_AUTUMN), (Object)Float.valueOf(0.6f))), Either.right((Object)SolarTerm.GREATER_HEAT), List.of(Pair.of((Object)Either.right((Object)SolarTerm.BEGINNING_OF_AUTUMN), (Object)Float.valueOf(1.0f))), Either.right((Object)SolarTerm.BEGINNING_OF_AUTUMN), List.of(Pair.of((Object)Either.right((Object)SolarTerm.AUTUMNAL_EQUINOX), (Object)Float.valueOf(1.0f))), Either.right((Object)SolarTerm.END_OF_HEAT), List.of(Pair.of((Object)Either.right((Object)SolarTerm.AUTUMNAL_EQUINOX), (Object)Float.valueOf(0.4f)), Pair.of((Object)Either.right((Object)SolarTerm.BEGINNING_OF_WINTER), (Object)Float.valueOf(0.6f))), Either.right((Object)SolarTerm.WHITE_DEW), List.of(Pair.of((Object)Either.right((Object)SolarTerm.BEGINNING_OF_WINTER), (Object)Float.valueOf(1.0f))), Either.right((Object)SolarTerm.AUTUMNAL_EQUINOX), List.of(Pair.of((Object)Either.right((Object)SolarTerm.BEGINNING_OF_WINTER), (Object)Float.valueOf(0.8f)), Pair.of((Object)Either.right((Object)SolarTerm.WINTER_SOLSTICE), (Object)Float.valueOf(0.2f))), Either.right((Object)SolarTerm.COLD_DEW), List.of(Pair.of((Object)Either.right((Object)SolarTerm.BEGINNING_OF_WINTER), (Object)Float.valueOf(0.4f)), Pair.of((Object)Either.right((Object)SolarTerm.WINTER_SOLSTICE), (Object)Float.valueOf(0.6f))), Either.right((Object)SolarTerm.FIRST_FROST), List.of(Pair.of((Object)Either.right((Object)SolarTerm.WINTER_SOLSTICE), (Object)Float.valueOf(0.8f)), Pair.of((Object)Either.right((Object)SolarTerm.GREATER_COLD), (Object)Float.valueOf(0.2f))), Either.right((Object)SolarTerm.BEGINNING_OF_WINTER), List.of(Pair.of((Object)Either.right((Object)SolarTerm.SUMMER_SOLSTICE), (Object)Float.valueOf(1.0f))), Either.right((Object)SolarTerm.LIGHT_SNOW), List.of(Pair.of((Object)Either.right((Object)SolarTerm.SUMMER_SOLSTICE), (Object)Float.valueOf(0.6f)), Pair.of((Object)Either.right((Object)SolarTerm.GREATER_COLD), (Object)Float.valueOf(0.4f))), Either.right((Object)SolarTerm.HEAVY_SNOW), List.of(Pair.of((Object)Either.right((Object)SolarTerm.SUMMER_SOLSTICE), (Object)Float.valueOf(0.4f)), Pair.of((Object)Either.right((Object)SolarTerm.GREATER_COLD), (Object)Float.valueOf(0.6f))), Either.right((Object)SolarTerm.WINTER_SOLSTICE), List.of(Pair.of((Object)Either.right((Object)SolarTerm.GREATER_COLD), (Object)Float.valueOf(1.0f))), Either.right((Object)SolarTerm.LESSER_COLD), List.of(Pair.of((Object)Either.right((Object)SolarTerm.GREATER_COLD), (Object)Float.valueOf(0.8f))), Either.right((Object)SolarTerm.GREATER_COLD), List.of(Pair.of((Object)Either.right((Object)SolarTerm.GREATER_COLD), (Object)Float.valueOf(0.55f))));
        context.m_255272_(COLD, (Object)AgroClimaticZone.builder(AgroClimateRegistry.get(ClimateTypeBiomeTags.COLD_REGION)).mapping(mapCold).add(Season.WINTER, 3).add(Season.SPRING, 4).add(Season.SUMMER, 3).add(Season.AUTUMN, 4).add(Season.WINTER, 10).end());
        Map<Either<Season, SolarTerm>, List<Pair<Either<Season, SolarTerm>, Float>>> mapHot = AgroClimateRegistry.of(Either.right((Object)SolarTerm.BEGINNING_OF_SPRING), List.of(Pair.of((Object)Either.right((Object)SolarTerm.BEGINNING_OF_SPRING), (Object)Float.valueOf(1.0f))), Either.right((Object)SolarTerm.RAIN_WATER), List.of(Pair.of((Object)Either.right((Object)SolarTerm.BEGINNING_OF_SPRING), (Object)Float.valueOf(0.8f)), Pair.of((Object)Either.right((Object)SolarTerm.SPRING_EQUINOX), (Object)Float.valueOf(0.2f))), Either.right((Object)SolarTerm.INSECTS_AWAKENING), List.of(Pair.of((Object)Either.right((Object)SolarTerm.SPRING_EQUINOX), (Object)Float.valueOf(1.0f))), Either.right((Object)SolarTerm.SPRING_EQUINOX), List.of(Pair.of((Object)Either.right((Object)SolarTerm.SPRING_EQUINOX), (Object)Float.valueOf(0.8f)), Pair.of((Object)Either.right((Object)SolarTerm.BEGINNING_OF_SUMMER), (Object)Float.valueOf(0.2f))), Either.right((Object)SolarTerm.FRESH_GREEN), List.of(Pair.of((Object)Either.right((Object)SolarTerm.BEGINNING_OF_SUMMER), (Object)Float.valueOf(0.7f)), Pair.of((Object)Either.right((Object)SolarTerm.LESSER_FULLNESS), (Object)Float.valueOf(0.3f))), Either.right((Object)SolarTerm.GRAIN_RAIN), List.of(Pair.of((Object)Either.right((Object)SolarTerm.LESSER_FULLNESS), (Object)Float.valueOf(0.5f)), Pair.of((Object)Either.right((Object)SolarTerm.GRAIN_IN_EAR), (Object)Float.valueOf(0.5f))), Either.right((Object)SolarTerm.BEGINNING_OF_SUMMER), List.of(Pair.of((Object)Either.right((Object)SolarTerm.GRAIN_IN_EAR), (Object)Float.valueOf(1.0f))), Either.right((Object)SolarTerm.LESSER_FULLNESS), List.of(Pair.of((Object)Either.right((Object)SolarTerm.GRAIN_IN_EAR), (Object)Float.valueOf(0.3f)), Pair.of((Object)Either.right((Object)SolarTerm.SUMMER_SOLSTICE), (Object)Float.valueOf(0.7f))), Either.right((Object)SolarTerm.GRAIN_IN_EAR), List.of(Pair.of((Object)Either.right((Object)SolarTerm.SUMMER_SOLSTICE), (Object)Float.valueOf(0.8f)), Pair.of((Object)Either.right((Object)SolarTerm.GREATER_HEAT), (Object)Float.valueOf(0.2f))), Either.right((Object)SolarTerm.SUMMER_SOLSTICE), List.of(Pair.of((Object)Either.right((Object)SolarTerm.SUMMER_SOLSTICE), (Object)Float.valueOf(0.4f)), Pair.of((Object)Either.right((Object)SolarTerm.LESSER_HEAT), (Object)Float.valueOf(0.4f)), Pair.of((Object)Either.right((Object)SolarTerm.GREATER_HEAT), (Object)Float.valueOf(0.2f))), Either.right((Object)SolarTerm.LESSER_HEAT), List.of(Pair.of((Object)Either.right((Object)SolarTerm.GREATER_HEAT), (Object)Float.valueOf(1.0f))), Either.right((Object)SolarTerm.GREATER_HEAT), List.of(Pair.of((Object)Either.right((Object)SolarTerm.GREATER_HEAT), (Object)Float.valueOf(0.8f))), Either.right((Object)SolarTerm.BEGINNING_OF_AUTUMN), List.of(Pair.of((Object)Either.right((Object)SolarTerm.GREATER_HEAT), (Object)Float.valueOf(0.7f))), Either.right((Object)SolarTerm.END_OF_HEAT), List.of(Pair.of((Object)Either.right((Object)SolarTerm.GREATER_HEAT), (Object)Float.valueOf(0.95f))), Either.right((Object)SolarTerm.WHITE_DEW), List.of(Pair.of((Object)Either.right((Object)SolarTerm.SUMMER_SOLSTICE), (Object)Float.valueOf(0.97f))), Either.right((Object)SolarTerm.AUTUMNAL_EQUINOX), List.of(Pair.of((Object)Either.right((Object)SolarTerm.SUMMER_SOLSTICE), (Object)Float.valueOf(1.0f))), Either.right((Object)SolarTerm.COLD_DEW), List.of(Pair.of((Object)Either.right((Object)SolarTerm.SUMMER_SOLSTICE), (Object)Float.valueOf(0.8f)), Pair.of((Object)Either.right((Object)SolarTerm.BEGINNING_OF_AUTUMN), (Object)Float.valueOf(0.2f))), Either.right((Object)SolarTerm.FIRST_FROST), List.of(Pair.of((Object)Either.right((Object)SolarTerm.SUMMER_SOLSTICE), (Object)Float.valueOf(0.6f)), Pair.of((Object)Either.right((Object)SolarTerm.BEGINNING_OF_AUTUMN), (Object)Float.valueOf(0.4f))), Either.right((Object)SolarTerm.BEGINNING_OF_WINTER), List.of(Pair.of((Object)Either.right((Object)SolarTerm.BEGINNING_OF_AUTUMN), (Object)Float.valueOf(1.0f))), Either.right((Object)SolarTerm.LIGHT_SNOW), List.of(Pair.of((Object)Either.right((Object)SolarTerm.BEGINNING_OF_AUTUMN), (Object)Float.valueOf(0.6f)), Pair.of((Object)Either.right((Object)SolarTerm.AUTUMNAL_EQUINOX), (Object)Float.valueOf(0.4f))), Either.right((Object)SolarTerm.HEAVY_SNOW), List.of(Pair.of((Object)Either.right((Object)SolarTerm.AUTUMNAL_EQUINOX), (Object)Float.valueOf(0.4f)), Pair.of((Object)Either.right((Object)SolarTerm.BEGINNING_OF_WINTER), (Object)Float.valueOf(0.6f))), Either.right((Object)SolarTerm.WINTER_SOLSTICE), List.of(Pair.of((Object)Either.right((Object)SolarTerm.AUTUMNAL_EQUINOX), (Object)Float.valueOf(0.2f)), Pair.of((Object)Either.right((Object)SolarTerm.BEGINNING_OF_WINTER), (Object)Float.valueOf(0.8f))), Either.right((Object)SolarTerm.LESSER_COLD), List.of(Pair.of((Object)Either.right((Object)SolarTerm.BEGINNING_OF_WINTER), (Object)Float.valueOf(0.5f)), Pair.of((Object)Either.right((Object)SolarTerm.WINTER_SOLSTICE), (Object)Float.valueOf(0.5f))), Either.right((Object)SolarTerm.GREATER_COLD), List.of(Pair.of((Object)Either.right((Object)SolarTerm.WINTER_SOLSTICE), (Object)Float.valueOf(1.0f))));
        context.m_255272_(HOT, (Object)AgroClimaticZone.builder(AgroClimateRegistry.get(ClimateTypeBiomeTags.HOT_REGION)).mapping(mapHot).add(Season.SPRING, 4).add(Season.SUMMER, 14).add(Season.AUTUMN, 3).add(Season.WINTER, 3).end());
        context.m_255272_(NETHER, (Object)AgroClimaticZone.builder(AgroClimateRegistry.get((TagKey<Biome>)BiomeTags.f_207612_)).defaultMapping((Pair<Either<Season, SolarTerm>, Float>)Pair.of((Object)Either.left((Object)Season.SUMMER), (Object)Float.valueOf(0.25f))).end());
        context.m_255272_(END, (Object)AgroClimaticZone.builder(AgroClimateRegistry.get((TagKey<Biome>)BiomeTags.f_215818_)).growParameter(GrowParameter.builder().growChance(0.35f).fertileChance(0.5f).deathChance(0.01f).end()).end());
        BIOME_REGISTRY_LOOKUP = null;
        BIOME_HOLDER_GETTER = null;
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24) {
        if (k1 == null) {
            throw new IllegalArgumentException("First key cannot be null");
        }
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        return map;
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        if (k1 == null) {
            throw new IllegalArgumentException("First key cannot be null");
        }
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    public record BiomeRegistryLookup(HolderGetter<Biome> biomeHolderGetter) implements HolderLookup.RegistryLookup<Biome>
    {
        @NotNull
        public Optional<Holder.Reference<Biome>> m_254902_(@NotNull ResourceKey<Biome> pResourceKey) {
            return this.biomeHolderGetter.m_254902_(pResourceKey);
        }

        @NotNull
        public Optional<HolderSet.Named<Biome>> m_254901_(@NotNull TagKey<Biome> pTagKey) {
            return this.biomeHolderGetter.m_254901_(pTagKey);
        }

        @NotNull
        public Stream<Holder.Reference<Biome>> m_214062_() {
            return Stream.empty();
        }

        @NotNull
        public Stream<HolderSet.Named<Biome>> m_214063_() {
            return Stream.empty();
        }

        @NotNull
        public ResourceKey<? extends Registry<? extends Biome>> m_254879_() {
            return Registries.f_256952_;
        }

        public boolean m_254921_(@NotNull HolderOwner<Biome> pOwner) {
            return true;
        }

        @NotNull
        public Lifecycle m_254883_() {
            return Lifecycle.stable();
        }
    }
}

