/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.registry;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.climate.TemperateRain;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.misc.SolarTermValueMap;
import com.teamtea.eclipticseasons.api.data.weather.CustomRainBuilder;
import com.teamtea.eclipticseasons.api.util.fast.Enum2ObjectMap;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class BiomeRainRegistry {
    public static final ResourceKey<CustomRainBuilder> PLAIN = BiomeRainRegistry.createKey("plain");

    private static ResourceKey<CustomRainBuilder> createKey(String name) {
        return ResourceKey.m_135785_(ESRegistries.BIOME_RAIN, (ResourceLocation)EclipticSeasons.rl(name));
    }

    public static void bootstrap2(BootstapContext<CustomRainBuilder> context) {
        HolderGetter holderGetter = context.m_255420_(Registries.f_256952_);
        SolarTermValueMap<List<CustomRainBuilder.Weather>> solarTermValueMap = SolarTermValueMap.builder().solarTermMap(new Enum2ObjectMap(SolarTerm.class)).build();
        for (int i = 0; i < TemperateRain.collectValues().length; ++i) {
            TemperateRain temperateRain = TemperateRain.collectValues()[i];
            SolarTerm solarTerm = temperateRain.getSolarTerm();
            boolean se = solarTerm == SolarTerm.SPRING_EQUINOX;
            solarTermValueMap.solarTermMap().get().put(solarTerm, List.of(new CustomRainBuilder.Weather(se ? Optional.of(ServerLevel.f_263681_) : Optional.empty(), se ? Optional.of(ServerLevel.f_263704_) : Optional.empty(), se ? Optional.of(ServerLevel.f_263755_) : Optional.empty(), temperateRain.getRainChance(), temperateRain.getThunderChance(), List.of())));
        }
        context.m_255272_(PLAIN, (Object)new CustomRainBuilder((HolderSet<Biome>)HolderSet.m_205809_((Holder[])new Holder[]{holderGetter.m_255043_(Biomes.f_48202_)}), solarTermValueMap));
    }
}

