/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.registry;

import com.google.common.collect.ImmutableMap;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.biome.Humidity;
import com.teamtea.eclipticseasons.api.constant.crop.CropHumidityType;
import com.teamtea.eclipticseasons.api.constant.crop.CropSeasonType;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.constant.tag.CropClimateTags;
import com.teamtea.eclipticseasons.api.data.climate.AgroClimaticZone;
import com.teamtea.eclipticseasons.api.data.crop.CropGrowControlBuilder;
import com.teamtea.eclipticseasons.api.data.crop.GrowParameter;
import com.teamtea.eclipticseasons.api.util.backport.FakeBlockPredicate;
import com.teamtea.eclipticseasons.api.util.backport.FakeStatePropertiesPredicate;
import com.teamtea.eclipticseasons.api.util.fast.Enum2ObjectMap;
import com.teamtea.eclipticseasons.common.registry.AgroClimateRegistry;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class CropRegistry {
    private static final ResourceKey<CropGrowControlBuilder> base = CropRegistry.createKey("templates/wheat");
    public static final ResourceKey<CropGrowControlBuilder> SPRING = CropRegistry.createKey(CropSeasonType.SPRING);
    public static final ResourceKey<CropGrowControlBuilder> SUMMER = CropRegistry.createKey(CropSeasonType.SUMMER);
    public static final ResourceKey<CropGrowControlBuilder> AUTUMN = CropRegistry.createKey(CropSeasonType.AUTUMN);
    public static final ResourceKey<CropGrowControlBuilder> WINTER = CropRegistry.createKey(CropSeasonType.WINTER);
    public static final ResourceKey<CropGrowControlBuilder> SP_SU = CropRegistry.createKey(CropSeasonType.SP_SU);
    public static final ResourceKey<CropGrowControlBuilder> SP_AU = CropRegistry.createKey(CropSeasonType.SP_AU);
    public static final ResourceKey<CropGrowControlBuilder> SP_WI = CropRegistry.createKey(CropSeasonType.SP_WI);
    public static final ResourceKey<CropGrowControlBuilder> SU_AU = CropRegistry.createKey(CropSeasonType.SU_AU);
    public static final ResourceKey<CropGrowControlBuilder> SU_WI = CropRegistry.createKey(CropSeasonType.SU_WI);
    public static final ResourceKey<CropGrowControlBuilder> AU_WI = CropRegistry.createKey(CropSeasonType.AU_WI);
    public static final ResourceKey<CropGrowControlBuilder> SP_SU_AU = CropRegistry.createKey(CropSeasonType.SP_SU_AU);
    public static final ResourceKey<CropGrowControlBuilder> SP_SU_WI = CropRegistry.createKey(CropSeasonType.SP_SU_WI);
    public static final ResourceKey<CropGrowControlBuilder> SP_AU_WI = CropRegistry.createKey(CropSeasonType.SP_AU_WI);
    public static final ResourceKey<CropGrowControlBuilder> SU_AU_WI = CropRegistry.createKey(CropSeasonType.SU_AU_WI);
    public static final ResourceKey<CropGrowControlBuilder> ALL = CropRegistry.createKey(CropSeasonType.ALL);
    public static final ResourceKey<CropGrowControlBuilder> ARID = CropRegistry.createKey(CropHumidityType.ARID);
    public static final ResourceKey<CropGrowControlBuilder> ARID_DRY = CropRegistry.createKey(CropHumidityType.ARID_DRY);
    public static final ResourceKey<CropGrowControlBuilder> ARID_AVERAGE = CropRegistry.createKey(CropHumidityType.ARID_AVERAGE);
    public static final ResourceKey<CropGrowControlBuilder> ARID_MOIST = CropRegistry.createKey(CropHumidityType.ARID_MOIST);
    public static final ResourceKey<CropGrowControlBuilder> ARID_HUMID = CropRegistry.createKey(CropHumidityType.ARID_HUMID);
    public static final ResourceKey<CropGrowControlBuilder> DRY = CropRegistry.createKey(CropHumidityType.DRY);
    public static final ResourceKey<CropGrowControlBuilder> DRY_AVERAGE = CropRegistry.createKey(CropHumidityType.DRY_AVERAGE);
    public static final ResourceKey<CropGrowControlBuilder> DRY_MOIST = CropRegistry.createKey(CropHumidityType.DRY_MOIST);
    public static final ResourceKey<CropGrowControlBuilder> DRY_HUMID = CropRegistry.createKey(CropHumidityType.DRY_HUMID);
    public static final ResourceKey<CropGrowControlBuilder> AVERAGE = CropRegistry.createKey(CropHumidityType.AVERAGE);
    public static final ResourceKey<CropGrowControlBuilder> AVERAGE_MOIST = CropRegistry.createKey(CropHumidityType.AVERAGE_MOIST);
    public static final ResourceKey<CropGrowControlBuilder> AVERAGE_HUMID = CropRegistry.createKey(CropHumidityType.AVERAGE_HUMID);
    public static final ResourceKey<CropGrowControlBuilder> MOIST = CropRegistry.createKey(CropHumidityType.MOIST);
    public static final ResourceKey<CropGrowControlBuilder> MOIST_HUMID = CropRegistry.createKey(CropHumidityType.MOIST_HUMID);
    public static final ResourceKey<CropGrowControlBuilder> HUMID = CropRegistry.createKey(CropHumidityType.HUMID);
    private static HolderGetter<Block> blockHolderGetter;
    static final HolderSet.Direct<CropGrowControlBuilder> EMPTY_HOLDER_SET;

    public static <K extends Enum<K>, V> Enum2ObjectMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24) {
        if (k1 == null) {
            throw new IllegalArgumentException("First key cannot be null");
        }
        Class<K> enumType = k1.getDeclaringClass();
        Enum2ObjectMap<K, V> map = new Enum2ObjectMap<K, V>(enumType);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        return map;
    }

    private static ResourceKey<CropGrowControlBuilder> createKey(String name) {
        return ResourceKey.m_135785_(ESRegistries.CROP, (ResourceLocation)EclipticSeasons.rl(name));
    }

    public static ResourceKey<CropGrowControlBuilder> createKey(CropSeasonType name) {
        return ResourceKey.m_135785_(ESRegistries.CROP, (ResourceLocation)EclipticSeasons.rl("seasons/" + name.getRes().m_135815_().split("/")[1]));
    }

    public static ResourceKey<CropGrowControlBuilder> createKey(CropHumidityType name) {
        return ResourceKey.m_135785_(ESRegistries.CROP, (ResourceLocation)EclipticSeasons.rl("humidity/" + name.getRes().m_135815_().split("/")[1]));
    }

    private static TagKey<Block> createTagKey(ResourceKey<CropGrowControlBuilder> templateName) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)EclipticSeasons.rl("crops/" + templateName.m_135782_().m_135815_().split("/")[1]));
    }

    private static FakeBlockPredicate createTagPredicate(ResourceKey<CropGrowControlBuilder> templateName) {
        return new FakeBlockPredicate(Optional.of(blockHolderGetter.m_254956_(CropRegistry.createTagKey(templateName))), Optional.empty());
    }

    public static void bootstrap(BootstapContext<CropGrowControlBuilder> context) {
        Enum2ObjectMap<SolarTerm, GrowParameter> solarTermListEmpty = new Enum2ObjectMap<SolarTerm, GrowParameter>(SolarTerm.class);
        Enum2ObjectMap<Season, GrowParameter> seasonListEmpty = new Enum2ObjectMap<Season, GrowParameter>(Season.class);
        Enum2ObjectMap<Humidity, GrowParameter> humidListEmpty = new Enum2ObjectMap<Humidity, GrowParameter>(Humidity.class);
        Optional empty = Optional.empty();
        Optional<GrowParameter> emptyGP = Optional.empty();
        Optional<GrowParameter> emptyGP2 = Optional.empty();
        Optional<HolderSet<Block>> emptyBP = Optional.empty();
        blockHolderGetter = context.m_255420_(Registries.f_256747_);
        HolderGetter biomeHolderGetter = context.m_255420_(Registries.f_256952_);
        HolderGetter cropGetter = context.m_255420_(ESRegistries.CROP);
        HolderGetter cropClimateTypeHolderGetter = context.m_255420_(ESRegistries.AGRO_CLIMATE);
        HolderSet.Direct temperate = HolderSet.m_205809_((Holder[])new Holder[]{cropClimateTypeHolderGetter.m_255043_(AgroClimateRegistry.TEMPERATE)});
        Optional<HolderSet.Named> icePredicate = Optional.of(blockHolderGetter.m_254956_(BlockTags.f_13047_));
        context.m_255272_(SPRING, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(SPRING), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(1.25f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.3f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.0f).end())), seasonListEmpty, humidListEmpty, icePredicate));
        context.m_255272_(SUMMER, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(SUMMER), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(0.15f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.75f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(1.025f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.3f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.0f).end())), seasonListEmpty, humidListEmpty, icePredicate));
        context.m_255272_(AUTUMN, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(AUTUMN), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.97f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(1.025f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.75f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.3f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.0f).end())), seasonListEmpty, humidListEmpty, icePredicate));
        context.m_255272_(WINTER, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(WINTER), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.3f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.75f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.7f).end())), seasonListEmpty, humidListEmpty, emptyBP));
        context.m_255272_(SP_SU, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(SP_SU), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.5f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.6f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(1.01f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(1.025f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(0.05f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.05f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.05f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.05f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.0f).end())), seasonListEmpty, humidListEmpty, icePredicate));
        context.m_255272_(SP_AU, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(SP_AU), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.5f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.64f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.75f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(1.01f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.75f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(1.01f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.5f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.15f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.0f).end())), seasonListEmpty, humidListEmpty, icePredicate));
        context.m_255272_(SP_WI, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(SP_WI), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.64f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.75f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(1.025f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.12f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(0.15f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.15f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.25f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.6f).end())), seasonListEmpty, humidListEmpty, emptyBP));
        context.m_255272_(SU_AU, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(SU_AU), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.15f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(0.25f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.3f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(1.01f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.6f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.0f).end())), seasonListEmpty, humidListEmpty, icePredicate));
        context.m_255272_(SU_WI, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(SU_WI), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.3f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.01f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(0.02f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.6f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(1.025f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.15f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.05f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.6f).end())), seasonListEmpty, humidListEmpty, emptyBP));
        context.m_255272_(AU_WI, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(AU_WI), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.5f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(0.15f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.05f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.5f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.64f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.75f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.75f).end())), seasonListEmpty, humidListEmpty, emptyBP));
        context.m_255272_(SP_SU_AU, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(SP_SU_AU), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.35f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.5f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.64f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(1.01f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(1.025f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.5f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.0f).end())), seasonListEmpty, humidListEmpty, icePredicate));
        context.m_255272_(SP_SU_WI, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(SP_SU_WI), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(1.025f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(1.01f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(1.01f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(1.025f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.3f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.3f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.6f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.6f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.55f).end())), seasonListEmpty, humidListEmpty, emptyBP));
        context.m_255272_(SP_AU_WI, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(SP_AU_WI), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(1.025f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(1.01f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.25f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.45f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.6f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.65f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.6f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.55f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.5f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.5f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.45f).end())), seasonListEmpty, humidListEmpty, emptyBP));
        context.m_255272_(SU_AU_WI, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(SU_AU_WI), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(0.3f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.3f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.5f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(0.5f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.6f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.4f).end())), seasonListEmpty, humidListEmpty, emptyBP));
        context.m_255272_(ALL, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(ALL), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.45f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.55f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.6f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.5f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.48f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.45f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.4f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.37f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.35f).end())), seasonListEmpty, humidListEmpty, emptyBP));
        HolderSet.Named allHolderSet = (HolderSet.Named)cropClimateTypeHolderGetter.m_254901_(CropClimateTags.ALL).get();
        context.m_255272_(ARID, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(ARID), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(1.01f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(0.5f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(0.15f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(0.0f).fertileChance(0.8f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.0f).fertileChance(0.5f).end())), emptyBP));
        context.m_255272_(ARID_DRY, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(ARID_DRY), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.99f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(1.0f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(0.35f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(0.1f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.0f).end())), emptyBP));
        context.m_255272_(ARID_AVERAGE, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(ARID_AVERAGE), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.97f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(1.01f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(0.97f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(0.35f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.1f).end())), emptyBP));
        context.m_255272_(ARID_MOIST, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(ARID_MOIST), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.9f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(0.97f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(1.025f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(0.9f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.35f).end())), emptyBP));
        context.m_255272_(ARID_HUMID, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(ARID_HUMID), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.8f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(0.85f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(1.0f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(0.95f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.8f).end())), emptyBP));
        context.m_255272_(DRY, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(DRY), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.4f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(1.025f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(0.45f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(0.15f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.0f).end())), emptyBP));
        context.m_255272_(DRY_AVERAGE, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(DRY_AVERAGE), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.3f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(0.97f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(0.97f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(0.4f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.1f).end())), emptyBP));
        context.m_255272_(DRY_MOIST, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(DRY_MOIST), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.35f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(0.95f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(1.025f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(0.95f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.35f).end())), emptyBP));
        context.m_255272_(DRY_HUMID, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(DRY_HUMID), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.25f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(0.9f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(1.0f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(1.0f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.9f).end())), emptyBP));
        context.m_255272_(AVERAGE, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(AVERAGE), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.07f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(0.45f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(1.025f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(0.45f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.07f).end())), emptyBP));
        context.m_255272_(AVERAGE_MOIST, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(AVERAGE_MOIST), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.1f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(0.35f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(0.97f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(0.97f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.4f).end())), emptyBP));
        context.m_255272_(AVERAGE_HUMID, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(AVERAGE_HUMID), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.05f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(0.35f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(0.95f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(1.025f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.95f).end())), emptyBP));
        context.m_255272_(MOIST, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(MOIST), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.0f).fertileChance(0.8f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(0.15f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(0.45f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(1.025f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.5f).end())), emptyBP));
        context.m_255272_(MOIST_HUMID, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(MOIST_HUMID), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.0f).fertileChance(0.8f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(0.1f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(0.35f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(1.0f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(1.0f).end())), emptyBP));
        context.m_255272_(HUMID, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(HUMID), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.0f).fertileChance(0.5f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(0.0f).fertileChance(0.8f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(0.3f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(0.6f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(1.025f).end())), emptyBP));
        blockHolderGetter = null;
    }

    public static void bootstrap2(BootstapContext<CropGrowControlBuilder> context) {
        HolderGetter cropClimateTypeHolderGetter = context.m_255420_(ESRegistries.AGRO_CLIMATE);
        HolderSet.Direct temperate = HolderSet.m_205809_((Holder[])new Holder[]{cropClimateTypeHolderGetter.m_255043_(AgroClimateRegistry.TEMPERATE)});
        HolderGetter cropGetter = context.m_255420_(ESRegistries.CROP);
        Optional empty = Optional.empty();
        Optional<GrowParameter> emptyGP = Optional.empty();
        Optional<GrowParameter> emptyGP2 = Optional.empty();
        Enum2ObjectMap solarTermListEmpty = new Enum2ObjectMap(SolarTerm.class);
        Enum2ObjectMap<Season, GrowParameter> seasonListEmpty = new Enum2ObjectMap<Season, GrowParameter>(Season.class);
        Enum2ObjectMap<Humidity, GrowParameter> humidListEmpty = new Enum2ObjectMap<Humidity, GrowParameter>(Humidity.class);
        Optional emptyBP = Optional.empty();
        context.m_255272_(CropRegistry.createKey("wheat"), (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, new FakeBlockPredicate(Optional.of(HolderSet.m_205809_((Holder[])new Holder[]{Blocks.f_50092_.m_204297_()})), FakeStatePropertiesPredicate.Builder.properties().hasProperty((Property<?>)CropBlock.f_52244_, 3).build()), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[]{cropGetter.m_255043_(SP_SU), cropGetter.m_255043_(AVERAGE_MOIST)}), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(Map.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.9f).fertileChance(0.8f).deathChance(0.01f).deadState(Blocks.f_50092_.m_49966_()).end())), seasonListEmpty, humidListEmpty, Optional.empty()));
    }

    static {
        EMPTY_HOLDER_SET = HolderSet.m_205800_(List.of());
    }
}

