/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.registry;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.constant.tag.ClimateTypeBiomeTags;
import com.teamtea.eclipticseasons.api.data.misc.SolarTermValueMap;
import com.teamtea.eclipticseasons.api.data.season.SeasonCycle;
import com.teamtea.eclipticseasons.common.registry.AgroClimateRegistry;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import com.teamtea.eclipticseasons.common.registry.SeasonPhaseRegistry;
import java.util.Arrays;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.holdersets.AndHolderSet;
import net.minecraftforge.registries.holdersets.NotHolderSet;
import net.minecraftforge.registries.holdersets.OrHolderSet;

public class SeasonCycleRegistry {
    public static final ResourceKey<SeasonCycle> MONSOON = SeasonCycleRegistry.createKey("monsoon");
    public static final ResourceKey<SeasonCycle> COLD = SeasonCycleRegistry.createKey("cold");
    public static final ResourceKey<SeasonCycle> HOT = SeasonCycleRegistry.createKey("hot");

    private static ResourceKey<SeasonCycle> createKey(String name) {
        return ResourceKey.m_135785_(ESRegistries.SEASON_CYCLE, (ResourceLocation)EclipticSeasons.rl(name));
    }

    @SafeVarargs
    private static <T> HolderSet<T> and(HolderSet<T> ... values) {
        return new AndHolderSet(Arrays.stream(values).toList());
    }

    @SafeVarargs
    private static <T> HolderSet<T> or(HolderSet<T> ... values) {
        return new OrHolderSet(Arrays.stream(values).toList());
    }

    private static HolderSet<Biome> not(AgroClimateRegistry.BiomeRegistryLookup biomeRegistryLookup, HolderSet<Biome> value) {
        return new NotHolderSet((HolderLookup.RegistryLookup)biomeRegistryLookup, value);
    }

    public static void bootstrap(BootstapContext<SeasonCycle> context) {
        HolderGetter getter = context.m_255420_(Registries.f_256952_);
        HolderGetter lookuped = context.m_255420_(ESRegistries.SEASON_PHASE);
        AgroClimateRegistry.BiomeRegistryLookup lazyLookup = new AgroClimateRegistry.BiomeRegistryLookup((HolderGetter<Biome>)getter);
        context.m_255272_(MONSOON, (Object)new SeasonCycle((HolderSet<Biome>)getter.m_254956_(ClimateTypeBiomeTags.MONSOONAL), SolarTermValueMap.builder().putSolarTerm(SolarTerm.BEGINNING_OF_WINTER, lookuped.m_255043_(SeasonPhaseRegistry.DRY_START)).putSolarTerm(SolarTerm.LIGHT_SNOW, lookuped.m_255043_(SeasonPhaseRegistry.DRY_START)).putSolarTerm(SolarTerm.HEAVY_SNOW, lookuped.m_255043_(SeasonPhaseRegistry.DRY_START)).putSolarTerm(SolarTerm.WINTER_SOLSTICE, lookuped.m_255043_(SeasonPhaseRegistry.DRY_START)).putSolarTerm(SolarTerm.LESSER_COLD, lookuped.m_255043_(SeasonPhaseRegistry.DRY_MIDDLE)).putSolarTerm(SolarTerm.GREATER_COLD, lookuped.m_255043_(SeasonPhaseRegistry.DRY_MIDDLE)).putSolarTerm(SolarTerm.BEGINNING_OF_SPRING, lookuped.m_255043_(SeasonPhaseRegistry.DRY_MIDDLE)).putSolarTerm(SolarTerm.RAIN_WATER, lookuped.m_255043_(SeasonPhaseRegistry.DRY_MIDDLE)).putSolarTerm(SolarTerm.INSECTS_AWAKENING, lookuped.m_255043_(SeasonPhaseRegistry.DRY_END)).putSolarTerm(SolarTerm.SPRING_EQUINOX, lookuped.m_255043_(SeasonPhaseRegistry.DRY_END)).putSolarTerm(SolarTerm.FRESH_GREEN, lookuped.m_255043_(SeasonPhaseRegistry.DRY_END)).putSolarTerm(SolarTerm.GRAIN_RAIN, lookuped.m_255043_(SeasonPhaseRegistry.DRY_END)).putSolarTerm(SolarTerm.BEGINNING_OF_SUMMER, lookuped.m_255043_(SeasonPhaseRegistry.RAIN_START)).putSolarTerm(SolarTerm.LESSER_FULLNESS, lookuped.m_255043_(SeasonPhaseRegistry.RAIN_MIDDLE)).putSolarTerm(SolarTerm.GRAIN_IN_EAR, lookuped.m_255043_(SeasonPhaseRegistry.RAIN_MIDDLE)).putSolarTerm(SolarTerm.SUMMER_SOLSTICE, lookuped.m_255043_(SeasonPhaseRegistry.RAIN_END)).putSolarTerm(SolarTerm.LESSER_HEAT, lookuped.m_255043_(SeasonPhaseRegistry.RAIN_END)).putSolarTerm(SolarTerm.GREATER_HEAT, lookuped.m_255043_(SeasonPhaseRegistry.RAIN_END)).putSolarTerm(SolarTerm.BEGINNING_OF_AUTUMN, lookuped.m_255043_(SeasonPhaseRegistry.RAIN_END)).putSolarTerm(SolarTerm.END_OF_HEAT, lookuped.m_255043_(SeasonPhaseRegistry.WET_START)).putSolarTerm(SolarTerm.WHITE_DEW, lookuped.m_255043_(SeasonPhaseRegistry.WET_START)).putSolarTerm(SolarTerm.AUTUMNAL_EQUINOX, lookuped.m_255043_(SeasonPhaseRegistry.WET_MIDDLE)).putSolarTerm(SolarTerm.COLD_DEW, lookuped.m_255043_(SeasonPhaseRegistry.WET_MIDDLE)).putSolarTerm(SolarTerm.FIRST_FROST, lookuped.m_255043_(SeasonPhaseRegistry.WET_END)).build()));
        context.m_255272_(COLD, (Object)new SeasonCycle((HolderSet<Biome>)getter.m_254956_(ClimateTypeBiomeTags.COLD_REGION), SolarTermValueMap.builder().putSolarTerm(SolarTerm.BEGINNING_OF_SPRING, lookuped.m_255043_(SeasonPhaseRegistry.COLD_BEGINNING_OF_SPRING)).putSolarTerm(SolarTerm.RAIN_WATER, lookuped.m_255043_(SeasonPhaseRegistry.COLD_RAIN_WATER)).putSolarTerm(SolarTerm.INSECTS_AWAKENING, lookuped.m_255043_(SeasonPhaseRegistry.COLD_INSECTS_AWAKENING)).putSolarTerm(SolarTerm.SPRING_EQUINOX, lookuped.m_255043_(SeasonPhaseRegistry.COLD_SPRING_EQUINOX)).putSolarTerm(SolarTerm.FRESH_GREEN, lookuped.m_255043_(SeasonPhaseRegistry.COLD_FRESH_GREEN)).putSolarTerm(SolarTerm.GRAIN_RAIN, lookuped.m_255043_(SeasonPhaseRegistry.COLD_GRAIN_RAIN)).putSolarTerm(SolarTerm.BEGINNING_OF_SUMMER, lookuped.m_255043_(SeasonPhaseRegistry.COLD_BEGINNING_OF_SUMMER)).putSolarTerm(SolarTerm.LESSER_FULLNESS, lookuped.m_255043_(SeasonPhaseRegistry.COLD_LESSER_FULLNESS)).putSolarTerm(SolarTerm.GRAIN_IN_EAR, lookuped.m_255043_(SeasonPhaseRegistry.COLD_GRAIN_IN_EAR)).putSolarTerm(SolarTerm.SUMMER_SOLSTICE, lookuped.m_255043_(SeasonPhaseRegistry.COLD_SUMMER_SOLSTICE)).putSolarTerm(SolarTerm.LESSER_HEAT, lookuped.m_255043_(SeasonPhaseRegistry.COLD_LESSER_HEAT)).putSolarTerm(SolarTerm.GREATER_HEAT, lookuped.m_255043_(SeasonPhaseRegistry.COLD_GREATER_HEAT)).putSolarTerm(SolarTerm.BEGINNING_OF_AUTUMN, lookuped.m_255043_(SeasonPhaseRegistry.COLD_BEGINNING_OF_AUTUMN)).putSolarTerm(SolarTerm.END_OF_HEAT, lookuped.m_255043_(SeasonPhaseRegistry.COLD_END_OF_HEAT)).putSolarTerm(SolarTerm.WHITE_DEW, lookuped.m_255043_(SeasonPhaseRegistry.COLD_WHITE_DEW)).putSolarTerm(SolarTerm.AUTUMNAL_EQUINOX, lookuped.m_255043_(SeasonPhaseRegistry.COLD_AUTUMNAL_EQUINOX)).putSolarTerm(SolarTerm.COLD_DEW, lookuped.m_255043_(SeasonPhaseRegistry.COLD_COLD_DEW)).putSolarTerm(SolarTerm.FIRST_FROST, lookuped.m_255043_(SeasonPhaseRegistry.COLD_FIRST_FROST)).putSolarTerm(SolarTerm.BEGINNING_OF_WINTER, lookuped.m_255043_(SeasonPhaseRegistry.COLD_BEGINNING_OF_WINTER)).putSolarTerm(SolarTerm.LIGHT_SNOW, lookuped.m_255043_(SeasonPhaseRegistry.COLD_LIGHT_SNOW)).putSolarTerm(SolarTerm.HEAVY_SNOW, lookuped.m_255043_(SeasonPhaseRegistry.COLD_HEAVY_SNOW)).putSolarTerm(SolarTerm.WINTER_SOLSTICE, lookuped.m_255043_(SeasonPhaseRegistry.COLD_WINTER_SOLSTICE)).putSolarTerm(SolarTerm.LESSER_COLD, lookuped.m_255043_(SeasonPhaseRegistry.COLD_LESSER_COLD)).putSolarTerm(SolarTerm.GREATER_COLD, lookuped.m_255043_(SeasonPhaseRegistry.COLD_GREATER_COLD)).build()));
        context.m_255272_(HOT, (Object)new SeasonCycle(SeasonCycleRegistry.and(new HolderSet[]{getter.m_254956_(ClimateTypeBiomeTags.HOT_REGION), SeasonCycleRegistry.not(lazyLookup, (HolderSet<Biome>)getter.m_254956_(ClimateTypeBiomeTags.MONSOONAL))}), SolarTermValueMap.builder().putSolarTerm(SolarTerm.BEGINNING_OF_SPRING, lookuped.m_255043_(SeasonPhaseRegistry.HOT_BEGINNING_OF_SPRING)).putSolarTerm(SolarTerm.RAIN_WATER, lookuped.m_255043_(SeasonPhaseRegistry.HOT_RAIN_WATER)).putSolarTerm(SolarTerm.INSECTS_AWAKENING, lookuped.m_255043_(SeasonPhaseRegistry.HOT_INSECTS_AWAKENING)).putSolarTerm(SolarTerm.SPRING_EQUINOX, lookuped.m_255043_(SeasonPhaseRegistry.HOT_SPRING_EQUINOX)).putSolarTerm(SolarTerm.FRESH_GREEN, lookuped.m_255043_(SeasonPhaseRegistry.HOT_FRESH_GREEN)).putSolarTerm(SolarTerm.GRAIN_RAIN, lookuped.m_255043_(SeasonPhaseRegistry.HOT_GRAIN_RAIN)).putSolarTerm(SolarTerm.BEGINNING_OF_SUMMER, lookuped.m_255043_(SeasonPhaseRegistry.HOT_BEGINNING_OF_SUMMER)).putSolarTerm(SolarTerm.LESSER_FULLNESS, lookuped.m_255043_(SeasonPhaseRegistry.HOT_LESSER_FULLNESS)).putSolarTerm(SolarTerm.GRAIN_IN_EAR, lookuped.m_255043_(SeasonPhaseRegistry.HOT_GRAIN_IN_EAR)).putSolarTerm(SolarTerm.SUMMER_SOLSTICE, lookuped.m_255043_(SeasonPhaseRegistry.HOT_SUMMER_SOLSTICE)).putSolarTerm(SolarTerm.LESSER_HEAT, lookuped.m_255043_(SeasonPhaseRegistry.HOT_LESSER_HEAT)).putSolarTerm(SolarTerm.GREATER_HEAT, lookuped.m_255043_(SeasonPhaseRegistry.HOT_GREATER_HEAT)).putSolarTerm(SolarTerm.BEGINNING_OF_AUTUMN, lookuped.m_255043_(SeasonPhaseRegistry.HOT_BEGINNING_OF_AUTUMN)).putSolarTerm(SolarTerm.END_OF_HEAT, lookuped.m_255043_(SeasonPhaseRegistry.HOT_END_OF_HEAT)).putSolarTerm(SolarTerm.WHITE_DEW, lookuped.m_255043_(SeasonPhaseRegistry.HOT_WHITE_DEW)).putSolarTerm(SolarTerm.AUTUMNAL_EQUINOX, lookuped.m_255043_(SeasonPhaseRegistry.HOT_AUTUMNAL_EQUINOX)).putSolarTerm(SolarTerm.COLD_DEW, lookuped.m_255043_(SeasonPhaseRegistry.HOT_COLD_DEW)).putSolarTerm(SolarTerm.FIRST_FROST, lookuped.m_255043_(SeasonPhaseRegistry.HOT_FIRST_FROST)).putSolarTerm(SolarTerm.BEGINNING_OF_WINTER, lookuped.m_255043_(SeasonPhaseRegistry.HOT_BEGINNING_OF_WINTER)).putSolarTerm(SolarTerm.LIGHT_SNOW, lookuped.m_255043_(SeasonPhaseRegistry.HOT_LIGHT_SNOW)).putSolarTerm(SolarTerm.HEAVY_SNOW, lookuped.m_255043_(SeasonPhaseRegistry.HOT_HEAVY_SNOW)).putSolarTerm(SolarTerm.WINTER_SOLSTICE, lookuped.m_255043_(SeasonPhaseRegistry.HOT_WINTER_SOLSTICE)).putSolarTerm(SolarTerm.LESSER_COLD, lookuped.m_255043_(SeasonPhaseRegistry.HOT_LESSER_COLD)).putSolarTerm(SolarTerm.GREATER_COLD, lookuped.m_255043_(SeasonPhaseRegistry.HOT_GREATER_COLD)).build()));
    }
}

