/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.resource;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.DetectedVersion;
import net.minecraft.WorldVersion;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.PathPackResources;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ESModFilePackResources
extends PathPackResources {
    protected final IModFile modFile;
    protected final String sourcePath;
    private final PackMetadataSection bindSection;

    public ESModFilePackResources(String modid, String name, IModFile modFile, String sourcePath) {
        super(name, true, modFile.findResource(new String[]{sourcePath}));
        this.modFile = modFile;
        this.sourcePath = sourcePath;
        this.bindSection = new PackMetadataSection((Component)Component.m_237113_((String)modid), DetectedVersion.f_132476_.m_264084_(PackType.SERVER_DATA), Arrays.stream(PackType.values()).collect(Collectors.toMap(Function.identity(), arg_0 -> ((WorldVersion)DetectedVersion.f_132476_).m_264084_(arg_0))));
    }

    public ESModFilePackResources(String name, IModFile modFile, String sourcePath) {
        this("eclipticseasons", name, modFile, sourcePath);
    }

    @NotNull
    protected Path resolve(String ... paths) {
        String[] allPaths = new String[paths.length + 1];
        allPaths[0] = this.sourcePath;
        System.arraycopy(paths, 0, allPaths, 1, paths.length);
        return this.modFile.findResource(allPaths);
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> pDeserializer) throws IOException {
        IoSupplier iosupplier = this.m_8017_(new String[]{"pack.mcmeta"});
        if (iosupplier == null) {
            return (T)(pDeserializer == PackMetadataSection.f_243696_ ? this.bindSection : null);
        }
        try (InputStream inputstream = (InputStream)iosupplier.m_247737_();){
            Object object = ESModFilePackResources.m_10214_(pDeserializer, (InputStream)inputstream);
            return (T)object;
        }
    }

    public void m_8031_(PackType type, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
        if (type == PackType.CLIENT_RESOURCES && this.sourcePath.equals("resourcepacks/extra_snow")) {
            try {
                if (!((Boolean)CommonConfig.Resource.extraSnow.get()).booleanValue()) {
                    return;
                }
            }
            catch (Exception e) {
                EclipticSeasons.logger(e);
            }
        }
        super.m_8031_(type, namespace, path, resourceOutput);
    }
}

