/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.compat;

import com.teamtea.eclipticseasons.compat.Platform;
import com.teamtea.eclipticseasons.compat.theoneprobe.TOPReflector;
import java.util.List;
import lombok.Generated;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;

public class CompatModule {
    private static boolean oculus = false;

    public static void init() {
        oculus = Platform.isModLoaded("oculus");
    }

    public static void register(IEventBus gameBus, IEventBus modBus) {
    }

    public static void onInterModEnqueue(InterModEnqueueEvent event) {
        event.enqueueWork(TOPReflector::init);
    }

    public static void setup() {
    }

    @Generated
    public static boolean isOculus() {
        return oculus;
    }

    public static class ClientConfig {
        public static ForgeConfigSpec.BooleanValue unifiedSnowyBlockShading;

        public static void load(ForgeConfigSpec.Builder builder) {
            builder.push("Compat");
            if (CompatModule.isOculus()) {
                builder.push("Oculus");
                unifiedSnowyBlockShading = builder.comment("Unify the shading and surface parameters of snow-covered blocks.").define("UnifiedSnowyBlockShading", true);
                builder.pop();
            }
            builder.pop();
        }
    }

    public static class CommonConfig {
        public static ForgeConfigSpec.BooleanValue sereneSeasons;
        public static ForgeConfigSpec.BooleanValue sereneSeasonsIgnoreSapling;
        public static ForgeConfigSpec.BooleanValue sereneSeasonBasedHumidity;
        public static ForgeConfigSpec.ConfigValue<List<? extends String>> modsWithoutSereneSeasonBasedHumidity;
        public static ForgeConfigSpec.BooleanValue fixBiome;
        public static ForgeConfigSpec.DoubleValue weatherVotePercent;

        public static void load(ForgeConfigSpec.Builder builder) {
            builder.push("Compat");
            sereneSeasons = builder.comment("Compatible with mods using SereneSeasons' CropTag.").define("SereneSeasonsCropTag", true);
            sereneSeasonsIgnoreSapling = builder.comment("If true, saplings will be ignored when applying Serene Seasons crop tags.\nSet to false if you want saplings to also follow seasonal crop rules.").define("SereneSeasonsCropTagIgnoreSapling", true);
            sereneSeasonBasedHumidity = builder.comment("Crops should get automatic humidity values based on seasons from Serene Season Crop Tag.").define("SereneSeasonCropTagBasedHumidity", true);
            modsWithoutSereneSeasonBasedHumidity = builder.comment("A blacklist of mods whose crops should NOT get automatic humidity values based on seasons.\nAdd mod IDs here to prevent seasonal humidity assignment.\nExample: [\"vinery\", \"meadow\"]").defineListAllowEmpty("ModsWithoutSereneSeasonBasedHumidity", List::of, o -> o instanceof String);
            fixBiome = builder.comment("If a mod tries to query biome precipitation using the raw method, would adjust it to correctly ignore small biomes like rivers.").define("FixBiomePrecipitation", true);
            weatherVotePercent = builder.comment("When a mod tries to query global weather parameters directly instead of using our API, Solar Weather will determine the result based on a weighted vote from the areas around players.").defineInRange("WeatherVotePercent", 0.5, 0.0, 1.0);
            builder.pop();
        }
    }
}

