/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.compat.vanilla;

import com.teamtea.eclipticseasons.api.EclipticSeasonsApi;
import com.teamtea.eclipticseasons.api.constant.climate.ISnowTerm;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.constant.tag.ClimateTypeBiomeTags;
import com.teamtea.eclipticseasons.api.misc.IBiomeTagHolder;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLLoader;

public class VanillaWeather {
    private static final IntProvider THUNDER_DELAY = UniformInt.m_146622_((int)12000, (int)180000);

    public static boolean isInWinter(Level level) {
        return EclipticSeasonsApi.getInstance().getSolarTerm(level).getSeason() == Season.WINTER;
    }

    public static boolean isInSummer(Level level) {
        return EclipticSeasonsApi.getInstance().getSolarTerm(level).getSeason() == Season.SUMMER;
    }

    public static Biome.Precipitation handlePrecipitationAt(Biome biome, BlockPos pos) {
        Level level = VanillaWeather.getValidLevel(biome);
        return VanillaWeather.handlePrecipitationAt(level, biome, pos);
    }

    public static boolean hasMonsoonalPrecipitation(Biome biome) {
        Level level = VanillaWeather.getValidLevel(biome);
        return VanillaWeather.hasPrecipitation(level, biome);
    }

    public static boolean hasPrecipitation(Level level, Biome biome) {
        SolarTerm solarTerm = EclipticSeasonsApi.getInstance().getSolarTerm(level);
        boolean hasPrecipitation = biome.getModifiedClimateSettings().f_263819_();
        TagKey<Biome> tag = ((IBiomeTagHolder)biome).eclipticseasons$getBindTag();
        if (tag.equals(ClimateTypeBiomeTags.MONSOONAL)) {
            Season season = solarTerm.getSeason();
            hasPrecipitation = season == Season.SUMMER || season == Season.AUTUMN;
        }
        return hasPrecipitation;
    }

    public static Biome.Precipitation handlePrecipitationAt(Level level, Biome biome, BlockPos pos) {
        Biome.Precipitation resultPrecipitation = Biome.Precipitation.NONE;
        SolarTerm solarTerm = EclipticSeasonsApi.getInstance().getSolarTerm(level);
        boolean hasPrecipitation = VanillaWeather.hasPrecipitation(level, biome);
        if (hasPrecipitation) {
            resultPrecipitation = biome.m_198904_(pos) ? Biome.Precipitation.SNOW : Biome.Precipitation.RAIN;
            ISnowTerm snowTerm = SolarTerm.getSnowTerm(biome, level instanceof ServerLevel, EclipticUtil.getSnowTempChange(level));
            boolean flag_cold = snowTerm.maySnow(solarTerm, biome, pos, level instanceof ServerLevel);
            if (resultPrecipitation == Biome.Precipitation.RAIN) {
                if (flag_cold) {
                    resultPrecipitation = Biome.Precipitation.SNOW;
                }
            } else if (!flag_cold) {
                resultPrecipitation = Biome.Precipitation.RAIN;
            }
        }
        return resultPrecipitation;
    }

    public static Biome.Precipitation getRainOrSnow(Level level, Biome biome, BlockPos pos) {
        return !level.m_46471_() ? Biome.Precipitation.NONE : VanillaWeather.handlePrecipitationAt(level, biome, pos);
    }

    public static Level getValidLevel(Biome biome) {
        boolean isOnServer;
        boolean bl = isOnServer = FMLLoader.getDist() == Dist.DEDICATED_SERVER;
        if (isOnServer) {
            return WeatherManager.getMainServerLevel();
        }
        return VanillaWeather.getUsingClientLevel() == null ? WeatherManager.getMainServerLevel() : VanillaWeather.getUsingClientLevel();
    }

    public static Level getUsingClientLevel() {
        for (Level level : WeatherManager.BIOME_WEATHER_LIST.keySet()) {
            if (level instanceof ServerLevel) continue;
            return level;
        }
        return null;
    }

    public static int replaceThunderDelay(Level level, Integer call) {
        switch (EclipticSeasonsApi.getInstance().getSolarTerm(level).getSeason()) {
            case SPRING: {
                return Mth.m_14045_((int)(call - 10000), (int)0, (int)THUNDER_DELAY.m_142737_());
            }
            case SUMMER: {
                return Mth.m_14045_((int)(call - 20000), (int)0, (int)THUNDER_DELAY.m_142737_());
            }
            case AUTUMN: {
                return Mth.m_14045_((int)(call + 20000), (int)0, (int)(THUNDER_DELAY.m_142737_() + 20000));
            }
            case WINTER: {
                return Mth.m_14045_((int)(call + 50000), (int)0, (int)(THUNDER_DELAY.m_142737_() + 50000));
            }
        }
        return call;
    }

    public static int replaceRainDelay(Level level, Integer call) {
        switch (EclipticSeasonsApi.getInstance().getSolarTerm(level).getSeason()) {
            case SPRING: {
                return Mth.m_14045_((int)(call - 20000), (int)0, (int)ServerLevel.f_263704_.m_142737_());
            }
            case SUMMER: {
                return Mth.m_14045_((int)(call - 10000), (int)0, (int)ServerLevel.f_263704_.m_142737_());
            }
            case AUTUMN: {
                return Mth.m_14045_((int)(call + 5000), (int)0, (int)ServerLevel.f_263704_.m_142737_());
            }
            case WINTER: {
                return Mth.m_14045_((int)(call + 20000), (int)0, (int)(ServerLevel.f_263704_.m_142737_() + 20000));
            }
        }
        return call;
    }
}

