/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.data.general.model;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.common.block.HygrometerBlock;
import com.teamtea.eclipticseasons.common.registry.BlockRegistry;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class BlockStatesDataProvider
extends BlockStateProvider {
    private final ExistingFileHelper existingFileHelper;

    public BlockStatesDataProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "eclipticseasons", existingFileHelper);
        this.existingFileHelper = existingFileHelper;
    }

    protected void registerStatesAndModels() {
        for (RegistryObject<Block> holder : List.of(BlockRegistry.calendar, BlockRegistry.pinwheel_blue, BlockRegistry.pinwheel_orange, BlockRegistry.pinwheel_lime)) {
            this.getVariantBuilder((Block)holder.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(BlockStatesDataProvider.resourceBlock(holder.getId().m_135815_()))).rotationY(BlockStatesDataProvider.getRotateYByFacing((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_))).build(), new Property[0]);
        }
        for (RegistryObject<Block> holder : List.of(BlockRegistry.hygrometer)) {
            this.getVariantBuilder((Block)holder.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(BlockStatesDataProvider.resourceBlock(holder.getId().m_135815_()).m_135815_() + "_" + HygrometerBlock.getHumidityLevelFromPower((Integer)state.m_61143_((Property)HygrometerBlock.POWER)), BlockStatesDataProvider.resourceBlock(holder.getId().m_135815_()))).texture("1", BlockStatesDataProvider.resourceBlock(holder.getId().m_135815_() + "_light_" + HygrometerBlock.getHumidityLevelFromPower((Integer)state.m_61143_((Property)HygrometerBlock.POWER))))).rotationY(BlockStatesDataProvider.getRotateYByFacing((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_))).build(), new Property[0]);
        }
        for (RegistryObject<Block> holder : List.of(BlockRegistry.ice_cauldron, BlockRegistry.snow_cauldron)) {
            this.getVariantBuilder((Block)holder.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(BlockStatesDataProvider.resourceBlock(holder.getId().m_135815_()).m_135815_(), "minecraft:block/powder_snow_cauldron_full")).texture("content", holder == BlockRegistry.ice_cauldron ? "minecraft:block/ice" : "minecraft:block/snow")).build(), new Property[0]);
        }
        this.addSimple((Block)BlockRegistry.wind_chimes.get());
        this.addSimple((Block)BlockRegistry.paper_wind_chimes.get());
        this.addSimple((Block)BlockRegistry.bamboo_wind_chimes.get());
        this.addSimple((Block)BlockRegistry.block_in_wooden_grate_block.get());
        for (Block block : List.of((Block)BlockRegistry.greenhouse_core_container.get(), (Block)BlockRegistry.spring_greenhouse_core.get(), (Block)BlockRegistry.summer_greenhouse_core.get(), (Block)BlockRegistry.autumn_greenhouse_core.get(), (Block)BlockRegistry.winter_greenhouse_core.get())) {
            this.simpleBlockWithItem(block, (ModelFile)((BlockModelBuilder)this.models().cubeAll(this.blockName(block), EclipticSeasons.rl("block/green_house_core_particle"))).texture("particle", EclipticSeasons.rl("block/green_house_core_particle")));
        }
        for (Block block : List.of((Block)BlockRegistry.season_quest_ceiling_hanging_sign.get(), (Block)BlockRegistry.season_quest_wall_hanging_sign.get())) {
            this.simpleBlockWithItem(block, (ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.blockName(block), new ResourceLocation("block/air"))).texture("particle", new ResourceLocation("block/oak_planks")));
        }
    }

    public void addSimple(Block block) {
        this.simpleBlock(block, (ModelFile)this.models().getExistingFile(BlockStatesDataProvider.resourceBlock(this.blockName(block))));
    }

    private String blockName(Block block) {
        return BuiltInRegistries.f_256975_.m_7981_((Object)block).m_135815_();
    }

    public static ResourceLocation resourceBlock(String path) {
        return EclipticSeasons.rl("block/" + path);
    }

    public static int getRotateYByFacing(Direction state) {
        switch (state) {
            case EAST: {
                return 90;
            }
            case SOUTH: {
                return 180;
            }
            case WEST: {
                return 270;
            }
        }
        return 0;
    }
}

