/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.mixin.client;

import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.client.core.ClientWeatherChecker;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Level.class})
public class MixinClientLevel {
    @Inject(at={@At(value="HEAD")}, method={"isRaining"}, cancellable=true)
    private void eclipticseasons$isRaining(CallbackInfoReturnable<Boolean> cir) {
        ClientLevel clientLevel;
        MixinClientLevel mixinClientLevel = this;
        if (mixinClientLevel instanceof ClientLevel && EclipticUtil.hasLocalWeather((Level)(clientLevel = (ClientLevel)mixinClientLevel))) {
            cir.setReturnValue((Object)ClientWeatherChecker.isRain((Level)clientLevel));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getRainLevel"}, cancellable=true)
    private void eclipticseasons$getRainLevel(float p_46723_, CallbackInfoReturnable<Float> cir) {
        ClientLevel clientLevel;
        MixinClientLevel mixinClientLevel = this;
        if (mixinClientLevel instanceof ClientLevel && EclipticUtil.hasLocalWeather((Level)(clientLevel = (ClientLevel)mixinClientLevel))) {
            cir.setReturnValue((Object)Float.valueOf(ClientWeatherChecker.getRainLevel((Level)clientLevel, p_46723_)));
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getBiome(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/core/Holder;")}, method={"isRainingAt"}, cancellable=true)
    private void eclipticseasons$client$isRainingAt_endBiomeCheck(BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        ClientLevel level;
        MixinClientLevel mixinClientLevel = this;
        if (mixinClientLevel instanceof ClientLevel && EclipticUtil.hasLocalWeather((Level)(level = (ClientLevel)mixinClientLevel))) {
            Biome.Precipitation precipitation = EclipticUtil.getRainOrSnow((Level)level, (Biome)MapChecker.getSurfaceBiome((Level)level, pos).m_203334_(), pos);
            cir.setReturnValue((Object)(precipitation == Biome.Precipitation.RAIN ? 1 : 0));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isThundering"}, cancellable=true)
    private void eclipticseasons$isThundering(CallbackInfoReturnable<Boolean> cir) {
        ClientLevel clientLevel;
        MixinClientLevel mixinClientLevel = this;
        if (mixinClientLevel instanceof ClientLevel && EclipticUtil.hasLocalWeather((Level)(clientLevel = (ClientLevel)mixinClientLevel))) {
            cir.setReturnValue((Object)ClientWeatherChecker.isThundering((Level)clientLevel));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getThunderLevel"}, cancellable=true)
    private void eclipticseasons$getThunderLevel(float p_46723_, CallbackInfoReturnable<Float> cir) {
        ClientLevel clientLevel;
        MixinClientLevel mixinClientLevel = this;
        if (mixinClientLevel instanceof ClientLevel && EclipticUtil.hasLocalWeather((Level)(clientLevel = (ClientLevel)mixinClientLevel))) {
            cir.setReturnValue((Object)Float.valueOf(ClientWeatherChecker.getThunderLevel((Level)clientLevel, p_46723_)));
        }
    }
}

