/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.mixin.common.biome;

import com.teamtea.eclipticseasons.api.constant.tag.ClimateTypeBiomeTags;
import com.teamtea.eclipticseasons.api.misc.IBiomeTagHolder;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.common.core.biome.BiomeClimateManager;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.compat.vanilla.VanillaWeather;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Biome.class})
public abstract class MixinBiome
implements IBiomeTagHolder {
    @Unique
    private boolean eclipticseasons$small = false;
    @Unique
    private int eclipticseasons$id = -1;
    @Unique
    private TagKey<Biome> eclipticseasons$biomeTagKey = ClimateTypeBiomeTags.RAINLESS;
    @Unique
    private TagKey<Biome> eclipticseasons$biomeColorTagKey = ClimateTypeBiomeTags.NONE_COLOR_CHANGE;

    @Shadow
    @Deprecated
    public abstract float m_47505_(BlockPos var1);

    @Inject(at={@At(value="HEAD")}, method={"getPrecipitationAt"}, cancellable=true)
    public void eclipticseasons$getPrecipitationAt(BlockPos pos, CallbackInfoReturnable<Biome.Precipitation> cir) {
        if (EclipticUtil.useSolarWeather()) {
            cir.setReturnValue((Object)WeatherManager.getPrecipitationAt((Biome)this, pos));
        } else {
            cir.setReturnValue((Object)VanillaWeather.handlePrecipitationAt((Biome)this, pos));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"hasPrecipitation"}, cancellable=true)
    public void eclipticseasons$hasPrecipitation(CallbackInfoReturnable<Boolean> cir) {
        if (EclipticUtil.useSolarWeather()) {
            cir.setReturnValue((Object)BiomeClimateManager.agent$hasPrecipitation((Biome)this));
        } else if (BiomeClimateManager.getTag((Biome)this).equals(ClimateTypeBiomeTags.MONSOONAL)) {
            cir.setReturnValue((Object)VanillaWeather.hasMonsoonalPrecipitation((Biome)this));
        }
    }

    @Override
    public TagKey<Biome> eclipticseasons$getBindTag() {
        return this.eclipticseasons$biomeTagKey;
    }

    @Override
    public void eclipticseasons$setTag(TagKey<Biome> tag) {
        this.eclipticseasons$biomeTagKey = tag;
    }

    @Override
    public void eclipticseasons$setColorTag(TagKey<Biome> tag) {
        this.eclipticseasons$biomeColorTagKey = tag;
    }

    @Override
    public TagKey<Biome> eclipticseasons$getBindColorTag() {
        return this.eclipticseasons$biomeColorTagKey;
    }

    @Override
    public boolean eclipticseasons$isSmallBiome() {
        return this.eclipticseasons$small;
    }

    @Override
    public void eclipticseasons$setSmall(boolean isSmall) {
        this.eclipticseasons$small = isSmall;
    }

    @Override
    public int eclipticseasons$getBindId() {
        return this.eclipticseasons$id;
    }

    @Override
    public void eclipticseasons$setBindId(int id) {
        this.eclipticseasons$id = id;
    }
}

