/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.mixin.compat.embeddium;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.misc.client.IExtraRendererContextOwner;
import com.teamtea.eclipticseasons.api.misc.client.IMapSlice;
import com.teamtea.eclipticseasons.api.misc.client.ISnowyGetter;
import com.teamtea.eclipticseasons.client.core.ExtraRendererContext;
import com.teamtea.eclipticseasons.common.core.map.BiomeHolder;
import com.teamtea.eclipticseasons.common.core.map.ChunkInfoMap;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.core.snow.SnowyStatusKeeper;
import java.util.Arrays;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSection;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(value={WorldSlice.class})
public abstract class MixinChunkSlice
implements IMapSlice,
IExtraRendererContextOwner {
    @Unique
    private static final int MAP_BLOCK_COUNT = 256;
    @Unique
    private static int MAP_ARRAY_SIZE;
    @Unique
    private int[][] HEIGHT_MAP;
    @Unique
    private int[][] SOLID_HEIGHT_MAP;
    @Unique
    private int[][] BIOME_MAP;
    @Unique
    private SnowyStatusKeeper[] SNOWY_STATUS_MAP;
    @Shadow(remap=false)
    @Final
    private static int SECTION_ARRAY_LENGTH;
    @Shadow(remap=false)
    private BoundingBox volume;
    @Shadow(remap=false)
    @Final
    private static int NEIGHBOR_CHUNK_RADIUS;
    @Shadow(remap=false)
    @Final
    public ClientLevel world;
    @Shadow(remap=false)
    private int originX;
    @Shadow(remap=false)
    private int originZ;
    @Unique
    private BlockPos.MutableBlockPos eclipticseasons$checkPos = new BlockPos.MutableBlockPos();
    @Unique
    private ExtraRendererContext eclipticseasons$rendererHolder = new ExtraRendererContext();

    @Shadow(remap=false)
    public static int getLocalSectionIndex(int sectionX, int sectionY, int sectionZ) {
        return 0;
    }

    @Inject(remap=false, method={"<clinit>"}, at={@At(value="TAIL")})
    private static void eclipticseasons$clinit(CallbackInfo ci) {
        MAP_ARRAY_SIZE = SECTION_ARRAY_LENGTH * SECTION_ARRAY_LENGTH;
    }

    @Inject(remap=false, method={"<init>"}, at={@At(value="TAIL")})
    private void eclipticseasons$init(ClientLevel level, CallbackInfo ci) {
        this.HEIGHT_MAP = new int[MAP_ARRAY_SIZE][256];
        this.SOLID_HEIGHT_MAP = new int[MAP_ARRAY_SIZE][256];
        this.BIOME_MAP = new int[MAP_ARRAY_SIZE][256];
        this.SNOWY_STATUS_MAP = new SnowyStatusKeeper[MAP_ARRAY_SIZE];
    }

    @Inject(remap=false, method={"copyData"}, at={@At(value="TAIL")})
    private void eclipticseasons$copySectionData(ChunkRenderContext context, CallbackInfo ci) {
        if (MapChecker.isValidDimension((Level)this.world)) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            int maxH = this.world.m_151558_();
            for (int sectionX = 0; sectionX < SECTION_ARRAY_LENGTH; ++sectionX) {
                for (int sectionZ = 0; sectionZ < SECTION_ARRAY_LENGTH; ++sectionZ) {
                    ClonedChunkSection contextSection = context.getSections()[MixinChunkSlice.getLocalSectionIndex(sectionX, 0, sectionZ)];
                    ISnowyGetter snowyGetter = (ISnowyGetter)contextSection;
                    int localSectionIndex = MixinChunkSlice.eclipticseasons$getLocalSectionIndex(sectionX, sectionZ);
                    ChunkPos chunkPos = contextSection.getPosition().m_123251_();
                    int startX = chunkPos.m_45604_();
                    int startZ = chunkPos.m_45605_();
                    mutableBlockPos.m_142451_(startX);
                    mutableBlockPos.m_142443_(startZ);
                    int[] heights = this.HEIGHT_MAP[localSectionIndex];
                    int[] biomes = this.BIOME_MAP[localSectionIndex];
                    int[] solidHeights = this.SOLID_HEIGHT_MAP[localSectionIndex];
                    this.SNOWY_STATUS_MAP[localSectionIndex] = snowyGetter.getSnowyStatusKeeper();
                    mutableBlockPos.m_142451_(startX);
                    mutableBlockPos.m_142443_(startZ);
                    ChunkInfoMap chunkMap = snowyGetter.getChunkInfoMap();
                    BiomeHolder biomeHolder = snowyGetter.getBiomeHolder();
                    if (chunkMap != null) {
                        for (int x = 0; x < 16; ++x) {
                            for (int z = 0; z < 16; ++z) {
                                int biomeId;
                                int index = x * 16 + z;
                                mutableBlockPos.m_142451_(startX + x);
                                mutableBlockPos.m_142443_(startZ + z);
                                int y = chunkMap.getHeight((BlockPos)mutableBlockPos);
                                heights[index] = y > chunkMap.getMinY() ? y : MapChecker.getHeight((Level)this.world, (BlockPos)mutableBlockPos);
                                mutableBlockPos.m_142448_(heights[index] + 1);
                                if (mutableBlockPos.m_123342_() > maxH) {
                                    mutableBlockPos.m_142448_(this.world.m_6924_(Heightmap.Types.MOTION_BLOCKING, mutableBlockPos.m_123341_(), mutableBlockPos.m_123343_()));
                                }
                                biomes[index] = (biomeId = biomeHolder.getBiomeId((BlockPos)mutableBlockPos)) > -1 ? biomeId : MapChecker.biomeToId((Level)this.world, (Biome)MapChecker.getUnCachedSurfaceBiome((Level)this.world, (BlockPos)mutableBlockPos).m_203334_());
                                solidHeights[index] = snowyGetter.getSolidHeightMap().m_158368_(x, z);
                            }
                        }
                        continue;
                    }
                    EclipticSeasons.logger("Warning, now try create slice for invalid level", this.world, context.getOrigin());
                }
            }
        }
    }

    @Unique
    private static int eclipticseasons$getLocalSectionIndex(int sectionX, int sectionZ) {
        return sectionZ * SECTION_ARRAY_LENGTH + sectionX;
    }

    @Override
    public int getSolidBlockHeight(BlockPos pos) {
        if (!this.volume.m_260866_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())) {
            return this.world.m_151558_() + 1;
        }
        int relBlockX = pos.m_123341_() - this.originX;
        int relBlockZ = pos.m_123343_() - this.originZ;
        int[] lightArrays = this.SOLID_HEIGHT_MAP[MixinChunkSlice.eclipticseasons$getLocalSectionIndex(relBlockX >> 4, relBlockZ >> 4)];
        int localBlockX = relBlockX & 0xF;
        int localBlockZ = relBlockZ & 0xF;
        return lightArrays[localBlockX * 16 + localBlockZ];
    }

    @Override
    public int getBlockHeight(BlockPos pos) {
        if (!this.volume.m_260866_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())) {
            return this.world.m_151558_() + 1;
        }
        int relBlockX = pos.m_123341_() - this.originX;
        int relBlockZ = pos.m_123343_() - this.originZ;
        int[] lightArrays = this.HEIGHT_MAP[MixinChunkSlice.eclipticseasons$getLocalSectionIndex(relBlockX >> 4, relBlockZ >> 4)];
        int localBlockX = relBlockX & 0xF;
        int localBlockZ = relBlockZ & 0xF;
        return lightArrays[localBlockX * 16 + localBlockZ];
    }

    @Override
    public int getSurfaceFaceBiomeId(BlockPos pos) {
        if (!this.volume.m_260866_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())) {
            return this.world.m_151558_() + 1;
        }
        int relBlockX = pos.m_123341_() - this.originX;
        int relBlockZ = pos.m_123343_() - this.originZ;
        int[] lightArrays = this.BIOME_MAP[MixinChunkSlice.eclipticseasons$getLocalSectionIndex(relBlockX >> 4, relBlockZ >> 4)];
        int localBlockX = relBlockX & 0xF;
        int localBlockZ = relBlockZ & 0xF;
        return lightArrays[localBlockX * 16 + localBlockZ];
    }

    @Override
    public boolean isSnowyBlock(BlockPos pos) {
        int relBlockZ;
        if (!this.volume.m_260866_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())) {
            return false;
        }
        int relBlockX = pos.m_123341_() - this.originX;
        SnowyStatusKeeper lightArrays = this.SNOWY_STATUS_MAP[MixinChunkSlice.eclipticseasons$getLocalSectionIndex(relBlockX >> 4, (relBlockZ = pos.m_123343_() - this.originZ) >> 4)];
        return lightArrays != null && lightArrays.isSnowyBlock(pos);
    }

    @Override
    public BlockPos.MutableBlockPos getModelCheckPos() {
        return this.eclipticseasons$checkPos;
    }

    @Inject(remap=false, method={"reset"}, at={@At(value="RETURN")})
    private void eclipticseasons$release(CallbackInfo ci) {
        this.eclipticseasons$rendererHolder.resetAll();
        Arrays.fill(this.SNOWY_STATUS_MAP, null);
    }

    @Override
    public ExtraRendererContext eclipticseasons$getContext() {
        return this.eclipticseasons$rendererHolder;
    }
}

