/*
 * Decompiled with CFR 0.152.
 */
package com.loqor.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2359;
import net.minecraft.class_2374;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_7923;

public class StackUtil {
    public static final class_2960 AIR_ID = class_7923.field_41178.method_10221((Object)class_1802.field_8162);
    public static final String AIR_STR_ID = AIR_ID.toString();

    public static boolean equals(Collection<class_1799> as, Collection<class_1799> bs) {
        if (as.size() != bs.size()) {
            return false;
        }
        for (class_1799 a : as) {
            boolean found = false;
            for (class_1799 b : bs) {
                if (!class_1799.method_7984((class_1799)a, (class_1799)b)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static <T extends Collection<class_1799>> T copy(T t, Supplier<T> supplier) {
        Collection copy = (Collection)supplier.get();
        for (class_1799 stack : t) {
            copy.add(stack.method_7972());
        }
        return (T)copy;
    }

    public static void spawn(class_1937 world, class_2374 pos, class_1799 stack) {
        world.method_8649((class_1297)new class_1542(world, pos.method_10216(), pos.method_10214(), pos.method_10215(), stack));
    }

    public static void spawn(class_1937 world, class_2338 pos, class_1799 stack) {
        StackUtil.spawn(world, (class_2374)pos.method_46558(), stack);
    }

    public static void playBreak(class_1657 player) {
        player.method_5783(class_3417.field_15075, 0.8f, 0.8f + player.method_37908().method_8409().method_43057() * 0.4f);
    }

    public static void scatter(class_1937 world, class_2374 pos, Collection<class_1799> stacks) {
        for (class_1799 stack : stacks) {
            class_1264.method_5449((class_1937)world, (double)pos.method_10216(), (double)pos.method_10214(), (double)pos.method_10215(), (class_1799)stack);
        }
    }

    public static void scatter(class_1937 world, class_2338 pos, Collection<class_1799> stacks) {
        StackUtil.scatter(world, (class_2374)pos.method_46558(), stacks);
    }

    public static class_2487 writeUnordered(class_2487 nbt, Collection<class_1799> stacks) {
        class_2499 nbtList = new class_2499();
        for (class_1799 stack : stacks) {
            if (stack == null || stack.method_7960()) continue;
            class_2487 nbtCompound = new class_2487();
            stack.method_7953(nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        if (!nbtList.isEmpty()) {
            nbt.method_10566("Items", (class_2520)nbtList);
        }
        return nbt;
    }

    public static class_2487 write(class_2487 nbt, List<class_1799> stacks) {
        class_2499 nbtList = new class_2499();
        for (int i = 0; i < stacks.size(); ++i) {
            class_1799 stack = stacks.get(i);
            if (stack == null) {
                stack = new class_1799((class_1935)class_1802.field_8162);
            }
            if (stack.method_7960()) continue;
            class_2487 nbtCompound = new class_2487();
            nbtCompound.method_10567("Slot", (byte)i);
            stack.method_7953(nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        if (!nbtList.isEmpty()) {
            nbt.method_10566("Items", (class_2520)nbtList);
        }
        return nbt;
    }

    public static class_2487 write(class_2487 nbt, class_1799 ... stacks) {
        class_2499 nbtList = new class_2499();
        for (int i = 0; i < stacks.length; ++i) {
            class_1799 stack = stacks[i];
            if (stack == null) {
                stack = new class_1799((class_1935)class_1802.field_8162);
            }
            if (stack.method_7960()) continue;
            class_2487 nbtCompound = new class_2487();
            nbtCompound.method_10567("Slot", (byte)i);
            stack.method_7953(nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        if (!nbtList.isEmpty()) {
            nbt.method_10566("Items", (class_2520)nbtList);
        }
        return nbt;
    }

    public static void read(class_2487 nbt, List<class_1799> stacks) {
        class_2499 nbtList = nbt.method_10554("Items", 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            class_2487 nbtCompound = nbtList.method_10602(i);
            int j = nbtCompound.method_10571("Slot") & 0xFF;
            if (j >= stacks.size()) continue;
            stacks.set(j, class_1799.method_7915((class_2487)nbtCompound));
        }
    }

    public static class_1799[] read(class_2487 nbt) {
        class_2499 nbtList = nbt.method_10554("Items", 10);
        class_1799[] stacks = new class_1799[nbtList.size()];
        for (int i = 0; i < nbtList.size(); ++i) {
            class_2487 nbtCompound = nbtList.method_10602(i);
            int j = nbtCompound.method_10571("Slot") & 0xFF;
            if (j >= stacks.length) continue;
            stacks[j] = class_1799.method_7915((class_2487)nbtCompound);
        }
        return stacks;
    }

    public static void readUnordered(class_2487 nbt, Collection<class_1799> stacks) {
        class_2499 nbtList = nbt.method_10554("Items", 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            stacks.add(class_1799.method_7915((class_2487)nbtList.method_10602(i)));
        }
    }

    public static void write(class_2487 nbt, String key, class_1792 item) {
        class_2960 identifier = item != null ? class_7923.field_41178.method_10221((Object)item) : null;
        nbt.method_10582(key, identifier == null ? AIR_STR_ID : identifier.toString());
    }

    public static class_1792 readItem(class_2487 nbt, String key) {
        String raw = nbt.method_10558(key);
        if (raw.isEmpty()) {
            return null;
        }
        return (class_1792)class_7923.field_41178.method_10223(new class_2960(raw));
    }

    public static class_1792 readItemNonNull(class_2487 nbt, String key) {
        class_1792 result = StackUtil.readItem(nbt, key);
        return result != null ? result : class_1802.field_8162;
    }

    public static class_1799 take(class_1799 other, int amount) {
        class_1799 result = other.method_46651(amount);
        other.method_7934(amount);
        return result;
    }

    public static class_1799 take(class_1799 other) {
        return StackUtil.take(other, 1);
    }

    public static class_1799 air() {
        return new class_1799((class_1935)class_1802.field_8162);
    }

    public static void writeItem(class_2540 buf, class_1792 item) {
        buf.method_42065((class_2359)class_7923.field_41178, (Object)item);
    }

    public static class_1792 readItem(class_2540 buf) {
        return (class_1792)buf.method_42064((class_2359)class_7923.field_41178);
    }

    public static class_1799 orAir(class_1799 stack) {
        return stack == null ? StackUtil.air() : stack;
    }

    public static class_1792 orAir(class_1792 item) {
        return item == null ? class_1802.field_8162 : item;
    }

    public static List<class_1799> cloneList(List<class_1799> list) {
        ArrayList<class_1799> clone = new ArrayList<class_1799>(list.size());
        for (class_1799 item : list) {
            clone.add(item.method_7972());
        }
        return clone;
    }
}

