/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.client.bedrock;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import dev.amble.lib.AmbleKit;
import dev.amble.lib.client.bedrock.BedrockAnimationAdapter;
import dev.amble.lib.client.bedrock.BedrockModel;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_630;
import net.minecraft.class_7094;

@Environment(value=EnvType.CLIENT)
public class BedrockAnimation {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(BedrockModel.LocatorBone.class, (Object)new BedrockModel.LocatorBone.Adapter()).registerTypeAdapter(BedrockAnimation.class, (Object)new BedrockAnimationAdapter()).create();
    public final boolean shouldLoop;
    public final double animationLength;
    public final Map<String, BoneTimeline> boneTimelines;
    public String name;

    public BedrockAnimation(boolean shouldLoop, double animationLength, Map<String, BoneTimeline> boneTimelines) {
        this.shouldLoop = shouldLoop;
        this.animationLength = animationLength;
        this.boneTimelines = boneTimelines;
    }

    @Environment(value=EnvType.CLIENT)
    public void apply(class_630 root, int totalTicks, float rawDelta) {
        float ticks = (float)((double)((float)totalTicks / 20.0f) % this.animationLength) * 20.0f;
        float delta = rawDelta / 10.0f;
        this.boneTimelines.forEach((boneName, timeline) -> {
            try {
                class_630 bone = root.method_32088().filter(part -> part.method_41919(boneName)).findFirst().map(part -> part.method_32086(boneName)).orElse(null);
                if (bone == null) {
                    if (boneName == "root") {
                        bone = root;
                    } else {
                        throw new IllegalStateException("Bone " + boneName + " not found in model. If this is the root part, ensure it is named 'root'.");
                    }
                }
                if (!timeline.position.isEmpty()) {
                    class_243 position = timeline.position.resolve((double)ticks / 20.0 + (double)delta);
                    bone.field_3657 += (float)position.field_1352;
                    bone.field_3656 += (float)position.field_1351;
                    bone.field_3655 += (float)position.field_1350;
                }
                if (!timeline.rotation.isEmpty()) {
                    class_243 rotation = timeline.rotation.resolve((double)ticks / 20.0 + (double)delta);
                    bone.field_3654 += (float)Math.toRadians((float)rotation.field_1352);
                    bone.field_3675 += (float)Math.toRadians((float)rotation.field_1351);
                    bone.field_3674 += (float)Math.toRadians((float)rotation.field_1350);
                }
                if (!timeline.scale.isEmpty()) {
                    class_243 scale = timeline.scale.resolve((double)ticks / 20.0 + (double)delta);
                    bone.field_37938 *= (float)scale.field_1352;
                    bone.field_37939 *= (float)scale.field_1351;
                    bone.field_37940 *= (float)scale.field_1350;
                }
            }
            catch (Exception e) {
                AmbleKit.LOGGER.error("Failed apply animation to {} in model. Skipping animation application for this bone.", boneName, (Object)e);
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    public void apply(class_630 root, class_7094 state, float progress, float speedMultiplier) {
        state.method_43686(progress, speedMultiplier);
        float ticks = this.shouldLoop ? (float)((double)((float)state.method_43687() / 1000.0f) % this.animationLength) * 20.0f : (float)state.method_43687();
        state.method_41323(s -> this.apply(root, (int)ticks, 0.0f));
    }

    public record BoneTimeline(BoneValue position, BoneValue rotation, BoneValue scale) {
    }

    public static interface BoneValue {
        public class_243 resolve(double var1);

        public boolean isEmpty();
    }

    public static enum Transformation {
        POSITION,
        ROTATION,
        SCALE;

    }

    public static enum InterpolationType {
        SMOOTH,
        LINEAR;

    }

    public static class JumpKeyFrame
    extends KeyFrame {
        private final BoneValue pre;
        private final BoneValue post;

        public JumpKeyFrame(double time, Transformation transformation, InterpolationType interpolationType, BoneValue pre, BoneValue post) {
            super(time, transformation, interpolationType);
            this.pre = pre;
            this.post = post;
        }

        @Override
        public BoneValue getPre() {
            return this.pre;
        }

        @Override
        public BoneValue getPost() {
            return this.post;
        }
    }

    public static class SimpleKeyFrame
    extends KeyFrame {
        public final BoneValue data;

        public SimpleKeyFrame(double time, Transformation transformation, InterpolationType interpolationType, BoneValue data) {
            super(time, transformation, interpolationType);
            this.data = data;
        }

        @Override
        public BoneValue getPre() {
            return this.data;
        }

        @Override
        public BoneValue getPost() {
            return this.data;
        }
    }

    public static abstract class KeyFrame {
        public final double time;
        public final Transformation transformation;
        public final InterpolationType interpolationType;

        public KeyFrame(double time, Transformation transformation, InterpolationType interpolationType) {
            this.time = time;
            this.transformation = transformation;
            this.interpolationType = interpolationType;
        }

        public abstract BoneValue getPre();

        public abstract BoneValue getPost();
    }

    public static class EmptyBoneValue
    implements BoneValue {
        public static final EmptyBoneValue INSTANCE = new EmptyBoneValue();

        private EmptyBoneValue() {
        }

        @Override
        public class_243 resolve(double time) {
            return class_243.field_1353;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }

    public static class KeyFrameBoneValue
    extends TreeMap<Double, KeyFrame>
    implements BoneValue {
        private KeyFrame getAtIndex(SortedMap<Double, KeyFrame> map, Integer index) {
            if (index == null) {
                return null;
            }
            if (index < 0 || index >= map.size()) {
                return null;
            }
            Double key = new ArrayList<Double>(map.keySet()).get(index);
            return (KeyFrame)map.get(key);
        }

        @Override
        public class_243 resolve(double time) {
            class_243 beforeData;
            ArrayList keyList = new ArrayList(this.keySet());
            Integer afterIndex = null;
            for (int i = 0; i < keyList.size(); ++i) {
                if (!((Double)keyList.get(i) > time)) continue;
                afterIndex = i;
                break;
            }
            Integer beforeIndex = afterIndex == null ? Integer.valueOf(this.size() - 1) : (afterIndex == 0 ? null : Integer.valueOf(afterIndex - 1));
            KeyFrame after = this.getAtIndex(this, afterIndex);
            KeyFrame before = this.getAtIndex(this, beforeIndex);
            class_243 afterData = after != null && after.getPre() != null ? after.getPre().resolve(time) : class_243.field_1353;
            class_243 class_2432 = beforeData = before != null && before.getPost() != null ? before.getPost().resolve(time) : class_243.field_1353;
            if (before != null || after != null) {
                boolean smoothAfter;
                boolean smoothBefore = before != null && before.interpolationType == InterpolationType.SMOOTH;
                boolean bl = smoothAfter = after != null && after.interpolationType == InterpolationType.SMOOTH;
                if (smoothBefore || smoothAfter) {
                    if (before != null && after != null) {
                        Integer beforePlusIndex = beforeIndex == 0 ? null : Integer.valueOf(beforeIndex - 1);
                        KeyFrame beforePlus = this.getAtIndex(this, beforePlusIndex);
                        Integer afterPlusIndex = afterIndex == this.size() - 1 ? null : Integer.valueOf(afterIndex + 1);
                        KeyFrame afterPlus = this.getAtIndex(this, afterPlusIndex);
                        class_243 beforePlusData = beforePlus != null && beforePlus.getPost() != null ? beforePlus.getPost().resolve(time) : beforeData;
                        class_243 afterPlusData = afterPlus != null && afterPlus.getPre() != null ? afterPlus.getPre().resolve(time) : afterData;
                        double t = (time - before.time) / (after.time - before.time);
                        return new class_243((double)class_3532.method_41303((float)((float)t), (float)((float)beforePlusData.field_1352), (float)((float)beforeData.field_1352), (float)((float)afterData.field_1352), (float)((float)afterPlusData.field_1352)), (double)class_3532.method_41303((float)((float)t), (float)((float)beforePlusData.field_1351), (float)((float)beforeData.field_1351), (float)((float)afterData.field_1351), (float)((float)afterPlusData.field_1351)), (double)class_3532.method_41303((float)((float)t), (float)((float)beforePlusData.field_1350), (float)((float)beforeData.field_1350), (float)((float)afterData.field_1350), (float)((float)afterPlusData.field_1350)));
                    }
                    if (before != null) {
                        return beforeData;
                    }
                    return afterData;
                }
                if (before != null && after != null) {
                    double alpha = class_3532.method_16436((double)time, (double)before.time, (double)after.time);
                    return new class_243(beforeData.method_10216() + (afterData.method_10216() - beforeData.method_10216()) * alpha, beforeData.method_10214() + (afterData.method_10214() - beforeData.method_10214()) * alpha, beforeData.method_10215() + (afterData.method_10215() - beforeData.method_10215()) * alpha);
                }
                if (before != null) {
                    return beforeData;
                }
                return afterData;
            }
            return new class_243(0.0, 0.0, 0.0);
        }
    }

    public static class SimpleBoneValue
    implements BoneValue {
        public final class_243 value;
        public final Transformation transformation;

        public SimpleBoneValue(class_243 value, Transformation transformation) {
            this.value = value.method_18805(1.0, transformation == Transformation.POSITION ? -1.0 : 1.0, 1.0);
            this.transformation = transformation;
        }

        @Override
        public class_243 resolve(double time) {
            return this.value;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    public static class Group {
        @SerializedName(value="format_version")
        public String version;
        public Map<String, BedrockAnimation> animations;
    }
}

