/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.client.bedrock;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import dev.amble.lib.api.Identifiable;
import dev.amble.lib.client.bedrock.BedrockAnimation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;

@Environment(value=EnvType.CLIENT)
public class BedrockModel
implements Identifiable {
    @SerializedName(value="format_version")
    public String version;
    @SerializedName(value="minecraft:geometry")
    public List<Geometry> geometry;
    private transient class_2960 id;

    public static BedrockModel from(JsonObject json, class_2960 id) {
        Gson gson = BedrockAnimation.GSON;
        BedrockModel model = (BedrockModel)gson.fromJson((JsonElement)json, BedrockModel.class);
        model.id = id;
        return model;
    }

    public class_5607 create() {
        class_5609 modelData = new class_5609();
        HashMap<String, class_5610> parts = new HashMap<String, class_5610>();
        HashMap<String, Bone> bones = new HashMap<String, Bone>();
        try {
            Geometry geometry = this.geometry.get(0);
            ArrayList<Bone> geometryBones = new ArrayList<Bone>(geometry.bones);
            for (Bone bone : geometryBones) {
                if (bone.locators == null) continue;
                for (Map.Entry<String, LocatorBone> entry : bone.locators.entrySet()) {
                    Bone locatorBone = Bone.empty();
                    locatorBone.name = "internal_locator__" + entry.getKey();
                    locatorBone.parent = bone.name;
                    locatorBone.pivot = entry.getValue().offset;
                    locatorBone.rotation = entry.getValue().rotation;
                    geometryBones.add(locatorBone);
                }
            }
            Bone rootLocator = Bone.empty();
            rootLocator.name = "internal_locator__root";
            geometryBones.add(rootLocator);
            for (Bone bone : geometryBones) {
                bones.put(bone.name, bone);
                class_5610 parentPart = bone.parent != null ? (class_5610)parts.get(bone.parent) : modelData.method_32111();
                List<Float> boneRotation = bone.rotation;
                class_5603 modelTransform = bone.parent == null ? class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f) : (boneRotation != null ? class_5603.method_32091((float)(-(((Bone)bones.get((Object)bone.parent)).pivot.get(0).floatValue() - bone.pivot.get(0).floatValue())), (float)(((Bone)bones.get((Object)bone.parent)).pivot.get(1).floatValue() - bone.pivot.get(1).floatValue()), (float)(-(((Bone)bones.get((Object)bone.parent)).pivot.get(2).floatValue() - bone.pivot.get(2).floatValue())), (float)((float)Math.toRadians(boneRotation.get(0).floatValue())), (float)((float)Math.toRadians(boneRotation.get(1).floatValue())), (float)((float)Math.toRadians(boneRotation.get(2).floatValue()))) : class_5603.method_32090((float)(-(((Bone)bones.get((Object)bone.parent)).pivot.get(0).floatValue() - bone.pivot.get(0).floatValue())), (float)(((Bone)bones.get((Object)bone.parent)).pivot.get(1).floatValue() - bone.pivot.get(1).floatValue()), (float)(-(((Bone)bones.get((Object)bone.parent)).pivot.get(2).floatValue() - bone.pivot.get(2).floatValue()))));
                class_5606 modelPart = class_5606.method_32108();
                ArrayList<class_5606> subParts = new ArrayList<class_5606>();
                ArrayList<class_5603> modelTransforms = new ArrayList<class_5603>();
                List<Cube> boneCubes = bone.cubes;
                if (boneCubes != null) {
                    for (Cube cube : boneCubes) {
                        List<Float> pivot;
                        class_5606 subPart = cube.rotation != null ? class_5606.method_32108() : modelPart;
                        List<Float> list = pivot = cube.pivot != null ? cube.pivot : bone.pivot;
                        if (cube.uv != null) {
                            subPart.method_32101(cube.uv.get(0).intValue(), cube.uv.get(1).intValue());
                        }
                        if (cube.mirror) {
                            subPart.method_32096();
                        }
                        if (cube.size != null && cube.origin != null) {
                            subPart.method_32098(cube.origin.get(0).floatValue() - pivot.get(0).floatValue(), -(cube.origin.get(1).floatValue() - pivot.get(1).floatValue() + cube.size.get(1).floatValue()), cube.origin.get(2).floatValue() - pivot.get(2).floatValue(), cube.size.get(0).floatValue(), cube.size.get(1).floatValue(), cube.size.get(2).floatValue(), new class_5605(cube.inflate));
                        }
                        if (cube.mirror) {
                            subPart.method_32106(false);
                        }
                        if (subPart == modelPart) continue;
                        modelTransforms.add(class_5603.method_32091((float)(-(bone.pivot.get(0).floatValue() - cube.pivot.get(0).floatValue())), (float)(bone.pivot.get(1).floatValue() - cube.pivot.get(1).floatValue()), (float)(-(bone.pivot.get(2).floatValue() - cube.pivot.get(2).floatValue())), (float)((float)Math.toRadians(cube.rotation.get(0).floatValue())), (float)((float)Math.toRadians(cube.rotation.get(1).floatValue())), (float)((float)Math.toRadians(cube.rotation.get(2).floatValue()))));
                        subParts.add(subPart);
                    }
                }
                parts.put(bone.name, parentPart.method_32117(bone.name, modelPart, modelTransform));
                int counter = 0;
                for (int index = 0; index < subParts.size(); ++index) {
                    ((class_5610)parts.get(bone.name)).method_32117(bone.name + counter++, (class_5606)subParts.get(index), (class_5603)modelTransforms.get(index));
                }
            }
            return class_5607.method_32110((class_5609)modelData, (int)geometry.description.textureWidth, (int)geometry.description.textureHeight);
        }
        catch (Exception e) {
            if (this.geometry != null && !this.geometry.isEmpty()) {
                throw new IllegalArgumentException("Error creating LayerDefinition with identifier " + this.geometry.get((int)0).description.identifier, e);
            }
            throw new IllegalArgumentException("Error creating LayerDefinition", e);
        }
    }

    public String toString() {
        return "BedrockModel{version='" + this.version + "', geometry=" + String.valueOf(this.geometry) + "}";
    }

    @Override
    public class_2960 id() {
        if (this.id == null) {
            throw new IllegalStateException("Model identifier is not set.");
        }
        return this.id;
    }

    public static class Geometry {
        public Description description;
        public List<Bone> bones;

        public String toString() {
            return "Geometry{description=" + String.valueOf(this.description) + ", bones=" + String.valueOf(this.bones) + "}";
        }
    }

    public static class Bone {
        public String name;
        public String parent;
        public List<Float> pivot;
        public List<Float> rotation;
        public List<Cube> cubes;
        public Map<String, LocatorBone> locators;

        public Bone() {
            this("", null, List.of(), null, null, null);
        }

        public Bone(String name, String parent, List<Float> pivot, List<Float> rotation, List<Cube> cubes, Map<String, LocatorBone> locators) {
            this.name = name;
            this.parent = parent;
            this.pivot = pivot;
            this.rotation = rotation;
            this.cubes = cubes;
            this.locators = locators;
        }

        public String toString() {
            return "Bone{name='" + this.name + "', parent='" + this.parent + "', pivot=" + String.valueOf(this.pivot) + ", rotation=" + String.valueOf(this.rotation) + ", cubes=" + String.valueOf(this.cubes) + ", locators=" + String.valueOf(this.locators) + "}";
        }

        public static Bone empty() {
            return new Bone();
        }
    }

    public static class LocatorBone {
        public List<Float> offset = List.of(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
        public List<Float> rotation = List.of(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));

        public String toString() {
            return "LocatorBone{offset=" + String.valueOf(this.offset) + ", rotation=" + String.valueOf(this.rotation) + "}";
        }

        public static class Adapter
        implements JsonDeserializer<LocatorBone> {
            public LocatorBone deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                List<Float> rotation;
                List<Float> offset;
                if (json.isJsonArray()) {
                    JsonArray arr = json.getAsJsonArray();
                    offset = Arrays.asList(Float.valueOf(arr.get(0).getAsFloat()), Float.valueOf(arr.get(1).getAsFloat()), Float.valueOf(arr.get(2).getAsFloat()));
                    rotation = Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
                } else {
                    JsonObject obj = json.getAsJsonObject();
                    JsonArray offsetArr = obj.has("offset") ? obj.getAsJsonArray("offset") : null;
                    JsonArray rotationArr = obj.has("rotation") ? obj.getAsJsonArray("rotation") : null;
                    offset = offsetArr != null ? Adapter.toFloatList(offsetArr) : Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
                    rotation = rotationArr != null ? Adapter.toFloatList(rotationArr) : Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
                }
                LocatorBone bone = new LocatorBone();
                bone.offset = offset;
                bone.rotation = rotation;
                return bone;
            }

            public static List<Float> toFloatList(JsonArray arr) {
                return Arrays.asList(Float.valueOf(arr.get(0).getAsFloat()), Float.valueOf(arr.get(1).getAsFloat()), Float.valueOf(arr.get(2).getAsFloat()));
            }
        }
    }

    public record Cube(List<Float> origin, List<Float> size, List<Float> pivot, List<Float> rotation, List<Integer> uv, float inflate, boolean mirror) {
        @Override
        public String toString() {
            return "Cube{origin=" + String.valueOf(this.origin) + ", size=" + String.valueOf(this.size) + ", pivot=" + String.valueOf(this.pivot) + ", rotation=" + String.valueOf(this.rotation) + ", uv=" + String.valueOf(this.uv) + ", inflate=" + this.inflate + ", mirror=" + this.mirror + "}";
        }
    }

    public static class Description {
        public String identifier;
        @SerializedName(value="texture_width")
        public int textureWidth;
        @SerializedName(value="texture_height")
        public int textureHeight;
        @SerializedName(value="visible_bounds_width")
        public float visibleBoundsWidth;
        @SerializedName(value="visible_bounds_height")
        public float visibleBoundsHeight;
        @SerializedName(value="visible_bounds_offset")
        public List<Float> visibleBoundsOffset;

        public String toString() {
            return "Description{identifier='" + this.identifier + "', textureWidth=" + this.textureWidth + ", textureHeight=" + this.textureHeight + ", visibleBoundsWidth=" + this.visibleBoundsWidth + ", visibleBoundsHeight=" + this.visibleBoundsHeight + ", visibleBoundsOffset=" + String.valueOf(this.visibleBoundsOffset) + "}";
        }
    }
}

