/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.datagen.lang;

import dev.amble.lib.container.RegistryContainer;
import dev.amble.lib.container.impl.BlockContainer;
import dev.amble.lib.container.impl.ItemContainer;
import dev.amble.lib.datagen.lang.LanguageType;
import dev.amble.lib.datagen.util.NoEnglish;
import dev.amble.lib.util.ReflectionUtil;
import java.util.HashMap;
import java.util.Set;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2588;
import net.minecraft.class_7417;

public class AmbleLanguageProvider
extends FabricLanguageProvider {
    private final FabricDataOutput output;
    protected final String modid;
    protected HashMap<String, String> translations = new HashMap();
    public LanguageType language;

    public AmbleLanguageProvider(FabricDataOutput output, LanguageType language) {
        super(output, language.name().toLowerCase());
        this.output = output;
        this.language = language;
        this.modid = output.getModId();
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder builder) {
        for (String key : this.translations.keySet()) {
            builder.add(key, this.translations.get(key));
        }
        this.output.getModContainer().findPath("assets/" + this.modid + "/lang/" + this.language.name().toLowerCase() + ".existing.json").ifPresent(existingFilePath -> {
            try {
                builder.add(existingFilePath);
            }
            catch (Exception e) {
                field_40831.warn("Failed to add existing language file! ({}) | ", (Object)this.language.name().toLowerCase(), (Object)e);
            }
        });
    }

    public void addTranslation(class_1792 item, String translation) {
        this.translations.put(item.method_7876(), translation);
    }

    public void addTranslation(class_1761 itemGroup, String translation) {
        class_7417 class_74172 = itemGroup.method_7737().method_10851();
        if (!(class_74172 instanceof class_2588)) {
            return;
        }
        class_2588 translatable = (class_2588)class_74172;
        this.translations.put(translatable.method_11022(), translation);
    }

    public void addTranslation(String key, String translation) {
        this.translations.put(key, translation);
    }

    public void addTranslation(class_2248 block, String translation) {
        this.translations.put(block.method_9539(), translation);
    }

    public <T, R extends RegistryContainer<T>> void addTranslation(Class<R> containerClazz, Class<T> valueClazz, Translator<T> translator) {
        Set<T> values = ReflectionUtil.getAnnotatedValues(containerClazz, valueClazz, NoEnglish.class, true).keySet();
        for (T value : values) {
            translator.addTranslation(this, value);
        }
    }

    public void translateItems(Class<? extends ItemContainer> container) {
        this.addTranslation(container, class_1792.class, (provider, value) -> {
            if (value instanceof class_1747) {
                return;
            }
            provider.addTranslation((class_1792)value, AmbleLanguageProvider.getNameFromKey(value.method_7876()));
        });
    }

    public void translateBlocks(Class<? extends BlockContainer> container) {
        this.addTranslation(container, class_2248.class, (provider, value) -> provider.addTranslation((class_2248)value, AmbleLanguageProvider.getNameFromKey(value.method_9539())));
    }

    public static String getNameFromKey(String key) {
        int lastDot = key.lastIndexOf(46);
        if (lastDot == -1) {
            return key;
        }
        String suffix = key.substring(lastDot + 1);
        String[] parts = suffix.split("_");
        StringBuilder builder = new StringBuilder();
        for (String part : parts) {
            builder.append(part.substring(0, 1).toUpperCase());
            builder.append(part.substring(1));
            builder.append(" ");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    @FunctionalInterface
    public static interface Translator<T> {
        public void addTranslation(AmbleLanguageProvider var1, T var2);
    }
}

