/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.register;

import dev.amble.lib.AmbleKit;
import dev.amble.lib.api.KitEvents;
import dev.amble.lib.register.Registry;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;

public class AmbleRegistries {
    private static AmbleRegistries INSTANCE;
    private final HashSet<Registry> registries = new HashSet();
    private final Set<InitType> initialized = new HashSet<InitType>();

    @Environment(value=EnvType.CLIENT)
    private static void registerClientStart() {
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> AmbleRegistries.getInstance().subscribe(InitType.CLIENT));
    }

    private AmbleRegistries() {
    }

    protected void subscribe(InitType env) {
        if (env == InitType.CLIENT && FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            throw new UnsupportedOperationException("Cannot call onInitializeClient while not running a client!");
        }
        if (this.initialized.contains((Object)env)) {
            return;
        }
        if (env == InitType.CLIENT) {
            this.subscribe(InitType.COMMON);
        }
        AmbleKit.LOGGER.info("Initializing {} side registries..", (Object)env);
        for (Registry registry : this.registries) {
            env.init(registry);
        }
        this.initialized.add(env);
    }

    public Registry register(Registry registry) {
        this.registries.add(registry);
        return registry;
    }

    public void registerAll(Registry ... registries) {
        for (Registry registry : registries) {
            this.register(registry);
        }
    }

    public static AmbleRegistries getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AmbleRegistries();
        }
        return INSTANCE;
    }

    static {
        KitEvents.PRE_DATAPACK_LOAD.register(() -> {
            AmbleRegistries.getInstance().subscribe(InitType.COMMON);
            AmbleRegistries.getInstance().subscribe(InitType.SERVER);
        });
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            AmbleRegistries.registerClientStart();
        }
    }

    public static enum InitType {
        CLIENT(Registry::onClientInit),
        SERVER(Registry::onServerInit),
        COMMON(Registry::onCommonInit);

        private final Consumer<Registry> consumer;

        private InitType(Consumer<Registry> consumer) {
            this.consumer = consumer;
        }

        public void init(Registry registry) {
            this.consumer.accept(registry);
        }
    }
}

