/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.skin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import dev.amble.lib.AmbleKit;
import dev.amble.lib.skin.SkinGrabber;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Optional;

public class SkinCache {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CACHE_FILE = "cache.json";
    private boolean locked;
    private ArrayList<CacheData> data;
    long lastJerynCheck;

    public boolean isLoaded() {
        return this.data != null && !this.data.isEmpty();
    }

    private void load() {
        if (this.isLoaded() || this.locked) {
            return;
        }
        this.data = new ArrayList();
        this.locked = true;
        try {
            Path path = this.getSavePath();
            if (Files.exists(path, new LinkOption[0])) {
                String json = Files.readString(path);
                JsonObject jsonObject = (JsonObject)GSON.fromJson(json, JsonObject.class);
                Type listType = new TypeToken<ArrayList<CacheData>>(){}.getType();
                this.data = (ArrayList)GSON.fromJson(jsonObject.get("data"), listType);
                if (this.data == null) {
                    this.data = new ArrayList();
                }
                this.lastJerynCheck = jsonObject.has("jeryn_update") ? jsonObject.get("jeryn_update").getAsLong() : 0L;
                AmbleKit.LOGGER.debug("Loaded skin cache");
            }
        }
        catch (Exception e) {
            AmbleKit.LOGGER.error("Failed to load skin cache", (Throwable)e);
        }
        for (CacheData cache : this.data) {
            SkinGrabber.INSTANCE.getSkinOrDownload(cache.key, cache.url);
        }
        this.locked = false;
    }

    void save() {
        if (this.locked) {
            return;
        }
        if (this.data == null || this.data.isEmpty()) {
            return;
        }
        this.locked = true;
        try {
            Path path = this.getSavePath();
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("data", GSON.toJsonTree(this.data));
            jsonObject.addProperty("jeryn_update", (Number)this.lastJerynCheck);
            String json = GSON.toJson((JsonElement)jsonObject);
            Files.writeString(path, (CharSequence)json, new OpenOption[0]);
            AmbleKit.LOGGER.debug("Saved skin cache");
        }
        catch (Exception e) {
            AmbleKit.LOGGER.error("Failed to save skin cache", (Throwable)e);
        }
        this.locked = false;
    }

    private Path getSavePath() throws IOException {
        Path result = Path.of("./amblekit//cache.json", new String[0]);
        Files.createDirectories(result.getParent(), new FileAttribute[0]);
        return result;
    }

    public boolean add(String uuid, String url) {
        if (this.locked) {
            return false;
        }
        this.load();
        if (this.get(uuid).isEmpty()) {
            this.data.add(new CacheData(uuid, url));
            return true;
        }
        return false;
    }

    public Optional<CacheData> get(String uuid) {
        if (this.locked) {
            return Optional.empty();
        }
        this.load();
        Optional<CacheData> result = this.data.stream().filter(cache -> cache.key.equals(uuid)).findFirst();
        if (result.isEmpty()) {
            return result;
        }
        if (result.get().isOutdated()) {
            AmbleKit.LOGGER.debug("Removing outdated skin from cache: {}", (Object)result.get().key);
            this.data.remove(result.get());
            return Optional.empty();
        }
        return result;
    }

    boolean isJerynOutdated() {
        return System.currentTimeMillis() - this.lastJerynCheck > 43200000L;
    }

    public record CacheData(String key, String url, long lastUpdate) {
        public CacheData(String key, String url) {
            this(key, url, System.currentTimeMillis());
        }

        public boolean isOutdated() {
            return System.currentTimeMillis() - this.lastUpdate > 86400000L;
        }
    }
}

