/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sealife.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.sealife.SeaLife;
import fuzs.sealife.client.renderer.ModRenderType;
import fuzs.sealife.init.ModRegistry;
import fuzs.sealife.world.level.block.entity.FishTrapBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiSpriteManager;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.state.ItemClusterRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class FishTrapBlockEntityRenderer
implements BlockEntityRenderer<FishTrapBlockEntity> {
    public static final ResourceLocation GUI_SHEET = ResourceLocationHelper.withDefaultNamespace((String)"textures/atlas/gui.png");
    static final ResourceLocation SPEECH_BUBBLE_SPRITE = SeaLife.id("speech_bubble");
    private final GuiSpriteManager guiSpriteManager;
    private final ItemRenderer itemRenderer;
    private final ItemModelResolver itemModelResolver;
    private final RandomSource random = RandomSource.create();
    private final ItemClusterRenderState renderState = new ItemClusterRenderState();

    public FishTrapBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.guiSpriteManager = Minecraft.getInstance().getGuiSprites();
        this.itemRenderer = context.getItemRenderer();
        this.itemModelResolver = context.getItemModelResolver();
    }

    public void render(FishTrapBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 cameraPos) {
        ItemStack itemStack;
        Level level = blockEntity.getLevel();
        if (level != null && !(itemStack = blockEntity.getItem(0)).isEmpty()) {
            if (!itemStack.is(ModRegistry.FISHING_BAIT_ITEM_TAG)) {
                this.renderSpeechBubble(blockEntity.getLevel(), itemStack, poseStack, bufferSource, packedLight, packedOverlay);
            }
            this.itemModelResolver.updateForTopItem(this.renderState.item, itemStack, ItemDisplayContext.GROUND, level, null, 0);
            this.renderState.count = ItemClusterRenderState.getRenderedAmount((int)itemStack.getCount());
            this.renderState.seed = ItemClusterRenderState.getSeedForItemStack((ItemStack)itemStack);
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.4f, 0.5f);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(blockEntity.getSpin(partialTick)));
            ItemEntityRenderer.renderMultipleFromCount((PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, (ItemClusterRenderState)this.renderState, (RandomSource)this.random);
            poseStack.popPose();
        }
    }

    private void renderSpeechBubble(Level level, ItemStack itemStack, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 1.5f, 0.5f);
        poseStack.scale(0.75f, 0.75f, 0.75f);
        poseStack.mulPose((Quaternionfc)Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        poseStack.scale(0.75f, 0.75f, 0.01f);
        this.itemRenderer.renderStatic(itemStack, ItemDisplayContext.GUI, packedLight, packedOverlay, poseStack, bufferSource, level, 0);
        poseStack.scale(1.5f, 1.5f, 1.5f);
        poseStack.translate(0.0f, -0.05f, 0.175f);
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
        TextureAtlasSprite sprite = this.guiSpriteManager.getSprite(SPEECH_BUBBLE_SPRITE);
        RenderType renderType = ModRenderType.text(sprite.atlasLocation());
        Matrix4f matrix4f = poseStack.last().pose();
        VertexConsumer vertexConsumer = bufferSource.getBuffer(renderType);
        vertexConsumer.addVertex(matrix4f, -0.5f, -0.5f, 0.0f).setUv(sprite.getU0(), sprite.getV0()).setColor(-1).setLight(packedLight);
        vertexConsumer.addVertex(matrix4f, -0.5f, 0.5f, 0.0f).setUv(sprite.getU0(), sprite.getV1()).setColor(-1).setLight(packedLight);
        vertexConsumer.addVertex(matrix4f, 0.5f, 0.5f, 0.0f).setUv(sprite.getU1(), sprite.getV1()).setColor(-1).setLight(packedLight);
        vertexConsumer.addVertex(matrix4f, 0.5f, -0.5f, 0.0f).setUv(sprite.getU1(), sprite.getV0()).setColor(-1).setLight(packedLight);
        poseStack.popPose();
    }

    public boolean shouldRenderOffScreen(FishTrapBlockEntity blockEntity) {
        return true;
    }

    public int getViewDistance() {
        return 32;
    }
}

