/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sealife.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.sealife.world.level.block.entity.HatcheryBlockEntity;
import fuzs.sealife.world.level.block.entity.HatcheryRenderData;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class HatcheryBlockEntityRenderer
implements BlockEntityRenderer<HatcheryBlockEntity> {
    private final EntityRenderDispatcher entityRenderer;

    public HatcheryBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.entityRenderer = context.getEntityRenderer();
    }

    public void render(HatcheryBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 cameraPos) {
        HatcheryRenderData renderer = blockEntity.getRenderData();
        Entity entity = renderer.getDisplayEntity();
        if (entity != null) {
            for (int i = 0; i < renderer.getCount(); ++i) {
                poseStack.pushPose();
                poseStack.translate(0.5, 0.6, 0.5);
                float maxBbDimension = Math.max(entity.getBbWidth(), entity.getBbHeight());
                float height = renderer.getHeight(i) + 0.021f;
                if ((double)maxBbDimension > 1.0) {
                    height += 1.6f;
                }
                boolean clockwise = renderer.isClockwise(i);
                poseStack.translate(0.0, -0.25 + (0.1 + (double)(height * 0.075f)), 0.0);
                float rotation = renderer.getRotation(i);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(rotation));
                poseStack.translate(0.0, (double)(-0.7f + (maxBbDimension > 1.0f ? 0.1f : 0.0f)), 0.0);
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
                float f = 0.53125f;
                poseStack.scale(f, f, f);
                if ((double)maxBbDimension > 1.0) {
                    poseStack.scale(0.2f, 0.2f, 0.2f);
                } else {
                    poseStack.scale(0.5f, 0.5f, 0.5f);
                }
                poseStack.translate(1.35f, 0.0f, 1.35f);
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(clockwise ? -65.0f : 65.0f));
                entity.setPose(Pose.SWIMMING);
                this.entityRenderer.render(entity, 0.0, 0.0, 0.0, partialTick, poseStack, bufferSource, 0xF000F0);
                poseStack.popPose();
            }
        }
    }
}

