/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sealife.init;

import com.google.common.collect.ImmutableMap;
import fuzs.puzzleslib.api.event.v1.server.LootTableLoadCallback;
import fuzs.sealife.init.ModItems;
import fuzs.sealife.init.ModRegistry;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class ModLootTables {
    static final Map<ResourceLocation, BiConsumer<LootPool.Builder, HolderLookup.Provider>> LOOT_TABLE_INJECTIONS;
    public static final ResourceKey<LootTable> TREASURE_ITEM;
    public static final ResourceKey<LootTable> FISH_TRAP;

    public static void bootstrap() {
    }

    public static void onLootTableLoad(ResourceLocation resourceLocation, LootTable.Builder lootTable, HolderLookup.Provider registries) {
        if (LOOT_TABLE_INJECTIONS.containsKey(resourceLocation)) {
            MutableBoolean mutableBoolean = new MutableBoolean();
            LootTableLoadCallback.forEachPool((LootTable.Builder)lootTable, lootPoolBuilder -> {
                if (mutableBoolean.isFalse()) {
                    mutableBoolean.setTrue();
                    LOOT_TABLE_INJECTIONS.get(resourceLocation).accept((LootPool.Builder)lootPoolBuilder, registries);
                }
            });
        }
    }

    public static void addFishingFish(LootPool.Builder lootPoolBuilder, HolderLookup.Provider registries) {
        lootPoolBuilder.add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.ANCHOVY.value())).setWeight(32).when(ModLootTables.inOceanBiome(registries))).when(ModLootTables.inHotBiome(registries))).add(LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.ANGELFISH.value())).setWeight(3).when(ModLootTables.inJungleBiome(registries))).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.ANGLERFISH.value())).setWeight(1).when(ModLootTables.inOceanBiome(registries))).when(ModLootTables.inSnowyBiome(registries))).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.BASS.value())).setWeight(12).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inHotBiome(registries)))).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inColdBiome(registries)))).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.BLUE_TANG.value())).setWeight(1).when(ModLootTables.inOceanBiome(registries))).when(ModLootTables.inHotBiome(registries))).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.BOWFIN.value())).setWeight(3).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inHotBiome(registries)))).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inOceanBiome(registries)))).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.BUTTERFLYFISH.value())).setWeight(1).when(ModLootTables.inOceanBiome(registries))).when(ModLootTables.inHotBiome(registries))).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.CARP.value())).setWeight(2).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inHotBiome(registries)))).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inOceanBiome(registries)))).add(LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.CATFISH.value())).setWeight(3).when(ModLootTables.inRiverBiome(registries))).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.CHUB.value())).setWeight(54).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inHotBiome(registries)))).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inOceanBiome(registries)))).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.DAMSELFISH.value())).setWeight(3).when(ModLootTables.inOceanBiome(registries))).when(ModLootTables.inHotBiome(registries))).add(LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.ELECTRIC_RAY.value())).setWeight(1).when(ModLootTables.inOceanBiome(registries))).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.GOLDFISH.value())).setWeight(37).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inHotBiome(registries)))).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inSwampyBiome(registries)))).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.KOI.value())).setWeight(1).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inHotBiome(registries)))).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inSwampyBiome(registries)))).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.LAMPREY.value())).setWeight(4).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inHotBiome(registries)))).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inColdBiome(registries)))).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.LUNGFISH.value())).setWeight(1).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inColdBiome(registries)))).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inOceanBiome(registries)))).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.MANTA_RAY.value())).setWeight(1).when(ModLootTables.inOceanBiome(registries))).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inSnowyBiome(registries)))).add(LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.MINNOW.value())).setWeight(102).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inOceanBiome(registries)))).add(LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.NEON_TETRA.value())).setWeight(2).when(ModLootTables.inJungleBiome(registries))).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.NORTHERN_PIKE.value())).setWeight(1).when(ModLootTables.inSnowyBiome(registries))).when(ModLootTables.inRiverBiome(registries))).add(LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.PERCH.value())).setWeight(21).when(ModLootTables.inRiverBiome(registries))).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.PICKEREL.value())).setWeight(2).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inHotBiome(registries)))).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inOceanBiome(registries)))).add(LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.PIRANHA.value())).setWeight(1).when(ModLootTables.inJungleBiome(registries))).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.PUPFISH.value())).setWeight(4).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inHotBiome(registries)))).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inOceanBiome(registries)))).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.SARDINE.value())).setWeight(30).when(ModLootTables.inOceanBiome(registries))).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inHotBiome(registries)))).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.SIAMESE_FIGHTING_FISH.value())).setWeight(2).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inHotBiome(registries)))).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inOceanBiome(registries)))).add(LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.STINGRAY.value())).setWeight(1).when(ModLootTables.inOceanBiome(registries))).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.SILVER_STRIPE_BLAASOP.value())).setWeight(1).when(ModLootTables.inOceanBiome(registries))).when(ModLootTables.inSnowyBiome(registries))).add(LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.TROUT.value())).setWeight(14).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inHotBiome(registries)))).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.TUNA.value())).setWeight(2).when(ModLootTables.inOceanBiome(registries))).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inHotBiome(registries)))).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.WALLEYE.value())).setWeight(8).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inHotBiome(registries)))).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inColdBiome(registries)))).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.WHITEMARGIN_STARGAZER.value())).setWeight(2).when(ModLootTables.inHotBiome(registries))).when(ModLootTables.inOceanBiome(registries)));
    }

    public static void addFishingJunk(LootPool.Builder lootPoolBuilder, HolderLookup.Provider registries) {
        lootPoolBuilder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.FISH_BONES.value())).setWeight(17)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.OLD_BOOT.value())).setWeight(14)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.EMPTY_CAN.value())).setWeight(16));
    }

    public static void addFishingTreasure(LootPool.Builder lootPoolBuilder, HolderLookup.Provider registries) {
        lootPoolBuilder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.EMERALD).setWeight(5)).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.FISH_FOSSIL.value())).setWeight(10).when(ModLootTables.inOceanBiome(registries))).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inSnowyBiome(registries)))).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.PIRATE_TREASURE.value())).setWeight(1).when(ModLootTables.inOceanBiome(registries))).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)ModLootTables.inSnowyBiome(registries))));
    }

    private static LootItemCondition.Builder inOceanBiome(HolderLookup.Provider registries) {
        return LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)registries.lookupOrThrow(Registries.BIOME).getOrThrow(BiomeTags.IS_OCEAN)));
    }

    private static LootItemCondition.Builder inColdBiome(HolderLookup.Provider registries) {
        return LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)registries.lookupOrThrow(Registries.BIOME).getOrThrow(ModRegistry.IS_COLD_BIOME_TAG)));
    }

    private static LootItemCondition.Builder inHotBiome(HolderLookup.Provider registries) {
        return LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)registries.lookupOrThrow(Registries.BIOME).getOrThrow(ModRegistry.IS_HOT_BIOME_TAG)));
    }

    private static LootItemCondition.Builder inSnowyBiome(HolderLookup.Provider registries) {
        return LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)registries.lookupOrThrow(Registries.BIOME).getOrThrow(ModRegistry.IS_SNOWY_BIOME_TAG)));
    }

    private static LootItemCondition.Builder inRiverBiome(HolderLookup.Provider registries) {
        return LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)registries.lookupOrThrow(Registries.BIOME).getOrThrow(BiomeTags.IS_RIVER)));
    }

    private static LootItemCondition.Builder inSwampyBiome(HolderLookup.Provider registries) {
        return LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)registries.lookupOrThrow(Registries.BIOME).getOrThrow(ModRegistry.IS_WET_BIOME_TAG)));
    }

    private static LootItemCondition.Builder inJungleBiome(HolderLookup.Provider registries) {
        return LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)registries.lookupOrThrow(Registries.BIOME).getOrThrow(BiomeTags.IS_JUNGLE)));
    }

    static {
        TREASURE_ITEM = ModRegistry.REGISTRIES.makeResourceKey(Registries.LOOT_TABLE, "gameplay/treasure_item");
        FISH_TRAP = ModRegistry.REGISTRIES.makeResourceKey(Registries.LOOT_TABLE, "gameplay/fish_trap");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)BuiltInLootTables.FISHING_FISH.location(), ModLootTables::addFishingFish);
        builder.put((Object)BuiltInLootTables.FISHING_JUNK.location(), ModLootTables::addFishingJunk);
        builder.put((Object)BuiltInLootTables.FISHING_TREASURE.location(), ModLootTables::addFishingTreasure);
        LOOT_TABLE_INJECTIONS = builder.build();
    }
}

