/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sealife.world.entity.animal;

import fuzs.sealife.world.entity.animal.SolitaryFish;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FloordwellingFish
extends SolitaryFish {
    public FloordwellingFish(EntityType<? extends SolitaryFish> entityType, Level level, Holder<Item> bucketItem) {
        super(entityType, level, bucketItem);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public static <T extends SolitaryFish> EntityType.EntityFactory<T> create(Holder<Item> bucketItem) {
        return (entityType, level) -> new FloordwellingFish((EntityType<? extends SolitaryFish>)entityType, level, bucketItem);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 4.0f, 0.8, 0.7, EntitySelector.NO_SPECTATORS::test));
        this.goalSelector.addGoal(4, (Goal)new SwimGoal(this));
    }

    static class SwimGoal
    extends RandomSwimmingGoal {
        public SwimGoal(AbstractFish abstractFish) {
            super((PathfinderMob)abstractFish, 1.0, 40);
        }

        @Nullable
        protected Vec3 getPosition() {
            Vec3 vector3d = DefaultRandomPos.getPos((PathfinderMob)this.mob, (int)1, (int)1);
            int i = 0;
            while (vector3d != null && !this.mob.level().getBlockState(BlockPos.containing((Position)vector3d)).isPathfindable(PathComputationType.WATER) && this.mob.level().getBlockState(BlockPos.containing((Position)vector3d).below()).getFluidState().is(FluidTags.WATER) && i++ < 10) {
                vector3d = DefaultRandomPos.getPos((PathfinderMob)this.mob, (int)10, (int)1);
            }
            return vector3d;
        }
    }
}

