/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sealife.world.level.block;

import com.mojang.serialization.MapCodec;
import fuzs.puzzleslib.api.block.v1.entity.TickingEntityBlock;
import fuzs.sealife.init.ModBlocks;
import fuzs.sealife.init.ModLootTables;
import fuzs.sealife.init.ModRegistry;
import fuzs.sealife.world.level.block.entity.FishTrapBlockEntity;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FishTrapBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
TickingEntityBlock<FishTrapBlockEntity> {
    public static final MapCodec<FishTrapBlock> CODEC = FishTrapBlock.simpleCodec(FishTrapBlock::new);
    public static final List<BlockPos> WATER_OFFSETS = BlockPos.withinManhattanStream((BlockPos)BlockPos.ZERO, (int)1, (int)1, (int)1).filter(blockPos -> blockPos.distManhattan((Vec3i)BlockPos.ZERO) == 1).map(BlockPos::immutable).toList();
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final IntegerProperty STAGE = BlockStateProperties.STAGE;
    public static final BooleanProperty ENABLED = BlockStateProperties.ENABLED;

    public FishTrapBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)STAGE, (Comparable)Integer.valueOf(0))).setValue((Property)ENABLED, (Comparable)Boolean.FALSE));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        boolean bl = fluidState.getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(bl))).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(FishTrapBlock.isSurroundedByWater((LevelReader)context.getLevel(), context.getClickedPos())));
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return (BlockState)state.setValue((Property)ENABLED, (Comparable)Boolean.valueOf(FishTrapBlock.isSurroundedByWater(level, pos)));
    }

    public static boolean isSurroundedByWater(LevelReader level, BlockPos blockPos) {
        int waterOnSides = 0;
        for (BlockPos offsetPos : WATER_OFFSETS) {
            if (!level.getFluidState(blockPos.offset((Vec3i)offsetPos)).is(FluidTags.WATER)) continue;
            ++waterOnSides;
        }
        return waterOnSides >= 5;
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return super.isRandomlyTicking(state) && (Boolean)state.getValue((Property)WATERLOGGED) != false;
    }

    protected void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        FishTrapBlockEntity blockEntity;
        BlockEntity blockEntity2;
        if (randomSource.nextInt(7) == 0 && ((Boolean)blockState.getValue((Property)ENABLED)).booleanValue() && (blockEntity2 = serverLevel.getBlockEntity(blockPos)) instanceof FishTrapBlockEntity && (blockEntity = (FishTrapBlockEntity)blockEntity2).isBaited()) {
            if ((Integer)blockState.getValue((Property)STAGE) == 0) {
                serverLevel.setBlock(blockPos, (BlockState)blockState.cycle((Property)STAGE), 2);
            } else {
                LootParams lootParams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)blockPos)).withParameter(LootContextParams.TOOL, (Object)blockEntity.getItem(0)).create(LootContextParamSets.FISHING);
                LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(ModLootTables.FISH_TRAP);
                ObjectArrayList list = lootTable.getRandomItems(lootParams);
                ItemStack itemStack = list.isEmpty() ? ItemStack.EMPTY : (ItemStack)list.getFirst();
                blockEntity.setItem(0, itemStack);
                serverLevel.setBlock(blockPos, (BlockState)blockState.setValue((Property)STAGE, (Comparable)Integer.valueOf(0)), 2);
            }
        }
    }

    protected InteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FishTrapBlockEntity) {
            FishTrapBlockEntity blockEntity2 = (FishTrapBlockEntity)blockEntity;
            if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && blockEntity2.getItem(0).isEmpty() && itemStack.is(ModRegistry.FISHING_BAIT_ITEM_TAG)) {
                if (!level.isClientSide()) {
                    player.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
                    blockEntity2.setItem(0, itemStack.consumeAndReturn(1, (LivingEntity)player));
                    level.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
            return super.useItemOn(itemStack, state, level, pos, player, hand, hitResult);
        }
        return InteractionResult.PASS;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FishTrapBlockEntity) {
            FishTrapBlockEntity blockEntity2 = (FishTrapBlockEntity)blockEntity;
            if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && !blockEntity2.getItem(0).isEmpty() && !blockEntity2.isBaited()) {
                if (!level.isClientSide()) {
                    ItemStack itemStack = blockEntity2.removeItem(0, 1);
                    level.playSound(null, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (!player.getInventory().add(itemStack)) {
                        player.drop(itemStack, false);
                    }
                    level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                    if (level.getRandom().nextInt(3) == 0) {
                        level.destroyBlock(pos, false);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            return super.useWithoutItem(state, level, pos, player, hitResult);
        }
        return InteractionResult.PASS;
    }

    public BlockEntityType<? extends FishTrapBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlocks.FISH_TRAP_BLOCK_ENTITY_TYPE.value();
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, STAGE, ENABLED});
    }
}

