/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sealife.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import fuzs.puzzleslib.api.block.v1.entity.TickingEntityBlock;
import fuzs.sealife.init.ModBlocks;
import fuzs.sealife.init.ModRegistry;
import fuzs.sealife.world.level.block.entity.HatcheryBlockEntity;
import java.util.Collections;
import java.util.Map;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HatcheryBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
TickingEntityBlock<HatcheryBlockEntity> {
    public static final int MAX_CAPACITY = 12;
    public static final int COMMON_CYCLES = 3;
    public static final int UNCOMMON_CYCLES = 5;
    public static final int RARE_CYCLES = 7;
    public static final MapCodec<HatcheryBlock> CODEC = HatcheryBlock.simpleCodec(HatcheryBlock::new);
    protected static final VoxelShape SHAPE_INSIDE = Block.column((double)14.0, (double)1.0, (double)16.0);
    protected static final VoxelShape SHAPE = Shapes.join((VoxelShape)Block.column((double)16.0, (double)0.0, (double)15.0), (VoxelShape)SHAPE_INSIDE, (BooleanOp)BooleanOp.ONLY_FIRST);
    protected static final VoxelShape COLLISION_SHAPE = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)SHAPE_INSIDE, (BooleanOp)BooleanOp.ONLY_FIRST);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final IntegerProperty STAGE = IntegerProperty.create((String)"stage", (int)0, (int)Math.max(Math.max(3, 5), 7));
    static Map<EntityType<?>, Item> bucketableMobs = Collections.emptyMap();

    public HatcheryBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public static void onLoadComplete() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Item item : BuiltInRegistries.ITEM) {
            if (!(item instanceof MobBucketItem)) continue;
            MobBucketItem mobBucketItem = (MobBucketItem)item;
            builder.put((Object)mobBucketItem.type, (Object)item);
        }
        bucketableMobs = builder.build();
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        boolean bl = fluidState.getType() == Fluids.WATER;
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(bl));
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPE;
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return super.isRandomlyTicking(state) && (Boolean)state.getValue((Property)WATERLOGGED) != false;
    }

    protected void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        HatcheryBlockEntity blockEntity;
        BlockEntity blockEntity2;
        if (randomSource.nextInt(3) == 0 && (blockEntity2 = serverLevel.getBlockEntity(blockPos)) instanceof HatcheryBlockEntity && (blockEntity = (HatcheryBlockEntity)blockEntity2).getEntityType() != null && blockEntity.getCount() < 12) {
            int hatchingCycles = HatcheryBlock.getHatchingCycles(blockEntity.getEntityType());
            if ((Integer)blockState.getValue((Property)STAGE) < hatchingCycles) {
                serverLevel.setBlock(blockPos, (BlockState)blockState.cycle((Property)STAGE), 3);
            } else {
                blockEntity.addFish(blockEntity.getEntityType(), 1);
                serverLevel.setBlock(blockPos, (BlockState)blockState.setValue((Property)STAGE, (Comparable)Integer.valueOf(0)), 3);
            }
        }
    }

    public static int getHatchingCycles(EntityType<?> entityType) {
        if (entityType.is(ModRegistry.COMMON_FISHES_ENTITY_TYPE_TAG)) {
            return 3;
        }
        if (entityType.is(ModRegistry.UNCOMMON_FISHES_ENTITY_TYPE_TAG)) {
            return 5;
        }
        if (entityType.is(ModRegistry.RARE_FISHES_ENTITY_TYPE_TAG)) {
            return 7;
        }
        return 5;
    }

    protected InteractionResult useItemOn(ItemStack itemInHand, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof HatcheryBlockEntity) {
            HatcheryBlockEntity blockEntity2 = (HatcheryBlockEntity)blockEntity;
            if (itemInHand.is(Items.WATER_BUCKET)) {
                Item item;
                if (!blockEntity2.isEmpty() && (item = bucketableMobs.get(blockEntity2.getEntityType())) != null) {
                    ItemStack itemStack = new ItemStack((ItemLike)item);
                    ItemStack resultItemStack = ItemUtils.createFilledResult((ItemStack)itemInHand, (Player)player, (ItemStack)itemStack);
                    if (!level.isClientSide()) {
                        level.setBlock(blockPos, (BlockState)blockState.setValue((Property)STAGE, (Comparable)Integer.valueOf(0)), 3);
                        blockEntity2.removeFish(1, false);
                        CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, itemStack);
                        player.playSound(SoundEvents.BUCKET_FILL_FISH, 1.0f, 1.0f);
                    }
                    player.setItemInHand(interactionHand, resultItemStack);
                    return InteractionResult.SUCCESS.heldItemTransformedTo(resultItemStack);
                }
            } else {
                Item item = itemInHand.getItem();
                if (item instanceof MobBucketItem) {
                    MobBucketItem item2 = (MobBucketItem)item;
                    if (blockEntity2.getCount() < 12 && (blockEntity2.getEntityType() == null || blockEntity2.getEntityType() == item2.type)) {
                        ItemStack itemStack = (Boolean)blockState.getValue((Property)WATERLOGGED) != false ? new ItemStack((ItemLike)Items.WATER_BUCKET) : new ItemStack((ItemLike)Items.BUCKET);
                        ItemStack resultItemStack = ItemUtils.createFilledResult((ItemStack)itemInHand, (Player)player, (ItemStack)itemStack);
                        if (!level.isClientSide()) {
                            if (!((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
                                FluidState fluidState = Fluids.WATER.getSource(false);
                                level.setBlock(blockPos, (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                                level.scheduleTick(blockPos, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)level));
                            }
                            CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, resultItemStack);
                            player.playSound(SoundEvents.BUCKET_FILL_FISH, 1.0f, 1.0f);
                            blockEntity2.addFish(item2.type, 1);
                        }
                        player.setItemInHand(interactionHand, resultItemStack);
                        return InteractionResult.SUCCESS.heldItemTransformedTo(resultItemStack);
                    }
                    return InteractionResult.CONSUME;
                }
            }
        } else {
            return InteractionResult.PASS;
        }
        return super.useItemOn(itemInHand, blockState, level, blockPos, player, interactionHand, hitResult);
    }

    public BlockEntityType<? extends HatcheryBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlocks.HATCHERY_BLOCK_ENTITY_TYPE.value();
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        int n;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof HatcheryBlockEntity) {
            HatcheryBlockEntity blockEntity2 = (HatcheryBlockEntity)blockEntity;
            n = blockEntity2.getCount();
        } else {
            n = 0;
        }
        return n;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, STAGE});
    }
}

