/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.block.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.data.LightData;
import foundry.veil.api.client.render.light.data.PointLightData;
import foundry.veil.api.client.render.light.renderer.LightRenderHandle;
import foundry.veil.api.client.render.light.renderer.LightRenderer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public final class DecalLightClient {
    private static final Map<Integer, LightRenderHandle<PointLightData>> HANDLES = new HashMap<Integer, LightRenderHandle<PointLightData>>();
    private static final Map<Integer, PointLightData> DATA = new HashMap<Integer, PointLightData>();
    private static class_2960 lastWorldId = null;

    public static void initClient() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> DecalLightClient.clearAll());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> DecalLightClient.clearAll());
        ClientChunkEvents.CHUNK_UNLOAD.register((world, chunk) -> DecalLightClient.pruneNow());
        WorldRenderEvents.START.register(ctx -> {
            if (!RenderSystem.isOnRenderThread()) {
                return;
            }
            class_310 mc = class_310.method_1551();
            class_638 w = mc.field_1687;
            if (w == null) {
                DecalLightClient.clearAll();
                return;
            }
            class_2960 wid = w.method_27983().method_29177();
            if (lastWorldId == null || !lastWorldId.equals((Object)wid)) {
                DecalLightClient.clearAll();
                lastWorldId = wid;
            }
            if (mc.field_1724 == null || !mc.field_1724.method_5805()) {
                DecalLightClient.clearAll();
                return;
            }
            DecalLightClient.pruneNow();
        });
    }

    public static void update(int id, double x, double y, double z, float r, float g, float b, float brightness, float radius) {
        LightRenderer renderer;
        if (!RenderSystem.isOnRenderThread()) {
            return;
        }
        if (brightness <= 0.0f || radius <= 0.0f) {
            DecalLightClient.remove(id);
            return;
        }
        LightRenderer lightRenderer = renderer = VeilRenderSystem.renderer() != null ? VeilRenderSystem.renderer().getLightRenderer() : null;
        if (renderer == null) {
            return;
        }
        PointLightData pl = DATA.get(id);
        LightRenderHandle handle = HANDLES.get(id);
        if (pl == null || handle == null || !handle.isValid()) {
            pl = new PointLightData().setBrightness(brightness).setColor(r, g, b).setRadius(radius);
            pl.setPosition((double)((float)x), (double)((float)y), (double)((float)z));
            handle = renderer.addLight((LightData)pl);
            DATA.put(id, pl);
            HANDLES.put(id, (LightRenderHandle<PointLightData>)handle);
            return;
        }
        pl.setBrightness(brightness);
        pl.setColor(r, g, b);
        pl.setRadius(radius);
        pl.setPosition((double)((float)x), (double)((float)y), (double)((float)z));
        handle.markDirty();
    }

    public static void remove(int id) {
        LightRenderHandle<PointLightData> h = HANDLES.remove(id);
        if (h != null && h.isValid()) {
            h.close();
        }
        DATA.remove(id);
    }

    private static void clearAll() {
        for (LightRenderHandle<PointLightData> h : HANDLES.values()) {
            if (h == null || !h.isValid()) continue;
            h.close();
        }
        HANDLES.clear();
        DATA.clear();
    }

    private static void pruneNow() {
        class_310 mc = class_310.method_1551();
        class_638 w = mc.field_1687;
        if (w == null) {
            DecalLightClient.clearAll();
            return;
        }
        Iterator<Map.Entry<Integer, LightRenderHandle<PointLightData>>> it = HANDLES.entrySet().iterator();
        while (it.hasNext()) {
            boolean dead;
            Map.Entry<Integer, LightRenderHandle<PointLightData>> e = it.next();
            int id = e.getKey();
            LightRenderHandle<PointLightData> h = e.getValue();
            class_1297 ent = w.method_8469(id);
            boolean bl = dead = ent == null || ent.method_31481();
            if (!dead && h != null && h.isValid()) continue;
            if (h != null && h.isValid()) {
                h.close();
            }
            it.remove();
            DATA.remove(id);
        }
    }

    private DecalLightClient() {
    }
}

