/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.block.custom;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.data.AreaLightData;
import foundry.veil.api.client.render.light.data.LightData;
import foundry.veil.api.client.render.light.data.PointLightData;
import foundry.veil.api.client.render.light.renderer.LightRenderHandle;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.kronoz.odyssey.block.CollisionShapeHelper;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class Light2Block
extends class_2248
implements class_3737 {
    public static final class_2753 FACING = class_2741.field_12525;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final Map<class_2350, class_265> DIR_SHAPES = CollisionShapeHelper.loadDirectionalCollisionFromModelJson("odyssey", "light_2");
    private static final double AL_SIZE_X = 0.2;
    private static final double AL_SIZE_Y = 0.2;
    private static final float AL_ANGLE = (float)Math.toRadians(40.0);
    private static final float AL_DIST = 25.0f;
    private static final float PL_RADIUS = 5.0f;
    private static final float CLR_R = 1.0f;
    private static final float CLR_G = 0.87f;
    private static final float CLR_B = 0.95f;
    private static final Quaternionf ORIENTATION_DOWN = new Quaternionf().rotateX(-1.5707964f);
    private static final Map<class_2338, LightRenderHandle<AreaLightData>> AREA_HANDLES = new ConcurrentHashMap<class_2338, LightRenderHandle<AreaLightData>>();
    private static final Map<class_2338, LightRenderHandle<PointLightData>> POINT_HANDLES = new ConcurrentHashMap<class_2338, LightRenderHandle<PointLightData>>();
    private static final Map<class_2338, AreaLightData> AREA_DATA = new ConcurrentHashMap<class_2338, AreaLightData>();
    private static final Map<class_2338, PointLightData> POINT_DATA = new ConcurrentHashMap<class_2338, PointLightData>();
    private static final class_243 BONE_LIGHT_OFFSET = new class_243(0.5, 0.8, 0.5);
    private static final float BASE_BRIGHTNESS = 1.0f;
    private static boolean hooks = false;
    private static boolean rescanPending = false;
    private static boolean rendererWasReady = false;
    private static final Random RNG = new Random();
    private static final Map<class_2338, Flicker> FLICKER = new ConcurrentHashMap<class_2338, Flicker>();

    public Light2Block(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        Light2Block.ensureHooks();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, WATERLOGGED});
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        boolean water = ctx.method_8045().method_8316(ctx.method_8037()).method_15772() == class_3612.field_15910;
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8038())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(water));
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9559(class_2680 state, class_2350 dir, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, dir, neighborState, world, pos, neighborPos);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean moved) {
        super.method_9615(state, world, pos, oldState, moved);
        if (world.field_9236) {
            Light2Block.spawnLightsIfNeeded(world, pos);
        }
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        super.method_9567(world, pos, state, placer, stack);
        if (world.field_9236) {
            Light2Block.spawnLightsIfNeeded(world, pos);
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);
        if (world.field_9236 && !newState.method_27852((class_2248)this)) {
            Light2Block.removeLightsIfAny(pos);
        }
    }

    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        super.method_9585(world, pos, state);
        if (world.method_8608()) {
            Light2Block.removeLightsIfAny(pos);
        }
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_265 s = DIR_SHAPES.get(state.method_11654((class_2769)FACING));
        return s != null ? s : class_259.method_1077();
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_265 s = DIR_SHAPES.get(state.method_11654((class_2769)FACING));
        return s != null ? s : class_259.method_1077();
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    private static void spawnLightsIfNeeded(class_1937 world, class_2338 pos) {
        if (!world.field_9236) {
            return;
        }
        if (AREA_HANDLES.containsKey(pos) || POINT_HANDLES.containsKey(pos)) {
            return;
        }
        if (VeilRenderSystem.renderer() == null || VeilRenderSystem.renderer().getLightRenderer() == null) {
            return;
        }
        class_243 c = new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()).method_1019(BONE_LIGHT_OFFSET);
        AreaLightData al = new AreaLightData().setBrightness(1.0f).setColor(1.0f, 0.87f, 0.95f).setSize(0.2, 0.2).setAngle(AL_ANGLE).setDistance(25.0f);
        al.getPosition().set(c.field_1352, c.field_1351, c.field_1350);
        al.getOrientation().set((Quaternionfc)ORIENTATION_DOWN);
        PointLightData pl = new PointLightData().setBrightness(1.0f).setColor(1.0f, 0.87f, 0.95f).setRadius(5.0f);
        pl.setPosition((double)((float)c.field_1352), (double)((float)c.field_1351), (double)((float)c.field_1350));
        LightRenderHandle ah = VeilRenderSystem.renderer().getLightRenderer().addLight((LightData)al);
        LightRenderHandle ph = VeilRenderSystem.renderer().getLightRenderer().addLight((LightData)pl);
        AREA_HANDLES.put(pos, (LightRenderHandle<AreaLightData>)ah);
        POINT_HANDLES.put(pos, (LightRenderHandle<PointLightData>)ph);
        AREA_DATA.put(pos, al);
        POINT_DATA.put(pos, pl);
        Flicker f = new Flicker();
        f.phase = Phase.IDLE;
        f.cooldown = Light2Block.rand(5.0f, 30.0f);
        FLICKER.put(pos, f);
    }

    private static void removeLightsIfAny(class_2338 pos) {
        LightRenderHandle<AreaLightData> ah = AREA_HANDLES.remove(pos);
        if (ah != null && ah.isValid()) {
            ah.close();
        }
        AREA_DATA.remove(pos);
        LightRenderHandle<PointLightData> ph = POINT_HANDLES.remove(pos);
        if (ph != null && ph.isValid()) {
            ph.close();
        }
        POINT_DATA.remove(pos);
        FLICKER.remove(pos);
    }

    private static void ensureHooks() {
        if (hooks) {
            return;
        }
        hooks = true;
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            rescanPending = true;
            rendererWasReady = false;
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            for (LightRenderHandle<AreaLightData> lightRenderHandle : AREA_HANDLES.values()) {
                if (lightRenderHandle == null || !lightRenderHandle.isValid()) continue;
                lightRenderHandle.close();
            }
            for (LightRenderHandle<AreaLightData> lightRenderHandle : POINT_HANDLES.values()) {
                if (lightRenderHandle == null || !lightRenderHandle.isValid()) continue;
                lightRenderHandle.close();
            }
            AREA_HANDLES.clear();
            POINT_HANDLES.clear();
            AREA_DATA.clear();
            POINT_DATA.clear();
            FLICKER.clear();
            rescanPending = false;
            rendererWasReady = false;
        });
        ClientChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            if (world == null || chunk == null) {
                return;
            }
            if (VeilRenderSystem.renderer() == null || VeilRenderSystem.renderer().getLightRenderer() == null) {
                return;
            }
            class_1923 cpos = chunk.method_12004();
            int minY = world.method_31607();
            int maxY = world.method_31600();
            int sx = cpos.method_8326();
            int sz = cpos.method_8328();
            for (int y = minY; y < maxY; ++y) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        class_2338 bp = new class_2338(sx + x, y, sz + z);
                        class_2680 st = world.method_8320(bp);
                        if (!(st.method_26204() instanceof Light2Block)) continue;
                        Light2Block.spawnLightsIfNeeded((class_1937)world, bp);
                    }
                }
            }
        });
        ClientChunkEvents.CHUNK_UNLOAD.register((world, chunk) -> {
            if (world == null || chunk == null) {
                return;
            }
            class_1923 cpos = chunk.method_12004();
            ArrayList<class_2338> toRemove = new ArrayList<class_2338>();
            for (class_2338 p : AREA_HANDLES.keySet()) {
                if (p.method_10263() >> 4 != cpos.field_9181 || p.method_10260() >> 4 != cpos.field_9180) continue;
                toRemove.add(p);
            }
            for (class_2338 p : toRemove) {
                Light2Block.removeLightsIfAny(p);
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            boolean rendererReady;
            if (client == null || client.method_1493()) {
                return;
            }
            boolean bl = rendererReady = VeilRenderSystem.renderer() != null && VeilRenderSystem.renderer().getLightRenderer() != null;
            if (rendererReady && !rendererWasReady) {
                rescanPending = true;
            }
            rendererWasReady = rendererReady;
            if (rescanPending && client.field_1687 != null && client.field_1724 != null && rendererReady) {
                class_638 w = client.field_1687;
                class_2338 p = client.field_1724.method_24515();
                int r = 4;
                for (int cx = (p.method_10263() >> 4) - r; cx <= (p.method_10263() >> 4) + r; ++cx) {
                    for (int cz = (p.method_10260() >> 4) - r; cz <= (p.method_10260() >> 4) + r; ++cz) {
                        if (w.method_2935().method_12246(cx, cz) == null) continue;
                        class_1923 cp = new class_1923(cx, cz);
                        int minY = w.method_31607();
                        int maxY = w.method_31600();
                        int sx = cp.method_8326();
                        int sz = cp.method_8328();
                        for (int y = minY; y < maxY; ++y) {
                            for (int x = 0; x < 16; ++x) {
                                for (int z = 0; z < 16; ++z) {
                                    class_2338 bp = new class_2338(sx + x, y, sz + z);
                                    class_2680 st = w.method_8320(bp);
                                    if (!(st.method_26204() instanceof Light2Block)) continue;
                                    Light2Block.spawnLightsIfNeeded((class_1937)w, bp);
                                }
                            }
                        }
                    }
                }
                rescanPending = false;
            }
            if (!rendererReady) {
                return;
            }
            float dt = client.method_60646().method_60636();
            block14: for (class_2338 pos : AREA_DATA.keySet().toArray(new class_2338[0])) {
                Flicker f = FLICKER.computeIfAbsent(pos, k -> {
                    Flicker n = new Flicker();
                    n.phase = Phase.IDLE;
                    n.cooldown = Light2Block.rand(5.0f, 30.0f);
                    return n;
                });
                switch (f.phase.ordinal()) {
                    case 0: {
                        f.cooldown -= dt;
                        Light2Block.applyBrightness(pos, 1.0f);
                        if (!(f.cooldown <= 0.0f)) continue block14;
                        f.flashesLeft = 1 + RNG.nextInt(5);
                        f.offDur = Light2Block.rand(0.04f, 0.12f);
                        f.onDur = Light2Block.rand(0.04f, 0.12f);
                        f.timer = 0.0f;
                        f.phase = Phase.BURST_OFF;
                        continue block14;
                    }
                    case 1: {
                        f.timer += dt;
                        Light2Block.applyBrightness(pos, 0.0f);
                        if (!(f.timer >= f.offDur)) continue block14;
                        f.timer = 0.0f;
                        f.phase = Phase.BURST_ON;
                        continue block14;
                    }
                    case 2: {
                        f.timer += dt;
                        Light2Block.applyBrightness(pos, 1.0f);
                        if (!(f.timer >= f.onDur)) continue block14;
                        --f.flashesLeft;
                        if (f.flashesLeft <= 0) {
                            f.tailLeft = 1 + RNG.nextInt(3);
                            f.tailGap = Light2Block.rand(0.35f, 0.9f);
                            f.timer = 0.0f;
                            f.phase = Phase.TAIL_WAIT;
                            continue block14;
                        }
                        f.offDur = Light2Block.rand(0.04f, 0.12f);
                        f.onDur = Light2Block.rand(0.04f, 0.12f);
                        f.timer = 0.0f;
                        f.phase = Phase.BURST_OFF;
                        continue block14;
                    }
                    case 3: {
                        f.timer += dt;
                        Light2Block.applyBrightness(pos, 1.0f);
                        if (!(f.timer >= f.tailGap)) continue block14;
                        f.timer = 0.0f;
                        f.offDur = Light2Block.rand(0.12f, 0.25f);
                        f.onDur = Light2Block.rand(0.1f, 0.22f);
                        f.phase = Phase.TAIL_OFF;
                        continue block14;
                    }
                    case 4: {
                        f.timer += dt;
                        Light2Block.applyBrightness(pos, 0.0f);
                        if (!(f.timer >= f.offDur)) continue block14;
                        f.timer = 0.0f;
                        f.phase = Phase.TAIL_ON;
                        continue block14;
                    }
                    case 5: {
                        f.timer += dt;
                        Light2Block.applyBrightness(pos, 1.0f);
                        if (!(f.timer >= f.onDur)) continue block14;
                        --f.tailLeft;
                        if (f.tailLeft <= 0) {
                            f.settleTime = 0.0f;
                            f.settleDur = Light2Block.rand(0.4f, 0.8f);
                            f.settleFrom = 1.0f;
                            f.phase = Phase.SETTLE;
                            continue block14;
                        }
                        f.timer = 0.0f;
                        f.tailGap = Light2Block.rand(0.35f, 0.9f);
                        f.phase = Phase.TAIL_WAIT;
                        continue block14;
                    }
                    case 6: {
                        f.settleTime += dt;
                        float t = Light2Block.clamp01(f.settleTime / f.settleDur);
                        float b = Light2Block.lerp(f.settleFrom, 1.0f, Light2Block.smoothstep01(t));
                        Light2Block.applyBrightness(pos, b);
                        if (!(t >= 1.0f)) continue block14;
                        f.cooldown = Light2Block.rand(5.0f, 30.0f);
                        f.phase = Phase.IDLE;
                    }
                }
            }
        });
    }

    private static void applyBrightness(class_2338 pos, float b) {
        LightRenderHandle<PointLightData> ph;
        LightRenderHandle<AreaLightData> ah;
        PointLightData pl;
        AreaLightData al = AREA_DATA.get(pos);
        if (al != null) {
            al.setBrightness(b);
        }
        if ((pl = POINT_DATA.get(pos)) != null) {
            pl.setBrightness(b);
        }
        if ((ah = AREA_HANDLES.get(pos)) != null && ah.isValid()) {
            ah.markDirty();
        }
        if ((ph = POINT_HANDLES.get(pos)) != null && ph.isValid()) {
            ph.markDirty();
        }
    }

    private static float rand(float a, float b) {
        return a + (b - a) * RNG.nextFloat();
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    private static float clamp01(float v) {
        return v < 0.0f ? 0.0f : (v > 1.0f ? 1.0f : v);
    }

    private static float smoothstep01(float x) {
        x = Light2Block.clamp01(x);
        return x * x * (3.0f - 2.0f * x);
    }

    private static final class Flicker {
        Phase phase = Phase.IDLE;
        float cooldown;
        int flashesLeft;
        float timer;
        float offDur;
        float onDur;
        int tailLeft;
        float tailGap;
        float settleTime;
        float settleDur;
        float settleFrom;

        private Flicker() {
        }
    }

    private static enum Phase {
        IDLE,
        BURST_OFF,
        BURST_ON,
        TAIL_WAIT,
        TAIL_OFF,
        TAIL_ON,
        SETTLE;

    }
}

