/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.client;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.data.LightData;
import foundry.veil.api.client.render.light.data.PointLightData;
import foundry.veil.api.client.render.light.renderer.LightRenderHandle;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.kronoz.odyssey.hud.death.DeathUICutscene;
import net.minecraft.class_2338;
import net.minecraft.class_243;

public final class ExpandingVeilLight {
    private static final float START_RADIUS = 0.0f;
    private static final float END_RADIUS = 16.0f;
    private static final float BRIGHTNESS = 4.0f;
    private static final float DURATION_S = 20.0f;
    private static final float CLR_R = 1.0f;
    private static final float CLR_G = 0.0f;
    private static final float CLR_B = 0.0f;
    private static final Map<class_2338, State> ACTIVE = new HashMap<class_2338, State>();
    private static boolean hooked = false;

    private ExpandingVeilLight() {
    }

    public static void trigger(class_2338 pos) {
        ExpandingVeilLight.ensureHooks();
        if (ACTIVE.containsKey(pos)) {
            return;
        }
        if (!ExpandingVeilLight.rendererReady()) {
            return;
        }
        State s = new State(pos);
        class_243 c = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.8, (double)pos.method_10260() + 0.5);
        PointLightData pl = new PointLightData().setBrightness(4.0f).setColor(1.0f, 0.0f, 0.0f).setRadius(0.0f);
        pl.setPosition((double)((float)c.field_1352), (double)((float)c.field_1351), (double)((float)c.field_1350));
        LightRenderHandle h = VeilRenderSystem.renderer().getLightRenderer().addLight((LightData)pl);
        s.data = pl;
        s.handle = h;
        ACTIVE.put(pos, s);
    }

    private static void ensureHooks() {
        if (hooked) {
            return;
        }
        hooked = true;
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            for (State s : ACTIVE.values()) {
                if (s.handle == null || !s.handle.isValid()) continue;
                s.handle.close();
            }
            ACTIVE.clear();
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client == null || client.method_1493()) {
                return;
            }
            if (!ExpandingVeilLight.rendererReady()) {
                return;
            }
            for (State s : ACTIVE.values().toArray(new State[0])) {
                if (s.done || s.data == null || s.handle == null || !s.handle.isValid()) {
                    if (s.handle != null && s.handle.isValid()) {
                        s.handle.close();
                    }
                    ACTIVE.remove(s.pos);
                    continue;
                }
                long nanos = System.nanoTime() - s.startNanos;
                double dt = (double)nanos / 1.0E9;
                float t = (float)Math.min(1.0, dt / 20.0);
                float radius = ExpandingVeilLight.lerp(0.0f, 16.0f, t);
                s.data.setRadius(radius);
                s.handle.markDirty();
                if (!(t >= 1.0f)) continue;
                s.done = true;
                try {
                    DeathUICutscene.start();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (s.handle.isValid()) {
                    s.handle.close();
                }
                ACTIVE.remove(s.pos);
            }
        });
    }

    private static boolean rendererReady() {
        return VeilRenderSystem.renderer() != null && VeilRenderSystem.renderer().getLightRenderer() != null;
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    private static final class State {
        final class_2338 pos;
        final long startNanos;
        PointLightData data;
        LightRenderHandle<PointLightData> handle;
        boolean done;

        State(class_2338 pos) {
            this.pos = pos;
            this.startNanos = System.nanoTime();
        }
    }
}

